/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items.armour;

import com.denfop.IUCore;
import com.denfop.api.item.energy.EnergyItem;
import com.denfop.api.item.upgrade.EnumUpgrades;
import com.denfop.api.item.upgrade.UpgradeItem;
import com.denfop.api.item.upgrade.UpgradeSystem;
import com.denfop.api.item.upgrade.event.EventItemLoad;
import com.denfop.items.EnumInfoUpgradeModules;
import com.denfop.items.IProperties;
import com.denfop.items.armour.ISpecialArmor;
import com.denfop.items.armour.ItemArmorEnergy;
import com.denfop.sound.EnumSound;
import com.denfop.sound.SoundHandler;
import com.denfop.utils.ElectricItem;
import com.denfop.utils.KeyboardClient;
import com.denfop.utils.KeyboardIU;
import com.denfop.utils.Localization;
import com.denfop.utils.ModUtils;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.Util;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.jetbrains.annotations.Nullable;

public class ItemAdvJetpack
extends ItemArmorEnergy
implements EnergyItem,
ISpecialArmor,
IProperties,
UpgradeItem {
    private static boolean lastJetpackUsed = false;
    private final String armorName;
    private final double maxStorage;
    private final double TransferLimit;
    private final int tier;

    public ItemAdvJetpack(String name, double maxStorage, double TransferLimit, int tier) {
        super("", ArmorItem.Type.CHESTPLATE, maxStorage, TransferLimit, tier);
        this.armorName = name;
        this.maxStorage = maxStorage;
        this.TransferLimit = TransferLimit;
        this.tier = tier;
        IUCore.runnableListAfterRegisterItem.add(() -> UpgradeSystem.system.addRecipe((Item)this, EnumUpgrades.JETPACK.list));
    }

    @Override
    public void fillItemCategory(CreativeModeTab p_41391_, NonNullList<ItemStack> p_41392_) {
        if (this.allowedIn(p_41391_)) {
            ItemStack var4 = new ItemStack((ItemLike)this, 1);
            ElectricItem.manager.charge(var4, 2.147483647E9, Integer.MAX_VALUE, true, false);
            p_41392_.add((Object)var4);
            p_41392_.add((Object)new ItemStack((ItemLike)this, 1));
        }
    }

    @Override
    protected String m_41467_() {
        if (this.nameItem == null) {
            StringBuilder pathBuilder = new StringBuilder(Util.m_137492_((String)"iu", (ResourceLocation)BuiltInRegistries.f_257033_.m_7981_((Object)this)));
            String targetString = "industrialupgrade.";
            String replacement = "";
            if (replacement != null) {
                int index = pathBuilder.indexOf(targetString);
                while (index != -1) {
                    pathBuilder.replace(index, index + targetString.length(), replacement);
                    index = pathBuilder.indexOf(targetString, index + replacement.length());
                }
            }
            this.nameItem = pathBuilder.toString().split("\\.")[2] + ".name";
        }
        return this.nameItem;
    }

    @Override
    public String[] properties() {
        return new String[]{"", "Demon", "Dark", "Cold", "Ender"};
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public float getItemProperty(ItemStack stack, ClientLevel level, LivingEntity entity, int p174679, String property) {
        CompoundTag nbt = ModUtils.nbt(stack);
        return nbt.m_128461_("mode").equals(property) ? 1.0f : 0.0f;
    }

    public void m_6883_(ItemStack stack, Level worldIn, Entity p_41406_, int p_41407_, boolean p_41408_) {
        super.m_6883_(stack, worldIn, p_41406_, p_41407_, p_41408_);
        CompoundTag nbt = ModUtils.nbt(stack);
        if (!UpgradeSystem.system.hasInMap(stack)) {
            nbt.m_128379_("hasID", false);
            MinecraftForge.EVENT_BUS.post((Event)new EventItemLoad(worldIn, this, stack));
        }
    }

    public void m_7373_(ItemStack stack, @Nullable Level p_41422_, List<Component> tooltip, TooltipFlag p_41424_) {
        super.m_7373_(stack, p_41422_, tooltip, p_41424_);
        CompoundTag nbtData = ModUtils.nbt(stack);
        if (UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.FLY, stack)) {
            tooltip.add((Component)Component.m_237113_((String)(Localization.translate("iu.fly") + " " + ModUtils.Boolean(nbtData.m_128471_("jetpack")))));
            tooltip.add((Component)Component.m_237113_((String)Localization.translate("iu.fly_need")));
            if (!KeyboardIU.isKeyDown(340)) {
                tooltip.add((Component)Component.m_237113_((String)Localization.translate("press.lshift")));
            }
            if (KeyboardIU.isKeyDown(340)) {
                tooltip.add((Component)Component.m_237113_((String)(Localization.translate("iu.changemode_fly") + KeyboardClient.flymode.getKey().m_84875_().getString())));
            }
        }
    }

    public void setDamage(ItemStack stack, int damage) {
        int prev = this.getDamage(stack);
    }

    @Override
    public double getDamageAbsorptionRatio() {
        return 0.4;
    }

    @Override
    public int getEnergyPerDamage() {
        return 20000;
    }

    @Override
    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
        int suffix = this.m_40402_() == EquipmentSlot.LEGS ? 2 : 1;
        CompoundTag nbtData = ModUtils.nbt(stack);
        if (!nbtData.m_128461_("mode").isEmpty()) {
            return "industrialupgrade:textures/armor/" + this.armorName + "_" + nbtData.m_128461_("mode") + "_" + suffix + ".png";
        }
        return "industrialupgrade:textures/armor/" + this.armorName + "_" + suffix + ".png";
    }

    public double getCharge(ItemStack itemStack) {
        return ElectricItem.manager.getCharge(itemStack);
    }

    public void use(ItemStack itemStack, double amount) {
        ElectricItem.manager.discharge(itemStack, amount, Integer.MAX_VALUE, true, false, false);
    }

    public boolean useJetpack(Player player, boolean hoverMode) {
        ItemStack jetpack = (ItemStack)player.m_150109_().f_35975_.get(2);
        if (this.getCharge(jetpack) <= 0.0) {
            return false;
        }
        boolean electric = true;
        float power = 1.0f;
        float dropPercentage = 0.2f;
        power = 0.7f;
        dropPercentage = 0.05f;
        if (this.getCharge(jetpack) / this.getMaxEnergy(jetpack) <= (double)dropPercentage) {
            power = (float)((double)power * (this.getCharge(jetpack) / (this.getMaxEnergy(jetpack) * (double)dropPercentage)));
        }
        if (IUCore.keyboard.isForwardKeyDown(player)) {
            float forwardpower;
            float retruster = 0.15f;
            if (hoverMode) {
                retruster = 1.0f;
            }
            if (electric) {
                retruster += 0.15f;
            }
            if ((forwardpower = power * retruster * 2.0f) > 0.0f) {
                player.m_19920_(0.0f, new Vec3(0.0, (double)(0.4f * forwardpower), (double)0.02f));
            }
        }
        int worldHeight = player.m_9236_().m_141928_();
        int maxFlightHeight = electric ? (int)((float)worldHeight / 1.28f) : worldHeight;
        double y = player.m_20186_();
        if (y > (double)(maxFlightHeight - 25)) {
            if (y > (double)maxFlightHeight) {
                y = maxFlightHeight;
            }
            power = (float)((double)power * (((double)maxFlightHeight - y) / 25.0));
        }
        Vec3 affectedMotion = player.m_20184_();
        double prevmotion = affectedMotion.f_82480_;
        double moveY = Math.min(affectedMotion.f_82480_ + (double)(power * 0.2f), (double)0.6f);
        player.m_20334_(affectedMotion.f_82479_, moveY, affectedMotion.f_82481_);
        if (hoverMode) {
            float maxHoverY = 0.0f;
            if (IUCore.keyboard.isJumpKeyDown(player)) {
                maxHoverY = electric ? 0.1f : 0.2f;
            }
            if (IUCore.keyboard.isSneakKeyDown(player)) {
                maxHoverY = electric ? -0.1f : -0.2f;
            }
            if (moveY > (double)maxHoverY) {
                moveY = maxHoverY;
                if (prevmotion > moveY) {
                    moveY = prevmotion;
                }
                player.m_20334_(affectedMotion.f_82479_, moveY, affectedMotion.f_82481_);
            }
        }
        int consume = 2;
        if (hoverMode) {
            consume = 1;
        }
        if (electric) {
            consume += 6;
        }
        if (!player.m_20096_()) {
            this.use(jetpack, consume);
        }
        player.f_19789_ = 0.0f;
        player.f_19787_ = 0.0f;
        return true;
    }

    @Override
    public boolean canProvideEnergy(ItemStack itemStack) {
        return false;
    }

    @Override
    public double getMaxEnergy(ItemStack itemStack) {
        return this.maxStorage;
    }

    @Override
    public short getTierItem(ItemStack itemStack) {
        return (short)this.tier;
    }

    @Override
    public double getTransferEnergy(ItemStack itemStack) {
        return this.TransferLimit;
    }

    public void onArmorTick(@Nonnull ItemStack itemStack, @Nonnull Level world, Player player) {
        if (((ItemStack)player.m_150109_().f_35975_.get(2)).m_150930_(itemStack.m_41720_())) {
            int resistance;
            boolean fireResistance;
            CompoundTag nbtData = ModUtils.nbt(itemStack);
            boolean hoverMode = nbtData.m_128471_("hoverMode");
            byte toggleTimer = nbtData.m_128445_("toggleTimer");
            boolean jetpackUsed = false;
            if (IUCore.keyboard.isJumpKeyDown(player) && IUCore.keyboard.isVerticalMode(player) && toggleTimer == 0) {
                toggleTimer = 10;
                boolean bl = hoverMode = !hoverMode;
                if (!player.m_9236_().m_5776_()) {
                    nbtData.m_128379_("hoverMode", hoverMode);
                    if (hoverMode) {
                        IUCore.proxy.messagePlayer(player, "Hover Mode enabled.");
                    } else {
                        IUCore.proxy.messagePlayer(player, "Hover Mode disabled.");
                    }
                }
            }
            if (nbtData.m_128471_("jetpack")) {
                player.f_19789_ = 0.0f;
                if (nbtData.m_128471_("jump") && !nbtData.m_128471_("canFly") && !player.m_150110_().f_35936_ && IUCore.keyboard.isJumpKeyDown(player) && !nbtData.m_128471_("isFlyActive") && toggleTimer == 0) {
                    toggleTimer = 10;
                    nbtData.m_128379_("canFly", true);
                }
                nbtData.m_128379_("jump", !player.m_20096_());
                if (!player.m_20096_()) {
                    if (ElectricItem.manager.canUse(itemStack, 25.0)) {
                        ElectricItem.manager.use(itemStack, 25.0, null);
                    } else {
                        nbtData.m_128379_("jetpack", false);
                    }
                }
            }
            boolean jetpack = nbtData.m_128471_("jetpack");
            if ((IUCore.keyboard.isJumpKeyDown(player) || hoverMode) && !jetpack) {
                jetpackUsed = this.useJetpack(player, hoverMode);
            }
            if (IUCore.keyboard.isFlyModeKeyDown(player) && toggleTimer == 0 && UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.FLY, itemStack)) {
                toggleTimer = 10;
                boolean bl = jetpack = !jetpack;
                if (!player.m_9236_().m_5776_()) {
                    nbtData.m_128379_("jetpack", jetpack);
                    if (jetpack) {
                        IUCore.proxy.messagePlayer(player, Localization.translate("iu.flymode_armor.info"));
                    } else {
                        IUCore.proxy.messagePlayer(player, Localization.translate("iu.flymode_armor.info1"));
                    }
                }
            }
            if (!player.m_9236_().m_5776_() && toggleTimer > 0) {
                toggleTimer = (byte)(toggleTimer - 1);
                nbtData.m_128344_("toggleTimer", toggleTimer);
            }
            if (world.m_5776_() && player == IUCore.proxy.getPlayerInstance()) {
                if (lastJetpackUsed != jetpackUsed) {
                    if (jetpackUsed) {
                        SoundHandler.playSound(player, "JetpackLoop");
                    }
                    if (!(lastJetpackUsed = jetpackUsed)) {
                        SoundHandler.stopSound(EnumSound.JetpackLoop);
                    }
                }
                Random rnd = IUCore.random;
                Vec3 motion = player.m_20184_();
                if (jetpackUsed) {
                    int i;
                    for (i = 0; i < rnd.nextInt(10); ++i) {
                        world.m_7106_((ParticleOptions)ParticleTypes.f_123762_, (double)((float)(player.m_20185_() - motion.f_82479_) + rnd.nextFloat()), (double)((float)player.m_20186_()), (double)((float)(player.m_20189_() - motion.f_82481_) + rnd.nextFloat()), 0.0, -0.25, 0.0);
                    }
                    for (i = 0; i < rnd.nextInt(10); ++i) {
                        world.m_7106_((ParticleOptions)ParticleTypes.f_123744_, (double)((float)(player.m_20185_() - motion.f_82479_) + rnd.nextFloat()), (double)((float)player.m_20186_()), (double)((float)(player.m_20189_() - motion.f_82481_) + rnd.nextFloat()), 0.0, -0.25, 0.0);
                    }
                }
            }
            if (fireResistance = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.FIRE_PROTECTION, itemStack)) {
                player.m_7292_(new MobEffectInstance(MobEffects.f_19607_, 300));
            }
            int n = resistance = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.RESISTANCE, itemStack) ? UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.RESISTANCE, (ItemStack)itemStack).number : 0;
            if (resistance != 0) {
                player.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 300, resistance));
            }
            if (UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.INVISIBILITY, itemStack)) {
                player.m_7292_(new MobEffectInstance(MobEffects.f_19609_, 300));
            }
            if (jetpackUsed) {
                player.f_36096_.m_38946_();
            }
        }
    }

    @Override
    public boolean getIsRepairable(ItemStack par1ItemStack, ItemStack par2ItemStack) {
        return false;
    }

    @Override
    public ISpecialArmor.ArmorProperties getProperties(LivingEntity player, @Nonnull ItemStack armor, DamageSource source, double damage, int slot) {
        return new ISpecialArmor.ArmorProperties(0, 0.0, 0, this);
    }

    @Override
    public int getArmorDisplay(Player player, @Nonnull ItemStack armor, int slot) {
        return 0;
    }

    @Override
    public List<EnumInfoUpgradeModules> getUpgradeModules() {
        return EnumUpgrades.JETPACK.list;
    }
}

