/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items;

import com.denfop.IUCore;
import com.denfop.api.container.CustomWorldContainer;
import com.denfop.containermenu.ContainerMenuBase;
import com.denfop.inventory.Inventory;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.network.packet.IUpdatableItemStack;
import com.denfop.register.Register;
import com.denfop.screen.ScreenIndustrialUpgrade;
import com.denfop.utils.ModUtils;
import java.util.Arrays;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public abstract class ItemStackInventory
implements CustomWorldContainer,
IUpdatableItemStack {
    public final Player player;
    protected final ItemStack[] inventory;
    protected ItemStack containerStack;
    protected boolean cleared;
    private int containerId;

    public ItemStackInventory(Player player, ItemStack containerStack, int inventorySize) {
        this.containerStack = containerStack;
        this.inventory = new ItemStack[inventorySize];
        Arrays.fill(this.inventory, ItemStack.f_41583_);
        this.player = player;
        if (player != null && !player.m_9236_().m_5776_()) {
            CompoundTag nbt = ModUtils.nbt(containerStack);
            if (!nbt.m_128425_("uid", 3)) {
                nbt.m_128405_("uid", IUCore.random.nextInt());
            }
            ListTag contentList = nbt.m_128437_("Items", 10);
            for (int i = 0; i < contentList.size(); ++i) {
                CompoundTag slotNbt = contentList.m_128728_(i);
                byte slot = slotNbt.m_128445_("Slot");
                if (slot < 0 || slot >= this.inventory.length) continue;
                this.inventory[slot] = ItemStack.m_41712_((CompoundTag)slotNbt);
            }
        }
    }

    @Override
    public Level getWorld() {
        return this.player.m_9236_();
    }

    @Override
    public CustomPacketBuffer writeContainer() {
        return new CustomPacketBuffer();
    }

    @Override
    public void readContainer(CustomPacketBuffer buffer) {
    }

    public ItemStack[] getInventory() {
        return this.inventory;
    }

    public int m_6643_() {
        return this.inventory.length;
    }

    public boolean m_7983_() {
        for (ItemStack stack : this.inventory) {
            if (ModUtils.isEmpty(stack)) continue;
            return false;
        }
        return true;
    }

    public ItemStack m_8020_(int slot) {
        return this.inventory[slot];
    }

    public ItemStack m_7407_(int index, int amount) {
        ItemStack stack;
        if (index >= 0 && index < this.inventory.length && !ModUtils.isEmpty(stack = this.inventory[index])) {
            ItemStack ret;
            if (amount >= ModUtils.getSize(stack)) {
                ret = stack;
                this.inventory[index] = ModUtils.emptyStack;
            } else {
                ret = ModUtils.setSize(stack, amount);
                this.inventory[index] = ModUtils.decSize(stack, amount);
            }
            this.save();
            return ret;
        }
        return ModUtils.emptyStack;
    }

    public ItemStack m_8016_(int index) {
        ItemStack ret = this.m_8020_(index);
        if (!ModUtils.isEmpty(ret)) {
            this.m_6836_(index, ItemStack.f_41583_);
        }
        return ret;
    }

    public void m_6836_(int slot, ItemStack stack) {
        if (!ModUtils.isEmpty(stack) && ModUtils.getSize(stack) > this.getInventoryStackLimit()) {
            stack = ModUtils.setSize(stack, this.getInventoryStackLimit());
        }
        this.inventory[slot] = ModUtils.isEmpty(stack) ? ModUtils.emptyStack : stack;
        this.save();
    }

    public boolean m_7013_(int p_18952_, ItemStack p_18953_) {
        return false;
    }

    public void m_6596_() {
        this.save();
    }

    public boolean m_6542_(Player player) {
        return player == this.player && this.getPlayerInventoryIndex() >= -1;
    }

    public ItemStack getContainerStack() {
        return this.containerStack;
    }

    public int getInventoryStackLimit() {
        return 64;
    }

    public boolean isItemValidForSlot(int slot, ItemStack stack1) {
        return false;
    }

    protected abstract String getName();

    public Component m_5446_() {
        return Component.m_237113_((String)this.getName());
    }

    public boolean isThisContainer(ItemStack stack) {
        if (!ModUtils.isEmpty(stack) && stack.m_41720_() == this.containerStack.m_41720_()) {
            CompoundTag nbt = stack.m_41783_();
            return nbt != null && nbt.m_128451_("uid") == this.getUid();
        }
        return false;
    }

    protected int getUid() {
        CompoundTag nbt = ModUtils.nbt(this.containerStack);
        return nbt.m_128451_("uid");
    }

    public CompoundTag getNBT() {
        CompoundTag nbt = ModUtils.nbt(this.containerStack);
        return nbt;
    }

    protected int getPlayerInventoryIndex() {
        for (int i = -1; i < this.player.m_150109_().m_6643_(); ++i) {
            ItemStack stack;
            ItemStack itemStack = stack = i == -1 ? this.player.m_150109_().m_36056_() : this.player.m_150109_().m_8020_(i);
            if (!this.isThisContainer(stack)) continue;
            return i;
        }
        return Integer.MIN_VALUE;
    }

    protected void save() {
        if (!this.player.m_9236_().m_5776_()) {
            if (this.containerStack.m_41619_()) {
                this.containerStack = this.player.m_150109_().m_36056_();
            }
            if (!this.cleared) {
                int idx;
                boolean dropItself = false;
                for (int i = 0; i < this.inventory.length; ++i) {
                    if (!this.isThisContainer(this.inventory[i])) continue;
                    this.inventory[i] = null;
                    dropItself = true;
                }
                ListTag contentList = new ListTag();
                for (idx = 0; idx < this.inventory.length; ++idx) {
                    if (ModUtils.isEmpty(this.inventory[idx])) continue;
                    CompoundTag nbt = new CompoundTag();
                    this.inventory[idx].m_41739_(nbt);
                    nbt.m_128344_("Slot", (byte)idx);
                    contentList.add((Object)nbt);
                }
                ModUtils.nbt(this.containerStack).m_128365_("Items", (Tag)contentList);
                this.containerStack = ModUtils.setSize(this.containerStack, 1);
                if (dropItself) {
                    ModUtils.dropAsEntity(this.player.m_9236_(), this.player.m_20183_(), this.containerStack);
                    this.clear();
                } else {
                    idx = this.getPlayerInventoryIndex();
                    if (idx < -1) {
                        this.clear();
                    } else if (idx == -1) {
                        this.player.m_150109_().m_36012_(this.containerStack);
                    } else {
                        this.player.m_150109_().m_6836_(idx, this.containerStack);
                    }
                }
            }
        }
        this.player.f_36096_.m_38946_();
    }

    public void saveAsThrown(ItemStack stack) {
        assert (!this.player.m_9236_().m_5776_());
        ListTag contentList = new ListTag();
        for (int i = 0; i < this.inventory.length; ++i) {
            if (ModUtils.isEmpty(this.inventory[i]) || this.isThisContainer(this.inventory[i])) continue;
            CompoundTag nbt = new CompoundTag();
            nbt.m_128344_("Slot", (byte)i);
            this.inventory[i].m_41739_(nbt);
            contentList.add((Object)nbt);
        }
        ModUtils.nbt(stack).m_128365_("Items", (Tag)contentList);
        assert (ModUtils.nbt(stack).m_128451_("uid") == 0);
        this.clear();
    }

    public void clear() {
        Arrays.fill(this.inventory, ItemStack.f_41583_);
        this.cleared = true;
    }

    @Override
    public void addInventorySlot(Inventory var1) {
    }

    @Override
    public MenuType<?> getMenuType() {
        return (MenuType)Register.inventory_container.get();
    }

    @Override
    public int getContainerId() {
        return this.containerId;
    }

    @Override
    public ContainerMenuBase<?> getGuiContainer(Player var1) {
        return null;
    }

    @Override
    public ScreenIndustrialUpgrade<ContainerMenuBase<? extends CustomWorldContainer>> getGui(Player var1, ContainerMenuBase<? extends CustomWorldContainer> var2) {
        return null;
    }

    public void m_6211_() {
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int p_39954_, net.minecraft.world.entity.player.Inventory p_39955_, Player p_39956_) {
        this.containerId = p_39954_;
        return this.getGuiContainer(p_39956_);
    }
}

