/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items;

import com.denfop.IUCore;
import com.denfop.IUItem;
import com.denfop.items.CapabilityFluidHandlerItem;
import com.denfop.items.ItemFluidContainer;
import com.denfop.tabs.IItemTab;
import com.denfop.utils.FluidHandlerFix;
import com.denfop.utils.KeyboardIU;
import com.denfop.utils.Localization;
import com.denfop.utils.ModUtils;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemFluidCell
extends ItemFluidContainer
implements IItemTab {
    public ItemFluidCell() {
        super(1000);
    }

    @Override
    public boolean canfill(Fluid fluid) {
        return true;
    }

    @Override
    public CreativeModeTab getItemCategory() {
        return IUCore.fluidCellTab;
    }

    @Override
    public void fillItemCategory(CreativeModeTab p_41391_, NonNullList<ItemStack> p_41392_) {
        if (this.allowedIn(p_41391_)) {
            p_41392_.addAll(this.getAllStacks());
        }
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> list, TooltipFlag tooltipFlag) {
        super.m_7373_(stack, level, list, tooltipFlag);
        if (!KeyboardIU.isKeyDown(340)) {
            list.add((Component)Component.m_237113_((String)Localization.translate("press.lshift")));
        }
        if (KeyboardIU.isKeyDown(340)) {
            list.add((Component)Component.m_237113_((String)Localization.translate("iu.fluid_cell.info")));
        }
    }

    @Override
    public ICapabilityProvider initCapabilities(@NotNull ItemStack stack, CompoundTag nbt) {
        return new CapabilityFluidHandlerItem(stack, 1000){

            public boolean canFillFluidType(FluidStack fluid) {
                return fluid != null && ItemFluidCell.this.canfill(fluid.getFluid());
            }

            public boolean canDrainFluidType(FluidStack fluid) {
                return fluid != null && ItemFluidCell.this.canfill(fluid.getFluid()) && fluid.getAmount() >= 1000;
            }

            public int fill(FluidStack resource, IFluidHandler.FluidAction doFill) {
                if (resource == null || resource.getAmount() < 1000) {
                    return 0;
                }
                return super.fill(resource, doFill);
            }

            @NotNull
            public FluidStack drain(int maxDrain, IFluidHandler.FluidAction doDrain) {
                if (maxDrain < 1000) {
                    return FluidStack.EMPTY;
                }
                return super.drain(maxDrain, doDrain);
            }

            @NotNull
            public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction doDrain) {
                if (resource == FluidStack.EMPTY || resource.getAmount() < 1000) {
                    return FluidStack.EMPTY;
                }
                return super.drain(resource, doDrain);
            }

            @NotNull
            public ItemStack getContainer() {
                return this.getFluid() == FluidStack.EMPTY ? new ItemStack((ItemLike)IUItem.fluidCell.getItem()) : this.container;
            }
        };
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        BlockHitResult blockhitresult;
        ItemStack itemstack = player.m_21120_(hand);
        IFluidHandlerItem fs = (IFluidHandlerItem)itemstack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM, null).orElse(null);
        if (fs == null) {
            fs = (IFluidHandlerItem)this.initCapabilities(itemstack, itemstack.m_41784_());
        }
        if ((blockhitresult = ItemFluidCell.m_41435_((Level)world, (Player)player, (ClipContext.Fluid)(fs.getFluidInTank(0).getFluid() == Fluids.f_76191_ ? ClipContext.Fluid.SOURCE_ONLY : ClipContext.Fluid.NONE))).m_6662_() == HitResult.Type.MISS) {
            return InteractionResultHolder.m_19098_((Object)itemstack);
        }
        if (blockhitresult.m_6662_() != HitResult.Type.BLOCK) {
            return InteractionResultHolder.m_19098_((Object)itemstack);
        }
        BlockPos blockpos = blockhitresult.m_82425_();
        Direction direction = blockhitresult.m_82434_();
        BlockPos blockpos1 = blockpos.m_121945_(direction);
        if (world.m_7966_(player, blockpos) && player.m_36204_(blockpos1, direction, itemstack)) {
            if (fs.getFluidInTank(0).getFluid() != Fluids.f_76191_) {
                BlockPos blockpos2;
                Fluid fluid = fs.getFluidInTank(0).getFluid();
                boolean flag1 = world.m_8055_(blockpos).m_247087_();
                BlockPos blockPos = blockpos2 = flag1 && blockhitresult.m_82434_() == Direction.UP ? blockpos : blockpos.m_121955_(blockhitresult.m_82434_().m_122436_());
                if (this.tryPlaceContainedLiquid(new FluidStack(fluid, 1000), player, world, blockpos2)) {
                    player.m_21120_(hand).m_41774_(1);
                    if (!ModUtils.storeInventoryItem(new ItemStack((ItemLike)this, 1), player, false) && !world.m_5776_()) {
                        ModUtils.dropAsEntity(world, player.m_20183_(), new ItemStack((ItemLike)this, 1));
                    }
                    return InteractionResultHolder.m_19092_((Object)itemstack, (boolean)world.f_46443_);
                }
            } else {
                BlockState block = world.m_8055_(blockpos);
                if (block.m_278721_()) {
                    FluidState fluidState = block.m_60734_().m_5888_(block);
                    if (!fluidState.m_76170_()) {
                        return InteractionResultHolder.m_19100_((Object)itemstack);
                    }
                    FluidStack ret = new FluidStack(fluidState.m_76152_(), 1000);
                    ItemStack stack = new ItemStack((ItemLike)this);
                    FluidHandlerFix.getFluidHandler(stack).fill(ret, IFluidHandler.FluidAction.EXECUTE);
                    stack = stack.m_41777_();
                    if (!ModUtils.storeInventoryItem(stack, player, false) && !world.m_5776_()) {
                        ModUtils.dropAsEntity(world, player.m_20183_(), stack);
                    }
                    world.m_7731_(blockpos, Blocks.f_50016_.m_49966_(), 3);
                    itemstack.m_41774_(1);
                    return InteractionResultHolder.m_19092_((Object)itemstack, (boolean)world.f_46443_);
                }
            }
        }
        return InteractionResultHolder.m_19100_((Object)itemstack);
    }

    public boolean tryPlaceContainedLiquid(FluidStack fs, @javax.annotation.Nullable Player player, Level worldIn, BlockPos posIn) {
        Block containedBlock = fs.getFluid() == Fluids.f_76193_ ? Blocks.f_49990_ : (fs.getFluid() == Fluids.f_76195_ ? Blocks.f_49991_ : fs.getFluid().m_76145_().m_76188_().m_60734_());
        if (containedBlock == Blocks.f_50016_) {
            return false;
        }
        BlockState iblockstate = worldIn.m_8055_(posIn);
        FluidState fluidState = worldIn.m_6425_(posIn);
        boolean flag1 = iblockstate.m_247087_();
        if (!fluidState.m_76178_() && fluidState.m_76170_()) {
            return false;
        }
        if (fluidState.m_76178_() && !flag1) {
            return false;
        }
        if (worldIn.m_46472_() == Level.f_46429_ && containedBlock == Blocks.f_49990_) {
            int l = posIn.m_123341_();
            int i = posIn.m_123342_();
            int j = posIn.m_123343_();
            worldIn.m_5594_(player, posIn, SoundEvents.f_11937_, SoundSource.BLOCKS, 0.5f, 2.6f + (worldIn.f_46441_.m_188501_() - worldIn.f_46441_.m_188501_()) * 0.8f);
            for (int k = 0; k < 8; ++k) {
                worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123755_, (double)l + Math.random(), (double)i + Math.random(), (double)j + Math.random(), 0.0, 0.0, 0.0);
            }
        } else {
            if (!worldIn.f_46443_ && flag1 && !iblockstate.m_278721_()) {
                worldIn.m_46961_(posIn, true);
            }
            SoundEvent soundevent = containedBlock == Blocks.f_49991_ ? SoundEvents.f_11780_ : SoundEvents.f_11778_;
            worldIn.m_5594_(player, posIn, soundevent, SoundSource.BLOCKS, 1.0f, 1.0f);
            worldIn.m_7731_(posIn, fs.getFluid().m_76145_().m_76188_(), 11);
        }
        fs.grow(-1000);
        return true;
    }
}

