/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.inventory;

import com.denfop.api.widget.EnumTypeSlot;
import com.denfop.api.widget.ITypeSlot;
import com.denfop.blockentity.base.BlockEntityInventory;
import com.denfop.inventory.Inventory;
import com.denfop.inventory.InventoryFluid;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.world.level.material.Fluid;

public class InventoryFluidByList
extends InventoryFluid
implements ITypeSlot {
    boolean usually = false;
    private Set<Fluid> acceptedFluids;

    public InventoryFluidByList(BlockEntityInventory base1, Inventory.TypeItemSlot typeItemSlot1, int count, InventoryFluid.TypeFluidSlot typeFluidSlot, Fluid ... fluidlist) {
        super(base1, typeItemSlot1, count, typeFluidSlot);
        this.acceptedFluids = new HashSet<Fluid>(Arrays.asList(fluidlist));
    }

    public InventoryFluidByList(BlockEntityInventory base1, int count, Fluid fluidlist) {
        super(base1, Inventory.TypeItemSlot.INPUT, count, InventoryFluid.TypeFluidSlot.INPUT);
        this.acceptedFluids = new HashSet<Fluid>(Collections.singletonList(fluidlist));
    }

    public InventoryFluidByList(BlockEntityInventory base1, int count, Fluid ... fluidlist) {
        super(base1, Inventory.TypeItemSlot.INPUT, count, InventoryFluid.TypeFluidSlot.INPUT);
        this.acceptedFluids = new HashSet<Fluid>(Arrays.asList(fluidlist));
    }

    public InventoryFluidByList(BlockEntityInventory base1, int count, List<Fluid> fluidlist) {
        super(base1, Inventory.TypeItemSlot.INPUT, count, InventoryFluid.TypeFluidSlot.INPUT);
        this.acceptedFluids = new HashSet<Fluid>(fluidlist);
    }

    public InventoryFluidByList(BlockEntityInventory base1, String name1, int count, Fluid fluidlist, InventoryFluid.TypeFluidSlot TypeFluidSlot2) {
        super(base1, Inventory.TypeItemSlot.INPUT, count, TypeFluidSlot2);
        this.acceptedFluids = new HashSet<Fluid>(Collections.singletonList(fluidlist));
    }

    @Override
    public EnumTypeSlot getTypeSlot() {
        return EnumTypeSlot.BUCKET;
    }

    public void setUsually(boolean usually) {
        this.usually = usually;
    }

    public Set<Fluid> getAcceptedFluids() {
        return this.acceptedFluids;
    }

    public void setAcceptedFluids(Set<Fluid> acceptedFluids) {
        this.acceptedFluids = acceptedFluids;
    }

    @Override
    protected boolean acceptsLiquid(Fluid fluid) {
        return this.usually || this.acceptedFluids.contains(fluid);
    }

    @Override
    protected Iterable<Fluid> getPossibleFluids() {
        return this.acceptedFluids;
    }
}

