/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.squeezer;

import com.denfop.IUItem;
import com.denfop.blocks.FluidName;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class SqueezerHandler {
    private static final List<SqueezerHandler> recipes = new ArrayList<SqueezerHandler>();
    private final ItemStack input;
    private final FluidStack output;

    public SqueezerHandler(ItemStack input, FluidStack output) {
        this.input = input;
        this.output = output;
    }

    public static List<SqueezerHandler> getRecipes() {
        if (recipes.isEmpty()) {
            SqueezerHandler.initRecipes();
        }
        return recipes;
    }

    public static SqueezerHandler addRecipe(ItemStack input, FluidStack output) {
        SqueezerHandler recipe = new SqueezerHandler(input, output);
        if (recipes.contains(recipe)) {
            return null;
        }
        recipes.add(recipe);
        return recipe;
    }

    public static void initRecipes() {
        SqueezerHandler.addRecipe(new ItemStack((ItemLike)IUItem.rawLatex.getItem()), new FluidStack((Fluid)FluidName.fluidrawlatex.getInstance().get(), 100));
        SqueezerHandler.addRecipe(new ItemStack((ItemLike)Items.f_42578_), new FluidStack((Fluid)FluidName.fluidseedoil.getInstance().get(), 35));
        SqueezerHandler.addRecipe(new ItemStack((ItemLike)Items.f_42577_), new FluidStack((Fluid)FluidName.fluidseedoil.getInstance().get(), 35));
        SqueezerHandler.addRecipe(new ItemStack((ItemLike)IUItem.crops.getStack(0)), new FluidStack((Fluid)FluidName.fluidseedoil.getInstance().get(), 50));
    }

    public ItemStack getInput() {
        return this.input;
    }

    public FluidStack getOutput() {
        return this.output;
    }
}

