/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.sawmill;

import com.denfop.api.Recipes;
import com.denfop.api.recipe.BaseMachineRecipe;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.item.ItemStack;

public class SawmillHandler {
    private static final List<SawmillHandler> recipes = new ArrayList<SawmillHandler>();
    private final ItemStack input;
    private final ItemStack output;

    public SawmillHandler(ItemStack input, ItemStack output) {
        this.input = input;
        this.output = output;
    }

    public static List<SawmillHandler> getRecipes() {
        if (recipes.isEmpty()) {
            SawmillHandler.initRecipes();
        }
        return recipes;
    }

    public static SawmillHandler addRecipe(ItemStack input, ItemStack output) {
        SawmillHandler recipe = new SawmillHandler(input, output);
        if (recipes.contains(recipe)) {
            return null;
        }
        recipes.add(recipe);
        return recipe;
    }

    public static SawmillHandler getRecipe(ItemStack is) {
        if (is == null || is.m_41619_()) {
            return null;
        }
        for (SawmillHandler recipe : recipes) {
            if (!recipe.matchesInput(is)) continue;
            return recipe;
        }
        return null;
    }

    public static void initRecipes() {
        for (BaseMachineRecipe container : Recipes.recipes.getRecipeList("sawmill")) {
            SawmillHandler.addRecipe(container.input.getInputs().get(0).getInputs().get(0), container.getOutput().items.get(0));
        }
    }

    public ItemStack getInput() {
        return this.input;
    }

    public ItemStack getOutput() {
        return this.output.m_41777_();
    }

    public boolean matchesInput(ItemStack is) {
        return true;
    }
}

