/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.rna_collector;

import com.denfop.api.Recipes;
import com.denfop.api.recipe.BaseFluidMachineRecipe;
import com.denfop.api.recipe.BaseMachineRecipe;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class RNACollectorHandler {
    private static final List<RNACollectorHandler> recipes = new ArrayList<RNACollectorHandler>();
    private final ItemStack input;
    private final FluidStack inputFluid;
    private final FluidStack outputFluid;

    public RNACollectorHandler(ItemStack input, FluidStack inputFluid, FluidStack outputFluid) {
        this.input = input;
        this.inputFluid = inputFluid;
        this.outputFluid = outputFluid;
    }

    public static List<RNACollectorHandler> getRecipes() {
        if (recipes.isEmpty()) {
            RNACollectorHandler.initRecipes();
        }
        return recipes;
    }

    public static RNACollectorHandler getRecipe(ItemStack is) {
        if (is == null || is.m_41619_()) {
            return null;
        }
        return recipes.get(0);
    }

    public static void initRecipes() {
        List<BaseFluidMachineRecipe> list = Recipes.recipes.getRecipeFluid().getRecipeList("rna_collector");
        List<BaseMachineRecipe> list1 = Recipes.recipes.getRecipeList("rna_collector");
        for (int i = 0; i < list1.size(); ++i) {
            BaseFluidMachineRecipe baseFluidMachineRecipe = list.get(i);
            BaseMachineRecipe baseMachineRecipe = list1.get(i);
            ItemStack input = baseMachineRecipe.input.getInputs().get(0).getInputs().get(0);
            FluidStack inputFluid = baseMachineRecipe.input.getFluid();
            FluidStack outputFluid = baseFluidMachineRecipe.output_fluid.get(0);
            RNACollectorHandler.addRecipe(input, inputFluid, outputFluid);
        }
    }

    private static RNACollectorHandler addRecipe(ItemStack input, FluidStack inputFluid, FluidStack outputFluid) {
        RNACollectorHandler recipe = new RNACollectorHandler(input, inputFluid, outputFluid);
        if (recipes.contains(recipe)) {
            return null;
        }
        recipes.add(recipe);
        return recipe;
    }

    public ItemStack getInput() {
        return this.input;
    }

    public FluidStack getInputFluid() {
        return this.inputFluid;
    }

    public FluidStack getOutputFluid() {
        return this.outputFluid;
    }
}

