/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.refractory_furnace;

import com.denfop.api.Recipes;
import com.denfop.api.recipe.BaseMachineRecipe;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class RefractoryFurnaceHandler {
    private static final List<RefractoryFurnaceHandler> recipes = new ArrayList<RefractoryFurnaceHandler>();
    private final FluidStack input2;
    private final ItemStack input;
    private final ItemStack output;

    public RefractoryFurnaceHandler(ItemStack input, FluidStack input2, ItemStack output) {
        this.input = input;
        this.input2 = input2;
        this.output = output;
    }

    public static List<RefractoryFurnaceHandler> getRecipes() {
        if (recipes.isEmpty()) {
            RefractoryFurnaceHandler.initRecipes();
        }
        return recipes;
    }

    public static RefractoryFurnaceHandler addRecipe(ItemStack input, FluidStack input2, ItemStack output) {
        RefractoryFurnaceHandler recipe = new RefractoryFurnaceHandler(input, input2, output);
        if (recipes.contains(recipe)) {
            return null;
        }
        recipes.add(recipe);
        return recipe;
    }

    public static RefractoryFurnaceHandler getRecipe(ItemStack is) {
        if (is == null || is.m_41619_()) {
            return null;
        }
        for (RefractoryFurnaceHandler recipe : recipes) {
            if (!recipe.matchesInput(is)) continue;
            return recipe;
        }
        return null;
    }

    public static void initRecipes() {
        for (BaseMachineRecipe container : Recipes.recipes.getRecipeList("elec_refractory_furnace")) {
            RefractoryFurnaceHandler.addRecipe(container.input.getInputs().get(0).getInputs().get(0), container.input.getFluid(), container.getOutput().items.get(0));
        }
    }

    public ItemStack getInput() {
        return this.input;
    }

    public FluidStack getInput2() {
        return this.input2;
    }

    public ItemStack getOutput() {
        return this.output.m_41777_();
    }

    public boolean matchesInput(ItemStack is) {
        return true;
    }
}

