/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.reactorschemes.fluid.simple;

import com.denfop.IUItem;
import com.denfop.api.reactors.CreativeReactor;
import com.denfop.api.reactors.EnumReactors;
import com.denfop.api.reactors.LogicCreativeComponent;
import com.denfop.api.reactors.LogicCreativeFluidReactor;
import com.denfop.api.reactors.LogicCreativeGasReactor;
import com.denfop.api.reactors.LogicCreativeGraphiteReactor;
import com.denfop.api.reactors.LogicCreativeHeatReactor;
import com.denfop.api.reactors.LogicCreativeReactor;
import com.denfop.inventory.Inventory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class ReactorSchemesFluidSimpleHandler {
    private static final List<ReactorSchemesFluidSimpleHandler> recipes = new ArrayList<ReactorSchemesFluidSimpleHandler>();
    private final EnumReactors reactors;
    private final int generation;
    private final int radGen;
    private final List<Tuple<Character, Item>> input;
    private final List<String> pattern;
    private final CreativeReactor reactor;
    private boolean stable;
    private LogicCreativeReactor logicReactor;

    public ReactorSchemesFluidSimpleHandler(EnumReactors reactors, List<String> pattern, List<Tuple<Character, Item>> tuple) {
        int i;
        this.input = tuple;
        this.reactors = reactors;
        this.pattern = pattern;
        AtomicInteger count = new AtomicInteger();
        pattern.forEach(patterns -> count.addAndGet(patterns.length()));
        Inventory invSlot = new Inventory(null, Inventory.TypeItemSlot.INPUT, count.get());
        List<ItemStack> inputs = Arrays.asList(this.convertPatternToLayout(pattern, tuple, reactors.getWidth(), reactors.getHeight()));
        for (i = 0; i < inputs.size(); ++i) {
            invSlot.set(i, inputs.get(i));
        }
        this.reactor = new CreativeReactor(this.reactors, invSlot);
        switch (this.reactors.getType()) {
            case FLUID: {
                this.logicReactor = new LogicCreativeFluidReactor(this.reactor);
                break;
            }
            case GAS_COOLING_FAST: {
                this.logicReactor = new LogicCreativeGasReactor(this.reactor);
                break;
            }
            case GRAPHITE_FLUID: {
                this.logicReactor = new LogicCreativeGraphiteReactor(this.reactor);
                break;
            }
            case HIGH_SOLID: {
                this.logicReactor = new LogicCreativeHeatReactor(this.reactor);
            }
        }
        for (i = 0; i < 100; ++i) {
            this.logicReactor.onTick();
        }
        this.stable = true;
        for (LogicCreativeComponent component : this.logicReactor.getListComponent()) {
            if (component.getDamageItem() == component.getMaxDamage()) continue;
            this.stable = false;
            break;
        }
        this.generation = this.logicReactor.getGeneration();
        this.radGen = this.logicReactor.getRadGeneration();
    }

    public static List<ReactorSchemesFluidSimpleHandler> getRecipes() {
        if (recipes.isEmpty()) {
            ReactorSchemesFluidSimpleHandler.initRecipes();
        }
        return recipes;
    }

    public static ReactorSchemesFluidSimpleHandler addRecipe(int generation, EnumReactors reactors, int radGen, List<String> pattern, List<Tuple<Character, Item>> tuple) {
        ReactorSchemesFluidSimpleHandler recipe = new ReactorSchemesFluidSimpleHandler(reactors, pattern, tuple);
        recipes.add(recipe);
        return recipe;
    }

    public static void initRecipes() {
        ReactorSchemesFluidSimpleHandler.addRecipe(18, EnumReactors.FS, 3, List.of(" A ", "ABA", " A "), List.of(new Tuple((Object)Character.valueOf('A'), (Object)IUItem.reactor_plate.getItem()), new Tuple((Object)Character.valueOf('B'), (Object)IUItem.mox_fuel_rod.getItem())));
        ReactorSchemesFluidSimpleHandler.addRecipe(149, EnumReactors.FS, 9, List.of("ABA", "BCB", "ADA"), List.of(new Tuple((Object)Character.valueOf('A'), (Object)IUItem.componentVent.getItem()), new Tuple((Object)Character.valueOf('B'), (Object)IUItem.vent.getItem()), new Tuple((Object)Character.valueOf('C'), (Object)IUItem.quad_uranium_fuel_rod.getItem()), new Tuple((Object)Character.valueOf('D'), (Object)IUItem.dual_uranium_fuel_rod.getItem())));
        ReactorSchemesFluidSimpleHandler.addRecipe(349, EnumReactors.FS, 21, List.of("ABA", "BCB", "ADA"), List.of(new Tuple((Object)Character.valueOf('A'), (Object)IUItem.componentVent.getItem()), new Tuple((Object)Character.valueOf('B'), (Object)IUItem.vent.getItem()), new Tuple((Object)Character.valueOf('C'), (Object)IUItem.quad_mox_fuel_rod.getItem()), new Tuple((Object)Character.valueOf('D'), (Object)IUItem.dual_mox_fuel_rod.getItem())));
        ReactorSchemesFluidSimpleHandler.addRecipe(300, EnumReactors.FS, 18, List.of("ABA", "BCB", "ADA"), List.of(new Tuple((Object)Character.valueOf('A'), (Object)IUItem.componentVent.getItem()), new Tuple((Object)Character.valueOf('B'), (Object)IUItem.vent.getItem()), new Tuple((Object)Character.valueOf('C'), (Object)IUItem.reactoruran233Quad.getItem()), new Tuple((Object)Character.valueOf('D'), (Object)IUItem.reactoruran233Dual.getItem())));
        ReactorSchemesFluidSimpleHandler.addRecipe(112, EnumReactors.FS, 6, List.of("ABA", "BCB", "ABA"), List.of(new Tuple((Object)Character.valueOf('A'), (Object)IUItem.componentVent.getItem()), new Tuple((Object)Character.valueOf('B'), (Object)IUItem.vent.getItem()), new Tuple((Object)Character.valueOf('C'), (Object)IUItem.quad_uranium_fuel_rod.getItem()), new Tuple((Object)Character.valueOf('D'), (Object)IUItem.dual_uranium_fuel_rod.getItem())));
        ReactorSchemesFluidSimpleHandler.addRecipe(262, EnumReactors.FS, 14, List.of("ABA", "BCB", "ABA"), List.of(new Tuple((Object)Character.valueOf('A'), (Object)IUItem.componentVent.getItem()), new Tuple((Object)Character.valueOf('B'), (Object)IUItem.vent.getItem()), new Tuple((Object)Character.valueOf('C'), (Object)IUItem.quad_mox_fuel_rod.getItem()), new Tuple((Object)Character.valueOf('D'), (Object)IUItem.dual_mox_fuel_rod.getItem())));
        ReactorSchemesFluidSimpleHandler.addRecipe(225, EnumReactors.FS, 12, List.of("ABA", "BCB", "ABA"), List.of(new Tuple((Object)Character.valueOf('A'), (Object)IUItem.componentVent.getItem()), new Tuple((Object)Character.valueOf('B'), (Object)IUItem.vent.getItem()), new Tuple((Object)Character.valueOf('C'), (Object)IUItem.reactoruran233Quad.getItem()), new Tuple((Object)Character.valueOf('D'), (Object)IUItem.reactoruran233Dual.getItem())));
        ReactorSchemesFluidSimpleHandler.addRecipe(37, EnumReactors.FS, 3, List.of(" B ", "BDB", " B "), List.of(new Tuple((Object)Character.valueOf('A'), (Object)IUItem.componentVent.getItem()), new Tuple((Object)Character.valueOf('B'), (Object)IUItem.vent.getItem()), new Tuple((Object)Character.valueOf('C'), (Object)IUItem.quad_uranium_fuel_rod.getItem()), new Tuple((Object)Character.valueOf('D'), (Object)IUItem.dual_uranium_fuel_rod.getItem())));
        ReactorSchemesFluidSimpleHandler.addRecipe(87, EnumReactors.FS, 7, List.of(" B ", "BDB", " B "), List.of(new Tuple((Object)Character.valueOf('A'), (Object)IUItem.componentVent.getItem()), new Tuple((Object)Character.valueOf('B'), (Object)IUItem.vent.getItem()), new Tuple((Object)Character.valueOf('C'), (Object)IUItem.quad_mox_fuel_rod.getItem()), new Tuple((Object)Character.valueOf('D'), (Object)IUItem.dual_mox_fuel_rod.getItem())));
        ReactorSchemesFluidSimpleHandler.addRecipe(75, EnumReactors.FS, 6, List.of(" B ", "BDB", " B "), List.of(new Tuple((Object)Character.valueOf('A'), (Object)IUItem.componentVent.getItem()), new Tuple((Object)Character.valueOf('B'), (Object)IUItem.vent.getItem()), new Tuple((Object)Character.valueOf('C'), (Object)IUItem.reactoruran233Quad.getItem()), new Tuple((Object)Character.valueOf('D'), (Object)IUItem.reactoruran233Dual.getItem())));
        ReactorSchemesFluidSimpleHandler.addRecipe(1350, EnumReactors.FA, 72, List.of(" BAB", "BACA", "ACAB", "BAB "), List.of(new Tuple((Object)Character.valueOf('A'), (Object)IUItem.adv_heat_exchange.getItem()), new Tuple((Object)Character.valueOf('B'), (Object)IUItem.adv_componentVent.getItem()), new Tuple((Object)Character.valueOf('C'), (Object)IUItem.reactoramericiumQuad.getItem())));
        ReactorSchemesFluidSimpleHandler.addRecipe(900, EnumReactors.FA, 48, List.of(" BAB", "BACA", "ACAB", "BAB "), List.of(new Tuple((Object)Character.valueOf('A'), (Object)IUItem.adv_heat_exchange.getItem()), new Tuple((Object)Character.valueOf('B'), (Object)IUItem.adv_componentVent.getItem()), new Tuple((Object)Character.valueOf('C'), (Object)IUItem.reactortoriyQuad.getItem())));
        ReactorSchemesFluidSimpleHandler.addRecipe(900, EnumReactors.FA, 48, List.of("ABAB", "BACA", "ACAB", "BABA"), List.of(new Tuple((Object)Character.valueOf('A'), (Object)IUItem.adv_heat_exchange.getItem()), new Tuple((Object)Character.valueOf('B'), (Object)IUItem.adv_componentVent.getItem()), new Tuple((Object)Character.valueOf('C'), (Object)IUItem.reactortoriyQuad.getItem())));
        ReactorSchemesFluidSimpleHandler.addRecipe(1050, EnumReactors.FA, 56, List.of(" BAB", "BACA", "ACAB", "BAB "), List.of(new Tuple((Object)Character.valueOf('A'), (Object)IUItem.adv_heat_exchange.getItem()), new Tuple((Object)Character.valueOf('B'), (Object)IUItem.adv_componentVent.getItem()), new Tuple((Object)Character.valueOf('C'), (Object)IUItem.reactorneptuniumQuad.getItem())));
        ReactorSchemesFluidSimpleHandler.addRecipe(1050, EnumReactors.FA, 56, List.of("ABAB", "BACA", "ACAB", "BABA"), List.of(new Tuple((Object)Character.valueOf('A'), (Object)IUItem.adv_heat_exchange.getItem()), new Tuple((Object)Character.valueOf('B'), (Object)IUItem.adv_componentVent.getItem()), new Tuple((Object)Character.valueOf('C'), (Object)IUItem.reactorneptuniumQuad.getItem())));
        ReactorSchemesFluidSimpleHandler.addRecipe(1397, EnumReactors.FA, 72, List.of("ABAC", "BDBA", "ABDB", "CABE"), List.of(new Tuple((Object)Character.valueOf('A'), (Object)IUItem.adv_componentVent.getItem()), new Tuple((Object)Character.valueOf('B'), (Object)IUItem.adv_Vent.getItem()), new Tuple((Object)Character.valueOf('C'), (Object)IUItem.reactoruran233Simple.getItem()), new Tuple((Object)Character.valueOf('D'), (Object)IUItem.reactoramericiumQuad.getItem()), new Tuple((Object)Character.valueOf('E'), (Object)IUItem.uranium_fuel_rod.getItem())));
        ReactorSchemesFluidSimpleHandler.addRecipe(16200, EnumReactors.FI, 864, List.of("ABABA", "BCBCB", "ABABA", "BCBCB", "ABABA"), List.of(new Tuple((Object)Character.valueOf('A'), (Object)IUItem.imp_componentVent.getItem()), new Tuple((Object)Character.valueOf('B'), (Object)IUItem.imp_Vent.getItem()), new Tuple((Object)Character.valueOf('C'), (Object)IUItem.reactorcaliforniaQuad.getItem())));
    }

    public ItemStack[] convertPatternToLayout(List<String> pattern, List<Tuple<Character, Item>> keys, int width, int height) {
        int y;
        ItemStack[] layout = new ItemStack[width * height];
        HashMap<Character, ItemStack> keyMap = new HashMap<Character, ItemStack>();
        for (Tuple<Character, Item> tuple : keys) {
            keyMap.put((Character)tuple.m_14418_(), new ItemStack((ItemLike)tuple.m_14419_()));
        }
        for (y = 0; y < pattern.size(); ++y) {
            String row = pattern.get(y);
            for (int x = 0; x < row.length(); ++x) {
                char c = row.charAt(x);
                int index = x + y * width;
                layout[index] = c == ' ' || !keyMap.containsKey(Character.valueOf(c)) ? ItemStack.f_41583_ : ((ItemStack)keyMap.get(Character.valueOf(c))).m_41777_();
            }
        }
        for (y = pattern.size(); y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                layout[x + y * width] = ItemStack.f_41583_;
            }
        }
        return layout;
    }

    public List<String> getPattern() {
        return this.pattern;
    }

    public List<Tuple<Character, Item>> getInput() {
        return this.input;
    }

    public int getGeneration() {
        return this.generation;
    }

    public EnumReactors getReactors() {
        return this.reactors;
    }

    public int getRadGen() {
        return this.radGen;
    }
}

