/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.primalrolling;

import com.denfop.api.Recipes;
import com.denfop.api.recipe.BaseMachineRecipe;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.item.ItemStack;

public class PrimalRollingHandler {
    private static final List<PrimalRollingHandler> recipes = new ArrayList<PrimalRollingHandler>();
    private final ItemStack input;
    private final ItemStack output;

    public PrimalRollingHandler(ItemStack input, ItemStack output) {
        this.input = input;
        this.output = output;
    }

    public static List<PrimalRollingHandler> getRecipes() {
        if (recipes.isEmpty()) {
            PrimalRollingHandler.initRecipes();
        }
        return recipes;
    }

    public static PrimalRollingHandler addRecipe(ItemStack input, ItemStack output) {
        PrimalRollingHandler recipe = new PrimalRollingHandler(input, output);
        if (recipes.contains(recipe)) {
            return null;
        }
        recipes.add(recipe);
        return recipe;
    }

    public static void initRecipes() {
        for (BaseMachineRecipe container : Recipes.recipes.getRecipeList("cutting")) {
            PrimalRollingHandler.addRecipe(container.input.getInputs().get(0).getInputs().get(0), container.getOutput().items.get(0));
        }
    }

    public ItemStack getInput() {
        return this.input;
    }

    public ItemStack getOutput() {
        return this.output;
    }
}

