/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.extractor;

import com.denfop.api.Recipes;
import com.denfop.api.recipe.BaseMachineRecipe;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.item.ItemStack;

public class ExtractorHandler {
    private static final List<ExtractorHandler> recipes = new ArrayList<ExtractorHandler>();
    private final ItemStack input;
    private final ItemStack output;
    private final BaseMachineRecipe container;

    public ExtractorHandler(ItemStack input, ItemStack output, BaseMachineRecipe container) {
        this.input = input;
        this.output = output;
        this.container = container;
    }

    public static List<ExtractorHandler> getRecipes() {
        if (recipes.isEmpty()) {
            ExtractorHandler.initRecipes();
        }
        return recipes;
    }

    public static ExtractorHandler addRecipe(ItemStack input, ItemStack output, BaseMachineRecipe container) {
        ExtractorHandler recipe = new ExtractorHandler(input, output, container);
        if (recipes.contains(recipe)) {
            return null;
        }
        recipes.add(recipe);
        return recipe;
    }

    public static ExtractorHandler getRecipe(ItemStack is) {
        if (is == null || is.m_41619_()) {
            return null;
        }
        for (ExtractorHandler recipe : recipes) {
            if (!recipe.matchesInput(is)) continue;
            return recipe;
        }
        return null;
    }

    public static void initRecipes() {
        for (BaseMachineRecipe container : Recipes.recipes.getRecipeList("extractor")) {
            try {
                ExtractorHandler.addRecipe(container.input.getInputs().get(0).getInputs().get(0), container.getOutput().items.get(0), container);
            }
            catch (Exception ignored) {
                System.out.println(2);
            }
        }
    }

    public BaseMachineRecipe getContainer() {
        return this.container;
    }

    public ItemStack getInput() {
        return this.input;
    }

    public ItemStack getOutput() {
        return this.output.m_41777_();
    }

    public boolean matchesInput(ItemStack is) {
        return is.m_41720_() == this.input.m_41720_();
    }
}

