/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.cutting;

import com.denfop.api.Recipes;
import com.denfop.api.recipe.BaseMachineRecipe;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.item.ItemStack;

public class CuttingHandler {
    private static final List<CuttingHandler> recipes = new ArrayList<CuttingHandler>();
    private final ItemStack input;
    private final ItemStack output;
    private final BaseMachineRecipe container;

    public CuttingHandler(ItemStack input, ItemStack output, BaseMachineRecipe container) {
        this.input = input;
        this.output = output;
        this.container = container;
    }

    public static List<CuttingHandler> getRecipes() {
        if (recipes.isEmpty()) {
            CuttingHandler.initRecipes();
        }
        return recipes;
    }

    public static CuttingHandler addRecipe(ItemStack input, ItemStack output, BaseMachineRecipe container) {
        CuttingHandler recipe = new CuttingHandler(input, output, container);
        if (recipes.contains(recipe)) {
            return null;
        }
        recipes.add(recipe);
        return recipe;
    }

    public static CuttingHandler getRecipe(ItemStack is) {
        if (is == null || is.m_41619_()) {
            return null;
        }
        for (CuttingHandler recipe : recipes) {
            if (!recipe.matchesInput(is)) continue;
            return recipe;
        }
        return null;
    }

    public static void initRecipes() {
        for (BaseMachineRecipe container : Recipes.recipes.getRecipeList("cutting")) {
            try {
                CuttingHandler.addRecipe(container.input.getInputs().get(0).getInputs().get(0), container.getOutput().items.get(0), container);
            }
            catch (Exception e) {
                System.out.println(2);
            }
        }
    }

    public BaseMachineRecipe getContainer() {
        return this.container;
    }

    public ItemStack getInput() {
        return this.input;
    }

    public ItemStack getOutput() {
        return this.output.m_41777_();
    }

    public boolean matchesInput(ItemStack is) {
        return is.m_41720_() == this.input.m_41720_();
    }
}

