/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.convertermatter;

import com.denfop.IUItem;
import com.denfop.blockentity.mechanism.multimechanism.simple.BlockEntityCompressor;
import com.denfop.blocks.mechanism.BlockSimpleMachineEntity;
import com.denfop.containermenu.ContainerMenuMultiMachine;
import com.denfop.integration.jei.IRecipeCategory;
import com.denfop.integration.jei.JeiInform;
import com.denfop.integration.jei.convertermatter.ConverterHandler;
import com.denfop.recipes.ItemStackHelper;
import com.denfop.screen.ScreenMain;
import com.denfop.utils.Localization;
import javax.annotation.Nonnull;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public class ConverterCategory
extends ScreenMain
implements IRecipeCategory<ConverterHandler> {
    private final IDrawableStatic bg;
    private final JeiInform jeiInform;
    private int progress = 0;
    private int energy = 0;

    public ConverterCategory(IGuiHelper guiHelper, JeiInform jeiInform) {
        super(new ContainerMenuMultiMachine((Player)Minecraft.m_91087_().f_91074_, (BlockEntityCompressor)BlockSimpleMachineEntity.compressor_iu.getDummyTe(), 1, true));
        this.jeiInform = jeiInform;
        this.f_96539_ = Component.m_237113_((String)this.getTitles());
        this.bg = guiHelper.createDrawable(new ResourceLocation("industrialupgrade", "textures/gui/guiconvertersolidmatter.png"), 3, 5, 168, 135);
    }

    public RecipeType<ConverterHandler> getRecipeType() {
        return this.jeiInform.recipeType;
    }

    @Override
    @Nonnull
    public String getTitles() {
        return Localization.translate(ItemStackHelper.fromData(IUItem.convertersolidmatter, 1, 0).m_41778_());
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.bg;
    }

    public void draw(ConverterHandler recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics stack, double mouseX, double mouseY) {
        ++this.progress;
        ++this.energy;
        int energylevel = (int)Math.min(38.0f * (float)this.energy / 100.0f, 38.0f);
        int xScale = 31 * this.progress / 100;
        if (xScale > 31) {
            this.progress = 0;
        }
        ConverterCategory.bindTexture(this.getTexture());
        this.drawTexturedModalRect(stack, 116, 110, 176, 81, energylevel, 11);
        this.drawTexturedModalRect(stack, 78, 46, 176, 24, xScale, 16);
        this.drawTexturedModalRect(stack, 166 - xScale, 46, 208 - xScale, 24, xScale, 16);
        this.drawTexturedModalRect(stack, 114, 10, 177, 42, 16, xScale);
        this.drawTexturedModalRect(stack, 114, 98 - xScale, 177, 74 - xScale, 16, xScale);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, ConverterHandler recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.OUTPUT, 113, 45).addItemStack(recipe.getOutput());
        builder.addSlot(RecipeIngredientRole.INPUT, 47, 45).addItemStack(recipe.getOutput());
    }

    @Override
    protected ResourceLocation getTexture() {
        return new ResourceLocation("industrialupgrade", "textures/gui/guiconvertersolidmatter.png");
    }
}

