/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei;

import com.denfop.IUItem;
import com.denfop.blockentity.mechanism.BlockEntityUpgradeMachineFactory;
import com.denfop.blocks.mechanism.BlockBaseMachine3Entity;
import com.denfop.integration.jei.IRecipeCategory;
import com.denfop.integration.jei.JeiInform;
import com.denfop.integration.jei.ScrapboxRecipeHandler;
import com.denfop.screen.ScreenMain;
import com.denfop.utils.Localization;
import javax.annotation.Nonnull;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public class ScrapboxRecipeCategory
extends ScreenMain
implements IRecipeCategory<ScrapboxRecipeHandler> {
    private final IDrawableStatic bg;
    JeiInform jeiInform;

    public ScrapboxRecipeCategory(IGuiHelper guiHelper, JeiInform jeiInform) {
        super(((BlockEntityUpgradeMachineFactory)BlockBaseMachine3Entity.upgrade_machine.getDummyTe()).getGuiContainer((Player)Minecraft.m_91087_().f_91074_));
        this.bg = guiHelper.createDrawable(new ResourceLocation("industrialupgrade" + ":textures/gui/ScrapboxRecipes.png".toLowerCase()), 55, 30, 82, 26);
        this.jeiInform = jeiInform;
        this.f_96539_ = Component.m_237113_((String)this.getTitles());
    }

    public RecipeType<ScrapboxRecipeHandler> getRecipeType() {
        return this.jeiInform.recipeType;
    }

    @Override
    @Nonnull
    public String getTitles() {
        return Localization.translate("iu.crafting.scrap_box");
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.bg;
    }

    public void draw(ScrapboxRecipeHandler recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics stack, double mouseX, double mouseY) {
        float value = (float)recipe.getNeed();
        Object text = (double)value < 0.001 ? "< 0.01" : "  " + String.format("%.2f", Float.valueOf(value * 100.0f));
        this.draw(stack, (String)text + "%", 86, 9, 0x404040);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, ScrapboxRecipeHandler recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 1, 5).addItemStack(IUItem.scrapBox);
        builder.addSlot(RecipeIngredientRole.OUTPUT, 61, 5).addItemStack(recipe.getOutput());
    }

    @Override
    protected ResourceLocation getTexture() {
        return new ResourceLocation("industrialupgrade", "textures/gui/guivein.png");
    }
}

