/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.events;

import com.denfop.IUCore;
import com.denfop.damagesource.IUDamageSource;
import com.denfop.items.armour.ISpecialArmor;
import com.denfop.network.WorldData;
import com.denfop.world.IWorldTickCallback;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.NonNullList;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class TickHandlerIU {
    public static void requestSingleWorldTick(Level world, IWorldTickCallback callback) {
        WorldData.get((Level)world).singleUpdates.add(callback);
    }

    private static void processUpdates(Level world, WorldData worldData) {
        IWorldTickCallback callback;
        while ((callback = worldData.singleUpdates.poll()) != null) {
            callback.onTick(world);
        }
    }

    @SubscribeEvent
    public void hurt(LivingDamageEvent event) {
        if (event.getEntity() instanceof LivingEntity) {
            NonNullList armorList = NonNullList.m_122780_((int)4, (Object)ItemStack.f_41583_);
            armorList.set(0, (Object)event.getEntity().m_6844_(EquipmentSlot.FEET));
            armorList.set(1, (Object)event.getEntity().m_6844_(EquipmentSlot.LEGS));
            armorList.set(2, (Object)event.getEntity().m_6844_(EquipmentSlot.CHEST));
            armorList.set(3, (Object)event.getEntity().m_6844_(EquipmentSlot.HEAD));
            float damageAmount = ISpecialArmor.ArmorProperties.applyArmor(event.getEntity(), (NonNullList<ItemStack>)armorList, event.getSource(), event.getAmount());
            event.setAmount(damageAmount);
        }
    }

    @SubscribeEvent
    public void hurt(LivingHurtEvent event) {
        if (event.getEntity() instanceof LivingEntity) {
            NonNullList armorList = NonNullList.m_122780_((int)4, (Object)ItemStack.f_41583_);
            armorList.set(0, (Object)event.getEntity().m_6844_(EquipmentSlot.FEET));
            armorList.set(1, (Object)event.getEntity().m_6844_(EquipmentSlot.LEGS));
            armorList.set(2, (Object)event.getEntity().m_6844_(EquipmentSlot.CHEST));
            armorList.set(3, (Object)event.getEntity().m_6844_(EquipmentSlot.HEAD));
            float damageAmount = ISpecialArmor.ArmorProperties.applyArmor(event.getEntity(), (NonNullList<ItemStack>)armorList, event.getSource(), event.getAmount());
            event.setAmount(damageAmount);
        }
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.LevelTickEvent event) {
        Level world = event.level;
        WorldData worldData = WorldData.get(world, false);
        if (worldData != null) {
            if (event.phase == TickEvent.Phase.START) {
                TickHandlerIU.processUpdates(world, worldData);
            } else if (world.f_46443_) {
                IUCore.network.getClient().onTickEnd(worldData);
            } else {
                IUCore.network.getServer().onTickEnd(worldData);
            }
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            IUCore.keyboard.sendKeyUpdate();
            if (Minecraft.m_91087_().f_91073_ != null) {
                if (IUDamageSource.current == null) {
                    IUDamageSource.initDamage(Minecraft.m_91087_().f_91073_.m_9598_());
                }
                ClientLevel world = Minecraft.m_91087_().f_91073_;
                TickHandlerIU.processUpdates((Level)world, WorldData.get((Level)world));
            }
        }
    }
}

