/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.events;

import com.denfop.IUItem;
import com.denfop.api.item.upgrade.UpgradeItemInform;
import com.denfop.api.item.upgrade.UpgradeSystem;
import com.denfop.api.pollution.radiation.Radiation;
import com.denfop.api.pollution.radiation.RadiationSystem;
import com.denfop.api.upgrades.IUpgradableBlock;
import com.denfop.api.upgrades.IUpgradeItem;
import com.denfop.api.upgrades.UpgradableProperty;
import com.denfop.blocks.BlockApatite;
import com.denfop.blocks.BlockClassicOre;
import com.denfop.blocks.BlockHeavyOre;
import com.denfop.blocks.BlockMineral;
import com.denfop.blocks.BlockOre;
import com.denfop.blocks.BlockOres2;
import com.denfop.blocks.BlockOres3;
import com.denfop.blocks.BlockPreciousOre;
import com.denfop.blocks.BlockThoriumOre;
import com.denfop.blocks.BlocksRadiationOre;
import com.denfop.blocks.blockitem.ItemBlockApatite;
import com.denfop.blocks.blockitem.ItemBlockClassicOre;
import com.denfop.blocks.blockitem.ItemBlockHeavyOre;
import com.denfop.blocks.blockitem.ItemBlockMineral;
import com.denfop.blocks.blockitem.ItemBlockOre;
import com.denfop.blocks.blockitem.ItemBlockOre2;
import com.denfop.blocks.blockitem.ItemBlockOre3;
import com.denfop.blocks.blockitem.ItemBlockPreciousOre;
import com.denfop.blocks.blockitem.ItemBlockRadiationOre;
import com.denfop.events.ClientTickHandler;
import com.denfop.items.EnumInfoUpgradeModules;
import com.denfop.items.ItemVeinSensor;
import com.denfop.items.energy.instruments.EnumOperations;
import com.denfop.items.energy.instruments.ItemEnergyInstruments;
import com.denfop.mixin.invoker.ParticleInvoker;
import com.denfop.render.base.RenderType;
import com.denfop.utils.ModUtils;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.XoroshiroRandomSource;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class TickHandler {
    final int latitudeSegments = 4;
    final int longitudeSegments = 4;
    double[] sinLat = new double[5];
    double[] cosLat = new double[5];
    double[] sinLng = new double[5];
    double[] cosLng = new double[5];
    boolean write = false;
    double[][] x1 = new double[4][4];
    double[][] x2 = new double[4][4];
    double[][] x3 = new double[4][4];
    double[][] x4 = new double[4][4];
    double[][] y1 = new double[4][4];
    double[][] y2 = new double[4][4];
    double[][] y3 = new double[4][4];
    double[][] y4 = new double[4][4];
    double[][] z1 = new double[4][4];
    double[][] z2 = new double[4][4];
    double[][] z3 = new double[4][4];
    double[][] z4 = new double[4][4];
    Set<UpgradableProperty> set = EnumSet.of(UpgradableProperty.FluidExtract, UpgradableProperty.FluidInput, UpgradableProperty.ItemInput, UpgradableProperty.ItemExtract);

    public TickHandler() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    protected static BlockHitResult getPlayerPOVHitResult(Level p_41436_, Player p_41437_, ClipContext.Fluid p_41438_) {
        float f = p_41437_.m_146909_();
        float f1 = p_41437_.m_146908_();
        Vec3 vec3 = p_41437_.m_146892_();
        float f2 = Mth.m_14089_((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = Mth.m_14031_((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = -Mth.m_14089_((float)(-f * ((float)Math.PI / 180)));
        float f5 = Mth.m_14031_((float)(-f * ((float)Math.PI / 180)));
        float f6 = f3 * f4;
        float f7 = f2 * f4;
        double d0 = p_41437_.getBlockReach();
        Vec3 vec31 = vec3.m_82520_((double)f6 * d0, (double)f5 * d0, (double)f7 * d0);
        return p_41436_.m_45547_(new ClipContext(vec3, vec31, ClipContext.Block.OUTLINE, p_41438_, (Entity)p_41437_));
    }

    @SubscribeEvent
    public void initData(TickEvent.LevelTickEvent event) {
    }

    public int getOreColor(BlockState state) {
        Block block = state.m_60734_();
        if (ItemVeinSensor.dataColors.containsKey(state)) {
            return ItemVeinSensor.dataColors.get(state);
        }
        if (block == Blocks.f_49996_) {
            return ModUtils.convertRGBcolorToInt(156, 156, 156);
        }
        if (block == Blocks.f_49995_ || block == Blocks.f_49998_) {
            return -10496;
        }
        if (block == Blocks.f_50089_) {
            return -16711681;
        }
        if (block == Blocks.f_50059_) {
            return ModUtils.convertRGBcolorToInt(30, 50, 173);
        }
        if (block == Blocks.f_50173_) {
            return ModUtils.convertRGBcolorToInt(173, 30, 30);
        }
        if (block == Blocks.f_49997_) {
            return ModUtils.convertRGBcolorToInt(4, 4, 4);
        }
        if (block == Blocks.f_152505_) {
            return ModUtils.convertRGBcolorToInt(255, 144, 0);
        }
        if (block == Blocks.f_50264_) {
            return ModUtils.convertRGBcolorToInt(0, 232, 0);
        }
        if (block == Blocks.f_50331_) {
            return ModUtils.convertRGBcolorToInt(223, 223, 223);
        }
        if (block == IUItem.toriyore.getBlock(0)) {
            return ModUtils.convertRGBcolorToInt(134, 134, 139);
        }
        if (block instanceof BlockClassicOre) {
            int meta = IUItem.classic_ore.getMeta((ItemBlockClassicOre)state.m_60734_().m_5456_());
            switch (meta) {
                case 0: {
                    return ModUtils.convertRGBcolorToInt(255, 144, 0);
                }
                case 1: {
                    return ModUtils.convertRGBcolorToInt(223, 223, 223);
                }
                case 2: {
                    return ModUtils.convertRGBcolorToInt(168, 176, 150);
                }
                case 3: {
                    return ModUtils.convertRGBcolorToInt(89, 158, 73);
                }
            }
            return ModUtils.convertRGBcolorToInt(4, 4, 4);
        }
        if (block instanceof BlocksRadiationOre) {
            int meta = IUItem.radiationore.getMeta((ItemBlockRadiationOre)state.m_60734_().m_5456_());
            switch (meta) {
                case 0: {
                    return ModUtils.convertRGBcolorToInt(120, 152, 183);
                }
                case 1: {
                    return ModUtils.convertRGBcolorToInt(97, 109, 88);
                }
                case 2: {
                    return ModUtils.convertRGBcolorToInt(150, 166, 148);
                }
            }
            return ModUtils.convertRGBcolorToInt(4, 4, 4);
        }
        if (block instanceof BlockPreciousOre) {
            int meta = IUItem.preciousore.getMeta((ItemBlockPreciousOre)state.m_60734_().m_5456_());
            switch (meta) {
                case 0: {
                    return ModUtils.convertRGBcolorToInt(251, 140, 119);
                }
                case 1: {
                    return ModUtils.convertRGBcolorToInt(38, 60, 143);
                }
                case 2: {
                    return ModUtils.convertRGBcolorToInt(204, 180, 47);
                }
            }
            return ModUtils.convertRGBcolorToInt(4, 4, 4);
        }
        if (block instanceof BlockOre) {
            int meta = IUItem.ore.getMeta((ItemBlockOre)state.m_60734_().m_5456_());
            switch (meta) {
                case 0: {
                    return ModUtils.convertRGBcolorToInt(119, 210, 202);
                }
                case 1: {
                    return ModUtils.convertRGBcolorToInt(108, 74, 108);
                }
                case 2: {
                    return ModUtils.convertRGBcolorToInt(142, 240, 216);
                }
                case 3: {
                    return ModUtils.convertRGBcolorToInt(199, 199, 199);
                }
                case 4: {
                    return ModUtils.convertRGBcolorToInt(0, 166, 226);
                }
                case 5: {
                    return ModUtils.convertRGBcolorToInt(170, 145, 160);
                }
                case 6: {
                    return ModUtils.convertRGBcolorToInt(145, 143, 88);
                }
                case 7: {
                    return ModUtils.convertRGBcolorToInt(104, 152, 237);
                }
                case 8: {
                    return ModUtils.convertRGBcolorToInt(71, 71, 71);
                }
                case 9: {
                    return ModUtils.convertRGBcolorToInt(83, 174, 85);
                }
                case 10: {
                    return ModUtils.convertRGBcolorToInt(184, 87, 145);
                }
                case 11: {
                    return ModUtils.convertRGBcolorToInt(211, 211, 211);
                }
                case 12: {
                    return ModUtils.convertRGBcolorToInt(186, 186, 186);
                }
                case 13: {
                    return ModUtils.convertRGBcolorToInt(235, 193, 207);
                }
                case 14: {
                    return ModUtils.convertRGBcolorToInt(234, 234, 234);
                }
                case 15: {
                    return ModUtils.convertRGBcolorToInt(138, 85, 34);
                }
            }
            return ModUtils.convertRGBcolorToInt(4, 4, 4);
        }
        if (block instanceof BlockHeavyOre) {
            int meta = IUItem.heavyore.getMeta((ItemBlockHeavyOre)state.m_60734_().m_5456_());
            switch (meta) {
                case 0: {
                    return ModUtils.convertRGBcolorToInt(137, 131, 149);
                }
                case 1: {
                    return ModUtils.convertRGBcolorToInt(249, 175, 44);
                }
                case 2: {
                    return ModUtils.convertRGBcolorToInt(150, 215, 206);
                }
                case 3: {
                    return ModUtils.convertRGBcolorToInt(211, 202, 110);
                }
                case 4: {
                    return ModUtils.convertRGBcolorToInt(212, 175, 55);
                }
                case 5: {
                    return ModUtils.convertRGBcolorToInt(250, 246, 241);
                }
                case 6: {
                    return ModUtils.convertRGBcolorToInt(70, 145, 15);
                }
                case 7: {
                    return ModUtils.convertRGBcolorToInt(230, 107, 0);
                }
                case 8: {
                    return ModUtils.convertRGBcolorToInt(139, 0, 0);
                }
                case 9: {
                    return ModUtils.convertRGBcolorToInt(55, 135, 135);
                }
                case 10: {
                    return ModUtils.convertRGBcolorToInt(170, 123, 44);
                }
                case 11: {
                    return ModUtils.convertRGBcolorToInt(109, 206, 167);
                }
                case 12: {
                    return ModUtils.convertRGBcolorToInt(110, 110, 110);
                }
                case 13: {
                    return ModUtils.convertRGBcolorToInt(198, 147, 64);
                }
                case 14: {
                    return ModUtils.convertRGBcolorToInt(100, 76, 136);
                }
                case 15: {
                    return ModUtils.convertRGBcolorToInt(135, 84, 64);
                }
            }
            return ModUtils.convertRGBcolorToInt(4, 4, 4);
        }
        if (block instanceof BlockMineral) {
            int meta = IUItem.mineral.getMeta((ItemBlockMineral)state.m_60734_().m_5456_());
            switch (meta) {
                case 0: {
                    return ModUtils.convertRGBcolorToInt(12, 166, 166);
                }
                case 1: {
                    return ModUtils.convertRGBcolorToInt(55, 117, 104);
                }
                case 2: {
                    return ModUtils.convertRGBcolorToInt(113, 97, 81);
                }
                case 3: {
                    return ModUtils.convertRGBcolorToInt(99, 51, 4);
                }
                case 4: {
                    return ModUtils.convertRGBcolorToInt(117, 88, 86);
                }
                case 5: {
                    return ModUtils.convertRGBcolorToInt(118, 28, 17);
                }
                case 6: {
                    return ModUtils.convertRGBcolorToInt(123, 76, 10);
                }
                case 7: {
                    return ModUtils.convertRGBcolorToInt(126, 101, 36);
                }
                case 8: {
                    return ModUtils.convertRGBcolorToInt(30, 126, 56);
                }
                case 9: {
                    return ModUtils.convertRGBcolorToInt(112, 129, 30);
                }
                case 10: {
                    return ModUtils.convertRGBcolorToInt(43, 43, 43);
                }
                case 11: {
                    return ModUtils.convertRGBcolorToInt(39, 64, 63);
                }
                case 12: {
                    return ModUtils.convertRGBcolorToInt(110, 25, 24);
                }
            }
            return ModUtils.convertRGBcolorToInt(4, 4, 4);
        }
        if (block instanceof BlockOres3) {
            int meta = IUItem.ore3.getMeta((ItemBlockOre3)state.m_60734_().m_5456_());
            switch (meta) {
                case 0: {
                    return ModUtils.convertRGBcolorToInt(191, 212, 65);
                }
                case 1: {
                    return ModUtils.convertRGBcolorToInt(253, 242, 80);
                }
                case 2: {
                    return ModUtils.convertRGBcolorToInt(37, 145, 133);
                }
                case 3: {
                    return ModUtils.convertRGBcolorToInt(255, 180, 0);
                }
                case 4: {
                    return ModUtils.convertRGBcolorToInt(252, 187, 89);
                }
                case 5: {
                    return ModUtils.convertRGBcolorToInt(212, 231, 255);
                }
                case 6: {
                    return ModUtils.convertRGBcolorToInt(222, 101, 98);
                }
                case 7: {
                    return ModUtils.convertRGBcolorToInt(118, 84, 192);
                }
                case 8: {
                    return ModUtils.convertRGBcolorToInt(125, 122, 160);
                }
                case 9: {
                    return ModUtils.convertRGBcolorToInt(61, 148, 224);
                }
                case 10: {
                    return ModUtils.convertRGBcolorToInt(230, 105, 17);
                }
                case 11: {
                    return ModUtils.convertRGBcolorToInt(84, 194, 246);
                }
                case 12: {
                    return ModUtils.convertRGBcolorToInt(168, 90, 41);
                }
                case 13: {
                    return ModUtils.convertRGBcolorToInt(121, 229, 71);
                }
                case 14: {
                    return ModUtils.convertRGBcolorToInt(255, 225, 136);
                }
            }
            return ModUtils.convertRGBcolorToInt(4, 4, 4);
        }
        if (block instanceof BlockOres2) {
            int meta = IUItem.ore2.getMeta((ItemBlockOre2)state.m_60734_().m_5456_());
            switch (meta) {
                case 0: {
                    return ModUtils.convertRGBcolorToInt(190, 207, 214);
                }
                case 1: {
                    return ModUtils.convertRGBcolorToInt(194, 194, 194);
                }
                case 2: {
                    return ModUtils.convertRGBcolorToInt(62, 69, 71);
                }
                case 3: {
                    return ModUtils.convertRGBcolorToInt(165, 236, 244);
                }
                case 4: {
                    return ModUtils.convertRGBcolorToInt(141, 174, 83);
                }
                case 5: {
                    return ModUtils.convertRGBcolorToInt(177, 100, 197);
                }
                case 6: {
                    return ModUtils.convertRGBcolorToInt(43, 43, 43);
                }
                case 7: {
                    return ModUtils.convertRGBcolorToInt(212, 212, 212);
                }
            }
            return ModUtils.convertRGBcolorToInt(4, 4, 4);
        }
        if (block instanceof BlockApatite) {
            int meta = IUItem.apatite.getMeta((ItemBlockApatite)state.m_60734_().m_5456_());
            switch (meta) {
                case 0: {
                    return ModUtils.convertRGBcolorToInt(48, 86, 16);
                }
                case 1: {
                    return ModUtils.convertRGBcolorToInt(134, 95, 11);
                }
                case 2: {
                    return ModUtils.convertRGBcolorToInt(202, 202, 202);
                }
                case 3: {
                    return ModUtils.convertRGBcolorToInt(202, 202, 202);
                }
                case 4: {
                    return ModUtils.convertRGBcolorToInt(202, 202, 202);
                }
            }
            return ModUtils.convertRGBcolorToInt(4, 4, 4);
        }
        return -1;
    }

    private int getRadiationTier(Level world, ChunkPos chunkPos) {
        Radiation rad = RadiationSystem.rad_system.getMap().get(chunkPos);
        return rad == null ? 0 : rad.getLevel().ordinal();
    }

    public int clamp(int a, int min, int max) {
        return a < min ? min : (a > max ? max : a);
    }

    public void showRadiationEffects(LocalPlayer player, Level world, ChunkPos chunkPos, int tier) {
        ParticleEngine particleEngine = Minecraft.m_91087_().f_91061_;
        int particleCount = this.clamp(tier * 30, 30, 120);
        double minX = chunkPos.m_45604_();
        double maxX = chunkPos.m_45608_() + 1;
        double minZ = chunkPos.m_45605_();
        double maxZ = chunkPos.m_45609_() + 1;
        XoroshiroRandomSource rand = new XoroshiroRandomSource(world.m_46467_());
        for (int i = 0; i < particleCount; ++i) {
            Particle particle;
            double x;
            double y = player.m_20186_() + rand.m_188500_() * 16.0;
            Vec3 position = new Vec3(x, y, switch (rand.m_188503_(4)) {
                case 0 -> {
                    x = minX;
                    yield minZ + rand.m_188500_() * 16.0;
                }
                case 1 -> {
                    x = maxX;
                    yield minZ + rand.m_188500_() * 16.0;
                }
                case 2 -> {
                    x = minX + rand.m_188500_() * 16.0;
                    yield minZ;
                }
                default -> {
                    x = minX + rand.m_188500_() * 16.0;
                    yield maxZ;
                }
            });
            boolean isPortal = rand.m_188499_();
            Particle particle2 = particle = isPortal ? particleEngine.m_107370_((ParticleOptions)ParticleTypes.f_123760_, position.f_82479_, position.f_82480_, position.f_82481_, 0.0, 0.0, 0.0) : particleEngine.m_107370_((ParticleOptions)ParticleTypes.f_123762_, position.f_82479_, position.f_82480_, position.f_82481_, 0.0, 0.0, 0.0);
            if (particle == null) continue;
            if (isPortal) {
                particle.m_107253_(0.0f, 1.0f - (float)tier * 0.2f, 0.0f);
                ((ParticleInvoker)particle).invokeSetAlpha(0.5f + rand.m_188501_() * 0.5f);
                continue;
            }
            particle.m_107253_(0.1f, 0.9f - (float)tier * 0.15f, 0.1f);
            ((ParticleInvoker)particle).invokeSetAlpha(0.7f + rand.m_188501_() * 0.3f);
            particle.m_107257_(40);
        }
    }

    public Direction getDirection(ItemStack stack) {
        byte rawDir = ModUtils.nbt(stack).m_128445_("dir");
        return rawDir >= 1 && rawDir <= 6 ? Direction.values()[rawDir - 1] : null;
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onRenderTileSide(RenderLevelStageEvent event) {
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null || mc.f_91073_ == null) {
            return;
        }
        Item item = player.m_21205_().m_41720_();
        if (!(item instanceof IUpgradeItem)) {
            return;
        }
        IUpgradeItem upgradeItem = (IUpgradeItem)item;
        if (!upgradeItem.isSuitableFor(player.m_21205_(), this.set)) {
            return;
        }
        if (mc.f_91073_ == null || event.getStage() != RenderLevelStageEvent.Stage.AFTER_SOLID_BLOCKS) {
            return;
        }
        BlockHitResult ray = TickHandler.getPlayerPOVHitResult((Level)mc.f_91073_, (Player)mc.f_91074_, ClipContext.Fluid.NONE);
        if (ray == null || ray.m_6662_() != HitResult.Type.BLOCK) {
            return;
        }
        Direction facing = this.getDirection(player.m_21205_());
        BlockEntity tile = player.m_9236_().m_7702_(ray.m_82425_());
        if (!(tile instanceof IUpgradableBlock)) {
            return;
        }
        PoseStack poseStack = event.getPoseStack();
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        if (facing != null) {
            BlockPos pos = ray.m_82425_().m_121955_(facing.m_122436_());
            boolean xRange = false;
            boolean yRange = false;
            boolean zRange = false;
            Vec3 camera = event.getCamera().m_90583_();
            double x = camera.f_82479_;
            double y = camera.f_82480_;
            double z = camera.f_82481_;
            poseStack.m_85836_();
            poseStack.m_85837_(-x, -y, -z);
            x = pos.m_123341_();
            y = pos.m_123342_();
            z = pos.m_123343_();
            RenderSystem.setShader(GameRenderer::m_172817_);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            VertexConsumer p_109623_ = Minecraft.m_91087_().m_91269_().m_110104_().m_6299_(net.minecraft.client.renderer.RenderType.m_110504_());
            RenderSystem.lineWidth((float)10.0f);
            Vec3 lookVec = player.m_20154_();
            int xPos = (int)(x - (double)xRange);
            while ((double)xPos <= x + (double)xRange) {
                int yPos = (int)(y - (double)yRange);
                while ((double)yPos <= y + (double)yRange) {
                    int zPos = (int)(z - (double)zRange);
                    while ((double)zPos <= z + (double)zRange) {
                        BlockPos currentPos = new BlockPos(xPos, yPos, zPos);
                        Vec3 blockVec = new Vec3((double)currentPos.m_123341_() + 0.5 - player.m_20185_(), (double)currentPos.m_123342_() + 0.5 - player.m_20186_(), (double)currentPos.m_123343_() + 0.5 - player.m_20189_());
                        float p_109630_ = 1.0f;
                        float p_109635_ = 1.0f;
                        float p_109636_ = 1.0f;
                        float p_109633_ = 1.0f;
                        float p_109634_ = 1.0f;
                        float p_109631_ = 1.0f;
                        float p_109632_ = 1.0f;
                        Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
                        Matrix3f matrix3f = poseStack.m_85850_().m_252943_();
                        int f = currentPos.m_123341_();
                        int f1 = currentPos.m_123342_();
                        int f2 = currentPos.m_123343_();
                        int f3 = currentPos.m_123341_() + 1;
                        int f4 = currentPos.m_123342_() + 1;
                        int f5 = currentPos.m_123343_() + 1;
                        p_109623_.m_252986_(matrix4f, (float)f, (float)f1, (float)f2).m_85950_(p_109630_, p_109635_, p_109636_, p_109633_).m_252939_(matrix3f, 1.0f, 0.0f, 0.0f).m_5752_();
                        p_109623_.m_252986_(matrix4f, (float)f3, (float)f1, (float)f2).m_85950_(p_109630_, p_109635_, p_109636_, p_109633_).m_252939_(matrix3f, 1.0f, 0.0f, 0.0f).m_5752_();
                        p_109623_.m_252986_(matrix4f, (float)f, (float)f1, (float)f2).m_85950_(p_109634_, p_109631_, p_109636_, p_109633_).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
                        p_109623_.m_252986_(matrix4f, (float)f, (float)f4, (float)f2).m_85950_(p_109634_, p_109631_, p_109636_, p_109633_).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
                        p_109623_.m_252986_(matrix4f, (float)f, (float)f1, (float)f2).m_85950_(p_109634_, p_109635_, p_109632_, p_109633_).m_252939_(matrix3f, 0.0f, 0.0f, 1.0f).m_5752_();
                        p_109623_.m_252986_(matrix4f, (float)f, (float)f1, (float)f5).m_85950_(p_109634_, p_109635_, p_109632_, p_109633_).m_252939_(matrix3f, 0.0f, 0.0f, 1.0f).m_5752_();
                        p_109623_.m_252986_(matrix4f, (float)f3, (float)f1, (float)f2).m_85950_(p_109630_, p_109631_, p_109632_, p_109633_).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
                        p_109623_.m_252986_(matrix4f, (float)f3, (float)f4, (float)f2).m_85950_(p_109630_, p_109631_, p_109632_, p_109633_).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
                        p_109623_.m_252986_(matrix4f, (float)f3, (float)f4, (float)f2).m_85950_(p_109630_, p_109631_, p_109632_, p_109633_).m_252939_(matrix3f, -1.0f, 0.0f, 0.0f).m_5752_();
                        p_109623_.m_252986_(matrix4f, (float)f, (float)f4, (float)f2).m_85950_(p_109630_, p_109631_, p_109632_, p_109633_).m_252939_(matrix3f, -1.0f, 0.0f, 0.0f).m_5752_();
                        p_109623_.m_252986_(matrix4f, (float)f, (float)f4, (float)f2).m_85950_(p_109630_, p_109631_, p_109632_, p_109633_).m_252939_(matrix3f, 0.0f, 0.0f, 1.0f).m_5752_();
                        p_109623_.m_252986_(matrix4f, (float)f, (float)f4, (float)f5).m_85950_(p_109630_, p_109631_, p_109632_, p_109633_).m_252939_(matrix3f, 0.0f, 0.0f, 1.0f).m_5752_();
                        p_109623_.m_252986_(matrix4f, (float)f, (float)f4, (float)f5).m_85950_(p_109630_, p_109631_, p_109632_, p_109633_).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
                        p_109623_.m_252986_(matrix4f, (float)f, (float)f1, (float)f5).m_85950_(p_109630_, p_109631_, p_109632_, p_109633_).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
                        p_109623_.m_252986_(matrix4f, (float)f, (float)f1, (float)f5).m_85950_(p_109630_, p_109631_, p_109632_, p_109633_).m_252939_(matrix3f, 1.0f, 0.0f, 0.0f).m_5752_();
                        p_109623_.m_252986_(matrix4f, (float)f3, (float)f1, (float)f5).m_85950_(p_109630_, p_109631_, p_109632_, p_109633_).m_252939_(matrix3f, 1.0f, 0.0f, 0.0f).m_5752_();
                        p_109623_.m_252986_(matrix4f, (float)f3, (float)f1, (float)f5).m_85950_(p_109630_, p_109631_, p_109632_, p_109633_).m_252939_(matrix3f, 0.0f, 0.0f, -1.0f).m_5752_();
                        p_109623_.m_252986_(matrix4f, (float)f3, (float)f1, (float)f2).m_85950_(p_109630_, p_109631_, p_109632_, p_109633_).m_252939_(matrix3f, 0.0f, 0.0f, -1.0f).m_5752_();
                        p_109623_.m_252986_(matrix4f, (float)f, (float)f4, (float)f5).m_85950_(p_109630_, p_109631_, p_109632_, p_109633_).m_252939_(matrix3f, 1.0f, 0.0f, 0.0f).m_5752_();
                        p_109623_.m_252986_(matrix4f, (float)f3, (float)f4, (float)f5).m_85950_(p_109630_, p_109631_, p_109632_, p_109633_).m_252939_(matrix3f, 1.0f, 0.0f, 0.0f).m_5752_();
                        p_109623_.m_252986_(matrix4f, (float)f3, (float)f1, (float)f5).m_85950_(p_109630_, p_109631_, p_109632_, p_109633_).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
                        p_109623_.m_252986_(matrix4f, (float)f3, (float)f4, (float)f5).m_85950_(p_109630_, p_109631_, p_109632_, p_109633_).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
                        p_109623_.m_252986_(matrix4f, (float)f3, (float)f4, (float)f2).m_85950_(p_109630_, p_109631_, p_109632_, p_109633_).m_252939_(matrix3f, 0.0f, 0.0f, 1.0f).m_5752_();
                        p_109623_.m_252986_(matrix4f, (float)f3, (float)f4, (float)f5).m_85950_(p_109630_, p_109631_, p_109632_, p_109633_).m_252939_(matrix3f, 0.0f, 0.0f, 1.0f).m_5752_();
                        ++zPos;
                    }
                    ++yPos;
                }
                ++xPos;
            }
            poseStack.m_85849_();
        } else {
            for (Direction facing1 : Direction.values()) {
                BlockPos pos = ray.m_82425_().m_121955_(facing1.m_122436_());
                boolean xRange = false;
                boolean yRange = false;
                boolean zRange = false;
                Vec3 camera = event.getCamera().m_90583_();
                double x = camera.f_82479_;
                double y = camera.f_82480_;
                double z = camera.f_82481_;
                poseStack.m_85836_();
                poseStack.m_85837_(-x, -y, -z);
                x = pos.m_123341_();
                y = pos.m_123342_();
                z = pos.m_123343_();
                RenderSystem.setShader(GameRenderer::m_172817_);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                VertexConsumer p_109623_ = Minecraft.m_91087_().m_91269_().m_110104_().m_6299_(net.minecraft.client.renderer.RenderType.m_110504_());
                RenderSystem.lineWidth((float)10.0f);
                Vec3 lookVec = player.m_20154_();
                int xPos = (int)(x - (double)xRange);
                while ((double)xPos <= x + (double)xRange) {
                    int yPos = (int)(y - (double)yRange);
                    while ((double)yPos <= y + (double)yRange) {
                        int zPos = (int)(z - (double)zRange);
                        while ((double)zPos <= z + (double)zRange) {
                            BlockPos currentPos = new BlockPos(xPos, yPos, zPos);
                            Vec3 blockVec = new Vec3((double)currentPos.m_123341_() + 0.5 - player.m_20185_(), (double)currentPos.m_123342_() + 0.5 - player.m_20186_(), (double)currentPos.m_123343_() + 0.5 - player.m_20189_());
                            float p_109630_ = 1.0f;
                            float p_109635_ = 1.0f;
                            float p_109636_ = 1.0f;
                            float p_109633_ = 1.0f;
                            float p_109634_ = 1.0f;
                            float p_109631_ = 1.0f;
                            float p_109632_ = 1.0f;
                            Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
                            Matrix3f matrix3f = poseStack.m_85850_().m_252943_();
                            int f = currentPos.m_123341_();
                            int f1 = currentPos.m_123342_();
                            int f2 = currentPos.m_123343_();
                            int f3 = currentPos.m_123341_() + 1;
                            int f4 = currentPos.m_123342_() + 1;
                            int f5 = currentPos.m_123343_() + 1;
                            p_109623_.m_252986_(matrix4f, (float)f, (float)f1, (float)f2).m_85950_(p_109630_, p_109635_, p_109636_, p_109633_).m_252939_(matrix3f, 1.0f, 0.0f, 0.0f).m_5752_();
                            p_109623_.m_252986_(matrix4f, (float)f3, (float)f1, (float)f2).m_85950_(p_109630_, p_109635_, p_109636_, p_109633_).m_252939_(matrix3f, 1.0f, 0.0f, 0.0f).m_5752_();
                            p_109623_.m_252986_(matrix4f, (float)f, (float)f1, (float)f2).m_85950_(p_109634_, p_109631_, p_109636_, p_109633_).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
                            p_109623_.m_252986_(matrix4f, (float)f, (float)f4, (float)f2).m_85950_(p_109634_, p_109631_, p_109636_, p_109633_).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
                            p_109623_.m_252986_(matrix4f, (float)f, (float)f1, (float)f2).m_85950_(p_109634_, p_109635_, p_109632_, p_109633_).m_252939_(matrix3f, 0.0f, 0.0f, 1.0f).m_5752_();
                            p_109623_.m_252986_(matrix4f, (float)f, (float)f1, (float)f5).m_85950_(p_109634_, p_109635_, p_109632_, p_109633_).m_252939_(matrix3f, 0.0f, 0.0f, 1.0f).m_5752_();
                            p_109623_.m_252986_(matrix4f, (float)f3, (float)f1, (float)f2).m_85950_(p_109630_, p_109631_, p_109632_, p_109633_).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
                            p_109623_.m_252986_(matrix4f, (float)f3, (float)f4, (float)f2).m_85950_(p_109630_, p_109631_, p_109632_, p_109633_).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
                            p_109623_.m_252986_(matrix4f, (float)f3, (float)f4, (float)f2).m_85950_(p_109630_, p_109631_, p_109632_, p_109633_).m_252939_(matrix3f, -1.0f, 0.0f, 0.0f).m_5752_();
                            p_109623_.m_252986_(matrix4f, (float)f, (float)f4, (float)f2).m_85950_(p_109630_, p_109631_, p_109632_, p_109633_).m_252939_(matrix3f, -1.0f, 0.0f, 0.0f).m_5752_();
                            p_109623_.m_252986_(matrix4f, (float)f, (float)f4, (float)f2).m_85950_(p_109630_, p_109631_, p_109632_, p_109633_).m_252939_(matrix3f, 0.0f, 0.0f, 1.0f).m_5752_();
                            p_109623_.m_252986_(matrix4f, (float)f, (float)f4, (float)f5).m_85950_(p_109630_, p_109631_, p_109632_, p_109633_).m_252939_(matrix3f, 0.0f, 0.0f, 1.0f).m_5752_();
                            p_109623_.m_252986_(matrix4f, (float)f, (float)f4, (float)f5).m_85950_(p_109630_, p_109631_, p_109632_, p_109633_).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
                            p_109623_.m_252986_(matrix4f, (float)f, (float)f1, (float)f5).m_85950_(p_109630_, p_109631_, p_109632_, p_109633_).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
                            p_109623_.m_252986_(matrix4f, (float)f, (float)f1, (float)f5).m_85950_(p_109630_, p_109631_, p_109632_, p_109633_).m_252939_(matrix3f, 1.0f, 0.0f, 0.0f).m_5752_();
                            p_109623_.m_252986_(matrix4f, (float)f3, (float)f1, (float)f5).m_85950_(p_109630_, p_109631_, p_109632_, p_109633_).m_252939_(matrix3f, 1.0f, 0.0f, 0.0f).m_5752_();
                            p_109623_.m_252986_(matrix4f, (float)f3, (float)f1, (float)f5).m_85950_(p_109630_, p_109631_, p_109632_, p_109633_).m_252939_(matrix3f, 0.0f, 0.0f, -1.0f).m_5752_();
                            p_109623_.m_252986_(matrix4f, (float)f3, (float)f1, (float)f2).m_85950_(p_109630_, p_109631_, p_109632_, p_109633_).m_252939_(matrix3f, 0.0f, 0.0f, -1.0f).m_5752_();
                            p_109623_.m_252986_(matrix4f, (float)f, (float)f4, (float)f5).m_85950_(p_109630_, p_109631_, p_109632_, p_109633_).m_252939_(matrix3f, 1.0f, 0.0f, 0.0f).m_5752_();
                            p_109623_.m_252986_(matrix4f, (float)f3, (float)f4, (float)f5).m_85950_(p_109630_, p_109631_, p_109632_, p_109633_).m_252939_(matrix3f, 1.0f, 0.0f, 0.0f).m_5752_();
                            p_109623_.m_252986_(matrix4f, (float)f3, (float)f1, (float)f5).m_85950_(p_109630_, p_109631_, p_109632_, p_109633_).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
                            p_109623_.m_252986_(matrix4f, (float)f3, (float)f4, (float)f5).m_85950_(p_109630_, p_109631_, p_109632_, p_109633_).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
                            p_109623_.m_252986_(matrix4f, (float)f3, (float)f4, (float)f2).m_85950_(p_109630_, p_109631_, p_109632_, p_109633_).m_252939_(matrix3f, 0.0f, 0.0f, 1.0f).m_5752_();
                            p_109623_.m_252986_(matrix4f, (float)f3, (float)f4, (float)f5).m_85950_(p_109630_, p_109631_, p_109632_, p_109633_).m_252939_(matrix3f, 0.0f, 0.0f, 1.0f).m_5752_();
                            ++zPos;
                        }
                        ++yPos;
                    }
                    ++xPos;
                }
                poseStack.m_85849_();
            }
        }
    }

    @SubscribeEvent
    public void onRenderWorld(RenderLevelStageEvent event) {
        Minecraft minecraft = Minecraft.m_91087_();
        LocalPlayer player = minecraft.f_91074_;
        if (player == null || minecraft.f_91073_ == null || event.getStage() != RenderLevelStageEvent.Stage.AFTER_PARTICLES) {
            return;
        }
        if (player != null && minecraft.f_91077_ instanceof BlockHitResult) {
            BlockHitResult ray = (BlockHitResult)minecraft.f_91077_;
            if (!(player.m_21205_().m_41720_() instanceof ItemEnergyInstruments)) {
                return;
            }
            if (ray.m_6662_() != HitResult.Type.BLOCK) {
                return;
            }
            BlockPos blockPos = ray.m_82425_();
            PoseStack poseStack = event.getPoseStack();
            float size = 1.0f;
            ItemEnergyInstruments instruments = (ItemEnergyInstruments)player.m_21205_().m_41720_();
            ItemStack stack = player.m_21205_();
            List<UpgradeItemInform> upgradeItemInforms = UpgradeSystem.system.getInformation(stack);
            int toolMode = instruments.readToolMode(stack);
            EnumOperations operations = instruments.getOperations().get(toolMode);
            int aoe = 0;
            int dig_depth = 0;
            switch (operations) {
                case BIGHOLES: {
                    aoe = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.AOE_DIG, stack, upgradeItemInforms) ? UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.AOE_DIG, (ItemStack)stack, upgradeItemInforms).number : 0;
                    ++aoe;
                    dig_depth = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.DIG_DEPTH, stack, upgradeItemInforms) ? UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.DIG_DEPTH, (ItemStack)stack, upgradeItemInforms).number : 0;
                    List<Integer> list = UpgradeSystem.system.getUpgradeFromList(stack);
                    if (list == null || list.size() < 5) break;
                    dig_depth += list.get(4).intValue();
                    break;
                }
                case MEGAHOLES: {
                    aoe = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.AOE_DIG, stack, upgradeItemInforms) ? UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.AOE_DIG, (ItemStack)stack, upgradeItemInforms).number : 0;
                    aoe += 2;
                    dig_depth = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.DIG_DEPTH, stack, upgradeItemInforms) ? UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.DIG_DEPTH, (ItemStack)stack, upgradeItemInforms).number : 0;
                    List<Integer> list = UpgradeSystem.system.getUpgradeFromList(stack);
                    if (list == null || list.size() < 5) break;
                    dig_depth += list.get(4).intValue();
                    break;
                }
                case ULTRAHOLES: {
                    aoe = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.AOE_DIG, stack, upgradeItemInforms) ? UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.AOE_DIG, (ItemStack)stack, upgradeItemInforms).number : 0;
                    aoe += 3;
                    dig_depth = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.DIG_DEPTH, stack, upgradeItemInforms) ? UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.DIG_DEPTH, (ItemStack)stack, upgradeItemInforms).number : 0;
                    List<Integer> list = UpgradeSystem.system.getUpgradeFromList(stack);
                    if (list == null || list.size() < 5) break;
                    dig_depth += list.get(4).intValue();
                    break;
                }
            }
            Minecraft mc = Minecraft.m_91087_();
            BlockPos pos = ray.m_82425_();
            int xRange = aoe;
            int yRange = aoe;
            int zRange = aoe;
            switch (ray.m_82434_().ordinal()) {
                case 0: 
                case 1: {
                    yRange = dig_depth;
                    break;
                }
                case 2: 
                case 3: {
                    zRange = dig_depth;
                    break;
                }
                case 4: 
                case 5: {
                    xRange = dig_depth;
                }
            }
            int Yy = yRange > 0 ? yRange - 1 : 0;
            poseStack.m_85836_();
            double camX = mc.f_91063_.m_109153_().m_90583_().m_7096_();
            double camY = mc.f_91063_.m_109153_().m_90583_().m_7098_();
            double camZ = mc.f_91063_.m_109153_().m_90583_().m_7094_();
            poseStack.m_85837_(-camX, -camY, -camZ);
            int x = pos.m_123341_();
            int y = pos.m_123342_();
            int z = pos.m_123343_();
            RenderSystem.enableDepthTest();
            RenderSystem.setShaderColor((float)0.0f, (float)1.0f, (float)0.0f, (float)0.5f);
            Tesselator tessellator = Tesselator.m_85913_();
            RenderSystem.setShader(GameRenderer::m_172817_);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            VertexConsumer p_109623_ = Minecraft.m_91087_().m_91269_().m_110104_().m_6299_(net.minecraft.client.renderer.RenderType.m_110504_());
            RenderSystem.lineWidth((float)10.0f);
            Vec3 lookVec = player.m_20154_();
            for (int xPos = x - xRange; xPos <= x + xRange; ++xPos) {
                for (int yPos = y - yRange + Yy; yPos <= y + yRange + Yy; ++yPos) {
                    for (int zPos = z - zRange; zPos <= z + zRange; ++zPos) {
                        BlockPos currentPos = new BlockPos(xPos, yPos, zPos);
                        BlockState state = player.m_9236_().m_8055_(currentPos);
                        if (state.m_60795_()) continue;
                        float p_109630_ = 1.0f;
                        float p_109635_ = 1.0f;
                        float p_109636_ = 1.0f;
                        float p_109633_ = 1.0f;
                        float p_109634_ = 1.0f;
                        float p_109631_ = 1.0f;
                        float p_109632_ = 1.0f;
                        Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
                        Matrix3f matrix3f = poseStack.m_85850_().m_252943_();
                        int f = currentPos.m_123341_();
                        int f1 = currentPos.m_123342_();
                        int f2 = currentPos.m_123343_();
                        int f3 = currentPos.m_123341_() + 1;
                        int f4 = currentPos.m_123342_() + 1;
                        int f5 = currentPos.m_123343_() + 1;
                        p_109623_.m_252986_(matrix4f, (float)f, (float)f1, (float)f2).m_85950_(0.0f, p_109635_, 0.0f, p_109633_).m_252939_(matrix3f, 1.0f, 0.0f, 0.0f).m_5752_();
                        p_109623_.m_252986_(matrix4f, (float)f3, (float)f1, (float)f2).m_85950_(0.0f, p_109635_, 0.0f, p_109633_).m_252939_(matrix3f, 1.0f, 0.0f, 0.0f).m_5752_();
                        p_109623_.m_252986_(matrix4f, (float)f, (float)f1, (float)f2).m_85950_(0.0f, p_109631_, 0.0f, p_109633_).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
                        p_109623_.m_252986_(matrix4f, (float)f, (float)f4, (float)f2).m_85950_(0.0f, p_109631_, 0.0f, p_109633_).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
                        p_109623_.m_252986_(matrix4f, (float)f, (float)f1, (float)f2).m_85950_(0.0f, p_109635_, 0.0f, p_109633_).m_252939_(matrix3f, 0.0f, 0.0f, 1.0f).m_5752_();
                        p_109623_.m_252986_(matrix4f, (float)f, (float)f1, (float)f5).m_85950_(0.0f, p_109635_, 0.0f, p_109633_).m_252939_(matrix3f, 0.0f, 0.0f, 1.0f).m_5752_();
                        p_109623_.m_252986_(matrix4f, (float)f3, (float)f1, (float)f2).m_85950_(0.0f, p_109631_, 0.0f, p_109633_).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
                        p_109623_.m_252986_(matrix4f, (float)f3, (float)f4, (float)f2).m_85950_(0.0f, p_109631_, 0.0f, p_109633_).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
                        p_109623_.m_252986_(matrix4f, (float)f3, (float)f4, (float)f2).m_85950_(0.0f, p_109631_, 0.0f, p_109633_).m_252939_(matrix3f, -1.0f, 0.0f, 0.0f).m_5752_();
                        p_109623_.m_252986_(matrix4f, (float)f, (float)f4, (float)f2).m_85950_(0.0f, p_109631_, 0.0f, p_109633_).m_252939_(matrix3f, -1.0f, 0.0f, 0.0f).m_5752_();
                        p_109623_.m_252986_(matrix4f, (float)f, (float)f4, (float)f2).m_85950_(0.0f, p_109631_, 0.0f, p_109633_).m_252939_(matrix3f, 0.0f, 0.0f, 1.0f).m_5752_();
                        p_109623_.m_252986_(matrix4f, (float)f, (float)f4, (float)f5).m_85950_(0.0f, p_109631_, 0.0f, p_109633_).m_252939_(matrix3f, 0.0f, 0.0f, 1.0f).m_5752_();
                        p_109623_.m_252986_(matrix4f, (float)f, (float)f4, (float)f5).m_85950_(0.0f, p_109631_, 0.0f, p_109633_).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
                        p_109623_.m_252986_(matrix4f, (float)f, (float)f1, (float)f5).m_85950_(0.0f, p_109631_, 0.0f, p_109633_).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
                        p_109623_.m_252986_(matrix4f, (float)f, (float)f1, (float)f5).m_85950_(0.0f, p_109631_, 0.0f, p_109633_).m_252939_(matrix3f, 1.0f, 0.0f, 0.0f).m_5752_();
                        p_109623_.m_252986_(matrix4f, (float)f3, (float)f1, (float)f5).m_85950_(0.0f, p_109631_, 0.0f, p_109633_).m_252939_(matrix3f, 1.0f, 0.0f, 0.0f).m_5752_();
                        p_109623_.m_252986_(matrix4f, (float)f3, (float)f1, (float)f5).m_85950_(0.0f, p_109631_, 0.0f, p_109633_).m_252939_(matrix3f, 0.0f, 0.0f, -1.0f).m_5752_();
                        p_109623_.m_252986_(matrix4f, (float)f3, (float)f1, (float)f2).m_85950_(0.0f, p_109631_, 0.0f, p_109633_).m_252939_(matrix3f, 0.0f, 0.0f, -1.0f).m_5752_();
                        p_109623_.m_252986_(matrix4f, (float)f, (float)f4, (float)f5).m_85950_(0.0f, p_109631_, 0.0f, p_109633_).m_252939_(matrix3f, 1.0f, 0.0f, 0.0f).m_5752_();
                        p_109623_.m_252986_(matrix4f, (float)f3, (float)f4, (float)f5).m_85950_(0.0f, p_109631_, 0.0f, p_109633_).m_252939_(matrix3f, 1.0f, 0.0f, 0.0f).m_5752_();
                        p_109623_.m_252986_(matrix4f, (float)f3, (float)f1, (float)f5).m_85950_(0.0f, p_109631_, 0.0f, p_109633_).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
                        p_109623_.m_252986_(matrix4f, (float)f3, (float)f4, (float)f5).m_85950_(0.0f, p_109631_, 0.0f, p_109633_).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
                        p_109623_.m_252986_(matrix4f, (float)f3, (float)f4, (float)f2).m_85950_(0.0f, p_109631_, 0.0f, p_109633_).m_252939_(matrix3f, 0.0f, 0.0f, 1.0f).m_5752_();
                        p_109623_.m_252986_(matrix4f, (float)f3, (float)f4, (float)f5).m_85950_(0.0f, p_109631_, 0.0f, p_109633_).m_252939_(matrix3f, 0.0f, 0.0f, 1.0f).m_5752_();
                    }
                }
            }
            RenderSystem.disableDepthTest();
            poseStack.m_85849_();
        }
    }

    @SubscribeEvent
    public void onRenderOres(RenderLevelStageEvent event) {
        HitResult ray;
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ == null) {
            return;
        }
        LocalPlayer player = mc.f_91074_;
        if (player == null || mc.f_91073_ == null || event.getStage() != RenderLevelStageEvent.Stage.AFTER_PARTICLES) {
            return;
        }
        if (!(player.m_21205_().m_41720_() instanceof ItemEnergyInstruments)) {
            return;
        }
        if (!this.write) {
            this.writeData();
        }
        if (!((ray = mc.f_91077_) instanceof BlockHitResult)) {
            return;
        }
        BlockHitResult blockRay = (BlockHitResult)ray;
        ItemStack stack = player.m_21205_();
        ItemEnergyInstruments instruments = (ItemEnergyInstruments)stack.m_41720_();
        int toolMode = instruments.readToolMode(stack);
        EnumOperations operations = instruments.getOperations().get(toolMode);
        if (operations != EnumOperations.ORE) {
            return;
        }
        PoseStack poseStack = event.getPoseStack();
        BlockPos centerPos = blockRay.m_82425_();
        double camX = mc.f_91063_.m_109153_().m_90583_().m_7096_();
        double camY = mc.f_91063_.m_109153_().m_90583_().m_7098_();
        double camZ = mc.f_91063_.m_109153_().m_90583_().m_7094_();
        for (int x = centerPos.m_123341_() - 5; x <= centerPos.m_123341_() + 5; ++x) {
            for (int y = centerPos.m_123342_() - 5; y <= centerPos.m_123342_() + 5; ++y) {
                for (int z = centerPos.m_123343_() - 5; z <= centerPos.m_123343_() + 5; ++z) {
                    BlockPos pos = new BlockPos(x, y, z);
                    BlockState state = player.m_9236_().m_8055_(pos);
                    if (!this.isOre(state)) continue;
                    int color = this.getOreColor(state);
                    float r = (float)(color >> 16 & 0xFF) / 255.0f;
                    float g = (float)(color >> 8 & 0xFF) / 255.0f;
                    float b = (float)(color & 0xFF) / 255.0f;
                    poseStack.m_85836_();
                    VertexConsumer bufferSource = Minecraft.m_91087_().m_91269_().m_110104_().m_6299_(RenderType.LEASH);
                    poseStack.m_85837_(-camX, -camY, -camZ);
                    RenderSystem.enableDepthTest();
                    this.drawCircle(poseStack, bufferSource, pos, r, g, b, 0.5f);
                    RenderSystem.disableDepthTest();
                    poseStack.m_85849_();
                }
            }
        }
    }

    private void drawCircle(PoseStack poseStack, VertexConsumer bufferSource, BlockPos pos, float r, float g, float b, float alpha) {
        float x = (float)pos.m_123341_() + 0.5f;
        float y = (float)pos.m_123342_() + 0.5f;
        float z = (float)pos.m_123343_() + 0.5f;
        float radius = 0.35f;
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        Matrix3f matrix3f = poseStack.m_85850_().m_252943_();
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                double x1 = this.x1[i][j];
                double y1 = this.y1[i][j];
                double z1 = this.z1[i][j];
                double x2 = this.x2[i][j];
                double y2 = this.y2[i][j];
                double z2 = this.z2[i][j];
                double x3 = this.x3[i][j];
                double y3 = this.y3[i][j];
                double z3 = this.z3[i][j];
                double x4 = this.x4[i][j];
                double y4 = this.y4[i][j];
                double z4 = this.z4[i][j];
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                bufferSource.m_252986_(matrix, (float)((double)x + x1 * (double)radius), (float)((double)y + y1 * (double)radius), (float)((double)z + z1 * (double)radius)).m_85950_(r, g, b, 1.0f).m_5752_();
                bufferSource.m_252986_(matrix, (float)((double)x + x2 * (double)radius), (float)((double)y + y2 * (double)radius), (float)((double)z + z2 * (double)radius)).m_85950_(r, g, b, 1.0f).m_5752_();
                bufferSource.m_252986_(matrix, (float)((double)x + x3 * (double)radius), (float)((double)y + y3 * (double)radius), (float)((double)z + z3 * (double)radius)).m_85950_(r, g, b, 1.0f).m_5752_();
                bufferSource.m_252986_(matrix, (float)((double)x + x3 * (double)radius), (float)((double)y + y3 * (double)radius), (float)((double)z + z3 * (double)radius)).m_85950_(r, g, b, 1.0f).m_5752_();
                bufferSource.m_252986_(matrix, (float)((double)x + x4 * (double)radius), (float)((double)y + y4 * (double)radius), (float)((double)z + z4 * (double)radius)).m_85950_(r, g, b, 1.0f).m_5752_();
                bufferSource.m_252986_(matrix, (float)((double)x + x1 * (double)radius), (float)((double)y + y1 * (double)radius), (float)((double)z + z1 * (double)radius)).m_85950_(r, g, b, 1.0f).m_5752_();
            }
        }
    }

    private void writeData() {
        int i;
        this.write = true;
        for (i = 0; i <= 4; ++i) {
            double lat = Math.PI * (-0.5 + (double)i / 4.0);
            this.sinLat[i] = Math.sin(lat);
            this.cosLat[i] = Math.cos(lat);
        }
        for (int j = 0; j <= 4; ++j) {
            double lng = Math.PI * 2 * (double)j / 4.0;
            this.sinLng[j] = Math.sin(lng);
            this.cosLng[j] = Math.cos(lng);
        }
        for (i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                this.x1[i][j] = this.cosLng[j] * this.cosLat[i];
                this.y1[i][j] = this.sinLat[i];
                this.z1[i][j] = this.sinLng[j] * this.cosLat[i];
                this.x2[i][j] = this.cosLng[j] * this.cosLat[i + 1];
                this.y2[i][j] = this.sinLat[i + 1];
                this.z2[i][j] = this.sinLng[j] * this.cosLat[i + 1];
                this.x3[i][j] = this.cosLng[j + 1] * this.cosLat[i + 1];
                this.y3[i][j] = this.sinLat[i + 1];
                this.z3[i][j] = this.sinLng[j + 1] * this.cosLat[i + 1];
                this.x4[i][j] = this.cosLng[j + 1] * this.cosLat[i];
                this.y4[i][j] = this.sinLat[i];
                this.z4[i][j] = this.sinLng[j + 1] * this.cosLat[i];
            }
        }
    }

    private boolean isOre(BlockState state) {
        return state.m_60734_() == Blocks.f_49996_ || state.m_60734_() instanceof BlocksRadiationOre || state.m_60734_() instanceof BlockThoriumOre || state.m_60734_() == Blocks.f_152505_ || state.m_60734_() == Blocks.f_49995_ || state.m_60734_() == Blocks.f_49997_ || state.m_60734_() == Blocks.f_50173_ || state.m_60734_() == Blocks.f_49998_ || state.m_60734_() == Blocks.f_50264_ || state.m_60734_() == Blocks.f_50331_ || state.m_60734_() == Blocks.f_50059_ || state.m_60734_() instanceof BlockClassicOre || state.m_60734_() instanceof BlockPreciousOre || state.m_60734_() == Blocks.f_50089_ || state.m_60734_() instanceof BlockHeavyOre || state.m_60734_() instanceof BlockMineral || state.m_60734_() instanceof BlockOre || state.m_60734_() instanceof BlockOres2 || state.m_60734_() instanceof BlockOres3 || state.m_60734_() instanceof BlockApatite;
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void renderTick(RenderGuiOverlayEvent.Post event) {
        ClientTickHandler.onTickRender1(event.getGuiGraphics());
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onPlayerUpdate(LivingEvent.LivingTickEvent event) {
        ChunkPos chunkPos;
        LocalPlayer player;
        Level world;
        int tier;
        if (event.getEntity() instanceof LocalPlayer && (tier = this.getRadiationTier(world = (player = (LocalPlayer)event.getEntity()).m_9236_(), chunkPos = new ChunkPos(player.m_20097_()))) > 1) {
            this.showRadiationEffects(player, world, chunkPos, tier);
        }
    }
}

