/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.containermenu;

import com.denfop.api.crop.CropItem;
import com.denfop.api.crop.CropNetwork;
import com.denfop.api.crop.genetics.Genome;
import com.denfop.containermenu.ContainerMenuHandHeldInventory;
import com.denfop.items.crop.ItemStackAgriculturalAnalyzer;
import com.denfop.utils.ModUtils;
import java.util.Objects;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetCarriedItemPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class ContainerMenuAgriculturalAnalyzer
extends ContainerMenuHandHeldInventory<ItemStackAgriculturalAnalyzer> {
    public final int inventorySize;
    private final int current;

    public ContainerMenuAgriculturalAnalyzer(Player player, final ItemStackAgriculturalAnalyzer Toolbox1) {
        super(Toolbox1, player);
        this.player = player;
        this.inventory = player.m_150109_();
        this.inventorySize = Toolbox1.inventorySize;
        int slots = Toolbox1.inventorySize;
        this.addSlotToContainer(new Slot(Toolbox1, 0, 180, 65){

            public boolean m_5857_(ItemStack stack) {
                return stack.m_41720_() instanceof CropItem;
            }

            public int m_6641_() {
                return 1;
            }

            public void m_5852_(ItemStack stack) {
                super.m_5852_(stack);
                if (stack.m_41619_()) {
                    Toolbox1.crop = null;
                    Toolbox1.genome = null;
                } else {
                    ModUtils.nbt(stack).m_128379_("analyzed", true);
                    Toolbox1.genome = new Genome(stack);
                    Toolbox1.crop = CropNetwork.instance.getCropFromStack(stack).copy();
                    Toolbox1.genome.loadCrop(Toolbox1.crop);
                }
            }
        });
        this.current = player.m_150109_().f_35977_;
        this.addPlayerInventorySlots(player.m_150109_(), 166);
    }

    @Override
    protected void addPlayerInventorySlots(Inventory inventory, int width, int height) {
        int xStart = (width - 162) / 2;
        for (int col = 0; col < 9; ++col) {
            this.addSlotToContainer(new Slot((Container)this.player.m_150109_(), col, xStart + col * 18, height + -24));
        }
    }

    @Override
    public void m_150399_(int slot, int button, ClickType type, Player player) {
        ItemStack held;
        if (slot >= 0 && slot < this.f_38839_.size() && ((ItemStackAgriculturalAnalyzer)this.base).isThisContainer(((Slot)this.f_38839_.get(slot)).m_7993_())) {
            return;
        }
        boolean closeGUI = false;
        block0 : switch (type) {
            case CLONE: 
            case PICKUP_ALL: 
            case QUICK_CRAFT: {
                break;
            }
            case PICKUP: 
            case THROW: {
                if (slot < 0 || slot >= this.f_38839_.size()) break;
                closeGUI = ((ItemStackAgriculturalAnalyzer)this.base).isThisContainer(((Slot)this.f_38839_.get(slot)).m_7993_());
                break;
            }
            case QUICK_MOVE: {
                if (slot < 0 || slot >= this.f_38839_.size() || !((ItemStackAgriculturalAnalyzer)this.base).isThisContainer(((Slot)this.f_38839_.get(slot)).m_7993_())) break;
                this.m_142503_(ModUtils.emptyStack);
                break;
            }
            case SWAP: {
                if (button == this.current) {
                    this.m_142503_(ItemStack.f_41583_);
                    return;
                }
                assert (this.getSlotFromInventory((Container)player.m_150109_(), button) != null);
                boolean swapOut = ((ItemStackAgriculturalAnalyzer)this.base).isThisContainer(this.getSlotFromInventory((Container)player.m_150109_(), button).m_7993_());
                boolean swapTo = ((ItemStackAgriculturalAnalyzer)this.base).isThisContainer(((Slot)this.f_38839_.get(slot)).m_7993_());
                if (!swapOut && !swapTo) break;
                for (int i = 0; i < 9; ++i) {
                    if ((!swapOut || slot != Objects.requireNonNull(this.getSlotFromInventory((Container)player.m_150109_(), (int)i)).f_40219_) && (!swapTo || button != i)) continue;
                    if (!(player instanceof ServerPlayer)) break block0;
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    serverPlayer.f_8906_.m_9829_((Packet)new ClientboundSetCarriedItemPacket(i));
                    break block0;
                }
                break;
            }
            default: {
                throw new RuntimeException("Unexpected ClickType: " + type);
            }
        }
        ItemStack stack = this.slotClick1(slot, button, type, player);
        if (closeGUI && !player.m_9236_().m_5776_()) {
            ((ItemStackAgriculturalAnalyzer)this.base).saveAsThrown(stack);
            player.m_6915_();
        } else if (type == ClickType.CLONE && ((ItemStackAgriculturalAnalyzer)this.base).isThisContainer(held = player.m_150109_().m_36056_())) {
            held.m_41783_().m_128473_("uid");
        }
        this.m_142503_(stack);
    }

    public ItemStack slotClick1(int slotId, int dragType, ClickType clickType, Player player) {
        super.m_150399_(slotId, dragType, clickType, player);
        return this.m_142621_();
    }
}

