/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.config;

import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class ModConfig {
    public static final Common COMMON;
    public static final ForgeConfigSpec COMMON_SPEC;

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Common::new);
        COMMON_SPEC = (ForgeConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
    }

    public static class Common {
        public final ForgeConfigSpec.BooleanValue newsystem;
        public final ForgeConfigSpec.BooleanValue enableEasyMode;
        public final ForgeConfigSpec.BooleanValue cableEasyMode;
        public final ForgeConfigSpec.BooleanValue enableExplosion;
        public final ForgeConfigSpec.BooleanValue enableLosing;
        public final ForgeConfigSpec.IntValue maxVein;
        public final ForgeConfigSpec.IntValue gasMaxVein;
        public final ForgeConfigSpec.IntValue gasChance;
        public final ForgeConfigSpec.BooleanValue airPollution;
        public final ForgeConfigSpec.BooleanValue soilPollution;
        public final ForgeConfigSpec.BooleanValue pressureWork;
        public final ForgeConfigSpec.BooleanValue damageRadiation;
        public final ForgeConfigSpec.BooleanValue informationText;
        public final ForgeConfigSpec.BooleanValue radiationChunksEnabled;
        public final ForgeConfigSpec.BooleanValue radiationDamageEnabled;
        public final ForgeConfigSpec.BooleanValue radiationAccumulationEnabled;
        public final ForgeConfigSpec.IntValue desertChance;
        public final ForgeConfigSpec.IntValue desertMin;
        public final ForgeConfigSpec.IntValue desertMax;
        public final ForgeConfigSpec.IntValue oceanChance;
        public final ForgeConfigSpec.IntValue oceanMin;
        public final ForgeConfigSpec.IntValue oceanMax;
        public final ForgeConfigSpec.IntValue deepOceanChance;
        public final ForgeConfigSpec.IntValue deepOceanMin;
        public final ForgeConfigSpec.IntValue deepOceanMax;
        public final ForgeConfigSpec.IntValue riverChance;
        public final ForgeConfigSpec.IntValue riverMin;
        public final ForgeConfigSpec.IntValue riverMax;
        public final ForgeConfigSpec.IntValue savannaChance;
        public final ForgeConfigSpec.IntValue savannaMin;
        public final ForgeConfigSpec.IntValue savannaMax;
        public final ForgeConfigSpec.IntValue defaultChance;
        public final ForgeConfigSpec.IntValue defaultMin;
        public final ForgeConfigSpec.IntValue defaultMax;
        public final ForgeConfigSpec.BooleanValue enableAllProfessions;
        public final ForgeConfigSpec.BooleanValue enableEngineer;
        public final ForgeConfigSpec.BooleanValue enableMechanic;
        public final ForgeConfigSpec.BooleanValue enableNuclear;
        public final ForgeConfigSpec.BooleanValue enableMetallurg;
        public final ForgeConfigSpec.BooleanValue enableChemist;
        public final ForgeConfigSpec.BooleanValue enableBotanist;
        public final ForgeConfigSpec.BooleanValue cooldownEnabled;
        public final ForgeConfigSpec.BooleanValue defaultSpawnEnabled;

        public Common(ForgeConfigSpec.Builder builder) {
            builder.push("Generation ores");
            this.defaultSpawnEnabled = builder.comment("Enable approximately default ore generation (false = vein system)").define("defaultSpawnEnabled", false);
            builder.pop();
            builder.push("Mechanisms");
            this.cooldownEnabled = builder.comment("Enable cooldown for mechanisms (false = no cooldown)").define("cooldownEnabled", true);
            builder.pop();
            builder.push("Vein");
            this.maxVein = builder.comment("Maximum amount of ore in a vein").defineInRange("maxVein", 30000, 1, Integer.MAX_VALUE);
            this.gasMaxVein = builder.comment("Maximum amount of mb in a gas vein (not natural gas)").defineInRange("gasMaxVein", 200000, 1, Integer.MAX_VALUE);
            this.gasChance = builder.comment("Chance to get a gas vein (not natural gas)").defineInRange("gasChance", 25, 1, 100);
            builder.pop();
            builder.push("Information Text");
            this.informationText = builder.comment("Informational text when logging the game").define("enable", true);
            builder.pop();
            builder.push("pollution");
            this.airPollution = builder.comment("Air pollution").define("airPollution", true);
            this.soilPollution = builder.comment("Soil pollution").define("soilPollution", true);
            builder.pop();
            builder.push("Oil Vein");
            this.desertChance = builder.comment("Chance % for oil vein in desert").defineInRange("desertChance", 65, 0, 100);
            this.desertMin = builder.defineInRange("desertMin", 250000, 0, Integer.MAX_VALUE);
            this.desertMax = builder.defineInRange("desertMax", 1000000, 0, Integer.MAX_VALUE);
            this.oceanChance = builder.defineInRange("oceanChance", 60, 0, 100);
            this.oceanMin = builder.defineInRange("oceanMin", 250000, 0, Integer.MAX_VALUE);
            this.oceanMax = builder.defineInRange("oceanMax", 750000, 0, Integer.MAX_VALUE);
            this.deepOceanChance = builder.defineInRange("deepOceanChance", 65, 0, 100);
            this.deepOceanMin = builder.defineInRange("deepOceanMin", 150000, 0, Integer.MAX_VALUE);
            this.deepOceanMax = builder.defineInRange("deepOceanMax", 500000, 0, Integer.MAX_VALUE);
            this.riverChance = builder.defineInRange("riverChance", 50, 0, 100);
            this.riverMin = builder.defineInRange("riverMin", 100000, 0, Integer.MAX_VALUE);
            this.riverMax = builder.defineInRange("riverMax", 250000, 0, Integer.MAX_VALUE);
            this.savannaChance = builder.defineInRange("savannaChance", 50, 0, 100);
            this.savannaMin = builder.defineInRange("savannaMin", 150000, 0, Integer.MAX_VALUE);
            this.savannaMax = builder.defineInRange("savannaMax", 500000, 0, Integer.MAX_VALUE);
            this.defaultChance = builder.defineInRange("defaultChance", 11, 0, 100);
            this.defaultMin = builder.defineInRange("defaultMin", 0, 0, Integer.MAX_VALUE);
            this.defaultMax = builder.defineInRange("defaultMax", 300000, 0, Integer.MAX_VALUE);
            builder.pop();
            builder.push("TransformerMode");
            this.newsystem = builder.comment("Transformer mode enabled").define("TransformerMode", true);
            this.enableEasyMode = builder.comment("Unchecking the tier").define("enableUnchecking", false);
            this.cableEasyMode = builder.comment("Unlimiting the conduction of energy in the cable").define("cableUnlimiting", false);
            this.enableExplosion = builder.comment("Enable explosion from mechanisms if transformer mode is on").define("enableExplosion", true);
            this.enableLosing = builder.comment("Enable lose energy in cables if transformer mode is on").define("enableLosing", true);
            builder.pop();
            builder.push("VillagerProfessions");
            this.enableAllProfessions = builder.comment("Enable registration of ALL custom villager professions").define("enableAllProfessions", true);
            this.enableEngineer = builder.define("enableEngineer", true);
            this.enableMechanic = builder.define("enableMechanic", true);
            this.enableNuclear = builder.define("enableNuclear", true);
            this.enableMetallurg = builder.define("enableMetallurg", true);
            this.enableChemist = builder.define("enableChemist", true);
            this.enableBotanist = builder.define("enableBotanist", true);
            builder.pop();
            builder.push("Pressure Network");
            this.pressureWork = builder.comment("Remove the pressure level restriction in the pressure system (allows machines to work at any pressure level)").define("pressureRestriction", true);
            builder.pop();
            builder.push("Radiation");
            this.damageRadiation = builder.comment("Enable damage from radiation").define("radiationDamageEnabled", true);
            this.radiationChunksEnabled = builder.comment("Enable radiation chunks generation").define("radiationChunksEnabled", true);
            this.radiationDamageEnabled = builder.comment("Enable damage from radiation chunk").define("radiationDamageEnabled", true);
            this.radiationAccumulationEnabled = builder.comment("Enable radiation accumulation on the player").define("radiationAccumulationEnabled", true);
            builder.pop();
        }
    }
}

