/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.componets;

import com.denfop.blockentity.base.BlockEntityInventory;
import com.denfop.componets.AbstractComponent;
import com.denfop.componets.TypePurifierJob;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.utils.Timer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class ComponentTimer
extends AbstractComponent {
    private final List<Timer> defaultTimers;
    private final List<Timer> timers;
    double percent = 1.0;
    private int indexWork;
    private boolean canWork = true;

    public ComponentTimer(BlockEntityInventory inventory, Timer ... timers) {
        super(inventory);
        this.timers = Arrays.asList(timers);
        this.defaultTimers = new ArrayList<Timer>();
        for (Timer timer : this.timers) {
            this.defaultTimers.add(timer.cloning());
        }
        this.indexWork = 0;
    }

    public int getIndexWork() {
        return this.indexWork;
    }

    @Override
    public boolean isServer() {
        return true;
    }

    public int getTickFromSecond() {
        return 20;
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        boolean need = true;
        if (this.getParent().m_58904_().m_46467_() % (long)this.getTickFromSecond() == 0L && this.canWork) {
            for (int i = 0; i < this.timers.size(); ++i) {
                Timer timer = this.timers.get(i);
                if (!timer.canWork()) continue;
                timer.work(this.percent);
                this.indexWork = i;
                need = false;
                break;
            }
            if (need) {
                this.indexWork = -1;
            }
        }
    }

    public boolean isCanWork() {
        return this.canWork;
    }

    public void setCanWork(boolean canWork) {
        boolean oldWork = this.canWork;
        this.canWork = canWork;
        if (oldWork && !this.canWork) {
            this.resetTime();
        }
    }

    public void setCanWorkWithOut(boolean canWork) {
        this.canWork = canWork;
    }

    public void resetTime() {
        for (int i = 0; i < this.timers.size(); ++i) {
            this.timers.get(i).readTimer(this.defaultTimers.get(i));
        }
    }

    public String getTime() {
        if (this.indexWork != -1) {
            return this.timers.get(this.indexWork % this.timers.size()).getDisplay();
        }
        return this.timers.get(this.timers.size() - 1).getDisplay();
    }

    public double getTimes() {
        if (this.indexWork != -1) {
            int max = this.getDefaultTimers().get(this.indexWork).getBar();
            return (double)(max - this.timers.get(this.indexWork).getBar()) / ((double)max * 1.0);
        }
        int max = this.getDefaultTimers().get(this.timers.size() - 1).getBar();
        return (double)(max - this.timers.get(this.timers.size() - 1).getBar()) / ((double)max * 1.0);
    }

    @Override
    public CompoundTag writeNBTToDrops(CompoundTag tagCompound) {
        tagCompound.m_128405_("size", this.timers.size());
        for (int i = 0; i < this.timers.size(); ++i) {
            tagCompound.m_128365_("Timer_" + i, (Tag)this.timers.get(i).writeNBT(new CompoundTag()));
        }
        return tagCompound;
    }

    @Override
    public CustomPacketBuffer updateComponent() {
        CustomPacketBuffer packet = super.updateComponent();
        this.timers.forEach(timer -> timer.writeBuffer(packet));
        packet.writeInt(this.indexWork);
        return packet;
    }

    @Override
    public CompoundTag writeToNbt() {
        CompoundTag nbtTagCompound = super.writeToNbt();
        nbtTagCompound.m_128405_("indexWork", this.indexWork);
        nbtTagCompound.m_128405_("size", this.timers.size());
        for (int i = 0; i < this.timers.size(); ++i) {
            nbtTagCompound.m_128365_("Timer_" + i, (Tag)this.timers.get(i).writeNBT(new CompoundTag()));
        }
        return nbtTagCompound;
    }

    @Override
    public void readFromNbt(CompoundTag nbt) {
        super.readFromNbt(nbt);
        this.indexWork = nbt.m_128451_("indexWork");
        int size = nbt.m_128451_("size");
        for (int i = 0; i < size; ++i) {
            this.timers.get(i).readNBT(nbt.m_128469_("Timer_" + i));
        }
    }

    public List<Timer> getDefaultTimers() {
        return this.defaultTimers;
    }

    public List<Timer> getTimers() {
        return this.timers;
    }

    @Override
    public boolean canUsePurifier(Player player) {
        return true;
    }

    @Override
    public TypePurifierJob getPurifierJob() {
        return TypePurifierJob.Actions;
    }

    @Override
    public void ActionPurifier() {
        this.resetTime();
    }

    @Override
    public void onContainerUpdate(ServerPlayer player) {
        CustomPacketBuffer buffer = new CustomPacketBuffer(this.timers.size() * 3 + 1);
        this.timers.forEach(timer -> timer.writeBuffer(buffer));
        buffer.writeInt(this.indexWork);
        buffer.flip();
        this.setNetworkUpdate(player, buffer);
    }

    @Override
    public void onNetworkUpdate(CustomPacketBuffer is) throws IOException {
        this.timers.forEach(timer -> {
            try {
                timer.readBuffer(is);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
        this.indexWork = is.readInt();
    }
}

