/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blocks.mechanism;

import com.denfop.api.blockentity.MultiBlockEntity;
import com.denfop.blockentity.base.BlockEntityBase;
import com.denfop.blockentity.storage.BlockEntityController;
import com.denfop.blockentity.storage.BlockEntityEncoderPatternBlock;
import com.denfop.blockentity.storage.BlockEntityEncoderPatternWorkbench;
import com.denfop.blockentity.storage.BlockEntityEntityStorageCells;
import com.denfop.blockentity.storage.BlockEntityExportBus;
import com.denfop.blockentity.storage.BlockEntityFluidExportBus;
import com.denfop.blockentity.storage.BlockEntityFluidImportBus;
import com.denfop.blockentity.storage.BlockEntityImportBus;
import com.denfop.blockentity.storage.BlockEntityInterface;
import com.denfop.blockentity.storage.BlockEntityInterfaceWorkbench;
import com.denfop.blockentity.storage.BlockEntityMonitor;
import com.denfop.blockentity.storage.processor.BlockEntityAdvProcessor;
import com.denfop.blockentity.storage.processor.BlockEntityImpProcessor;
import com.denfop.blockentity.storage.processor.BlockEntityPerProcessor;
import com.denfop.blockentity.storage.processor.BlockEntitySimpleProcessor;
import com.denfop.blocks.state.DefaultDrop;
import com.denfop.blocks.state.HarvestTool;
import com.denfop.utils.ModUtils;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.registries.RegistryObject;

public enum BlockStorageSystemEntity implements MultiBlockEntity
{
    storage_cells(BlockEntityEntityStorageCells.class, 0),
    controller(BlockEntityController.class, 1),
    interface_workbench(BlockEntityInterfaceWorkbench.class, 2),
    interface_entity(BlockEntityInterface.class, 3),
    importbus(BlockEntityImportBus.class, 4),
    exportbus(BlockEntityExportBus.class, 5),
    fluid_importbus(BlockEntityFluidImportBus.class, 6),
    fluid_exportbus(BlockEntityFluidExportBus.class, 7),
    processor(BlockEntitySimpleProcessor.class, 8),
    adv_processor(BlockEntityAdvProcessor.class, 9),
    imp_processor(BlockEntityImpProcessor.class, 10),
    per_processor(BlockEntityPerProcessor.class, 11),
    encoder_pattern_workbench(BlockEntityEncoderPatternWorkbench.class, 12),
    encoder_pattern_block(BlockEntityEncoderPatternBlock.class, 13),
    monitor(BlockEntityMonitor.class, 14);

    private final Class<? extends BlockEntityBase> teClass;
    private final int itemMeta;
    private final Rarity rarity;
    int idBlock;
    private BlockEntityBase dummyTe;
    private BlockState defaultState;
    private RegistryObject<BlockEntityType<? extends BlockEntityBase>> blockType;

    private BlockStorageSystemEntity(Class<? extends BlockEntityBase> teClass, int itemMeta) {
        this(teClass, itemMeta, Rarity.UNCOMMON);
    }

    private BlockStorageSystemEntity(Class<? extends BlockEntityBase> teClass, int itemMeta, Rarity rarity) {
        this.teClass = teClass;
        this.itemMeta = itemMeta;
        this.rarity = rarity;
    }

    @Override
    public int getIDBlock() {
        return this.idBlock;
    }

    @Override
    public void setIdBlock(int id) {
        this.idBlock = id;
    }

    @Override
    public void buildDummies() {
        ModContainer mc = ModLoadingContext.get().getActiveContainer();
        if (mc == null || !"industrialupgrade".equals(mc.getModId())) {
            throw new IllegalAccessError("Don't mess with this please.");
        }
        if (this.getTeClass() != null) {
            try {
                this.dummyTe = (BlockEntityBase)((Object)this.teClass.getConstructors()[0].newInstance(BlockPos.f_121853_, this.defaultState));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void setDefaultState(BlockState blockState) {
        this.defaultState = blockState;
    }

    @Override
    public void setType(RegistryObject<BlockEntityType<? extends BlockEntityBase>> blockEntityType) {
        this.blockType = blockEntityType;
    }

    @Override
    public BlockEntityType<? extends BlockEntityBase> getBlockType() {
        return (BlockEntityType)this.blockType.get();
    }

    @Override
    public String getMainPath() {
        return "storagesystem";
    }

    @Override
    public String getName() {
        return this.name();
    }

    @Override
    public int getId() {
        return this.itemMeta;
    }

    @Override
    public boolean hasItem() {
        return true;
    }

    @Override
    public Class<? extends BlockEntityBase> getTeClass() {
        return this.teClass;
    }

    @Override
    public boolean hasActive() {
        return true;
    }

    @Override
    @Nonnull
    public Set<Direction> getSupportedFacings() {
        return ModUtils.horizontalFacings;
    }

    @Override
    public float getHardness() {
        return 3.0f;
    }

    @Override
    @Nonnull
    public HarvestTool getHarvestTool() {
        return HarvestTool.Wrench;
    }

    @Override
    @Nonnull
    public DefaultDrop getDefaultDrop() {
        return DefaultDrop.Self;
    }

    @Override
    public boolean allowWrenchRotating() {
        return true;
    }

    @Override
    public BlockEntityBase getDummyTe() {
        return this.dummyTe;
    }
}

