/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blocks;

import com.denfop.IUItem;
import com.denfop.blocks.BlockCore;
import com.denfop.blocks.ItemBlockCore;
import com.denfop.blocks.SubEnum;
import com.denfop.dataregistry.DataBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;

public class BlockFoam<T extends Enum<T>>
extends BlockCore<T> {
    public BlockFoam(T[] elements, T element, DataBlock<T, ? extends BlockCore<T>, ? extends ItemBlockCore<T>> dataBlock) {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283930_).m_155954_(0.01f).m_60955_().m_60910_().m_155956_(10.0f).m_60918_(SoundType.f_56745_).m_60977_(), elements, element, dataBlock);
    }

    public static float getHardenChance(Level world, BlockPos pos, BlockState state, FoamType type) {
        int light = world.m_46803_(pos);
        if (!state.supportsExternalFaceHiding() && state.m_60734_().getLightEmission(state, (BlockGetter)world, pos) == 0) {
            Direction[] var5;
            for (Direction side : var5 = Direction.values()) {
                light = Math.max(light, world.m_46803_(pos.m_121955_(side.m_122436_())));
            }
        }
        int avgTime = type.hardenTime * (16 - light);
        return 1.0f / (float)(avgTime * 20);
    }

    public void m_213898_(BlockState p_222954_, ServerLevel p_222955_, BlockPos p_222956_, RandomSource p_222957_) {
        int tickSpeed = p_222955_.m_46469_().m_46215_(GameRules.f_46143_);
        if (tickSpeed <= 0) {
            throw new IllegalStateException("Foam was randomly ticked when world " + p_222955_ + " isn't ticking?");
        }
        FoamType type = (FoamType)this.getElement();
        float chance = BlockFoam.getHardenChance((Level)p_222955_, p_222956_, p_222954_, type) * 4096.0f / (float)tickSpeed;
        if (p_222957_.m_188501_() < chance) {
            p_222955_.m_7731_(p_222956_, FoamType.values()[this.getMetaFromState(p_222954_)].getResult(), 3);
        }
    }

    public InteractionResult m_6227_(BlockState p_60503_, Level p_60504_, BlockPos p_60505_, Player p_60506_, InteractionHand p_60507_, BlockHitResult p_60508_) {
        ItemStack handItem = p_60506_.m_21120_(p_60507_);
        if (!handItem.m_41619_() && handItem.m_150930_(new ItemStack((ItemLike)Blocks.f_49992_).m_41720_())) {
            p_60504_.m_7731_(p_60505_, FoamType.values()[this.getMetaFromState(p_60503_)].getResult(), 3);
            handItem.m_41774_(1);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public boolean isValidSpawn(BlockState state, BlockGetter level, BlockPos pos, SpawnPlacements.Type type, EntityType<?> entityType) {
        return false;
    }

    @Override
    public <T extends Enum<T>> BlockState getStateForPlacement(T element, BlockPlaceContext context) {
        return (BlockState)this.f_49792_.m_61090_();
    }

    @Override
    public <T extends Enum<T>> void fillItemCategory(CreativeModeTab p40569, NonNullList<ItemStack> p40570, T element) {
        p40570.add((Object)new ItemStack((ItemLike)((BlockState)this.f_49792_.m_61090_()).m_60734_()));
    }

    public static enum FoamType implements SubEnum
    {
        reinforced(600);

        public final int hardenTime;

        private FoamType(int hardenTime) {
            this.hardenTime = hardenTime;
        }

        @Override
        public String getName() {
            return this.name();
        }

        @Override
        public boolean registerOnlyBlock() {
            return true;
        }

        @Override
        public String getMainPath() {
            return "foam";
        }

        @Override
        public int getId() {
            return this.ordinal();
        }

        public BlockState getResult() {
            return IUItem.blockResource.getBlock(7).m_49966_();
        }
    }
}

