/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blockentity.storage;

import com.denfop.blockentity.transport.types.ICableItem;
import com.denfop.blocks.SubEnum;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;

public enum StorageSystemCableType implements SubEnum,
ICableItem
{
    storagecable(0, 0, 0.25f, 0.02, 2.147483647E9);

    public static final StorageSystemCableType[] values;
    private static final Map<String, StorageSystemCableType> nameMap;
    public final int maxInsulation;
    public final int minColoredInsulation;
    public final float thickness;
    public final double loss;
    public final double capacity;
    private final ResourceLocation texture;

    private StorageSystemCableType(int maxInsulation, int minColoredInsulation, float thickness, double loss, double capacity) {
        this.maxInsulation = maxInsulation;
        this.minColoredInsulation = minColoredInsulation;
        this.thickness = thickness;
        this.loss = loss;
        this.capacity = capacity;
        this.texture = new ResourceLocation("industrialupgrade", "blocks/wiring/" + this.getMainPath() + "/" + this.getNameCable());
    }

    public static StorageSystemCableType get(String name) {
        return nameMap.get(name);
    }

    @Override
    public String getName() {
        return this.name() + "_storagecable";
    }

    @Override
    public float getThickness() {
        return this.thickness;
    }

    @Override
    public int getId() {
        return this.ordinal();
    }

    @Override
    public String getNameCable() {
        return this.name() + "_storagecable";
    }

    @Override
    public String getMainPath() {
        return "storagecable";
    }

    @Override
    public ResourceLocation getRecourse() {
        return this.texture;
    }

    static {
        values = StorageSystemCableType.values();
        nameMap = new HashMap<String, StorageSystemCableType>();
        for (StorageSystemCableType type : values) {
            nameMap.put(type.getName(), type);
        }
    }
}

