/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blockentity.storage;

import com.denfop.IUItem;
import com.denfop.api.Recipes;
import com.denfop.api.blockentity.MultiBlockEntity;
import com.denfop.api.otherenergies.common.EnergyType;
import com.denfop.api.storage.EnumTypeSlots;
import com.denfop.api.storage.IWorkbenchInterface;
import com.denfop.api.storage.Interface;
import com.denfop.api.storage.PatternItem;
import com.denfop.api.storage.StorageNetwork;
import com.denfop.api.storage.autocrafting.PatternStack;
import com.denfop.api.storage.autocrafting.SameStack;
import com.denfop.api.storage.autocrafting.TypeRecipe;
import com.denfop.blockentity.base.BlockEntityInventory;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockStorageSystemEntity;
import com.denfop.componets.ComponentBaseEnergy;
import com.denfop.containermenu.ContainerInterfaceWorkbench;
import com.denfop.containermenu.ContainerMenuBase;
import com.denfop.inventory.Inventory;
import com.denfop.mixin.access.RecipeManagerAccessor;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.recipe.IInputItemStack;
import com.denfop.screen.ScreenIndustrialUpgrade;
import com.denfop.screen.ScreenInterfaceWorkbench;
import com.denfop.utils.ModUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;

public class BlockEntityInterfaceWorkbench
extends BlockEntityInventory
implements IWorkbenchInterface {
    private final Inventory slotSlots;
    Map<Integer, PatternStack> patternItemHashMap = new HashMap<Integer, PatternStack>();
    List<PatternStack> patternStacks = new LinkedList<PatternStack>();
    protected ComponentBaseEnergy energy = this.addComponent(ComponentBaseEnergy.asBasicSink(EnergyType.STORAGE, this, 0.0));
    private StorageNetwork network;

    public BlockEntityInterfaceWorkbench(BlockPos pos, BlockState state) {
        super(BlockStorageSystemEntity.interface_workbench, pos, state);
        this.slotSlots = new Inventory(this, Inventory.TypeItemSlot.INPUT, 63){

            @Override
            public boolean m_7013_(int index, ItemStack stack) {
                return stack.m_41720_() instanceof PatternItem && ((PatternItem)stack.m_41720_()).hasPattern(stack) && ((PatternItem)stack.m_41720_()).getPattern(stack).typeRecipe() == TypeRecipe.WORKBENCH;
            }

            @Override
            public ItemStack set(int i, ItemStack empty) {
                ItemStack stack = super.set(i, empty);
                BlockEntityInterfaceWorkbench.this.reload();
                if (BlockEntityInterfaceWorkbench.this.network != null) {
                    StorageNetwork storageNetwork = BlockEntityInterfaceWorkbench.this.network;
                    storageNetwork.reloadInterface((Interface)((Object)this.base));
                }
                return stack;
            }
        };
        this.slotSlots.setStackSizeLimit(1);
    }

    @Override
    public MultiBlockEntity getTeBlock() {
        return BlockStorageSystemEntity.interface_workbench;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.storageSystem.getBlock(this.getTeBlock());
    }

    public Inventory getSlots() {
        return this.slotSlots;
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer packet = super.writeContainerPacket();
        return packet;
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        super.addInformation(stack, tooltip);
    }

    @Override
    public void onPlaced(ItemStack stack, LivingEntity placer, Direction facing) {
        super.onPlaced(stack, placer, facing);
    }

    @Override
    public List<ItemStack> getWrenchDrops(Player player, int fortune) {
        List<ItemStack> itemStackList = super.getWrenchDrops(player, fortune);
        return itemStackList;
    }

    @Override
    public CustomPacketBuffer writePacket() {
        CustomPacketBuffer packet = super.writePacket();
        return packet;
    }

    @Override
    public void readPacket(CustomPacketBuffer customPacketBuffer) {
        super.readPacket(customPacketBuffer);
    }

    @Override
    public void onNeighborChange(BlockState neighbor, BlockPos neighborPos) {
        super.onNeighborChange(neighbor, neighborPos);
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
    }

    @Override
    public void updateField(String name, CustomPacketBuffer is) {
        super.updateField(name, is);
    }

    public ContainerInterfaceWorkbench getGuiContainer(Player var1) {
        return new ContainerInterfaceWorkbench(this, var1);
    }

    @OnlyIn(value=Dist.CLIENT)
    public ScreenIndustrialUpgrade<ContainerMenuBase<?>> getGui(Player var1, ContainerMenuBase<?> var2) {
        return new ScreenInterfaceWorkbench((ContainerInterfaceWorkbench)var2);
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        this.reload();
    }

    public void reload() {
        if (!(this.f_58857_ instanceof ServerLevel)) {
            return;
        }
        RecipeManager recipeManager = this.f_58857_.m_7465_();
        this.patternItemHashMap.clear();
        this.patternStacks.clear();
        for (int i = 0; i < this.slotSlots.size(); ++i) {
            ItemStack stack = this.slotSlots.m_8020_(i);
            if (stack.m_41619_()) continue;
            PatternItem cellItem = (PatternItem)stack.m_41720_();
            PatternStack cell = cellItem.getPattern(stack);
            Recipe<?> recipe = ((RecipeManagerAccessor)recipeManager).getRecipes().get(RecipeType.f_44107_).get(cell.location());
            if (recipe == null) continue;
            ArrayList<IInputItemStack> list = new ArrayList<IInputItemStack>();
            for (Ingredient ingredient : recipe.m_7527_()) {
                if (ingredient.m_43947_()) continue;
                boolean find = false;
                for (IInputItemStack iInputItemStack : list) {
                    if (!iInputItemStack.matches(ingredient.m_43908_()[0])) continue;
                    find = true;
                    iInputItemStack.growAmount(ingredient.m_43908_()[0].m_41613_());
                }
                if (find) continue;
                IInputItemStack input = Recipes.inputFactory.getInput(ingredient);
                list.add(input);
            }
            ArrayList<SameStack> stacks = new ArrayList<SameStack>();
            for (IInputItemStack iInputItemStack : list) {
                stacks.add(new SameStack(iInputItemStack.getInputs().get(0)));
            }
            if (!cell.matches(stacks) && !ModUtils.checkItemEquality(recipe.m_8043_(this.f_58857_.m_9598_()), cell.output().getStack())) continue;
            this.patternItemHashMap.put(i, cell);
            this.patternStacks.add(cell);
        }
    }

    @Override
    public double getRequiredPower() {
        return 1.0;
    }

    @Override
    public void setStorageNetwork(StorageNetwork network) {
        this.network = network;
    }

    @Override
    public List<PatternStack> getPatterns() {
        return this.patternStacks;
    }

    @Override
    public List<ItemStack> getStacks() {
        return Collections.emptyList();
    }

    @Override
    public List<FluidStack> getFluidStacks() {
        return Collections.emptyList();
    }

    @Override
    public BlockEntity getBlockEntityNeighbor() {
        return null;
    }

    @Override
    public Direction getDirection() {
        return Direction.UP;
    }

    @Override
    public EnumTypeSlots getTypeSlots() {
        return EnumTypeSlots.WHITELIST;
    }
}

