/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blockentity.storage;

import com.denfop.IUItem;
import com.denfop.api.blockentity.MultiBlockEntity;
import com.denfop.api.container.CustomWorldContainer;
import com.denfop.api.otherenergies.common.EnergyType;
import com.denfop.api.storage.StorageDeviceCell;
import com.denfop.api.storage.StorageNetwork;
import com.denfop.api.storage.cell.ICell;
import com.denfop.api.storage.cell.ICellItem;
import com.denfop.api.storage.cell.ItemStackCell;
import com.denfop.api.storage.cell.TypeCell;
import com.denfop.api.widget.EnumTypeSlot;
import com.denfop.blockentity.base.BlockEntityInventory;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockStorageSystemEntity;
import com.denfop.componets.ComponentBaseEnergy;
import com.denfop.containermenu.ContainerMenuBase;
import com.denfop.containermenu.ContainerStorageCells;
import com.denfop.inventory.Inventory;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.screen.ScreenIndustrialUpgrade;
import com.denfop.screen.ScreenStorageCells;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BlockEntityEntityStorageCells
extends BlockEntityInventory
implements StorageDeviceCell {
    private final Inventory slotSlots;
    Map<Integer, ICell> cellsMap = new HashMap<Integer, ICell>();
    List<ICell> itemCells = new LinkedList<ICell>();
    List<ICell> fluidCells = new LinkedList<ICell>();
    protected ComponentBaseEnergy energy = this.addComponent(ComponentBaseEnergy.asBasicSink(EnergyType.STORAGE, this, 0.0));

    public BlockEntityEntityStorageCells(BlockPos pos, BlockState state) {
        super(BlockStorageSystemEntity.storage_cells, pos, state);
        this.slotSlots = new Inventory(this, Inventory.TypeItemSlot.INPUT, 25){

            @Override
            public boolean m_7013_(int index, ItemStack stack) {
                return stack.m_41720_() instanceof ICellItem;
            }

            @Override
            public EnumTypeSlot getTypeSlot() {
                return EnumTypeSlot.STORAGE_CELL;
            }

            @Override
            public ItemStack set(int i, ItemStack empty) {
                ItemStack stack = super.set(i, empty);
                if (stack.m_41619_()) {
                    ICell cell = BlockEntityEntityStorageCells.this.cellsMap.remove(i);
                    if (cell != null) {
                        if (cell.getCellInfo().typeCell() == TypeCell.FLUID) {
                            BlockEntityEntityStorageCells.this.fluidCells.remove(cell);
                        } else {
                            BlockEntityEntityStorageCells.this.itemCells.remove(cell);
                        }
                    }
                } else {
                    ICellItem cellItem = (ICellItem)stack.m_41720_();
                    ItemStackCell cell = cellItem.getCell(stack);
                    if (!BlockEntityEntityStorageCells.this.cellsMap.containsKey(i)) {
                        BlockEntityEntityStorageCells.this.cellsMap.put(i, cell);
                    } else {
                        ICell cell1 = BlockEntityEntityStorageCells.this.cellsMap.remove(i);
                        BlockEntityEntityStorageCells.this.cellsMap.put(i, cell);
                        if (cell1 != null) {
                            if (cell1.getCellInfo().typeCell() == TypeCell.FLUID) {
                                BlockEntityEntityStorageCells.this.fluidCells.remove(cell1);
                            } else {
                                BlockEntityEntityStorageCells.this.itemCells.remove(cell1);
                            }
                        }
                    }
                    if (cell.getCellInfo().typeCell() == TypeCell.FLUID) {
                        BlockEntityEntityStorageCells.this.fluidCells.add(cell);
                    } else {
                        BlockEntityEntityStorageCells.this.itemCells.add(cell);
                    }
                }
                return stack;
            }
        };
    }

    @Override
    public MultiBlockEntity getTeBlock() {
        return BlockStorageSystemEntity.storage_cells;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.storageSystem.getBlock(this.getTeBlock());
    }

    @Override
    public Inventory getSlots() {
        return this.slotSlots;
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer packet = super.writeContainerPacket();
        return packet;
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        super.addInformation(stack, tooltip);
    }

    @Override
    public void onPlaced(ItemStack stack, LivingEntity placer, Direction facing) {
        super.onPlaced(stack, placer, facing);
    }

    @Override
    public List<ItemStack> getWrenchDrops(Player player, int fortune) {
        List<ItemStack> itemStackList = super.getWrenchDrops(player, fortune);
        return itemStackList;
    }

    @Override
    public CustomPacketBuffer writePacket() {
        CustomPacketBuffer packet = super.writePacket();
        return packet;
    }

    @Override
    public void readPacket(CustomPacketBuffer customPacketBuffer) {
        super.readPacket(customPacketBuffer);
    }

    @Override
    public void onNeighborChange(BlockState neighbor, BlockPos neighborPos) {
        super.onNeighborChange(neighbor, neighborPos);
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        for (Map.Entry<Integer, ICell> cellEntry : this.cellsMap.entrySet()) {
            ICell cell = cellEntry.getValue();
            if (!cell.needUpdate()) continue;
            cell.save();
            cell.setUpdate(false);
        }
    }

    @Override
    public void updateField(String name, CustomPacketBuffer is) {
        super.updateField(name, is);
    }

    public ContainerStorageCells getGuiContainer(Player entityPlayer) {
        return new ContainerStorageCells(this, entityPlayer);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ScreenIndustrialUpgrade<ContainerMenuBase<? extends CustomWorldContainer>> getGui(Player entityPlayer, ContainerMenuBase<? extends CustomWorldContainer> isAdmin) {
        return new ScreenStorageCells((ContainerStorageCells)isAdmin);
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        for (int i = 0; i < 25; ++i) {
            ItemStack stack = this.slotSlots.m_8020_(i);
            if (stack.m_41619_()) {
                ICell cell = this.cellsMap.remove(i);
                if (cell == null) continue;
                if (cell.getCellInfo().typeCell() == TypeCell.FLUID) {
                    this.fluidCells.remove(cell);
                    continue;
                }
                this.itemCells.remove(cell);
                continue;
            }
            ICellItem cellItem = (ICellItem)stack.m_41720_();
            ItemStackCell cell = cellItem.getCell(stack);
            if (!this.cellsMap.containsKey(i)) {
                this.cellsMap.put(i, cell);
            } else {
                ICell cell1 = this.cellsMap.remove(i);
                this.cellsMap.put(i, cell);
                if (cell1 != null) {
                    if (cell1.getCellInfo().typeCell() == TypeCell.FLUID) {
                        this.fluidCells.remove(cell1);
                    } else {
                        this.itemCells.remove(cell1);
                    }
                }
            }
            if (cell.getCellInfo().typeCell() == TypeCell.FLUID) {
                this.fluidCells.add(cell);
                continue;
            }
            this.itemCells.add(cell);
        }
    }

    @Override
    public double getRequiredPower() {
        return 1.0;
    }

    @Override
    public void setStorageNetwork(StorageNetwork network) {
    }

    @Override
    public List<ICell> getFluidCells() {
        return this.fluidCells;
    }

    @Override
    public List<ICell> getItemCells() {
        return this.itemCells;
    }
}

