/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blockentity.storage;

import com.denfop.IUItem;
import com.denfop.api.blockentity.MultiBlockEntity;
import com.denfop.api.container.CustomWorldContainer;
import com.denfop.api.otherenergies.common.EnergyBase;
import com.denfop.api.otherenergies.common.EnergyType;
import com.denfop.api.otherenergies.common.ISink;
import com.denfop.api.otherenergies.common.ISource;
import com.denfop.api.otherenergies.common.Path;
import com.denfop.api.storage.Controller;
import com.denfop.api.storage.ElectricStorage;
import com.denfop.api.storage.StorageNetwork;
import com.denfop.api.storage.autocrafting.SameStack;
import com.denfop.blockentity.base.BlockEntityInventory;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockStorageSystemEntity;
import com.denfop.componets.ComponentBaseEnergy;
import com.denfop.componets.Energy;
import com.denfop.containermenu.ContainerMenuBase;
import com.denfop.containermenu.ContainerMenuTank;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.network.packet.PacketCreateNetwork;
import com.denfop.screen.ScreenIndustrialUpgrade;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BlockEntityController
extends BlockEntityInventory
implements Controller {
    public final Energy energyDefault;
    public final StorageNetwork networkSystem;
    public ComponentBaseEnergy energy = this.addComponent(ComponentBaseEnergy.asBasicSource(EnergyType.STORAGE, this, 1.0));
    private List<Path> paths;

    public BlockEntityController(BlockPos pos, BlockState state) {
        super(BlockStorageSystemEntity.controller, pos, state);
        this.energyDefault = this.addComponent(Energy.asBasicSink((BlockEntityInventory)this, 500000.0, 14));
        this.networkSystem = new StorageNetwork();
    }

    @Override
    public MultiBlockEntity getTeBlock() {
        return BlockStorageSystemEntity.controller;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.storageSystem.getBlock(this.getTeBlock());
    }

    @Override
    public void loadBeforeFirstUpdate() {
        super.loadBeforeFirstUpdate();
        if (!this.m_58904_().f_46443_) {
            this.paths = EnergyBase.storage.getLocalSystem(this.f_58857_).getPaths((ISource)((Object)this.energy.delegate));
            ArrayList posList = new ArrayList();
            if (this.paths != null) {
                this.paths.forEach(path -> {
                    ISink sink = path.getSink();
                    BlockEntity blockEntity = this.m_58904_().m_7702_(sink.getPos());
                    if (blockEntity instanceof ElectricStorage) {
                        ElectricStorage storage = (ElectricStorage)blockEntity;
                        this.networkSystem.addElement(storage);
                        posList.add(sink.getPos());
                    }
                });
            }
            if (!posList.isEmpty()) {
                new PacketCreateNetwork(this.pos, this.f_58857_, new ArrayList<BlockPos>(posList));
            }
        }
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer packet = super.writeContainerPacket();
        return packet;
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        super.addInformation(stack, tooltip);
    }

    @Override
    public void onPlaced(ItemStack stack, LivingEntity placer, Direction facing) {
        super.onPlaced(stack, placer, facing);
    }

    @Override
    public List<ItemStack> getWrenchDrops(Player player, int fortune) {
        List<ItemStack> itemStackList = super.getWrenchDrops(player, fortune);
        return itemStackList;
    }

    @Override
    public CustomPacketBuffer writePacket() {
        CustomPacketBuffer packet = super.writePacket();
        return packet;
    }

    @Override
    public void readPacket(CustomPacketBuffer customPacketBuffer) {
        super.readPacket(customPacketBuffer);
    }

    @Override
    public void onNeighborChange(BlockState neighbor, BlockPos neighborPos) {
        super.onNeighborChange(neighbor, neighborPos);
    }

    @Override
    public void updateEntityClient() {
        super.updateEntityClient();
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        List<Path> pathTemp = this.paths;
        this.paths = EnergyBase.storage.getLocalSystem(this.f_58857_).getPaths((ISource)((Object)this.energy.delegate));
        this.energy.buffer.storage = 1.0;
        if (this.paths == null && pathTemp != null || this.paths != null && pathTemp == null || this.paths != null && this.paths.size() != pathTemp.size()) {
            this.networkSystem.reBuild(this.paths, this.f_58857_);
            LinkedList posList = new LinkedList();
            if (this.paths != null) {
                this.paths.forEach(path -> {
                    ISink sink = path.getSink();
                    BlockEntity blockEntity = this.m_58904_().m_7702_(sink.getPos());
                    if (blockEntity instanceof ElectricStorage) {
                        posList.add(sink.getPos());
                    }
                });
            }
            new PacketCreateNetwork(this.pos, this.f_58857_, new ArrayList<BlockPos>(posList));
        }
        this.networkSystem.tick(this.f_58857_, this.energyDefault, this.pos);
    }

    @Override
    public void updateField(String name, CustomPacketBuffer is) {
        super.updateField(name, is);
    }

    public ContainerMenuTank getGuiContainer(Player entityPlayer) {
        return null;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ScreenIndustrialUpgrade<ContainerMenuBase<? extends CustomWorldContainer>> getGui(Player entityPlayer, ContainerMenuBase<? extends CustomWorldContainer> isAdmin) {
        return null;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.f_58857_.f_46443_) {
            // empty if block
        }
    }

    @Override
    public void onUnloaded() {
        super.onUnloaded();
        this.networkSystem.onUnload();
    }

    @Override
    public double getRequiredPower() {
        return 1.0;
    }

    @Override
    public void setStorageNetwork(StorageNetwork network) {
    }

    @Override
    public void setStack(boolean isFluid, boolean isCreate, List<SameStack> stacks) {
        if (!isCreate) {
            if (isFluid) {
                this.networkSystem.setFluids(stacks);
            } else {
                this.networkSystem.setItems(stacks);
            }
        } else if (isFluid) {
            this.networkSystem.setFluidsCreate(stacks);
        } else {
            this.networkSystem.setItemsCreate(stacks);
        }
    }

    @Override
    public StorageNetwork getStorageNetwork() {
        return this.networkSystem;
    }
}

