/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blockentity.storage;

import com.denfop.api.blockentity.MultiBlockEntity;
import com.denfop.api.otherenergies.common.EnergyType;
import com.denfop.api.storage.EnumTypeSlots;
import com.denfop.api.storage.StorageNetwork;
import com.denfop.api.storage.TypeStack;
import com.denfop.blockentity.base.BlockEntityInventory;
import com.denfop.componets.ComponentBaseEnergy;
import com.denfop.containermenu.ContainerBus;
import com.denfop.containermenu.ContainerMenuBase;
import com.denfop.containermenu.SlotInfo;
import com.denfop.screen.ScreenBus;
import com.denfop.screen.ScreenIndustrialUpgrade;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;

public class BlockEntityBus
extends BlockEntityInventory {
    private final ComponentBaseEnergy energy;
    private final boolean isImport;
    private final boolean isFluid;
    public SlotInfo listSlot;
    BlockEntity blockEntityDown;

    public BlockEntityBus(MultiBlockEntity block, boolean isFluid, boolean isImport, BlockPos pos, BlockState state) {
        super(block, pos, state);
        this.isImport = isImport;
        this.isFluid = isFluid;
        this.listSlot = new SlotInfo(this, 9, isFluid);
        this.energy = this.addComponent(ComponentBaseEnergy.asBasicSink(EnergyType.STORAGE, this, 0.0));
    }

    public boolean isFluid() {
        return this.isFluid;
    }

    public boolean isImport() {
        return this.isImport;
    }

    public double getRequiredPower() {
        return 1.0;
    }

    public SlotInfo getListSlot() {
        return this.listSlot;
    }

    public ContainerBus getGuiContainer(Player var1) {
        return new ContainerBus(var1, this);
    }

    @OnlyIn(value=Dist.CLIENT)
    public ScreenIndustrialUpgrade<ContainerMenuBase<?>> getGui(Player var1, ContainerMenuBase<?> var2) {
        return new ScreenBus((ContainerBus)var2);
    }

    public void setStorageNetwork(StorageNetwork network) {
    }

    @Override
    public void loadBeforeFirstUpdate() {
        super.loadBeforeFirstUpdate();
        this.blockEntityDown = this.m_58904_().m_7702_(this.pos.m_121955_(this.getFacing().m_122424_().m_122436_()));
    }

    @Override
    public void onNeighborChange(BlockState neighbor, BlockPos neighborPos) {
        super.onNeighborChange(neighbor, neighborPos);
        if (this.pos.m_121955_(this.getFacing().m_122424_().m_122436_()).equals((Object)neighborPos)) {
            this.blockEntityDown = this.m_58904_().m_7702_(neighborPos);
        }
    }

    public TypeStack getTypeStack() {
        return this.isFluid ? TypeStack.FLUID : TypeStack.ITEM;
    }

    public List<ItemStack> getStacks() {
        return this.listSlot.getListBlack();
    }

    public List<FluidStack> getFluidStacks() {
        return this.listSlot.getFluidStackList();
    }

    public Direction getDirection() {
        return this.getFacing().m_122424_();
    }

    public BlockEntity getBlockEntityNeighbor() {
        return this.blockEntityDown;
    }

    public EnumTypeSlots getTypeSlots() {
        return !this.isImport ? EnumTypeSlots.WHITELIST : (!this.listSlot.m_7983_() ? EnumTypeSlots.WHITELIST : EnumTypeSlots.BLACKLIST);
    }
}

