/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blockentity.storage;

import com.denfop.api.blockentity.MultiBlockEntity;
import com.denfop.api.otherenergies.common.EnergyType;
import com.denfop.api.storage.StorageNetwork;
import com.denfop.api.storage.autocrafting.AutoCraftSystem;
import com.denfop.api.storage.autocrafting.Processor;
import com.denfop.blockentity.base.BlockEntityInventory;
import com.denfop.componets.ComponentBaseEnergy;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.block.state.BlockState;

public class BlockEntityBaseProcessor
extends BlockEntityInventory
implements Processor {
    private final int count;
    private final ComponentBaseEnergy energy;
    List<AutoCraftSystem> autoCraftSystems = new ArrayList<AutoCraftSystem>();

    public BlockEntityBaseProcessor(MultiBlockEntity block, int count, BlockPos pos, BlockState state) {
        super(block, pos, state);
        this.count = count;
        this.energy = this.addComponent(ComponentBaseEnergy.asBasicSink(EnergyType.STORAGE, this, 0.0));
    }

    @Override
    public CompoundTag writeToNBT(CompoundTag nbt) {
        nbt = super.writeToNBT(nbt);
        ListTag autoCraftList = new ListTag();
        for (AutoCraftSystem acs : this.getAutoCrafts()) {
            autoCraftList.add((Object)acs.writeToTag());
        }
        nbt.m_128365_("AutoCrafts", (Tag)autoCraftList);
        return nbt;
    }

    @Override
    public void readFromNBT(CompoundTag nbtTagCompound) {
        super.readFromNBT(nbtTagCompound);
        ListTag autoCraftList = nbtTagCompound.m_128437_("AutoCrafts", 10);
        for (int i = 0; i < autoCraftList.size(); ++i) {
            CompoundTag acTag = autoCraftList.m_128728_(i);
            AutoCraftSystem acs = AutoCraftSystem.readFromTag(acTag);
            this.addAutoCraft(acs);
        }
    }

    @Override
    public double getRequiredPower() {
        return 1.0;
    }

    @Override
    public void setStorageNetwork(StorageNetwork network) {
    }

    @Override
    public int getMaxSize() {
        return this.count;
    }

    @Override
    public List<AutoCraftSystem> getAutoCrafts() {
        return this.autoCraftSystems;
    }

    @Override
    public boolean canAddAutoCraft() {
        return this.autoCraftSystems.size() < this.count;
    }

    @Override
    public void addAutoCraft(AutoCraftSystem autoCraftSystem) {
        this.autoCraftSystems.add(autoCraftSystem);
    }

    @Override
    public void removeAutoCraft(AutoCraftSystem autoCraftSystem) {
        this.autoCraftSystems.remove(autoCraftSystem);
    }
}

