/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blockentity.smeltery;

import com.denfop.IUItem;
import com.denfop.api.blockentity.MultiBlockEntity;
import com.denfop.api.container.CustomWorldContainer;
import com.denfop.blockentity.mechanism.multiblocks.base.BlockEntityMultiBlockElement;
import com.denfop.blockentity.smeltery.IFuelTank;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.FluidName;
import com.denfop.blocks.mechanism.BlockSmelteryEntity;
import com.denfop.componets.Fluids;
import com.denfop.containermenu.ContainerMenuBase;
import com.denfop.containermenu.ContainerMenuSmelteryFuelTank;
import com.denfop.screen.ScreenIndustrialUpgrade;
import com.denfop.screen.ScreenSmelteryFuelTank;
import com.denfop.utils.FluidHandlerFix;
import com.denfop.utils.ModUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class BlockEntitySmelteryFuelTank
extends BlockEntityMultiBlockElement
implements IFuelTank {
    private final Fluids fluids = this.addComponent(new Fluids(this));
    private final Fluids.InternalFluidTank fluidTank = this.fluids.addTank("fluids", 10000);
    private double speed;

    public BlockEntitySmelteryFuelTank(BlockPos pos, BlockState state) {
        super(BlockSmelteryEntity.smeltery_fuel_tank, pos, state);
        this.fluidTank.setAcceptedFluids(Fluids.fluidPredicate(new Fluid[]{net.minecraft.world.level.material.Fluids.f_76195_, (Fluid)FluidName.fluidpahoehoe_lava.getInstance().get()}));
    }

    @Override
    public boolean onActivated(Player player, InteractionHand hand, Direction side, Vec3 vec3) {
        if (!this.getWorld().f_46443_ && FluidHandlerFix.getFluidHandler(player.m_21120_(hand)) != null) {
            return ModUtils.interactWithFluidHandler(player, hand, (IFluidHandler)this.fluids.getCapability(ForgeCapabilities.FLUID_HANDLER, side));
        }
        return super.onActivated(player, hand, side, vec3);
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        this.speed = !this.fluidTank.getFluid().isEmpty() && this.fluidTank.getFluid().getFluid().equals(FluidName.fluidpahoehoe_lava.getInstance().get()) ? 2.0 : 1.0;
    }

    @Override
    public boolean hasOwnInventory() {
        return true;
    }

    public ContainerMenuSmelteryFuelTank getGuiContainer(Player var1) {
        return new ContainerMenuSmelteryFuelTank(this, var1);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ScreenIndustrialUpgrade<ContainerMenuBase<? extends CustomWorldContainer>> getGui(Player var1, ContainerMenuBase<? extends CustomWorldContainer> menu) {
        return new ScreenSmelteryFuelTank((ContainerMenuSmelteryFuelTank)menu);
    }

    @Override
    public MultiBlockEntity getTeBlock() {
        return BlockSmelteryEntity.smeltery_fuel_tank;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.smeltery.getBlock(this.getTeBlock());
    }

    @Override
    public FluidTank getFuelTank() {
        return this.fluidTank;
    }

    @Override
    public double getSpeed() {
        return this.speed;
    }
}

