/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blockentity.reactors.graphite.cooling;

import com.denfop.api.blockentity.MultiBlockEntity;
import com.denfop.api.reactors.IGraphiteReactor;
import com.denfop.blockentity.mechanism.multiblocks.base.BlockEntityMultiBlockElement;
import com.denfop.blockentity.reactors.graphite.ICooling;
import com.denfop.componets.CoolComponent;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.state.BlockState;

public class BlockEntityCoolant
extends BlockEntityMultiBlockElement
implements ICooling {
    public final CoolComponent cold;
    private final int levelBlock;
    private IGraphiteReactor gasReactor;

    public BlockEntityCoolant(int levelBlock, MultiBlockEntity block, BlockPos pos, BlockState state) {
        super(block, pos, state);
        this.levelBlock = levelBlock;
        this.cold = this.addComponent(CoolComponent.asBasicSource(this, 8.0 * Math.pow(2.0, this.levelBlock), 14));
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.getMain() != null) {
            this.gasReactor = (IGraphiteReactor)this.getMain();
            if (this.gasReactor.getEnergy() != null && this.gasReactor.getEnergy().getEnergy() >= 30.0 && this.cold.getEnergy() < this.cold.getCapacity()) {
                this.cold.addEnergy(1.0);
                this.gasReactor.getEnergy().useEnergy(30.0);
            }
            if (this.getWorld().m_46467_() % 40L == 0L && this.cold.getEnergy() > 0.0) {
                this.cold.useEnergy(1.0);
            }
        }
    }

    @Override
    public int getBlockLevel() {
        return this.levelBlock;
    }

    @Override
    public double work(double heat) {
        return Math.max(1.0, heat - (double)this.getWorld().f_46441_.m_188503_(40 * (this.levelBlock + 1)));
    }
}

