/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blockentity.mechanism.combpump;

import com.denfop.api.blockentity.MultiBlockEntity;
import com.denfop.api.container.CustomWorldContainer;
import com.denfop.api.otherenergies.common.EnergyType;
import com.denfop.api.recipe.InventoryOutput;
import com.denfop.api.upgrades.IUpgradableBlock;
import com.denfop.api.upgrades.UpgradableProperty;
import com.denfop.api.widget.IType;
import com.denfop.blockentity.base.BlockEntityElectricLiquidTankInventory;
import com.denfop.blockentity.mechanism.combpump.EnumTypePump;
import com.denfop.componets.ComponentBaseEnergy;
import com.denfop.componets.EnumTypeStyle;
import com.denfop.containermenu.ContainerMenuBase;
import com.denfop.containermenu.ContainerMenuCombPump;
import com.denfop.inventory.Inventory;
import com.denfop.inventory.InventoryFluid;
import com.denfop.inventory.InventoryUpgrade;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.screen.ScreenCompPump;
import com.denfop.screen.ScreenIndustrialUpgrade;
import com.denfop.sound.EnumSound;
import com.denfop.utils.Keyboard;
import com.denfop.utils.Localization;
import java.io.IOException;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.apache.commons.lang3.mutable.MutableObject;

public class BlockEntityCombinedPump
extends BlockEntityElectricLiquidTankInventory
implements IUpgradableBlock,
IType {
    public final int defaultTier;
    public final double defaultEnergyStorage;
    public final double defaultEnergyConsume;
    public final int defaultOperationLength;
    public final InventoryFluid containerSlot = new InventoryFluid(this, Inventory.TypeItemSlot.INPUT, 1, InventoryFluid.TypeFluidSlot.OUTPUT);
    public final InventoryOutput outputSlot;
    public final InventoryUpgrade upgradeSlot;
    public final ComponentBaseEnergy energyQe;
    public final EnumTypePump typePump;
    public double energyConsume;
    public int operationsPerTick;
    public short progress = 0;
    public int operationLength;
    public float guiProgress;
    public int x;
    public int z;
    public int y;
    boolean canWork = true;

    public BlockEntityCombinedPump(int size, int operationLength, EnumTypePump typePump, MultiBlockEntity block, BlockPos pos, BlockState state) {
        super(0.0, 0, size, block, pos, state);
        this.typePump = typePump;
        this.energyQe = this.addComponent(ComponentBaseEnergy.asBasicSink(EnergyType.QUANTUM, this, 100.0));
        this.outputSlot = new InventoryOutput(this, 1);
        this.upgradeSlot = new InventoryUpgrade(this, 4);
        this.defaultEnergyConsume = this.energyConsume = (double)(this.getStyle().ordinal() + 1);
        this.defaultOperationLength = this.operationLength = operationLength;
        this.defaultTier = 1;
        this.defaultEnergyStorage = this.operationLength;
        this.fluidTank.setTypeItemSlot(Inventory.TypeItemSlot.OUTPUT);
    }

    private static int applyModifier(int base, int extra, double multiplier) {
        double ret = Math.round(((double)base + (double)extra) * multiplier);
        return ret > 2.147483647E9 ? Integer.MAX_VALUE : (int)ret;
    }

    private static double applyModifier(double base, double extra, double multiplier) {
        return Math.round((base + extra) * multiplier);
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        try {
            this.guiProgress = ((Float)DecoderHandler.decode(customPacketBuffer)).floatValue();
            this.x = customPacketBuffer.readInt();
            this.y = customPacketBuffer.readInt();
            this.z = customPacketBuffer.readInt();
            this.canWork = customPacketBuffer.readBoolean();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public ContainerMenuCombPump getGuiContainer(Player var1) {
        return new ContainerMenuCombPump(var1, this);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ScreenIndustrialUpgrade<ContainerMenuBase<? extends CustomWorldContainer>> getGui(Player var1, ContainerMenuBase<? extends CustomWorldContainer> var2) {
        return new ScreenCompPump((ContainerMenuCombPump)var2);
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer packet = super.writeContainerPacket();
        try {
            EncoderHandler.encode(packet, Float.valueOf(this.guiProgress));
            packet.writeInt(this.x);
            packet.writeInt(this.y);
            packet.writeInt(this.z);
            packet.writeBoolean(this.canWork);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public void updateEntityServer() {
        MutableObject output;
        super.updateEntityServer();
        if (this.canWork && this.energyQe.canUseEnergy(this.energyConsume)) {
            if (this.progress < this.operationLength) {
                this.progress = (short)(this.progress + 1);
                this.energyQe.useEnergy(this.energyConsume);
            } else {
                for (int i = 0; i < this.operationsPerTick; ++i) {
                    if (this.x < this.getPos().m_123341_() + this.typePump.getXz()) {
                        ++this.x;
                    } else if (this.z < this.getPos().m_123343_() + this.typePump.getXz()) {
                        ++this.z;
                        this.x = this.getPos().m_123341_();
                    } else if (this.y >= this.getPos().m_123342_() - this.typePump.getY()) {
                        this.z = this.getPos().m_123343_();
                        this.x = this.getPos().m_123341_();
                        --this.y;
                    } else {
                        this.canWork = false;
                    }
                    if (!this.operate(this.x, this.y, this.z)) continue;
                    this.progress = 0;
                }
            }
        }
        if (this.containerSlot.transferFromTank((IFluidTank)this.fluidTank, (MutableObject<ItemStack>)(output = new MutableObject()), true) && (output.getValue() == null || this.outputSlot.canAdd((ItemStack)output.getValue()))) {
            this.containerSlot.transferFromTank((IFluidTank)this.fluidTank, (MutableObject<ItemStack>)output, false);
            if (output.getValue() != null) {
                this.outputSlot.add((ItemStack)output.getValue());
            }
        }
        this.guiProgress = (float)this.progress / (float)this.operationLength;
        if (this.upgradeSlot.tickNoMark()) {
            this.setUpgradestat();
        }
    }

    public boolean operate(int x, int y, int z) {
        if (this.fluidTank.getFluidAmount() >= this.fluidTank.getCapacity()) {
            return false;
        }
        boolean canOperate = false;
        if (this.fluidTank.getFluidAmount() >= this.fluidTank.getCapacity()) {
            return false;
        }
        FluidStack liquid = this.pump(new BlockPos(x, y, z), false);
        if (this.getFluidTank().fill(liquid, IFluidHandler.FluidAction.SIMULATE) > 0) {
            this.getFluidTank().fill(liquid, IFluidHandler.FluidAction.EXECUTE);
            canOperate = true;
        }
        return canOperate;
    }

    public FluidStack pump(BlockPos pos, boolean sim) {
        BlockState block;
        FluidStack ret = FluidStack.EMPTY;
        int freespace = this.fluidTank.getCapacity() - this.fluidTank.getFluidAmount();
        if (freespace >= 1000 && (block = this.getWorld().m_8055_(pos)).m_278721_()) {
            FluidState fluidState = block.m_60734_().m_5888_(block);
            if (!fluidState.m_76170_()) {
                return FluidStack.EMPTY;
            }
            ret = new FluidStack(fluidState.m_76152_(), 1000);
            if ((this.fluidTank.getFluid().isEmpty() || this.fluidTank.getFluid().getFluid() == ret.getFluid()) && !sim) {
                this.getWorld().m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
            }
        }
        return ret;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.f_58857_.f_46443_) {
            this.setUpgradestat();
            this.x = this.pos.m_123341_();
            this.y = this.pos.m_123342_() - 1;
            this.z = this.pos.m_123343_();
        }
    }

    public void setUpgradestat() {
        double previousProgress = (double)this.progress / (double)this.operationLength;
        double stackOpLen = ((double)this.defaultOperationLength + (double)this.upgradeSlot.extraProcessTime) * 64.0 * this.upgradeSlot.processTimeMultiplier;
        this.operationsPerTick = (int)Math.min(Math.ceil(64.0 / stackOpLen), 2.147483647E9);
        this.operationLength = (int)Math.round(stackOpLen * (double)this.operationsPerTick / 64.0);
        this.energyConsume = BlockEntityCombinedPump.applyModifier(this.defaultEnergyConsume, this.upgradeSlot.extraEnergyDemand, 1.0);
        this.energyQe.setSinkTier(BlockEntityCombinedPump.applyModifier(this.defaultTier, this.upgradeSlot.extraTier, 1.0));
        this.energyQe.setCapacity(BlockEntityCombinedPump.applyModifier(this.defaultEnergyStorage, this.upgradeSlot.extraEnergyStorage + (double)this.operationLength * this.energyConsume, this.upgradeSlot.energyStorageMultiplier));
        if (this.operationLength < 1) {
            this.operationLength = 1;
        }
        this.progress = (short)Math.floor(previousProgress * (double)this.operationLength + 0.1);
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        if (!Keyboard.isKeyDown(340)) {
            tooltip.add(Localization.translate("press.lshift"));
        }
        if (Keyboard.isKeyDown(340)) {
            tooltip.add(Localization.translate("iu.machines_work_energy") + this.defaultEnergyConsume + Localization.translate("iu.machines_work_energy_type_eu"));
            tooltip.add(Localization.translate("iu.machines_work_length") + this.defaultOperationLength);
        }
        super.addInformation(stack, tooltip);
    }

    @Override
    public double getEnergy() {
        return this.energyQe.getEnergy();
    }

    @Override
    public boolean useEnergy(double amount) {
        if (this.energyQe.canUseEnergy(amount)) {
            this.energyQe.useEnergy(amount);
            return true;
        }
        return false;
    }

    @Override
    public void readFromNBT(CompoundTag nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.progress = nbttagcompound.m_128448_("progress");
        this.x = nbttagcompound.m_128451_("x_pump");
        this.y = nbttagcompound.m_128451_("y_pump");
        this.z = nbttagcompound.m_128451_("z_pump");
        this.canWork = nbttagcompound.m_128471_("canWork");
    }

    @Override
    public CompoundTag writeToNBT(CompoundTag nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.m_128376_("progress", this.progress);
        nbttagcompound.m_128405_("x_pump", this.x);
        nbttagcompound.m_128405_("y_pump", this.y);
        nbttagcompound.m_128405_("z_pump", this.z);
        nbttagcompound.m_128379_("canWork", this.canWork);
        return nbttagcompound;
    }

    @Override
    public Set<UpgradableProperty> getUpgradableProperties() {
        return EnumSet.of(UpgradableProperty.Processing, UpgradableProperty.Transformer, UpgradableProperty.EnergyStorage, UpgradableProperty.FluidExtract);
    }

    @Override
    public EnumTypeStyle getStyle() {
        return null;
    }

    @Override
    public SoundEvent getSound() {
        return EnumSound.PumpOp.getSoundEvent();
    }
}

