/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blockentity.mechanism;

import com.denfop.IUItem;
import com.denfop.api.Recipes;
import com.denfop.api.blockentity.MultiBlockEntity;
import com.denfop.api.recipe.IHasRecipe;
import com.denfop.api.recipe.IUpdateTick;
import com.denfop.api.recipe.InventoryRecipes;
import com.denfop.api.recipe.MachineRecipe;
import com.denfop.api.upgrades.IUpgradableBlock;
import com.denfop.api.upgrades.UpgradableProperty;
import com.denfop.blockentity.base.BlockEntityElectricMachine;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockPrimalSiliconCrystalHandlerEntity;
import com.denfop.componets.ComponentTimer;
import com.denfop.inventory.InventoryUpgrade;
import com.denfop.items.resource.ItemDust;
import com.denfop.network.EncoderHandler;
import com.denfop.network.IUpdatableTileEvent;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.network.packet.PacketUpdateFieldTile;
import com.denfop.recipe.IInputHandler;
import com.denfop.utils.Localization;
import com.denfop.utils.ModUtils;
import com.denfop.utils.Timer;
import java.io.IOException;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockEntityPrimalSiliconCrystalHandler
extends BlockEntityElectricMachine
implements IUpgradableBlock,
IUpdateTick,
IUpdatableTileEvent,
IHasRecipe {
    public final ComponentTimer timer;
    public final InventoryRecipes inputSlotA;
    public final InventoryUpgrade upgradeSlot;
    public int col;
    private MachineRecipe output;
    private boolean checkState;

    public BlockEntityPrimalSiliconCrystalHandler(BlockPos pos, BlockState state) {
        super(0.0, 0, 1, BlockPrimalSiliconCrystalHandlerEntity.primal_silicon_crystal_handler, pos, state);
        Recipes.recipes.addInitRecipes(this);
        this.inputSlotA = new InventoryRecipes(this, "silicon_recipe", this){

            @Override
            public boolean m_7013_(int index, ItemStack itemStack) {
                return false;
            }
        };
        this.upgradeSlot = new InventoryUpgrade(this, 4);
        this.timer = this.addComponent(new ComponentTimer(this, new Timer(0, 3, 0)));
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        tooltip.add(Localization.translate("iu.primal_repair4"));
    }

    @Override
    public void updateField(String name, CustomPacketBuffer is) {
        super.updateField(name, is);
        if (name.equals("timer")) {
            try {
                is.readByte();
                this.timer.onNetworkUpdate(is);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void init() {
        IInputHandler input = Recipes.inputFactory;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.getWorld().f_46443_) {
            this.inputSlotA.load();
        }
        this.output = this.inputSlotA.process();
        if (this.output == null) {
            this.timer.resetTime();
        }
    }

    @Override
    public boolean onActivated(Player player, InteractionHand hand, Direction side, Vec3 hitX) {
        ItemStack stack = player.m_21120_(hand);
        if (!stack.m_41619_() && this.outputSlot.m_7983_()) {
            if (stack.m_41720_() instanceof ItemDust && IUItem.iudust.getMeta((ItemDust)stack.m_41720_()) == 60) {
                if (this.inputSlotA.get(1).m_41619_()) {
                    ItemStack stack1 = stack.m_41777_();
                    if (stack1.m_41613_() > 3) {
                        stack1.m_41764_(3);
                        stack.m_41774_(3);
                    } else {
                        stack.m_41774_(stack1.m_41613_());
                    }
                    this.inputSlotA.set(1, stack1);
                    if (!this.f_58857_.f_46443_) {
                        this.getOutput();
                    }
                    return true;
                }
                if (!this.inputSlotA.get(1).m_41619_() && this.inputSlotA.get(1).m_150930_(stack.m_41720_())) {
                    int minCount = 3 - this.inputSlotA.get(1).m_41613_();
                    minCount = Math.min(stack.m_41613_(), minCount);
                    this.inputSlotA.get(1).m_41769_(minCount);
                    stack.m_41769_(-minCount);
                    if (!this.f_58857_.f_46443_) {
                        this.getOutput();
                    }
                    return true;
                }
            } else if (stack.m_41720_() == Items.f_42484_ && !this.inputSlotA.get(1).m_41619_() && this.inputSlotA.get(1).m_41613_() >= 3 && this.inputSlotA.get(0).m_41619_()) {
                ItemStack stack1 = stack.m_41777_();
                if (stack1.m_41613_() > 1) {
                    stack1.m_41764_(1);
                    stack.m_41774_(1);
                } else {
                    stack.m_41774_(stack1.m_41613_());
                }
                this.inputSlotA.set(0, stack1);
                if (!this.f_58857_.f_46443_) {
                    this.getOutput();
                }
                return true;
            }
        } else if (!this.outputSlot.m_7983_()) {
            if (!this.f_58857_.f_46443_) {
                ModUtils.dropAsEntity(this.f_58857_, this.pos, this.outputSlot.get(0));
            }
            this.outputSlot.set(0, ItemStack.f_41583_);
            return true;
        }
        return false;
    }

    @Override
    public CustomPacketBuffer writePacket() {
        CustomPacketBuffer customPacketBuffer = super.writePacket();
        try {
            EncoderHandler.encode(customPacketBuffer, this.timer, false);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return customPacketBuffer;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.primalSiliconCrystal.getBlock();
    }

    @Override
    public MultiBlockEntity getTeBlock() {
        return BlockPrimalSiliconCrystalHandlerEntity.primal_silicon_crystal_handler;
    }

    @Override
    public void onUpdate() {
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.getWorld().m_46467_() % 20L == 0L) {
            new PacketUpdateFieldTile(this, "timer", this.timer);
            this.checkState = false;
            ItemStack stack1 = this.inputSlotA.get(0);
            ItemStack stack2 = this.inputSlotA.get(1);
            if (this.outputSlot.m_7983_()) {
                if (stack1.m_41619_()) {
                    if (!stack2.m_41619_()) {
                        switch (stack2.m_41613_()) {
                            case 1: {
                                this.setActive("1");
                                break;
                            }
                            case 2: {
                                this.setActive("2");
                                break;
                            }
                            default: {
                                this.setActive("3");
                                break;
                            }
                        }
                    } else {
                        this.setActive(false);
                    }
                } else if (this.outputSlot.m_7983_()) {
                    if (stack2.m_41613_() >= 3) {
                        double time = this.timer.getTimes();
                        if (time >= 0.5 && time < 1.0) {
                            this.setActive("5");
                        } else if (time < 0.5) {
                            this.setActive("4");
                        } else {
                            this.setActive("6");
                        }
                    } else {
                        this.setActive(false);
                    }
                } else {
                    this.setActive("6");
                }
            } else {
                this.setActive("6");
            }
        }
        if (this.inputSlotA.get(0).m_41619_() || this.output == null || !this.outputSlot.get(0).m_41619_()) {
            this.timer.setCanWorkWithOut(false);
            return;
        }
        if (!this.timer.isCanWork()) {
            this.timer.setCanWork(true);
        }
        if (this.timer.getTimers().get(0).getTime() <= 0) {
            this.inputSlotA.consume();
            this.outputSlot.add(this.output.getRecipe().output.items.get(0));
            this.output = null;
            this.timer.resetTime();
        }
    }

    public void setUpgradestat() {
        this.energy.setSinkTier(this.tier + this.upgradeSlot.extraTier);
    }

    @Override
    public MachineRecipe getRecipeOutput() {
        return this.output;
    }

    @Override
    public void setRecipeOutput(MachineRecipe output) {
        this.output = output;
    }

    public MachineRecipe getOutput() {
        this.output = this.inputSlotA.process();
        if (this.output != null) {
            this.timer.resetTime();
        }
        return this.output;
    }

    @Override
    public List<ItemStack> getWrenchDrops(Player player, int fortune) {
        List<ItemStack> ret = super.getWrenchDrops(player, fortune);
        return ret;
    }

    @Override
    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction facing) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return LazyOptional.empty();
        }
        return super.getCapability(cap, facing);
    }

    @Override
    public void readPacket(CustomPacketBuffer customPacketBuffer) {
        super.readPacket(customPacketBuffer);
        try {
            this.timer.onNetworkUpdate(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Set<UpgradableProperty> getUpgradableProperties() {
        return EnumSet.of(UpgradableProperty.Transformer, UpgradableProperty.EnergyStorage, UpgradableProperty.ItemExtract, UpgradableProperty.ItemInput);
    }
}

