/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blockentity.mechanism;

import com.denfop.IUItem;
import com.denfop.api.blockentity.MultiBlockEntity;
import com.denfop.api.container.CustomWorldContainer;
import com.denfop.api.upgrades.IUpgradableBlock;
import com.denfop.api.upgrades.UpgradableProperty;
import com.denfop.api.vein.common.Type;
import com.denfop.api.vein.common.VeinBase;
import com.denfop.api.vein.common.VeinSystem;
import com.denfop.blockentity.base.BlockEntityElectricLiquidTankInventory;
import com.denfop.blockentity.base.BlockEntityInventory;
import com.denfop.blockentity.base.IManufacturerBlock;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.FluidName;
import com.denfop.blocks.mechanism.BlockPetrolQuarryEntity;
import com.denfop.blocks.state.DefaultDrop;
import com.denfop.componets.Fluids;
import com.denfop.containermenu.ContainerMenuBase;
import com.denfop.containermenu.ContainerMenuOilPump;
import com.denfop.inventory.Inventory;
import com.denfop.inventory.InventoryFluid;
import com.denfop.inventory.InventoryFluidByList;
import com.denfop.inventory.InventoryUpgrade;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.network.packet.PacketUpdateFieldTile;
import com.denfop.screen.ScreenIndustrialUpgrade;
import com.denfop.screen.ScreenOilPump;
import com.denfop.sound.EnumSound;
import com.denfop.utils.Keyboard;
import com.denfop.utils.Localization;
import com.denfop.utils.ModUtils;
import java.io.IOException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import org.apache.commons.lang3.mutable.MutableObject;

public class BlockEntityOilPump
extends BlockEntityElectricLiquidTankInventory
implements IUpgradableBlock,
IManufacturerBlock {
    private static final List<AABB> aabbs = Collections.singletonList(new AABB(0.0, 0.0, -1.0, 1.0, 2.0, 2.0));
    public final int defaultTier;
    public final InventoryUpgrade upgradeSlot;
    public final InventoryFluid containerslot = new InventoryFluidByList((BlockEntityInventory)this, Inventory.TypeItemSlot.INPUT, 1, InventoryFluid.TypeFluidSlot.OUTPUT, (Fluid)FluidName.fluidpetroleum.getInstance().get(), (Fluid)FluidName.fluidsour_light_oil.getInstance().get(), (Fluid)FluidName.fluidsour_heavy_oil.getInstance().get(), (Fluid)FluidName.fluidsour_medium_oil.getInstance().get(), (Fluid)FluidName.fluidsweet_medium_oil.getInstance().get(), (Fluid)FluidName.fluidsweet_heavy_oil.getInstance().get());
    public int levelMech = 0;
    public boolean find;
    public int count;
    public int maxcount;
    public VeinBase vein;
    public int type;

    public BlockEntityOilPump(BlockPos pos, BlockState state) {
        super(50000.0, 14, 20, Fluids.fluidPredicate((Fluid)FluidName.fluidpetroleum.getInstance().get(), (Fluid)FluidName.fluidsour_light_oil.getInstance().get(), (Fluid)FluidName.fluidsour_heavy_oil.getInstance().get(), (Fluid)FluidName.fluidsour_medium_oil.getInstance().get(), (Fluid)FluidName.fluidsweet_medium_oil.getInstance().get(), (Fluid)FluidName.fluidsweet_heavy_oil.getInstance().get()), BlockPetrolQuarryEntity.petrol_quarry, pos, state);
        this.upgradeSlot = new InventoryUpgrade(this, 4);
        this.defaultTier = 14;
        this.fluidTank.setTypeItemSlot(Inventory.TypeItemSlot.INPUT);
        this.fluidTank.setTypeItemSlot(Inventory.TypeItemSlot.OUTPUT);
    }

    private static int applyModifier(int extra) {
        double ret = Math.round(14.0 + (double)extra);
        return ret > 2.147483647E9 ? Integer.MAX_VALUE : (int)ret;
    }

    @Override
    public MultiBlockEntity getTeBlock() {
        return BlockPetrolQuarryEntity.petrol_quarry;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.oilgetter.getBlock();
    }

    @Override
    public int getLevelMechanism() {
        return this.levelMech;
    }

    @Override
    public void setLevelMech(int levelMech) {
        this.levelMech = levelMech;
    }

    @Override
    public void removeLevel(int level) {
        this.levelMech -= level;
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        tooltip.add(Localization.translate("iu.oil_quarry.info"));
        if (!Keyboard.isKeyDown(340)) {
            tooltip.add(Localization.translate("press.lshift"));
        }
        if (Keyboard.isKeyDown(340)) {
            tooltip.add(Localization.translate("iu.machines_work_energy") + "1" + Localization.translate("iu.machines_work_energy_type_eu"));
        }
        if (stack.m_41782_() && stack.m_41783_().m_128441_("fluid")) {
            FluidStack fluidStack = FluidStack.loadFluidStackFromNBT((CompoundTag)((CompoundTag)stack.m_41783_().m_128423_("fluid")));
            tooltip.add(Localization.translate("iu.fluid.info") + fluidStack.getDisplayName().getString());
            tooltip.add(Localization.translate("iu.fluid.info1") + fluidStack.getAmount() / 1000 + " B");
        }
        super.addInformation(stack, tooltip);
    }

    @Override
    public CompoundTag writeToNBT(CompoundTag nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.m_128405_("level", this.levelMech);
        nbttagcompound.m_128379_("find", this.find);
        return nbttagcompound;
    }

    @Override
    public void readFromNBT(CompoundTag nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.levelMech = nbttagcompound.m_128451_("level");
        this.find = nbttagcompound.m_128471_("find");
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        try {
            this.count = (Integer)DecoderHandler.decode(customPacketBuffer);
            this.find = (Boolean)DecoderHandler.decode(customPacketBuffer);
            this.maxcount = (Integer)DecoderHandler.decode(customPacketBuffer);
            this.levelMech = (Integer)DecoderHandler.decode(customPacketBuffer);
            this.type = (Integer)DecoderHandler.decode(customPacketBuffer);
            this.vein = (VeinBase)DecoderHandler.decode(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer packet = super.writeContainerPacket();
        try {
            EncoderHandler.encode(packet, this.count);
            EncoderHandler.encode(packet, this.find);
            EncoderHandler.encode(packet, this.maxcount);
            EncoderHandler.encode(packet, this.levelMech);
            EncoderHandler.encode(packet, this.type);
            EncoderHandler.encode(packet, this.vein);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    public VeinBase getVein() {
        return this.vein;
    }

    @Override
    public boolean onActivated(Player player, InteractionHand hand, Direction side, Vec3 vec3) {
        if (this.levelMech < 10) {
            ItemStack stack = player.m_21120_(hand);
            if (!stack.m_41720_().equals(IUItem.upgrade_speed_creation.getItem())) {
                return super.onActivated(player, hand, side, vec3);
            }
            stack.m_41774_(1);
            ++this.levelMech;
            return true;
        }
        return super.onActivated(player, hand, side, vec3);
    }

    @Override
    public List<ItemStack> getWrenchDrops(Player player, int fortune) {
        List<ItemStack> ret = super.getWrenchDrops(player, fortune);
        if (this.levelMech != 0) {
            ret.add(new ItemStack((ItemLike)IUItem.upgrade_speed_creation.getItem(), this.levelMech));
            this.levelMech = 0;
        }
        return ret;
    }

    private void updateTileEntityField() {
        new PacketUpdateFieldTile(this, "vein", this.vein);
    }

    @Override
    public ItemStack adjustDrop(ItemStack drop, boolean wrench) {
        if ((drop = super.adjustDrop(drop, wrench)).m_150930_(this.getPickBlock(null, null).m_41720_()) && (wrench || this.teBlock.getDefaultDrop() == DefaultDrop.Self)) {
            CompoundTag nbt = ModUtils.nbt(drop);
            if (this.fluidTank.getFluidAmount() > 0) {
                nbt.m_128365_("fluid", (Tag)this.fluidTank.getFluid().writeToNBT(new CompoundTag()));
            }
        }
        return drop;
    }

    @Override
    public void onPlaced(ItemStack stack, LivingEntity placer, Direction facing) {
        super.onPlaced(stack, placer, facing);
        if (this.m_58904_().f_46443_) {
            return;
        }
        this.vein = VeinSystem.system.getVein(new ChunkPos(this.pos));
        if (this.vein != VeinSystem.system.getEMPTY()) {
            this.find = this.vein.get();
            this.count = this.vein.getCol();
            this.maxcount = this.vein.getMaxCol();
            this.type = this.vein.getType().ordinal();
        }
        if (stack.m_41782_() && stack.m_41783_().m_128441_("fluid")) {
            FluidStack fluidStack = FluidStack.loadFluidStackFromNBT((CompoundTag)((CompoundTag)stack.m_41783_().m_128423_("fluid")));
            if (fluidStack != null) {
                this.fluidTank.fill(fluidStack, IFluidHandler.FluidAction.EXECUTE);
            }
            new PacketUpdateFieldTile(this, "fluidTank", (Object)this.fluidTank);
        }
        this.updateTileEntityField();
    }

    @Override
    public void updateField(String name, CustomPacketBuffer is) {
        if (name.equals("fluidTank")) {
            try {
                FluidTank fluidTank = (FluidTank)DecoderHandler.decode(is);
                this.fluidTank.readFromNBT(fluidTank.writeToNBT(new CompoundTag()));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (name.equals("vein")) {
            try {
                this.vein = (VeinBase)DecoderHandler.decode(is);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        super.updateField(name, is);
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (this.f_58857_.f_46443_) {
            return;
        }
        this.vein = VeinSystem.system.getVein(new ChunkPos(this.pos));
        if (this.vein != VeinSystem.system.getEMPTY()) {
            boolean find = this.vein.get();
            if (this.find != find) {
                this.vein.setFind(this.find);
            }
            this.count = this.vein.getCol();
            this.maxcount = this.vein.getMaxCol();
            this.type = this.vein.getType().ordinal();
        }
        this.updateTileEntityField();
    }

    @Override
    public List<AABB> getAabbs(boolean forCollision) {
        return aabbs;
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.vein == null || this.vein.getType() != Type.OIL) {
            return;
        }
        MutableObject output = new MutableObject();
        if (this.containerslot.transferFromTank((IFluidTank)this.fluidTank, (MutableObject<ItemStack>)output, true) && (output.getValue() == null || this.outputSlot.canAdd((ItemStack)output.getValue()))) {
            this.containerslot.transferFromTank((IFluidTank)this.fluidTank, (MutableObject<ItemStack>)output, false);
            if (output.getValue() != null) {
                this.outputSlot.add((ItemStack)output.getValue());
            }
        }
        if (this.energy.getEnergy() >= 1.0 && this.find) {
            this.get_oil();
            if (!this.getActive()) {
                this.setActive(true);
                this.initiate(0);
            }
        } else if (this.getActive()) {
            this.setActive(false);
            this.initiate(2);
        }
    }

    private void get_oil() {
        if (this.vein.getCol() >= 1) {
            int size = Math.min(this.levelMech * 15 + 5, this.vein.getCol());
            size = Math.min(size, this.fluidTank.getCapacity() - this.fluidTank.getFluidAmount());
            if (this.fluidTank.getFluidAmount() + size <= this.fluidTank.getCapacity()) {
                int variety = this.vein.getMeta() / 3;
                int type = this.vein.getMeta() % 3;
                block0 : switch (variety) {
                    case 0: {
                        switch (type) {
                            case 0: {
                                this.fluidTank.fill(new FluidStack((Fluid)FluidName.fluidpetroleum.getInstance().get(), size), IFluidHandler.FluidAction.EXECUTE);
                                break;
                            }
                            case 1: {
                                this.fluidTank.fill(new FluidStack((Fluid)FluidName.fluidsweet_medium_oil.getInstance().get(), size), IFluidHandler.FluidAction.EXECUTE);
                                break;
                            }
                            case 2: {
                                this.fluidTank.fill(new FluidStack((Fluid)FluidName.fluidsweet_heavy_oil.getInstance().get(), size), IFluidHandler.FluidAction.EXECUTE);
                            }
                        }
                        break;
                    }
                    case 1: {
                        switch (type) {
                            case 0: {
                                this.fluidTank.fill(new FluidStack((Fluid)FluidName.fluidsour_light_oil.getInstance().get(), size), IFluidHandler.FluidAction.EXECUTE);
                                break block0;
                            }
                            case 1: {
                                this.fluidTank.fill(new FluidStack((Fluid)FluidName.fluidsour_medium_oil.getInstance().get(), size), IFluidHandler.FluidAction.EXECUTE);
                                break block0;
                            }
                            case 2: {
                                this.fluidTank.fill(new FluidStack((Fluid)FluidName.fluidsour_heavy_oil.getInstance().get(), size), IFluidHandler.FluidAction.EXECUTE);
                            }
                        }
                    }
                }
                this.vein.removeCol(size);
                this.count = this.vein.getCol();
                this.energy.useEnergy(1.0);
                this.updateTileEntityField();
                if (this.upgradeSlot.tickNoMark()) {
                    this.setUpgradestat();
                }
            }
        }
    }

    @Override
    public void m_6596_() {
        super.m_6596_();
        if (!this.f_58857_.f_46443_) {
            this.setUpgradestat();
        }
    }

    public void setUpgradestat() {
        this.energy.setSinkTier(BlockEntityOilPump.applyModifier(this.upgradeSlot.extraTier));
    }

    @Override
    public double getEnergy() {
        return this.energy.getEnergy();
    }

    @Override
    public boolean useEnergy(double amount) {
        if (this.energy.getEnergy() >= amount) {
            this.energy.useEnergy(amount);
            return true;
        }
        return false;
    }

    public String getStartSoundFile() {
        return "Machines/oilgetter.ogg";
    }

    public String getInterruptSoundFile() {
        return "Machines/InterruptOne.ogg";
    }

    public ContainerMenuOilPump getGuiContainer(Player entityPlayer) {
        return new ContainerMenuOilPump(entityPlayer, this);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ScreenIndustrialUpgrade<ContainerMenuBase<? extends CustomWorldContainer>> getGui(Player entityPlayer, ContainerMenuBase<? extends CustomWorldContainer> isAdmin) {
        return new ScreenOilPump((ContainerMenuOilPump)isAdmin);
    }

    @Override
    public Set<UpgradableProperty> getUpgradableProperties() {
        return EnumSet.of(UpgradableProperty.Transformer, UpgradableProperty.FluidExtract);
    }

    @Override
    public SoundEvent getSound() {
        return EnumSound.oilgetter.getSoundEvent();
    }
}

