/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blockentity.mechanism;

import com.denfop.IUItem;
import com.denfop.api.blockentity.MultiBlockEntity;
import com.denfop.api.container.CustomWorldContainer;
import com.denfop.api.recipe.InventoryOutput;
import com.denfop.api.upgrades.IUpgradableBlock;
import com.denfop.api.upgrades.UpgradableProperty;
import com.denfop.blockentity.base.BlockEntityInventory;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockBaseMachine3Entity;
import com.denfop.componets.AirPollutionComponent;
import com.denfop.componets.ComponentUpgradeSlots;
import com.denfop.componets.Energy;
import com.denfop.componets.SoilPollutionComponent;
import com.denfop.componets.client.ComponentVisibleArea;
import com.denfop.containermenu.ContainerMenuBase;
import com.denfop.containermenu.ContainerMenuCowFarm;
import com.denfop.inventory.Inventory;
import com.denfop.inventory.InventoryUpgrade;
import com.denfop.screen.ScreenCowFarm;
import com.denfop.screen.ScreenIndustrialUpgrade;
import com.denfop.utils.Localization;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BlockEntityCowFarm
extends BlockEntityInventory
implements IUpgradableBlock {
    private static final int RADIUS = 4;
    private static final int MAX_COWS = 20;
    public final Inventory slotSeeds;
    public final InventoryOutput output;
    public final Energy energy;
    public final InventoryOutput output1;
    public final InventoryUpgrade upgradeSlot;
    private final SoilPollutionComponent pollutionSoil;
    private final AirPollutionComponent pollutionAir;
    private final ComponentUpgradeSlots componentUpgrade;
    private final ComponentVisibleArea visible;
    AABB searchArea;

    public BlockEntityCowFarm(BlockPos pos, BlockState state) {
        super(BlockBaseMachine3Entity.cow_farm, pos, state);
        this.searchArea = new AABB(this.pos.m_7918_(-4, -4, -4), this.pos.m_7918_(5, 5, 5));
        this.slotSeeds = new Inventory(this, Inventory.TypeItemSlot.INPUT, 1){

            @Override
            public boolean m_7013_(int index, ItemStack stack) {
                return stack.m_41720_() == Items.f_42405_;
            }
        };
        this.output = new InventoryOutput(this, 9);
        this.output1 = new InventoryOutput(this, 4);
        this.energy = this.addComponent(Energy.asBasicSink((BlockEntityInventory)this, 1024.0, 4));
        this.upgradeSlot = new InventoryUpgrade(this, 4);
        this.componentUpgrade = this.addComponent(new ComponentUpgradeSlots(this, this.upgradeSlot));
        this.pollutionSoil = this.addComponent(new SoilPollutionComponent(this, 0.1));
        this.pollutionAir = this.addComponent(new AirPollutionComponent(this, 0.1));
        this.visible = this.addComponent(new ComponentVisibleArea(this));
    }

    @Override
    public Set<UpgradableProperty> getUpgradableProperties() {
        return EnumSet.of(UpgradableProperty.Transformer, UpgradableProperty.EnergyStorage, UpgradableProperty.ItemExtract, UpgradableProperty.ItemInput);
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine2.getBlock(this.getTeBlock());
    }

    @Override
    public MultiBlockEntity getTeBlock() {
        return BlockBaseMachine3Entity.cow_farm;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        this.visible.aabb = this.searchArea;
    }

    public ContainerMenuCowFarm getGuiContainer(Player var1) {
        return new ContainerMenuCowFarm(this, var1);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ScreenIndustrialUpgrade<ContainerMenuBase<? extends CustomWorldContainer>> getGui(Player var1, ContainerMenuBase<? extends CustomWorldContainer> menu) {
        return new ScreenCowFarm((ContainerMenuCowFarm)menu);
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.getWorld().m_46467_() % 20L == 0L && this.energy.canUseEnergy(50.0)) {
            this.energy.useEnergy(50.0);
            List cows = this.f_58857_.m_45976_(Cow.class, this.searchArea);
            if (cows.size() < 20) {
                this.breedCows(cows);
            }
            this.killOldCows(cows);
        }
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        super.addInformation(stack, tooltip);
        tooltip.add(Localization.translate("iu.cow_farm.info"));
        if (this.getComp(Energy.class) != null) {
            Energy energy = this.getComp(Energy.class);
            if (!energy.getSourceDirs().isEmpty()) {
                tooltip.add(Localization.translate("iu.item.tooltip.PowerTier", energy.getSourceTier()));
            } else if (!energy.getSinkDirs().isEmpty()) {
                tooltip.add(Localization.translate("iu.item.tooltip.PowerTier", energy.getSinkTier()));
            }
        }
    }

    private void breedCows(List<Cow> cows) {
        block0: for (int i = 0; i < cows.size(); ++i) {
            for (int j = i + 1; j < cows.size(); ++j) {
                Cow cow1 = cows.get(i);
                Cow cow2 = cows.get(j);
                if (cow1.m_146764_() != 0 || cow2.m_146764_() != 0 || cow1.m_27593_() || cow2.m_27593_() || cow1.m_27592_() != null || cow2.m_27592_() != null || this.slotSeeds.m_7983_() || this.slotSeeds.get(0).m_41613_() < 2) continue;
                cow1.m_27595_(null);
                cow2.m_27595_(null);
                this.slotSeeds.get(0).m_41774_(2);
                continue block0;
            }
        }
    }

    private void killOldCows(List<Cow> cows) {
        for (int i = cows.size() - 1; i >= 20; --i) {
            Cow cow = cows.get(i);
            cow.m_146870_();
            this.output.add(new ItemStack((ItemLike)Items.f_42579_, 1));
            if (!this.f_58857_.f_46441_.m_188499_()) continue;
            this.output.add(new ItemStack((ItemLike)Items.f_42454_, this.f_58857_.f_46441_.m_188503_(2) + 1));
        }
    }
}

