/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blockentity.geothermalpump;

import com.denfop.IUCore;
import com.denfop.IUItem;
import com.denfop.api.blockentity.MultiBlockEntity;
import com.denfop.api.container.CustomWorldContainer;
import com.denfop.blockentity.geothermalpump.IController;
import com.denfop.blockentity.geothermalpump.IExchanger;
import com.denfop.blockentity.geothermalpump.IGenerator;
import com.denfop.blockentity.geothermalpump.IWaste;
import com.denfop.blockentity.mechanism.multiblocks.base.BlockEntityMultiBlockBase;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.FluidName;
import com.denfop.blocks.mechanism.BlockGeothermalPumpEntity;
import com.denfop.componets.ComponentBaseEnergy;
import com.denfop.componets.Fluids;
import com.denfop.containermenu.ContainerMenuBase;
import com.denfop.containermenu.ContainerMenuGeothermalController;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.register.InitMultiBlockSystem;
import com.denfop.screen.ScreenGeothermalController;
import com.denfop.screen.ScreenIndustrialUpgrade;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class BlockEntityGeothermalController
extends BlockEntityMultiBlockBase
implements IController {
    public boolean work = false;
    List<IGenerator> generatorList = new ArrayList<IGenerator>();
    List<IWaste> wasteList = new ArrayList<IWaste>();
    IExchanger exchanger;

    public BlockEntityGeothermalController(BlockPos pos, BlockState state) {
        super(InitMultiBlockSystem.GeoThermalPumpMultiBlock, BlockGeothermalPumpEntity.geothermal_controller, pos, state);
    }

    @Override
    public void updateTileServer(Player var1, double var2) {
        this.work = !this.work;
    }

    @Override
    public void readFromNBT(CompoundTag nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.work = nbttagcompound.m_128471_("work");
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer customPacketBuffer = super.writeContainerPacket();
        customPacketBuffer.writeBoolean(this.work);
        return customPacketBuffer;
    }

    public ContainerMenuGeothermalController getGuiContainer(Player entityPlayer) {
        return new ContainerMenuGeothermalController(this, entityPlayer);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ScreenIndustrialUpgrade<ContainerMenuBase<? extends CustomWorldContainer>> getGui(Player var1, ContainerMenuBase<? extends CustomWorldContainer> menu) {
        return new ScreenGeothermalController((ContainerMenuGeothermalController)menu);
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        this.work = customPacketBuffer.readBoolean();
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.work && this.isFull()) {
            Fluids.InternalFluidTank fluidTank = this.exchanger.getFluidTank();
            for (IGenerator generator : this.generatorList) {
                ItemStack stack;
                if (fluidTank.getFluidAmount() < 3) break;
                ComponentBaseEnergy baseEnergy = generator.getEnergy();
                int canAdd = generator.getFluidTank().getCapacity() - generator.getFluidTank().getFluidAmount();
                if (!(baseEnergy.getEnergy() >= 10.0) || canAdd < 1) continue;
                generator.getFluidTank().fill(new FluidStack((Fluid)FluidName.fluidpetroleum.getInstance().get(), 1), IFluidHandler.FluidAction.EXECUTE);
                baseEnergy.useEnergy(10.0);
                fluidTank.drain(3, IFluidHandler.FluidAction.EXECUTE);
                if (IUCore.random.nextInt(100) >= 98) {
                    stack = new ItemStack((ItemLike)IUItem.crafting_elements.getStack(457), 1);
                    for (IWaste waste : this.wasteList) {
                        if (waste.getSlot().add(stack)) break;
                    }
                }
                if (IUCore.random.nextInt(100) == 99 && IUCore.random.nextInt(2) == 0) {
                    stack = new ItemStack((ItemLike)IUItem.crafting_elements.getStack(461), 1);
                    for (IWaste waste : this.wasteList) {
                        if (waste.getSlot().add(stack)) break;
                    }
                }
                if (IUCore.random.nextInt(100) == 99 && IUCore.random.nextInt(2) == 0) {
                    stack = new ItemStack((ItemLike)IUItem.crafting_elements.getStack(462), 1);
                    for (IWaste waste : this.wasteList) {
                        if (waste.getSlot().add(stack)) break;
                    }
                }
                if (IUCore.random.nextInt(100) != 99 || IUCore.random.nextInt(2) != 0) continue;
                stack = new ItemStack((ItemLike)IUItem.crafting_elements.getStack(463), 1);
                for (IWaste waste : this.wasteList) {
                    if (waste.getSlot().add(stack)) break;
                }
            }
        }
    }

    @Override
    public CompoundTag writeToNBT(CompoundTag nbttagcompound) {
        nbttagcompound.m_128379_("work", this.work);
        return super.writeToNBT(nbttagcompound);
    }

    @Override
    public void setFull(boolean full) {
        super.setFull(full);
        if (!full) {
            this.generatorList.clear();
            this.wasteList.clear();
            this.exchanger = null;
        }
    }

    @Override
    public void updateAfterAssembly() {
        List<BlockPos> pos1 = this.getMultiBlockStucture().getPosFromClass(this.getFacing(), this.m_58899_(), IExchanger.class);
        this.exchanger = (IExchanger)this.getWorld().m_7702_(pos1.get(0));
        List<BlockPos> pos2 = this.getMultiBlockStucture().getPosFromClass(this.getFacing(), this.m_58899_(), IGenerator.class);
        for (BlockPos pos3 : pos2) {
            this.generatorList.add((IGenerator)this.getWorld().m_7702_(pos3));
        }
        pos2 = this.getMultiBlockStucture().getPosFromClass(this.getFacing(), this.m_58899_(), IWaste.class);
        for (BlockPos pos3 : pos2) {
            this.wasteList.add((IWaste)this.getWorld().m_7702_(pos3));
        }
    }

    @Override
    public void usingBeforeGUI() {
    }

    @Override
    public MultiBlockEntity getTeBlock() {
        return BlockGeothermalPumpEntity.geothermal_controller;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.geothermalpump.getBlock(this.getTeBlock());
    }
}

