/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blockentity.crop;

import com.denfop.IUItem;
import com.denfop.api.blockentity.MultiBlockEntity;
import com.denfop.api.container.CustomWorldContainer;
import com.denfop.api.crop.Crop;
import com.denfop.api.crop.CropInit;
import com.denfop.api.crop.CropItem;
import com.denfop.api.crop.CropNetwork;
import com.denfop.api.crop.EnumSoil;
import com.denfop.api.crop.genetics.EnumGenetic;
import com.denfop.api.crop.genetics.GeneticTraits;
import com.denfop.api.crop.genetics.GeneticsManager;
import com.denfop.api.crop.genetics.Genome;
import com.denfop.api.pollution.PollutionManager;
import com.denfop.api.pollution.component.ChunkLevel;
import com.denfop.api.pollution.component.LevelPollution;
import com.denfop.api.pollution.radiation.EnumLevelRadiation;
import com.denfop.api.pollution.radiation.Radiation;
import com.denfop.api.pollution.radiation.RadiationSystem;
import com.denfop.api.recipe.InventoryOutput;
import com.denfop.api.widget.EnumTypeSlot;
import com.denfop.blockentity.base.BlockEntityInventory;
import com.denfop.blocks.FluidName;
import com.denfop.componets.AirPollutionComponent;
import com.denfop.componets.Energy;
import com.denfop.componets.Fluids;
import com.denfop.componets.SoilPollutionComponent;
import com.denfop.containermenu.ContainerMenuBase;
import com.denfop.containermenu.ContainerMenuMultiCrop;
import com.denfop.inventory.Inventory;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.screen.ScreenIndustrialUpgrade;
import com.denfop.screen.ScreenMultiCrop;
import com.denfop.utils.FluidHandlerFix;
import com.denfop.utils.Localization;
import com.denfop.utils.ModUtils;
import com.denfop.world.WorldBaseGen;
import java.io.IOException;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class BlockEntityMultiCrop
extends BlockEntityInventory {
    public final Inventory downBlockSlot;
    public final Inventory upBlockSlot;
    public final Fluids.InternalFluidTank fluidPestTank;
    public final Fluids.InternalFluidTank fluidWaterTank;
    public final InventoryOutput outputSlot;
    public final Inventory fertilizerSlot;
    private final Fluids fluids;
    public Crop[] crop;
    public Genome[] genome;
    public int[] tickPest;
    public int[] pestUse;
    public EnumSoil[] enumSoils;
    public boolean[] place;
    public int[] tickSoil;
    public int[] maxTickSoil;
    public double[] biomeCoef;
    private Radiation radLevel;
    private ChunkPos chunkPos;
    private LevelChunk chunk;
    private Biome biome;
    private ChunkLevel chunkLevel;

    public BlockEntityMultiCrop(int col, MultiBlockEntity block, BlockPos pos, BlockState state) {
        super(block, pos, state);
        this.tickPest = new int[col];
        this.pestUse = new int[col];
        this.enumSoils = new EnumSoil[col];
        this.crop = new Crop[col];
        this.genome = new Genome[col];
        this.biomeCoef = new double[col];
        this.place = new boolean[col];
        this.tickSoil = new int[col];
        this.maxTickSoil = new int[col];
        this.fluids = this.addComponent(new Fluids(this));
        this.fluidWaterTank = this.fluids.addTankInsert("waterTank", 16000, Fluids.fluidPredicate(Fluids.WATER));
        this.fluidPestTank = this.fluids.addTankInsert("pestTank", 16000, Fluids.fluidPredicate((Fluid)FluidName.fluidweed_ex.getInstance().get()));
        this.outputSlot = new InventoryOutput(this, 9);
        this.pollutionSoil = this.addComponent(new SoilPollutionComponent(this, 0.1 * (double)col / 2.0));
        this.pollutionAir = this.addComponent(new AirPollutionComponent(this, 0.1 * (double)col / 2.0));
        this.fertilizerSlot = new Inventory(this, Inventory.TypeItemSlot.INPUT, 1){

            @Override
            public boolean m_7013_(int index, ItemStack stack) {
                return stack.m_41720_() == IUItem.fertilizer.getItem();
            }

            @Override
            public EnumTypeSlot getTypeSlot() {
                return EnumTypeSlot.FERTILIZER;
            }
        };
        this.downBlockSlot = new Inventory(this, Inventory.TypeItemSlot.INPUT, col){

            @Override
            public boolean m_7013_(int index, ItemStack stack) {
                return EnumSoil.contain(stack);
            }

            @Override
            public int getStackSizeLimit() {
                return 1;
            }

            @Override
            public ItemStack set(int index, ItemStack content) {
                super.set(index, content);
                if (content.m_41619_()) {
                    BlockEntityMultiCrop.this.enumSoils[index] = null;
                    BlockEntityMultiCrop.this.place[index] = false;
                } else {
                    BlockEntityMultiCrop.this.enumSoils[index] = EnumSoil.get(content);
                }
                return content;
            }

            @Override
            public EnumTypeSlot getTypeSlot() {
                return EnumTypeSlot.BLOCKS;
            }
        };
        this.upBlockSlot = new Inventory(this, Inventory.TypeItemSlot.INPUT, col){

            @Override
            public boolean m_7013_(int index, ItemStack stack) {
                return stack.m_41720_() instanceof CropItem && BlockEntityMultiCrop.this.canPlace(((CropItem)stack.m_41720_()).getCrop(stack.m_41773_(), stack), index);
            }

            @Override
            public EnumTypeSlot getTypeSlot() {
                return EnumTypeSlot.CROP;
            }

            @Override
            public int getStackSizeLimit() {
                return 1;
            }

            @Override
            public ItemStack set(int index, ItemStack content) {
                super.set(index, content);
                if (content.m_41619_()) {
                    BlockEntityMultiCrop.this.crop[index] = null;
                    BlockEntityMultiCrop.this.genome[index] = null;
                    BlockEntityMultiCrop.this.place[index] = false;
                } else if (BlockEntityMultiCrop.this.crop[index] == null) {
                    BlockEntityMultiCrop.this.genome[index] = new Genome(content);
                    BlockEntityMultiCrop.this.crop[index] = CropNetwork.instance.getCropFromStack(content).copy();
                    BlockEntityMultiCrop.this.genome[index].loadCrop(BlockEntityMultiCrop.this.crop[index]);
                    BlockEntityMultiCrop.this.place[index] = true;
                    BlockEntityMultiCrop.this.biomeCoef[index] = BlockEntityMultiCrop.this.crop[index].canGrowInBiome(BlockEntityMultiCrop.this.biome, BlockEntityMultiCrop.this.f_58857_) ? 1.0 : 0.5;
                }
                return content;
            }
        };
    }

    @Override
    public boolean onActivated(Player player, InteractionHand hand, Direction side, Vec3 vec3) {
        if (!this.getWorld().f_46443_ && FluidHandlerFix.hasFluidHandler(player.m_21120_(hand))) {
            return ModUtils.interactWithFluidHandler(player, hand, (IFluidHandler)this.fluids.getCapability(ForgeCapabilities.FLUID_HANDLER, side));
        }
        return super.onActivated(player, hand, side, vec3);
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        try {
            this.tickSoil = (int[])DecoderHandler.decode(customPacketBuffer);
            this.maxTickSoil = (int[])DecoderHandler.decode(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer buffer = super.writeContainerPacket();
        try {
            EncoderHandler.encode(buffer, this.tickSoil);
            EncoderHandler.encode(buffer, this.maxTickSoil);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return buffer;
    }

    public ContainerMenuMultiCrop getGuiContainer(Player var1) {
        return new ContainerMenuMultiCrop(this, var1);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ScreenIndustrialUpgrade<ContainerMenuBase<? extends CustomWorldContainer>> getGui(Player var1, ContainerMenuBase<? extends CustomWorldContainer> menu) {
        return new ScreenMultiCrop((ContainerMenuMultiCrop)menu);
    }

    public boolean canPlace(Crop crop, int index) {
        EnumSoil soil = crop.getSoil();
        return soil == this.enumSoils[index];
    }

    @Override
    public CompoundTag writeToNBT(CompoundTag nbt) {
        CompoundTag nbtTagCompound = super.writeToNBT(nbt);
        nbtTagCompound.m_128385_("tickSoil", this.tickSoil);
        nbtTagCompound.m_128385_("maxTickSoil", this.maxTickSoil);
        return nbtTagCompound;
    }

    @Override
    public void readFromNBT(CompoundTag nbtTagCompound) {
        super.readFromNBT(nbtTagCompound);
        this.tickSoil = nbtTagCompound.m_128465_("tickSoil");
        if (this.tickSoil.length == 0) {
            this.tickSoil = new int[this.crop.length];
        }
        this.maxTickSoil = nbtTagCompound.m_128465_("maxTickSoil");
        if (this.maxTickSoil.length == 0) {
            this.maxTickSoil = new int[this.crop.length];
        }
    }

    public int getTickPest(int i) {
        return this.tickPest[i];
    }

    public void setTickPest(int i) {
        this.tickPest[i] = 7000;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.getWorld().f_46443_) {
            this.biome = (Biome)this.getWorld().m_204166_(this.pos).m_203334_();
            for (int i = 0; i < this.crop.length; ++i) {
                if (this.downBlockSlot.get(i).m_41619_()) {
                    this.enumSoils[i] = null;
                    this.place[i] = false;
                } else {
                    this.enumSoils[i] = EnumSoil.get(this.downBlockSlot.get(i));
                }
                ItemStack content = this.upBlockSlot.get(i);
                if (content.m_41619_()) {
                    this.crop[i] = null;
                    this.genome[i] = null;
                    this.place[i] = false;
                    continue;
                }
                this.genome[i] = new Genome(content);
                this.crop[i] = CropNetwork.instance.getCropFromStack(content).copy();
                this.genome[i].loadCrop(this.crop[i]);
                this.crop[i].setTick(this.tickSoil[i]);
                this.biomeCoef[i] = this.crop[i].canGrowInBiome(this.biome, this.f_58857_) ? 1.0 : 0.5;
                this.place[i] = true;
            }
            this.chunkPos = new ChunkPos(this.pos);
            Radiation radiation1 = RadiationSystem.rad_system.getMap().get(this.chunkPos);
            if (radiation1 == null) {
                radiation1 = new Radiation(this.chunkPos);
                RadiationSystem.rad_system.addRadiation(radiation1);
            }
            this.radLevel = radiation1;
            ChunkLevel chunkLevel = PollutionManager.pollutionManager.getChunkLevelSoil(this.chunkPos);
            if (chunkLevel == null) {
                chunkLevel = new ChunkLevel(this.chunkPos, LevelPollution.VERY_LOW, 0.0);
                PollutionManager.pollutionManager.addChunkLevelSoil(chunkLevel);
            }
            this.chunkLevel = chunkLevel;
            this.chunk = this.getWorld().m_46745_(this.pos);
        }
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.getWorld().m_46467_() % 20L == 0L) {
            for (int i = 0; i < this.downBlockSlot.size(); ++i) {
                int chanceWeed;
                Crop crop = this.crop[i];
                if (crop == null || crop.getId() == 3) {
                    this.tickSoil[i] = 0;
                    this.maxTickSoil[i] = 0;
                }
                if (crop == null) continue;
                if (crop.getId() == 3) {
                    this.upBlockSlot.set(i, ItemStack.f_41583_);
                    continue;
                }
                this.tickSoil[i] = crop.getTick();
                this.maxTickSoil[i] = crop.getMaxTick();
                if (!CropNetwork.instance.canMultiGrow(this.f_58857_, this.pos, this.chunkPos, crop, this.radLevel, (ChunkAccess)this.chunk, this.biome, this.chunkLevel) || !this.place[i] || !this.canUseWater(crop)) continue;
                if (this.tickPest[i] == 0 && this.fluidPestTank.getFluidAmount() > 0) {
                    this.setTickPest(i);
                    this.fluidPestTank.drain(1, IFluidHandler.FluidAction.EXECUTE);
                }
                int n = i;
                this.tickPest[n] = this.tickPest[n] - 20;
                if (crop.getTick() < crop.getMaxTick() && this.getWorld().m_46467_() % 200L == 0L && crop.getId() != 3 && this.tickPest[i] == 0 && (chanceWeed = 100 - crop.getChanceWeed() - 5 * (crop.getSizeSeed() - 1)) > 0 && this.getWorld().m_46467_() % 200L == 0L && WorldBaseGen.random.nextInt(100) < chanceWeed && WorldBaseGen.random.nextInt(100) == 0) {
                    this.crop[i] = CropInit.weed_seed.copy();
                    this.pestUse[i] = 0;
                    this.upBlockSlot.set(i, CropInit.weed_seed.getStack());
                    continue;
                }
                if (this.radLevel.getLevel().ordinal() > EnumLevelRadiation.HIGH.ordinal() && crop.getId() != 3) {
                    this.canAdaptationCrop(i);
                }
                if (crop.getTick() < crop.getMaxTick()) {
                    crop.addTick((int)(this.biomeCoef[i] * 20.0 * crop.getGrowthSpeed()));
                    this.useWater(crop);
                    if (this.pestUse[i] < 40 && !this.fertilizerSlot.get(0).m_41619_()) {
                        int n2 = i;
                        this.pestUse[n2] = this.pestUse[n2] + 1;
                        crop.addTick((int)((double)crop.getMaxTick() * 0.2));
                        this.fertilizerSlot.get(0).m_41774_(1);
                    }
                    if (crop.getTick() < crop.getMaxTick() || crop.getId() == 3) continue;
                    this.outputSlot.addAll(crop.getDrops());
                    if (WorldBaseGen.random.nextInt(100) < 10) {
                        this.outputSlot.add(ModUtils.setSize(this.upBlockSlot.get(i).m_41777_(), 1));
                    }
                    this.crop[i].setGeneration(crop.getGeneration() + 1);
                    this.crop[i].setTick(0);
                    this.canAdaptationCrop(i);
                    continue;
                }
                if (crop.getId() == 3) continue;
                this.outputSlot.addAll(crop.getDrops());
                if (WorldBaseGen.random.nextInt(100) < 10) {
                    this.outputSlot.add(ModUtils.setSize(this.upBlockSlot.get(i).m_41777_(), 1));
                }
                this.crop[i].setGeneration(crop.getGeneration() + 1);
                this.crop[i].setTick(0);
                this.canAdaptationCrop(i);
            }
        }
    }

    private boolean canUseWater(Crop crop) {
        return crop.getWaterRequirement() == 0 || this.fluidWaterTank.getFluidAmount() >= crop.getWaterRequirement();
    }

    private void useWater(Crop crop) {
        this.fluidWaterTank.drain(crop.getWaterRequirement(), IFluidHandler.FluidAction.EXECUTE);
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        super.addInformation(stack, tooltip);
        if (this.getComp(Energy.class) != null) {
            Energy energy = this.getComp(Energy.class);
            if (!energy.getSourceDirs().isEmpty()) {
                tooltip.add(Localization.translate("iu.item.tooltip.PowerTier", energy.getSourceTier()));
            } else if (!energy.getSinkDirs().isEmpty()) {
                tooltip.add(Localization.translate("iu.item.tooltip.PowerTier", energy.getSinkTier()));
            }
        }
    }

    private void canAdaptationCrop(int i) {
        if (WorldBaseGen.random.nextInt(100) != 0) {
            return;
        }
        Genome genome = this.genome[i];
        Crop crop = this.crop[i];
        ItemStack cropItem = this.upBlockSlot.get(i);
        int geneticAdaptive = genome.hasGenome(EnumGenetic.GENOME_ADAPTIVE) ? genome.getLevelGenome(EnumGenetic.GENOME_ADAPTIVE, Integer.class) : 5;
        int geneticResistance = genome.hasGenome(EnumGenetic.GENOME_RESISTANCE) ? genome.getLevelGenome(EnumGenetic.GENOME_RESISTANCE, Integer.class) : 5;
        block21: for (EnumGenetic enumGenetic : EnumGenetic.values()) {
            GeneticTraits geneticTraits;
            boolean canUpgrade;
            List<GeneticTraits> genetic = GeneticsManager.enumGeneticListMap.get((Object)enumGenetic);
            if (WorldBaseGen.random.nextInt(100) > geneticAdaptive || WorldBaseGen.random.nextInt(100) <= geneticResistance) continue;
            boolean hasGenome = genome.hasGenome(enumGenetic);
            if (!hasGenome && WorldBaseGen.random.nextInt(100) == 0) {
                GeneticTraits geneticTraits2 = genetic.get(WorldBaseGen.random.nextInt(genetic.size()));
                genome.addGenome(geneticTraits2, this.upBlockSlot.get(i));
                continue;
            }
            boolean needRemove = WorldBaseGen.random.nextInt(geneticResistance) > WorldBaseGen.random.nextInt(geneticAdaptive);
            boolean bl = canUpgrade = WorldBaseGen.random.nextInt(geneticAdaptive) > WorldBaseGen.random.nextInt(geneticResistance);
            if ((needRemove || !canUpgrade) && hasGenome) {
                geneticTraits = genome.removeGenome(enumGenetic, this.upBlockSlot.get(i));
                GeneticsManager.instance.deleteGenomeCrop(crop, geneticTraits);
                continue;
            }
            if (!canUpgrade) continue;
            switch (enumGenetic) {
                case SUN: {
                    if (hasGenome) break block21;
                    genome.addGenome(genetic.get(0), this.upBlockSlot.get(i));
                    crop.setSun(true);
                    break block21;
                }
                case BIOME: {
                    if (!hasGenome) {
                        geneticTraits = genetic.get(WorldBaseGen.random.nextInt(genetic.size()));
                        List<ResourceKey<Biome>> biomeList = Genome.geneticBiomes.get((Object)geneticTraits);
                        if (crop.canGrowInBiome(biomeList.get(0))) break block21;
                        biomeList.forEach(crop::addBiome);
                        genome.addGenome(geneticTraits, cropItem);
                        break block21;
                    }
                    geneticTraits = genetic.get(WorldBaseGen.random.nextInt(genetic.size()));
                    GeneticTraits geneticTraits1 = genome.removeGenome(enumGenetic, cropItem);
                    GeneticsManager.instance.deleteGenomeCrop(crop, geneticTraits1);
                    List<ResourceKey<Biome>> biomeList = Genome.geneticBiomes.get((Object)geneticTraits);
                    biomeList.forEach(crop::addBiome);
                    genome.addGenome(geneticTraits, cropItem);
                    break block21;
                }
                case AIR: {
                    if (!hasGenome) {
                        geneticTraits = genetic.get(WorldBaseGen.random.nextInt(genetic.size()));
                        genome.addGenome(geneticTraits, cropItem);
                        crop.setAirRequirements(geneticTraits.getValue(LevelPollution.class));
                        break block21;
                    }
                    boolean needDecrease = WorldBaseGen.random.nextBoolean();
                    if (needDecrease) {
                        GeneticTraits traits = genome.getGenome(enumGenetic);
                        if (traits.getPrev() != null) {
                            genome.removeGenome(traits, cropItem);
                            genome.addGenome(traits.getPrev(), cropItem);
                            crop.setAirRequirements(traits.getPrev().getValue(LevelPollution.class));
                            break block21;
                        }
                        genome.removeGenome(traits, cropItem);
                        crop.setAirRequirements(LevelPollution.LOW);
                        break block21;
                    }
                    GeneticTraits traits = genome.getGenome(enumGenetic);
                    GeneticTraits traits1 = GeneticsManager.geneticTraitsMap.get((Object)traits);
                    if (traits1 == null) break block21;
                    genome.removeGenome(traits, cropItem);
                    genome.addGenome(traits1, cropItem);
                    crop.setAirRequirements(traits1.getValue(LevelPollution.class));
                    break block21;
                }
                case SOIL: {
                    boolean needDecrease;
                    if (!hasGenome) {
                        geneticTraits = genetic.get(WorldBaseGen.random.nextInt(genetic.size()));
                        LevelPollution levelPollution = geneticTraits.getValue(LevelPollution.class);
                        if (levelPollution.ordinal() < this.chunkLevel.getLevelPollution().ordinal()) break block21;
                        genome.addGenome(geneticTraits, cropItem);
                        crop.setAirRequirements(levelPollution);
                        break block21;
                    }
                    GeneticTraits traits = genome.getGenome(enumGenetic);
                    LevelPollution levelPollution = traits.getValue(LevelPollution.class);
                    boolean bl2 = needDecrease = WorldBaseGen.random.nextBoolean() && this.chunkLevel.getLevelPollution().ordinal() < levelPollution.ordinal();
                    if (needDecrease) {
                        if (traits.getPrev() != null) {
                            genome.removeGenome(traits, cropItem);
                            genome.addGenome(traits.getPrev(), cropItem);
                            crop.setSoilRequirements(traits.getPrev().getValue(LevelPollution.class));
                            break block21;
                        }
                        genome.removeGenome(traits, cropItem);
                        crop.setSoilRequirements(LevelPollution.LOW);
                        break block21;
                    }
                    GeneticTraits traits1 = GeneticsManager.geneticTraitsMap.get((Object)traits);
                    if (traits1 == null) break block21;
                    genome.removeGenome(traits, cropItem);
                    genome.addGenome(traits1, cropItem);
                    crop.setSoilRequirements(traits1.getValue(LevelPollution.class));
                    break block21;
                }
                case WATER: {
                    if (!hasGenome) {
                        genome.addGenome(genetic.get(0), cropItem);
                        crop.setWaterRequirement(0);
                        break block21;
                    }
                    boolean needDecrease = WorldBaseGen.random.nextBoolean();
                    if (!needDecrease) break block21;
                    genome.removeGenome(genetic.get(0), cropItem);
                    crop.setWaterRequirement(crop.getDefaultWaterRequirement());
                    break block21;
                }
                case PEST: {
                    if (!hasGenome) {
                        geneticTraits = genetic.get(WorldBaseGen.random.nextInt(genetic.size()));
                        int level = geneticTraits.getValue(Integer.class);
                        genome.addGenome(geneticTraits, cropItem);
                        crop.setPestResistance(level);
                        break block21;
                    }
                    GeneticTraits traits = genome.getGenome(enumGenetic);
                    int level = traits.getValue(Integer.class);
                    boolean needDecrease = WorldBaseGen.random.nextBoolean();
                    if (needDecrease) {
                        if (traits.getPrev() != null) {
                            genome.removeGenome(traits, cropItem);
                            genome.addGenome(traits.getPrev(), cropItem);
                            crop.setPestResistance(crop.getPestResistance() - level + traits.getPrev().getValue(Integer.class));
                            break block21;
                        }
                        genome.removeGenome(traits, cropItem);
                        crop.setPestResistance(crop.getPestResistance() - level);
                        break block21;
                    }
                    GeneticTraits traits1 = GeneticsManager.geneticTraitsMap.get((Object)traits);
                    if (traits1 == null) break block21;
                    genome.removeGenome(traits, cropItem);
                    genome.addGenome(traits1, cropItem);
                    crop.setPestResistance(crop.getPestResistance() - level + traits1.getValue(Integer.class));
                    break block21;
                }
                case WEED: {
                    if (!hasGenome) {
                        geneticTraits = genetic.get(WorldBaseGen.random.nextInt(genetic.size()));
                        int level = geneticTraits.getValue(Integer.class);
                        genome.addGenome(geneticTraits, cropItem);
                        crop.addChanceWeed(level);
                        break block21;
                    }
                    GeneticTraits traits = genome.getGenome(enumGenetic);
                    int level = traits.getValue(Integer.class);
                    boolean needDecrease = WorldBaseGen.random.nextBoolean();
                    if (needDecrease) {
                        if (traits.getPrev() != null) {
                            genome.removeGenome(traits, cropItem);
                            genome.addGenome(traits.getPrev(), cropItem);
                            crop.addChanceWeed(-level + traits.getPrev().getValue(Integer.class));
                            break block21;
                        }
                        genome.removeGenome(traits, cropItem);
                        crop.addChanceWeed(-level);
                        break block21;
                    }
                    GeneticTraits traits1 = GeneticsManager.geneticTraitsMap.get((Object)traits);
                    if (traits1 == null) break block21;
                    genome.removeGenome(traits, cropItem);
                    genome.addGenome(traits1, cropItem);
                    crop.addChanceWeed(-level + traits1.getValue(Integer.class));
                    break block21;
                }
                case LIGHT: {
                    if (!hasGenome) {
                        geneticTraits = genetic.get(WorldBaseGen.random.nextInt(genetic.size()));
                        int level = geneticTraits.getValue(Integer.class);
                        genome.addGenome(geneticTraits, cropItem);
                        crop.setLight(level);
                        break block21;
                    }
                    GeneticTraits traits = genome.getGenome(enumGenetic);
                    boolean needDecrease = WorldBaseGen.random.nextBoolean();
                    if (needDecrease) {
                        if (traits.getPrev() != null) {
                            genome.removeGenome(traits, cropItem);
                            genome.addGenome(traits.getPrev(), cropItem);
                            crop.setLight(traits.getPrev().getValue(Integer.class));
                            break block21;
                        }
                        genome.removeGenome(traits, cropItem);
                        crop.setLight(crop.getDefaultLightLevel());
                        break block21;
                    }
                    GeneticTraits traits1 = GeneticsManager.geneticTraitsMap.get((Object)traits);
                    if (traits1 == null) break block21;
                    genome.removeGenome(traits, cropItem);
                    genome.addGenome(traits1, cropItem);
                    crop.setLight(traits1.getValue(Integer.class));
                    break block21;
                }
                case RADIATION: {
                    boolean needDecrease;
                    if (!hasGenome) {
                        geneticTraits = genetic.get(WorldBaseGen.random.nextInt(genetic.size()));
                        EnumLevelRadiation levelPollution = geneticTraits.getValue(EnumLevelRadiation.class);
                        if (levelPollution.ordinal() < this.radLevel.getLevel().ordinal()) break block21;
                        genome.addGenome(geneticTraits, cropItem);
                        crop.setRadiationRequirements(levelPollution);
                        break block21;
                    }
                    GeneticTraits traits = genome.getGenome(enumGenetic);
                    EnumLevelRadiation levelPollution = traits.getValue(EnumLevelRadiation.class);
                    boolean bl3 = needDecrease = WorldBaseGen.random.nextBoolean() && this.radLevel.getLevel().ordinal() < levelPollution.ordinal();
                    if (needDecrease) {
                        if (traits.getPrev() != null) {
                            genome.removeGenome(traits, cropItem);
                            genome.addGenome(traits.getPrev(), cropItem);
                            crop.setRadiationRequirements(traits.getPrev().getValue(EnumLevelRadiation.class));
                            break block21;
                        }
                        genome.removeGenome(traits, cropItem);
                        crop.setRadiationRequirements(EnumLevelRadiation.LOW);
                        break block21;
                    }
                    GeneticTraits traits1 = GeneticsManager.geneticTraitsMap.get((Object)traits);
                    if (traits1 == null) break block21;
                    genome.removeGenome(traits, cropItem);
                    genome.addGenome(traits1, cropItem);
                    crop.setRadiationRequirements(traits1.getValue(EnumLevelRadiation.class));
                    break block21;
                }
                case SEED: {
                    if (!hasGenome) {
                        geneticTraits = genetic.get(WorldBaseGen.random.nextInt(genetic.size()));
                        int level = geneticTraits.getValue(Integer.class);
                        genome.addGenome(geneticTraits, cropItem);
                        crop.addSizeSeed(level);
                        break block21;
                    }
                    GeneticTraits traits = genome.getGenome(enumGenetic);
                    int level = traits.getValue(Integer.class);
                    boolean needDecrease = WorldBaseGen.random.nextBoolean();
                    if (needDecrease) {
                        if (traits.getPrev() != null) {
                            genome.removeGenome(traits, cropItem);
                            genome.addGenome(traits.getPrev(), cropItem);
                            crop.addSizeSeed(-level + traits.getPrev().getValue(Integer.class));
                            break block21;
                        }
                        genome.removeGenome(traits, cropItem);
                        crop.addSizeSeed(-level);
                        break block21;
                    }
                    GeneticTraits traits1 = GeneticsManager.geneticTraitsMap.get((Object)traits);
                    if (traits1 == null) break block21;
                    genome.removeGenome(traits, cropItem);
                    genome.addGenome(traits1, cropItem);
                    crop.addSizeSeed(-level + traits1.getValue(Integer.class));
                    break block21;
                }
                case YIELD: {
                    if (!hasGenome) {
                        geneticTraits = genetic.get(WorldBaseGen.random.nextInt(genetic.size()));
                        int level = geneticTraits.getValue(Integer.class);
                        genome.addGenome(geneticTraits, cropItem);
                        crop.setYield(level);
                        break block21;
                    }
                    GeneticTraits traits = genome.getGenome(enumGenetic);
                    int level = traits.getValue(Integer.class);
                    boolean needDecrease = WorldBaseGen.random.nextBoolean();
                    if (needDecrease) {
                        if (traits.getPrev() != null) {
                            genome.removeGenome(traits, cropItem);
                            genome.addGenome(traits.getPrev(), cropItem);
                            crop.setYield(crop.getYield() - level + traits.getPrev().getValue(Integer.class));
                            break block21;
                        }
                        genome.removeGenome(traits, cropItem);
                        crop.setYield(crop.getYield() - level);
                        break block21;
                    }
                    GeneticTraits traits1 = GeneticsManager.geneticTraitsMap.get((Object)traits);
                    if (traits1 == null) break block21;
                    genome.removeGenome(traits, cropItem);
                    genome.addGenome(traits1, cropItem);
                    crop.setYield(crop.getYield() - level + traits1.getValue(Integer.class));
                    break block21;
                }
                case BEE: {
                    if (hasGenome) break block21;
                    genome.addGenome(genetic.get(0), cropItem);
                    crop.setBeeCombine(true);
                    break block21;
                }
                case NIGHT_GROW: {
                    if (hasGenome) break block21;
                    genome.addGenome(genetic.get(0), cropItem);
                    crop.setNight(true);
                    break block21;
                }
                case SOIL_BLOCK: {
                    if (hasGenome) break block21;
                    genome.addGenome(genetic.get(0), cropItem);
                    crop.setIgnoreSoil(true);
                    break block21;
                }
                case CHANCE: {
                    if (!hasGenome) {
                        geneticTraits = genetic.get(WorldBaseGen.random.nextInt(genetic.size()));
                        int level = geneticTraits.getValue(Integer.class);
                        genome.addGenome(geneticTraits, cropItem);
                        crop.setChance(level);
                        break block21;
                    }
                    GeneticTraits traits = genome.getGenome(enumGenetic);
                    int level = traits.getValue(Integer.class);
                    boolean needDecrease = WorldBaseGen.random.nextBoolean();
                    if (needDecrease) {
                        if (traits.getPrev() != null) {
                            genome.removeGenome(traits, cropItem);
                            genome.addGenome(traits.getPrev(), cropItem);
                            crop.setChance(crop.getChance() - level + traits.getPrev().getValue(Integer.class));
                            break block21;
                        }
                        genome.removeGenome(traits, cropItem);
                        crop.setChance(crop.getChance() - level);
                        break block21;
                    }
                    GeneticTraits traits1 = GeneticsManager.geneticTraitsMap.get((Object)traits);
                    if (traits1 == null) break block21;
                    genome.removeGenome(traits, cropItem);
                    genome.addGenome(traits1, cropItem);
                    crop.setChance(crop.getChance() - level + traits1.getValue(Integer.class));
                    break block21;
                }
                case GROW_SPEED: {
                    if (!hasGenome) {
                        geneticTraits = genetic.get(WorldBaseGen.random.nextInt(genetic.size()));
                        double level = geneticTraits.getValue(Double.class);
                        genome.addGenome(geneticTraits, cropItem);
                        crop.setGrowthSpeed(level);
                        break block21;
                    }
                    GeneticTraits traits = genome.getGenome(enumGenetic);
                    double level = traits.getValue(Double.class);
                    boolean needDecrease = WorldBaseGen.random.nextBoolean();
                    if (needDecrease) {
                        if (traits.getPrev() != null) {
                            genome.removeGenome(traits, cropItem);
                            genome.addGenome(traits.getPrev(), cropItem);
                            crop.setGrowthSpeed(traits.getPrev().getValue(Double.class));
                            break block21;
                        }
                        genome.removeGenome(traits, cropItem);
                        crop.setGrowthSpeed(1.0);
                        break block21;
                    }
                    GeneticTraits traits1 = GeneticsManager.geneticTraitsMap.get((Object)traits);
                    if (traits1 == null) break block21;
                    genome.removeGenome(traits, cropItem);
                    genome.addGenome(traits1, cropItem);
                    crop.setGrowthSpeed(traits1.getValue(Double.class));
                    break block21;
                }
                case WEATHER: {
                    if (!hasGenome) {
                        geneticTraits = genetic.get(WorldBaseGen.random.nextInt(genetic.size()));
                        int level = geneticTraits.getValue(Integer.class);
                        genome.addGenome(geneticTraits, cropItem);
                        crop.setWeatherResistance(level);
                        break block21;
                    }
                    GeneticTraits traits = genome.getGenome(enumGenetic);
                    boolean needDecrease = WorldBaseGen.random.nextBoolean();
                    if (needDecrease) {
                        if (traits.getPrev() != null) {
                            genome.removeGenome(traits, cropItem);
                            genome.addGenome(traits.getPrev(), cropItem);
                            crop.setWeatherResistance(traits.getPrev().getValue(Integer.class));
                            break block21;
                        }
                        genome.removeGenome(traits, cropItem);
                        crop.setWeatherResistance(crop.getDefaultWeatherResistance());
                        break block21;
                    }
                    GeneticTraits traits1 = GeneticsManager.geneticTraitsMap.get((Object)traits);
                    if (traits1 == null) break block21;
                    genome.removeGenome(traits, cropItem);
                    genome.addGenome(traits1, cropItem);
                    crop.setWeatherResistance(traits1.getValue(Integer.class));
                    break block21;
                }
                case GENOME_ADAPTIVE: {
                    if (!hasGenome) {
                        geneticTraits = genetic.get(WorldBaseGen.random.nextInt(genetic.size()));
                        int level = geneticTraits.getValue(Integer.class);
                        genome.addGenome(geneticTraits, cropItem);
                        crop.setGenomeAdaptive(level);
                        break block21;
                    }
                    GeneticTraits traits = genome.getGenome(enumGenetic);
                    int level = traits.getValue(Integer.class);
                    boolean needDecrease = WorldBaseGen.random.nextBoolean();
                    if (needDecrease) {
                        if (traits.getPrev() != null) {
                            genome.removeGenome(traits, cropItem);
                            genome.addGenome(traits.getPrev(), cropItem);
                            crop.setGenomeAdaptive(crop.getGenomeAdaptive() - level + traits.getPrev().getValue(Integer.class));
                            break block21;
                        }
                        genome.removeGenome(traits, cropItem);
                        crop.setGenomeAdaptive(crop.getGenomeAdaptive() - level);
                        break block21;
                    }
                    GeneticTraits traits1 = GeneticsManager.geneticTraitsMap.get((Object)traits);
                    if (traits1 == null) break block21;
                    genome.removeGenome(traits, cropItem);
                    genome.addGenome(traits1, cropItem);
                    crop.setGenomeAdaptive(crop.getGenomeAdaptive() - level + traits1.getValue(Integer.class));
                    break block21;
                }
                case GENOME_RESISTANCE: {
                    if (!hasGenome) {
                        geneticTraits = genetic.get(WorldBaseGen.random.nextInt(genetic.size()));
                        int level = geneticTraits.getValue(Integer.class);
                        genome.addGenome(geneticTraits, cropItem);
                        crop.setGenomeResistance(level);
                        break block21;
                    }
                    GeneticTraits traits = genome.getGenome(enumGenetic);
                    int level = traits.getValue(Integer.class);
                    boolean needDecrease = WorldBaseGen.random.nextBoolean();
                    if (needDecrease) {
                        if (traits.getPrev() != null) {
                            genome.removeGenome(traits, cropItem);
                            genome.addGenome(traits.getPrev(), cropItem);
                            crop.setGenomeResistance(crop.getGenomeResistance() - level + traits.getPrev().getValue(Integer.class));
                            break block21;
                        }
                        genome.removeGenome(traits, cropItem);
                        crop.setGenomeResistance(crop.getGenomeResistance() - level);
                        break block21;
                    }
                    GeneticTraits traits1 = GeneticsManager.geneticTraitsMap.get((Object)traits);
                    if (traits1 == null) break block21;
                    genome.removeGenome(traits, cropItem);
                    genome.addGenome(traits1, cropItem);
                    crop.setGenomeResistance(crop.getGenomeResistance() - level + traits1.getValue(Integer.class));
                    break block21;
                }
                default: {
                    continue block21;
                }
            }
        }
    }
}

