/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blockentity.base;

import com.denfop.api.blockentity.MultiBlockEntity;
import com.denfop.api.recipe.IUpdateTick;
import com.denfop.api.recipe.InventoryRecipes;
import com.denfop.api.recipe.MachineRecipe;
import com.denfop.api.upgrades.IUpgradableBlock;
import com.denfop.api.upgrades.UpgradableProperty;
import com.denfop.blockentity.base.BlockEntityInventory;
import com.denfop.blockentity.base.BlockEntityStandartMachine;
import com.denfop.blockentity.base.EnumTripleElectricMachine;
import com.denfop.componets.ComponentProcess;
import com.denfop.componets.ComponentProgress;
import com.denfop.componets.ComponentUpgrade;
import com.denfop.componets.ComponentUpgradeSlots;
import com.denfop.componets.Energy;
import com.denfop.componets.TypeUpgrade;
import com.denfop.containermenu.ContainerMenuTripleElectricMachine;
import com.denfop.inventory.Inventory;
import com.denfop.inventory.InventoryDischarge;
import com.denfop.inventory.InventoryUpgrade;
import com.denfop.network.packet.PacketStopSound;
import com.denfop.sound.EnumSound;
import com.denfop.utils.Keyboard;
import com.denfop.utils.Localization;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;

public abstract class BlockEntityTripleElectricMachine
extends BlockEntityStandartMachine
implements IUpgradableBlock,
IUpdateTick {
    public final InventoryDischarge dischargeSlot;
    public final InventoryRecipes inputSlotA;
    public final InventoryUpgrade upgradeSlot = new InventoryUpgrade(this, 4);
    public final ComponentUpgradeSlots componentUpgrade;
    public final ComponentProgress componentProgress;
    public final ComponentProcess componentProcess;
    protected final String name;
    protected final EnumTripleElectricMachine type;
    private final ComponentUpgrade componentUpgrades;
    public double energyConsume;
    public int operationLength;
    public int operationsPerTick;
    public MachineRecipe output;
    protected boolean sound = true;

    public BlockEntityTripleElectricMachine(int energyPerTick, int length, int outputSlots, String name, EnumTripleElectricMachine type, MultiBlockEntity block, BlockPos pos, BlockState state) {
        super(outputSlots, block, pos, state);
        this.name = name;
        this.inputSlotA = new InventoryRecipes((BlockEntityInventory)this, type.recipe_name, (IUpdateTick)this);
        this.type = type;
        this.dischargeSlot = new InventoryDischarge(this, Inventory.TypeItemSlot.INPUT, 1, false);
        this.componentUpgrade = this.addComponent(new ComponentUpgradeSlots(this, this.upgradeSlot));
        this.componentProgress = this.addComponent(new ComponentProgress((BlockEntityInventory)this, 1, (short)length));
        this.componentProcess = this.addComponent(new ComponentProcess(this, length, energyPerTick));
        this.componentProcess.setHasAudio(true);
        this.componentProcess.setSlotOutput(this.outputSlot);
        this.componentProcess.setInvSlotRecipes(this.inputSlotA);
        this.energy = this.addComponent(Energy.asBasicSink((BlockEntityInventory)this, (double)energyPerTick * (double)length, 1).addManagedSlot(this.dischargeSlot));
        this.componentUpgrades = this.addComponent(new ComponentUpgrade(this, TypeUpgrade.INSTANT, TypeUpgrade.STACK));
    }

    @Override
    public boolean getEnable() {
        return this.sound;
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        if (this.type == EnumTripleElectricMachine.ADV_ALLOY_SMELTER) {
            if (!Keyboard.isKeyDown(340)) {
                tooltip.add(Localization.translate("press.lshift"));
            }
            if (Keyboard.isKeyDown(340)) {
                tooltip.add(Localization.translate("iu.heatmachine.info"));
                tooltip.add(Localization.translate("iu.machines_work_energy") + this.componentProcess.getEnergyConsume() + Localization.translate("iu.machines_work_energy_type_eu"));
                tooltip.add(Localization.translate("iu.machines_work_length") + this.componentProcess.getDefaultOperationLength());
            }
        } else {
            if (!Keyboard.isKeyDown(340)) {
                tooltip.add(Localization.translate("press.lshift"));
            }
            if (Keyboard.isKeyDown(340)) {
                tooltip.add(Localization.translate("iu.machines_work_energy") + this.componentProcess.getEnergyConsume() + Localization.translate("iu.machines_work_energy_type_eu"));
                tooltip.add(Localization.translate("iu.machines_work_length") + this.componentProcess.getDefaultOperationLength());
            }
        }
        if (this.getComp(Energy.class) != null) {
            Energy energy = this.getComp(Energy.class);
            if (!energy.getSourceDirs().isEmpty()) {
                tooltip.add(Localization.translate("iu.item.tooltip.PowerTier", energy.getSourceTier()));
            } else if (!energy.getSinkDirs().isEmpty()) {
                tooltip.add(Localization.translate("iu.item.tooltip.PowerTier", energy.getSinkTier()));
            }
        }
    }

    @Override
    public void onUpdate() {
    }

    @Override
    public MachineRecipe getRecipeOutput() {
        return this.output;
    }

    @Override
    public void setRecipeOutput(MachineRecipe output) {
        this.output = output;
    }

    @Override
    public void readFromNBT(CompoundTag nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.sound = nbttagcompound.m_128471_("sound");
    }

    @Override
    public CompoundTag writeToNBT(CompoundTag nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.m_128379_("sound", this.sound);
        return nbttagcompound;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.getWorld().f_46443_) {
            this.inputSlotA.load();
            this.getOutput();
        }
    }

    public MachineRecipe getOutput() {
        this.output = this.inputSlotA.process();
        return this.output;
    }

    public ContainerMenuTripleElectricMachine getGuiContainer(Player entityPlayer) {
        return new ContainerMenuTripleElectricMachine(entityPlayer, this, this.type);
    }

    @Override
    public Set<UpgradableProperty> getUpgradableProperties() {
        return EnumSet.of(UpgradableProperty.Processing, UpgradableProperty.Transformer, UpgradableProperty.EnergyStorage, UpgradableProperty.ItemExtract, UpgradableProperty.ItemInput);
    }

    @Override
    public void initiate(int soundEvent) {
        if (this.getTypeAudio() == this.valuesAudio[soundEvent % this.valuesAudio.length]) {
            return;
        }
        this.setType(this.valuesAudio[soundEvent % this.valuesAudio.length]);
        if (!this.getEnable()) {
            return;
        }
        if (this.getSound() == null) {
            return;
        }
        if (soundEvent == 0) {
            this.getWorld().m_5594_(null, this.m_58899_(), this.getSound(), SoundSource.BLOCKS, 1.0f, 1.0f);
        } else if (soundEvent == 1) {
            new PacketStopSound(this.getWorld(), this.m_58899_());
            this.getWorld().m_5594_(null, this.m_58899_(), EnumSound.InterruptOne.getSoundEvent(), SoundSource.BLOCKS, 1.0f, 1.0f);
        } else {
            new PacketStopSound(this.getWorld(), this.m_58899_());
        }
    }

    @Override
    public final float getChargeLevel() {
        return Math.min((float)this.energy.getEnergy() / (float)this.energy.getCapacity(), 1.0f);
    }

    public String getInventoryName() {
        return this.name;
    }
}

