/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blockentity.base;

import com.denfop.IUItem;
import com.denfop.api.Recipes;
import com.denfop.api.blockentity.MultiBlockEntity;
import com.denfop.api.container.CustomWorldContainer;
import com.denfop.api.energy.networking.EnergyNetGlobal;
import com.denfop.api.recipe.BaseMachineRecipe;
import com.denfop.api.recipe.IHasRecipe;
import com.denfop.api.recipe.IUpdateTick;
import com.denfop.api.recipe.Input;
import com.denfop.api.recipe.InventoryOutput;
import com.denfop.api.recipe.InventoryRecipes;
import com.denfop.api.recipe.MachineRecipe;
import com.denfop.api.recipe.RecipeOutput;
import com.denfop.blockentity.base.BlockEntityBase;
import com.denfop.blockentity.base.BlockEntityElectricMachine;
import com.denfop.blockentity.base.BlockEntityInventory;
import com.denfop.blockentity.base.IIsMolecular;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockMolecularEntity;
import com.denfop.componets.Energy;
import com.denfop.containermenu.ContainerMenuBase;
import com.denfop.containermenu.ContainerMenuBaseMolecular;
import com.denfop.items.resource.ItemNuclearResource;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.IUpdatableTileEvent;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.network.packet.PacketUpdateFieldTile;
import com.denfop.recipe.IInputHandler;
import com.denfop.screen.ScreenIndustrialUpgrade;
import com.denfop.screen.ScreenMolecularTransformer;
import com.denfop.sound.EnumSound;
import com.denfop.utils.ModUtils;
import com.mojang.blaze3d.vertex.PoseStack;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.fml.loading.FMLEnvironment;

public class BlockEntityMolecularTransformer
extends BlockEntityElectricMachine
implements IUpdatableTileEvent,
IUpdateTick,
IHasRecipe,
IIsMolecular {
    public double[] energyShare;
    public boolean queue = false;
    public byte redstoneMode = 0;
    public InventoryRecipes[] inputSlot;
    public MachineRecipe[] output;
    public double perenergy;
    public double differenceenergy;
    public ItemStack[] output_stack = new ItemStack[4];
    public int maxAmount = 1;
    public InventoryOutput[] outputSlot = new InventoryOutput[4];
    public double[] energySlots;
    public double[] maxEnergySlots;
    protected double[] guiProgress;
    protected double[] size_recipe;
    int index;
    int indexModel = 0;
    int tick = 0;
    private boolean need = false;
    @OnlyIn(value=Dist.CLIENT)
    private BakedModel[] bakedModel;
    @OnlyIn(value=Dist.CLIENT)
    private BakedModel[] transformedModel;

    public BlockEntityMolecularTransformer(BlockPos pos, BlockState state) {
        super(0.0, 14, 0, BlockMolecularEntity.molecular, pos, state);
        this.energy = this.addComponent(Energy.asBasicSink((BlockEntityInventory)this, 0.0, 14).addManagedSlot(this.dischargeSlot));
        this.inputSlot = new InventoryRecipes[4];
        this.output = new MachineRecipe[4];
        this.energySlots = new double[4];
        this.guiProgress = new double[4];
        this.energyShare = new double[4];
        this.maxEnergySlots = new double[4];
        if (FMLEnvironment.dist.isClient()) {
            this.bakedModel = new BakedModel[4];
            this.transformedModel = new BakedModel[4];
        }
        this.size_recipe = new double[4];
        for (int i = 0; i < 4; ++i) {
            this.output_stack[i] = new ItemStack((ItemLike)Items.f_41852_);
            this.inputSlot[i] = new InventoryRecipes(this, "molecular", this){

                @Override
                public boolean m_7013_(int index, ItemStack itemStack) {
                    return this.getIndex() < BlockEntityMolecularTransformer.this.maxAmount;
                }
            };
            this.inputSlot[i].setIndex(i);
            this.outputSlot[i] = new InventoryOutput(this, 1);
        }
        Recipes.recipes.addInitRecipes(this);
    }

    public static void addrecipe(ItemStack stack, ItemStack stack1, double energy) {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128347_("energy", energy);
        IInputHandler input = Recipes.inputFactory;
        Recipes.recipes.addRecipe("molecular", new BaseMachineRecipe(new Input(input.getInput(stack)), new RecipeOutput(nbt, stack1)));
    }

    public static void addrecipe(String stack, ItemStack stack1, double energy) {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128347_("energy", energy);
        IInputHandler input = Recipes.inputFactory;
        Recipes.recipes.addRecipe("molecular", new BaseMachineRecipe(new Input(input.getInput(stack)), new RecipeOutput(nbt, stack1)));
    }

    @Override
    public MultiBlockEntity getTeBlock() {
        return BlockMolecularEntity.molecular;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.blockmolecular.getBlock(0);
    }

    public ItemStack getOutput_stack() {
        return this.output_stack[0];
    }

    @Override
    public void init() {
        BlockEntityMolecularTransformer.addrecipe(new ItemStack((ItemLike)Items.f_42679_, 1), new ItemStack((ItemLike)Items.f_42686_, 1), 4000000.0);
        BlockEntityMolecularTransformer.addrecipe(new ItemStack((ItemLike)IUItem.nuclear_res.getItem(ItemNuclearResource.Types.plutonium)), new ItemStack((ItemLike)IUItem.proton.getItem(), 1), 1.55E7);
        BlockEntityMolecularTransformer.addrecipe("forge:ingots/Spinel", new ItemStack((ItemLike)IUItem.iuingot.getStack(5), 1), 2500000.0);
        BlockEntityMolecularTransformer.addrecipe(new ItemStack((ItemLike)IUItem.photoniy.getItem()), new ItemStack((ItemLike)IUItem.photoniy_ingot.getItem()), 1.2E7);
        BlockEntityMolecularTransformer.addrecipe(new ItemStack((ItemLike)Blocks.f_50134_), new ItemStack((ItemLike)Items.f_42403_, 2), 70000.0);
        BlockEntityMolecularTransformer.addrecipe(new ItemStack((ItemLike)Blocks.f_49992_), new ItemStack((ItemLike)Blocks.f_49994_, 1), 45000.0);
        BlockEntityMolecularTransformer.addrecipe("forge:ingots/Iridium", new ItemStack((ItemLike)IUItem.core.getStack(0), 1), 1500.0);
        BlockEntityMolecularTransformer.addrecipe(new ItemStack((ItemLike)IUItem.core.getStack(0), 4), new ItemStack((ItemLike)IUItem.core.getStack(1)), 11720.0);
        BlockEntityMolecularTransformer.addrecipe(new ItemStack((ItemLike)IUItem.core.getStack(1), 4), new ItemStack((ItemLike)IUItem.core.getStack(2)), 60000.0);
        BlockEntityMolecularTransformer.addrecipe(new ItemStack((ItemLike)IUItem.core.getStack(2), 4), new ItemStack((ItemLike)IUItem.core.getStack(3)), 300000.0);
        BlockEntityMolecularTransformer.addrecipe(new ItemStack((ItemLike)IUItem.core.getStack(3), 4), new ItemStack((ItemLike)IUItem.core.getStack(4)), 1500000.0);
        BlockEntityMolecularTransformer.addrecipe(new ItemStack((ItemLike)IUItem.core.getStack(4), 4), new ItemStack((ItemLike)IUItem.core.getStack(5)), 7500000.0);
        BlockEntityMolecularTransformer.addrecipe(new ItemStack((ItemLike)IUItem.core.getStack(5), 4), new ItemStack((ItemLike)IUItem.core.getStack(6)), 4.5E7);
        BlockEntityMolecularTransformer.addrecipe(new ItemStack((ItemLike)IUItem.core.getStack(6), 4), new ItemStack((ItemLike)IUItem.core.getStack(7)), 1.8E8);
        BlockEntityMolecularTransformer.addrecipe(new ItemStack((ItemLike)IUItem.core.getStack(7), 4), new ItemStack((ItemLike)IUItem.core.getStack(8)), 9.0E8);
        BlockEntityMolecularTransformer.addrecipe(new ItemStack((ItemLike)IUItem.core.getStack(8), 4), new ItemStack((ItemLike)IUItem.core.getStack(9)), 2.7E9);
        BlockEntityMolecularTransformer.addrecipe(new ItemStack((ItemLike)IUItem.core.getStack(9), 4), new ItemStack((ItemLike)IUItem.core.getStack(10)), 4.5E9);
        BlockEntityMolecularTransformer.addrecipe(new ItemStack((ItemLike)IUItem.core.getStack(10), 4), new ItemStack((ItemLike)IUItem.core.getStack(11)), 9.0E9);
        BlockEntityMolecularTransformer.addrecipe(new ItemStack((ItemLike)IUItem.core.getStack(11), 4), new ItemStack((ItemLike)IUItem.core.getStack(12)), 1.2E10);
        BlockEntityMolecularTransformer.addrecipe(new ItemStack((ItemLike)IUItem.core.getStack(12), 4), new ItemStack((ItemLike)IUItem.core.getStack(13)), 2.1E10);
        BlockEntityMolecularTransformer.addrecipe(new ItemStack((ItemLike)IUItem.crafting_elements.getStack(649), 8), new ItemStack((ItemLike)IUItem.crafting_elements.getStack(645)), 2.0E7);
        BlockEntityMolecularTransformer.addrecipe(new ItemStack((ItemLike)IUItem.matter.getStack(1)), new ItemStack((ItemLike)IUItem.lens.getStack(5)), 2.5E7);
        BlockEntityMolecularTransformer.addrecipe(new ItemStack((ItemLike)IUItem.matter.getStack(2)), new ItemStack((ItemLike)IUItem.lens.getStack(6)), 2.5E7);
        BlockEntityMolecularTransformer.addrecipe(new ItemStack((ItemLike)IUItem.matter.getStack(3)), new ItemStack((ItemLike)IUItem.lens.getStack(2)), 2.5E7);
        BlockEntityMolecularTransformer.addrecipe(new ItemStack((ItemLike)IUItem.matter.getStack(4)), new ItemStack((ItemLike)IUItem.lens.getStack(4)), 2.5E7);
        BlockEntityMolecularTransformer.addrecipe(new ItemStack((ItemLike)IUItem.matter.getStack(5)), new ItemStack((ItemLike)IUItem.lens.getStack(1)), 2.5E7);
        BlockEntityMolecularTransformer.addrecipe(new ItemStack((ItemLike)IUItem.matter.getStack(6)), new ItemStack((ItemLike)IUItem.lens.getStack(3)), 2.5E7);
        BlockEntityMolecularTransformer.addrecipe(new ItemStack((ItemLike)IUItem.matter.getStack(7)), new ItemStack((ItemLike)IUItem.lens.getStack(0), 1), 2.5E7);
        BlockEntityMolecularTransformer.addrecipe(new ItemStack((ItemLike)Items.f_42416_), IUItem.iridiumOre, 7500000.0);
        BlockEntityMolecularTransformer.addrecipe(IUItem.iridiumOre, new ItemStack((ItemLike)IUItem.photoniy.getItem()), 1450000.0);
    }

    public List<Double> getTime(int i) {
        double dif = this.energyShare[i];
        return ModUtils.Time((1.0 - this.guiProgress[i]) * this.maxEnergySlots[i] / (dif * 20.0));
    }

    public double getInput() {
        return EnergyNetGlobal.instance.getNodeStats(this.energy.getDelegate(), this.f_58857_).getEnergyIn();
    }

    public ContainerMenuBaseMolecular getGuiContainer(Player entityPlayer) {
        return new ContainerMenuBaseMolecular(entityPlayer, this);
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        try {
            this.guiProgress = (double[])DecoderHandler.decode(customPacketBuffer);
            this.energyShare = (double[])DecoderHandler.decode(customPacketBuffer);
            this.energySlots = (double[])DecoderHandler.decode(customPacketBuffer);
            this.maxEnergySlots = (double[])DecoderHandler.decode(customPacketBuffer);
            this.queue = (Boolean)DecoderHandler.decode(customPacketBuffer);
            this.redstoneMode = (Byte)DecoderHandler.decode(customPacketBuffer);
            this.differenceenergy = (Double)DecoderHandler.decode(customPacketBuffer);
            this.perenergy = (Double)DecoderHandler.decode(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer packet = super.writeContainerPacket();
        try {
            EncoderHandler.encode(packet, this.guiProgress);
            EncoderHandler.encode(packet, this.energyShare);
            EncoderHandler.encode(packet, this.energySlots);
            EncoderHandler.encode(packet, this.maxEnergySlots);
            EncoderHandler.encode(packet, this.queue);
            EncoderHandler.encode(packet, this.redstoneMode);
            EncoderHandler.encode(packet, this.differenceenergy);
            EncoderHandler.encode(packet, this.perenergy);
            EncoderHandler.encode(packet, this.output_stack);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public boolean onActivated(Player player, InteractionHand hand, Direction side, Vec3 hitX) {
        ItemStack stack = player.m_21120_(hand);
        if (!this.getWorld().f_46443_ && this.maxAmount == 1 && stack.m_41720_() == IUItem.double_molecular.getItem()) {
            this.maxAmount = 2;
            stack.m_41774_(1);
            new PacketUpdateFieldTile(this, "maxAmount", this.maxAmount);
            return true;
        }
        if (!this.getWorld().f_46443_ && this.maxAmount == 2 && stack.m_41720_() == IUItem.quad_molecular.getItem()) {
            this.maxAmount = 4;
            stack.m_41774_(1);
            new PacketUpdateFieldTile(this, "maxAmount", this.maxAmount);
            return true;
        }
        return super.onActivated(player, hand, side, hitX);
    }

    @Override
    public CustomPacketBuffer writePacket() {
        CustomPacketBuffer packet = super.writePacket();
        try {
            EncoderHandler.encode(packet, this.guiProgress);
            EncoderHandler.encode(packet, this.energyShare);
            EncoderHandler.encode(packet, this.energySlots);
            EncoderHandler.encode(packet, this.queue);
            EncoderHandler.encode(packet, this.maxAmount);
            EncoderHandler.encode(packet, this.redstoneMode);
            EncoderHandler.encode(packet, this.energy, false);
            EncoderHandler.encode(packet, this.output_stack);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public void readPacket(CustomPacketBuffer customPacketBuffer) {
        super.readPacket(customPacketBuffer);
        try {
            this.guiProgress = (double[])DecoderHandler.decode(customPacketBuffer);
            this.energyShare = (double[])DecoderHandler.decode(customPacketBuffer);
            this.energySlots = (double[])DecoderHandler.decode(customPacketBuffer);
            this.queue = (Boolean)DecoderHandler.decode(customPacketBuffer);
            this.maxAmount = (Integer)DecoderHandler.decode(customPacketBuffer);
            this.redstoneMode = (Byte)DecoderHandler.decode(customPacketBuffer);
            this.energy.onNetworkUpdate(customPacketBuffer);
            this.output_stack = (ItemStack[])DecoderHandler.decode(customPacketBuffer);
            for (int i = 0; i < Objects.requireNonNull(this.output_stack).length; ++i) {
                if (!this.output_stack[i].m_41619_()) {
                    this.bakedModel[i] = Minecraft.m_91087_().m_91291_().m_174264_(this.output_stack[i], this.getWorld(), null, 0);
                    this.transformedModel[i] = ForgeHooksClient.handleCameraTransforms((PoseStack)new PoseStack(), (BakedModel)this.bakedModel[i], (ItemDisplayContext)ItemDisplayContext.GROUND, (boolean)false);
                    continue;
                }
                this.bakedModel[i] = null;
                this.transformedModel[i] = null;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean shouldRenderInPass(int pass) {
        return true;
    }

    public String getInventoryName() {
        return "Molecular Transformer";
    }

    @Override
    public void readFromNBT(CompoundTag nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.maxAmount = nbttagcompound.m_128451_("maxAmount");
        for (int i = 0; i < this.maxAmount; ++i) {
            this.energySlots[i] = nbttagcompound.m_128459_("energySlots" + i);
        }
        this.queue = nbttagcompound.m_128471_("queue");
        this.redstoneMode = nbttagcompound.m_128445_("redstoneMode");
    }

    @Override
    public CompoundTag writeToNBT(CompoundTag nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.m_128344_("redstoneMode", this.redstoneMode);
        nbttagcompound.m_128379_("queue", this.queue);
        nbttagcompound.m_128405_("maxAmount", this.maxAmount);
        for (int i = 0; i < this.maxAmount; ++i) {
            nbttagcompound.m_128347_("energySlots" + i, this.energySlots[i]);
        }
        return nbttagcompound;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ScreenIndustrialUpgrade<ContainerMenuBase<? extends CustomWorldContainer>> getGui(Player entityPlayer, ContainerMenuBase<? extends CustomWorldContainer> isAdmin) {
        return new ScreenMolecularTransformer((ContainerMenuBaseMolecular)isAdmin);
    }

    @Override
    public void updateTileServer(Player player, double event) {
        if (this.getWorld().f_46443_) {
            return;
        }
        if (event == 0.0) {
            this.redstoneMode = (byte)(this.redstoneMode + 1);
            if (this.redstoneMode >= 8) {
                this.redstoneMode = 0;
            }
            new PacketUpdateFieldTile(this, "redstoneMode", this.redstoneMode);
        }
        if (event == -1.0) {
            this.redstoneMode = (byte)(this.redstoneMode - 1);
            if (this.redstoneMode < 0) {
                this.redstoneMode = (byte)7;
            }
            new PacketUpdateFieldTile(this, "redstoneMode", this.redstoneMode);
        }
        if (event == 1.0) {
            boolean bl = this.queue = !this.queue;
            if (this.need) {
                this.queue = false;
            }
            this.setOverclockRates();
        }
    }

    @Override
    public void m_6596_() {
        super.m_6596_();
        if (!this.getWorld().f_46443_) {
            this.setOverclockRates();
        }
    }

    public void operate(int i, MachineRecipe output) {
        List<ItemStack> processResult = output.getRecipe().output.items;
        this.operateOnce(i, processResult);
    }

    public void operate(int i, MachineRecipe output, int size) {
        List<ItemStack> processResult = output.getRecipe().output.items;
        this.operateOnce(i, processResult, size);
    }

    public void operateOnce(int i, List<ItemStack> processResult) {
        this.inputSlot[i].consume();
        this.outputSlot[i].addAll(processResult);
        this.energySlots[i] = 0.0;
        if (!this.inputSlot[i].continue_process(this.output[i]) || !this.outputSlot[i].canAdd(this.output[i].getRecipe().output.items)) {
            this.getOutput(i);
        }
        this.setOverclockRates();
    }

    public void operateOnce(int index, List<ItemStack> processResult, int size) {
        for (int i = 0; i < size; ++i) {
            this.inputSlot[index].consume();
            this.outputSlot[index].addAll(processResult);
        }
        this.energySlots[index] = 0.0;
        if (!this.inputSlot[index].continue_process(this.output[index]) || !this.outputSlot[index].canAdd(this.output[index].getRecipe().output.items)) {
            this.getOutput(index);
        }
        this.setOverclockRates();
    }

    @Override
    public int getMode() {
        return this.redstoneMode;
    }

    @Override
    public ItemStack getItemStack() {
        return this.output_stack[0];
    }

    @Override
    public BlockEntityBase getEntityBlock() {
        return this;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public BakedModel getBakedModel() {
        if (this.tick % 120 == 0) {
            int i;
            this.tick = 1;
            boolean found = false;
            for (i = Math.min(this.indexModel + 1, this.maxAmount); i < this.maxAmount; ++i) {
                if (this.bakedModel[i] == null) continue;
                this.indexModel = i;
                found = true;
                break;
            }
            if (!found) {
                for (i = 0; i < this.maxAmount; ++i) {
                    if (this.bakedModel[i] == null) continue;
                    this.indexModel = i;
                    break;
                }
            }
        } else {
            ++this.tick;
        }
        return this.bakedModel[this.indexModel];
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.m_58904_().f_46443_) {
            for (int i = 0; i < this.maxAmount; ++i) {
                this.inputSlot[i].load();
            }
            this.setOverclockRates();
            new PacketUpdateFieldTile(this, "redstoneMode", this.redstoneMode);
        }
    }

    @Override
    public void updateField(String name, CustomPacketBuffer is) {
        if (name.equals("redstoneMode")) {
            try {
                this.redstoneMode = (Byte)DecoderHandler.decode(is);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (name.equals("maxAmount")) {
            try {
                this.maxAmount = (Integer)DecoderHandler.decode(is);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (name.equals("output")) {
            try {
                this.output_stack = (ItemStack[])DecoderHandler.decode(is);
                for (int i = 0; i < Objects.requireNonNull(this.output_stack).length; ++i) {
                    if (!this.output_stack[i].m_41619_()) {
                        this.bakedModel[i] = Minecraft.m_91087_().m_91291_().m_174264_(this.output_stack[i], this.getWorld(), null, 0);
                        this.transformedModel[i] = ForgeHooksClient.handleCameraTransforms((PoseStack)new PoseStack(), (BakedModel)this.bakedModel[i], (ItemDisplayContext)ItemDisplayContext.GROUND, (boolean)false);
                        continue;
                    }
                    this.bakedModel[i] = null;
                    this.transformedModel[i] = null;
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        super.updateField(name, is);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public BakedModel getTransformedModel() {
        return this.transformedModel[this.indexModel];
    }

    public void setOverclockRates() {
        double newStorage = 0.0;
        for (int i = 0; i < this.maxAmount; ++i) {
            MachineRecipe output;
            MachineRecipe machineRecipe = output = this.getRecipeOutput(i) == null ? this.getOutput(i) : this.getRecipeOutput(i);
            if (!this.queue) {
                if (this.inputSlot[i].m_7983_() || !this.inputSlot[i].continue_proccess(this.outputSlot[i])) {
                    this.maxEnergySlots[i] = 0.0;
                    this.setActive(true);
                    continue;
                }
                if (output != null) {
                    newStorage += output.getRecipe().output.metadata.m_128459_("energy");
                    this.maxEnergySlots[i] = output.getRecipe().output.metadata.m_128459_("energy");
                    this.energySlots[i] = Math.max(0.0, this.energySlots[i]);
                    this.energySlots[i] = Math.min(this.energySlots[i], this.maxEnergySlots[i]);
                    newStorage -= this.energySlots[i];
                    continue;
                }
                this.maxEnergySlots[i] = 0.0;
                this.energySlots[i] = 0.0;
                continue;
            }
            if (this.inputSlot[i].m_7983_() || !this.inputSlot[i].continue_proccess(this.outputSlot[i])) {
                this.maxEnergySlots[i] = 0.0;
                this.energySlots[i] = 0.0;
                continue;
            }
            if (output != null) {
                ItemStack output1 = this.output[i].getRecipe().output.items.get(0);
                int size = this.output[i].getRecipe().input.getInputs().get(0).getInputs().get(0).m_41613_();
                size = (int)Math.floor((float)this.inputSlot[i].get(0).m_41613_() / (float)size);
                int size1 = !this.outputSlot[i].m_7983_() ? (64 - this.outputSlot[i].get(0).m_41613_()) / output1.m_41613_() : 64 / output1.m_41613_();
                size = Math.min(size1, size);
                size = Math.min(size, output1.m_41741_());
                this.size_recipe[i] = size;
                newStorage += output.getRecipe().output.metadata.m_128459_("energy") * (double)size;
                this.maxEnergySlots[i] = output.getRecipe().output.metadata.m_128459_("energy") * (double)size;
                this.energySlots[i] = Math.max(0.0, this.energySlots[i]);
                this.energySlots[i] = Math.min(this.energySlots[i], this.maxEnergySlots[i]);
                newStorage -= this.energySlots[i];
                continue;
            }
            this.maxEnergySlots[i] = 0.0;
            this.energySlots[i] = 0.0;
        }
        this.energy.setCapacity(newStorage);
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        this.differenceenergy = this.energy.getEnergy() - this.perenergy;
        this.perenergy = this.energy.getEnergy();
        this.energy.useEnergy(this.perenergy);
        this.energy.setCapacity(this.energy.getCapacity() - this.perenergy);
        double prev = this.perenergy;
        this.distributeEnergy(prev);
        boolean active = false;
        for (int i = 0; i < this.maxAmount; ++i) {
            MachineRecipe output = this.getRecipeOutput(i);
            if (!this.queue) {
                this.guiProgress[i] = Math.ceil(this.energySlots[i]) / this.maxEnergySlots[i];
                if (output != null && this.outputSlot[i].canAdd(output.getRecipe().output.items) && this.guiProgress[i] >= 0.0) {
                    if (!this.getActive()) {
                        if (this.f_58857_.m_46467_() % 2L == 0L) {
                            this.initiate(0);
                        }
                        this.setActive(true);
                        this.setOverclockRates();
                    }
                    active = true;
                    this.guiProgress[i] = Math.ceil(this.energySlots[i]) / this.maxEnergySlots[i];
                    if (this.guiProgress[i] >= 1.0 && this.guiProgress[i] != Double.POSITIVE_INFINITY) {
                        this.operate(i, output);
                        this.guiProgress[i] = 0.0;
                        if (this.f_58857_.m_46467_() % 2L == 0L) {
                            this.initiate(2);
                        }
                    }
                } else {
                    if (this.energy.getEnergy() != 0.0 && this.getActive() && this.f_58857_.m_46467_() % 2L == 0L) {
                        this.initiate(1);
                    }
                    this.guiProgress[i] = 0.0;
                    this.setActive(false);
                }
            } else if (output != null && this.inputSlot[i].continue_proccess(this.outputSlot[i])) {
                active = true;
                ItemStack output1 = this.output[i].getRecipe().output.items.get(0);
                int size = this.output[i].getRecipe().input.getInputs().get(0).getInputs().get(0).m_41613_();
                size = (int)Math.floor((float)this.inputSlot[i].get(0).m_41613_() / (float)size);
                int size1 = !this.outputSlot[i].m_7983_() ? (64 - this.outputSlot[i].get(0).m_41613_()) / output1.m_41613_() : 64 / output1.m_41613_();
                size = Math.min(size1, size);
                if (this.size_recipe[i] != (double)(size = Math.min(size, output1.m_41741_()))) {
                    this.setOverclockRates();
                }
                this.guiProgress[i] = Math.ceil(this.energySlots[i]) / this.maxEnergySlots[i];
                if (this.guiProgress[i] >= 1.0) {
                    this.operate(i, output, size);
                    this.initiate(2);
                }
            } else {
                if (this.energy.getEnergy() != 0.0 && this.getActive()) {
                    this.initiate(1);
                }
                this.setActive(false);
            }
            if (!this.getActive() || output != null) continue;
            this.setActive(false);
        }
        if (!this.getActive() && active) {
            if (this.f_58857_.m_46467_() % 2L == 0L) {
                this.initiate(0);
            }
            this.setActive(true);
            this.setOverclockRates();
        }
        for (int ii = 0; ii < this.maxAmount; ++ii) {
            if (this.outputSlot[ii].m_7983_() || this.getWorld().m_46467_() % 10L != 0L) continue;
            ModUtils.tick(this.outputSlot[ii], this);
        }
    }

    private void distributeEnergy(double inputEnergy) {
        int size = this.maxAmount;
        double totalNeed = 0.0;
        for (int i = 0; i < 4; ++i) {
            this.energySlots[i] = Math.max(this.energySlots[i], 0.0);
        }
        int size1 = 0;
        for (int i = 0; i < size; ++i) {
            totalNeed += Math.max(0.0, this.maxEnergySlots[i] - this.energySlots[i]);
            if (!(this.maxEnergySlots[i] > 0.0)) continue;
            ++size1;
        }
        if (totalNeed <= 0.0) {
            return;
        }
        double minEnergyPerSlot = inputEnergy * 0.1 / (double)size1;
        if (inputEnergy >= totalNeed) {
            for (int i = 0; i < size; ++i) {
                this.energySlots[i] = this.maxEnergySlots[i];
            }
        } else {
            int i;
            for (i = 0; i < size; ++i) {
                double need = this.maxEnergySlots[i] - this.energySlots[i];
                if (!(need > 0.0)) continue;
                this.energyShare[i] = Math.max(Math.min(minEnergyPerSlot, need), inputEnergy * need / totalNeed);
                int n = i;
                this.energySlots[n] = this.energySlots[n] + this.energyShare[i];
                inputEnergy -= this.energyShare[i];
            }
            for (i = 0; i < size && inputEnergy > 0.0; ++i) {
                double remainingCapacity = this.maxEnergySlots[i] - this.energySlots[i];
                if (!(remainingCapacity > 0.0)) continue;
                double additionalEnergy = Math.min(inputEnergy, remainingCapacity);
                int n = i;
                this.energySlots[n] = this.energySlots[n] + additionalEnergy;
                int n2 = i;
                this.energyShare[n2] = this.energyShare[n2] + additionalEnergy;
                inputEnergy -= additionalEnergy;
            }
        }
    }

    public MachineRecipe getOutput(int i) {
        this.output[i] = this.inputSlot[i].process();
        this.output_stack[i] = this.output[i] != null ? this.output[i].getRecipe().output.items.get(0) : new ItemStack((ItemLike)Items.f_41852_);
        return this.output[i];
    }

    public double getProgress(int i) {
        return Math.min(this.guiProgress[i], 1.0);
    }

    public String getStartSoundFile() {
        return "Machines/molecular.ogg";
    }

    @Override
    public void onUpdate() {
        for (int i = 0; i < 4; ++i) {
            if (this.inputSlot[i].get(0).m_41720_() instanceof EnchantedBookItem) {
                this.need = true;
                return;
            }
            if (!(this.inputSlot[i].get(0).m_41720_() instanceof PotionItem)) continue;
            this.need = true;
            return;
        }
        this.need = false;
    }

    @Override
    public MachineRecipe getRecipeOutput() {
        return this.getRecipeOutput(0);
    }

    @Override
    public void setRecipeOutput(MachineRecipe output) {
        this.setRecipeOutput(0, output);
    }

    @Override
    public MachineRecipe getRecipeOutput(int i) {
        return this.output[i];
    }

    @Override
    public void setRecipeOutput(int i, MachineRecipe output) {
        this.output[i] = output;
        if (this.output[i] != null) {
            this.output_stack[i] = this.output[i].getRecipe().output.items.get(0);
        } else {
            this.output_stack[i] = new ItemStack((ItemLike)Items.f_41852_);
            this.energySlots[i] = 0.0;
            this.maxEnergySlots[i] = 0.0;
        }
        new PacketUpdateFieldTile(this, "output", this.output_stack);
        this.setOverclockRates();
    }

    @Override
    public SoundEvent getSound() {
        return EnumSound.molecular.getSoundEvent();
    }
}

