/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blockentity.base;

import com.denfop.IUItem;
import com.denfop.api.blockentity.MultiBlockEntity;
import com.denfop.api.container.CustomWorldContainer;
import com.denfop.api.recipe.IUpdateTick;
import com.denfop.api.recipe.InventoryOutput;
import com.denfop.api.recipe.InventoryRecipes;
import com.denfop.api.recipe.MachineRecipe;
import com.denfop.api.upgrades.IUpgradableBlock;
import com.denfop.api.upgrades.UpgradableProperty;
import com.denfop.api.widget.EnumTypeSlot;
import com.denfop.api.widget.IType;
import com.denfop.blockentity.base.BlockEntityElectricMachine;
import com.denfop.blockentity.base.BlockEntityInventory;
import com.denfop.componets.ComponentProcess;
import com.denfop.componets.ComponentProgress;
import com.denfop.componets.ComponentUpgrade;
import com.denfop.componets.ComponentUpgradeSlots;
import com.denfop.componets.EnumTypeStyle;
import com.denfop.componets.HeatComponent;
import com.denfop.componets.TypeUpgrade;
import com.denfop.containermenu.ContainerMenuBase;
import com.denfop.containermenu.ContainerMenuHandlerHeavyOre;
import com.denfop.inventory.Inventory;
import com.denfop.inventory.InventoryUpgrade;
import com.denfop.screen.ScreenHandlerHeavyOre;
import com.denfop.screen.ScreenIndustrialUpgrade;
import com.denfop.sound.EnumSound;
import com.denfop.utils.Keyboard;
import com.denfop.utils.Localization;
import com.denfop.utils.ParticleUtils;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class BlockEntityBaseHandlerHeavyOre
extends BlockEntityElectricMachine
implements IUpgradableBlock,
IUpdateTick,
IType {
    public final InventoryOutput outputSlot;
    public final InventoryUpgrade upgradeSlot;
    public final HeatComponent heat;
    public final ComponentUpgradeSlots componentUpgrade;
    public final ComponentProcess componentProcess;
    public final ComponentProgress componentProgress;
    private final EnumTypeStyle enumTypeSlot;
    private final double coef;
    private final Inventory input_slot;
    private final ComponentUpgrade componentUpgrades;
    public InventoryRecipes inputSlotA;
    public MachineRecipe output;
    private boolean auto;
    private int[] col;

    public BlockEntityBaseHandlerHeavyOre(EnumTypeStyle enumTypeSlot, MultiBlockEntity block, BlockPos pos, BlockState state) {
        super(300.0, 1, 1, block, pos, state);
        this.enumTypeSlot = enumTypeSlot;
        this.outputSlot = new InventoryOutput(this, 3 + 2 * Math.min(3, enumTypeSlot.ordinal()));
        this.upgradeSlot = new InventoryUpgrade(this, 4);
        this.inputSlotA = new InventoryRecipes((BlockEntityInventory)this, "handlerho", (IUpdateTick)this);
        this.heat = this.addComponent(HeatComponent.asBasicSink(this, 5000.0));
        this.col = new int[0];
        this.coef = this.getCoef();
        this.componentUpgrade = this.addComponent(new ComponentUpgradeSlots(this, this.upgradeSlot){

            @Override
            public void onLoaded() {
                super.onLoaded();
                this.componentProcess = ((BlockEntityBaseHandlerHeavyOre)this.getParent()).componentProcess;
            }
        });
        this.componentProgress = this.addComponent(new ComponentProgress((BlockEntityInventory)this, 1, (short)(300.0 / this.getSpeed())));
        this.componentProcess = this.addComponent(new ComponentProcess(this, (int)(300.0 / this.getSpeed()), 1.0){

            @Override
            public void operateWithMax(MachineRecipe output) {
                this.operate(output);
            }

            @Override
            public void operateWithMax(MachineRecipe output, int size) {
                if (output.getRecipe() == null) {
                    return;
                }
                for (int i = 0; i < size; ++i) {
                    this.operate(output);
                }
            }

            @Override
            public void operateOnce(List<ItemStack> processResult) {
                for (int i = 0; i < BlockEntityBaseHandlerHeavyOre.this.col.length; ++i) {
                    RandomSource rand = ((BlockEntityBaseHandlerHeavyOre)BlockEntityBaseHandlerHeavyOre.this).f_58857_.f_46441_;
                    if (100 - BlockEntityBaseHandlerHeavyOre.this.col[i] > rand.m_188503_(100)) continue;
                    this.outputSlot.add(processResult.get(i));
                }
                this.invSlotRecipes.consume();
            }
        });
        this.componentProcess.setHasAudio(true);
        this.componentProcess.setSlotOutput(this.outputSlot);
        this.componentProcess.setInvSlotRecipes(this.inputSlotA);
        this.input_slot = new Inventory(this, Inventory.TypeItemSlot.INPUT, 1){

            @Override
            public ItemStack set(int index, ItemStack content) {
                super.set(index, content);
                if (this.get(0).m_41619_()) {
                    ((BlockEntityBaseHandlerHeavyOre)this.base).inputSlotA.changeAccepts(ItemStack.f_41583_);
                } else {
                    ((BlockEntityBaseHandlerHeavyOre)this.base).inputSlotA.changeAccepts(this.get(0));
                }
                return content;
            }

            @Override
            public EnumTypeSlot getTypeSlot() {
                return EnumTypeSlot.RECIPE_SCHEDULE;
            }

            @Override
            public boolean m_7013_(int index, ItemStack stack) {
                return stack.m_41720_() == IUItem.recipe_schedule.getItem();
            }
        };
        this.componentUpgrades = this.addComponent(new ComponentUpgrade(this, TypeUpgrade.INSTANT, TypeUpgrade.STACK));
    }

    public static int applyModifier(int base, int extra, double multiplier) {
        double ret = Math.round((double)(base + extra) * multiplier);
        return ret > 2.147483647E9 ? Integer.MAX_VALUE : (int)ret;
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.getActive() && this.f_58857_.m_46467_() % 5L == 0L) {
            ParticleUtils.spawnMineralSeparatorParticles(this.f_58857_, this.pos, this.f_58857_.f_46441_);
        }
    }

    protected double getCoef() {
        switch (this.enumTypeSlot) {
            case ADVANCED: {
                return 1.1;
            }
            case PERFECT: {
                return 1.3;
            }
            case IMPROVED: {
                return 1.2;
            }
        }
        return 1.0;
    }

    @Override
    public EnumTypeStyle getStyle() {
        return this.enumTypeSlot;
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        if (!Keyboard.isKeyDown(340)) {
            tooltip.add(Localization.translate("press.lshift"));
        }
        if (Keyboard.isKeyDown(340)) {
            tooltip.add(Localization.translate("iu.heatmachine.info"));
            tooltip.add(Localization.translate("iu.machines_work_energy") + this.componentProcess.getEnergyConsume() + Localization.translate("iu.machines_work_energy_type_eu"));
            tooltip.add(Localization.translate("iu.machines_work_length") + this.componentProcess.getDefaultOperationLength());
        }
        super.addInformation(stack, tooltip);
    }

    @Override
    public Set<UpgradableProperty> getUpgradableProperties() {
        return EnumSet.of(UpgradableProperty.Processing, UpgradableProperty.Transformer, UpgradableProperty.EnergyStorage, UpgradableProperty.ItemExtract, UpgradableProperty.ItemInput);
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.getWorld().f_46443_) {
            this.inputSlotA.load();
            this.getOutput();
            if (this.input_slot.m_7983_()) {
                this.inputSlotA.changeAccepts(ItemStack.f_41583_);
            } else {
                this.inputSlotA.changeAccepts(this.input_slot.get(0));
            }
        }
    }

    @Override
    public void onUnloaded() {
        super.onUnloaded();
    }

    public ContainerMenuHandlerHeavyOre getGuiContainer(Player entityPlayer) {
        return new ContainerMenuHandlerHeavyOre(entityPlayer, this);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ScreenIndustrialUpgrade<ContainerMenuBase<? extends CustomWorldContainer>> getGui(Player entityPlayer, ContainerMenuBase<? extends CustomWorldContainer> isAdmin) {
        return new ScreenHandlerHeavyOre((ContainerMenuHandlerHeavyOre)isAdmin);
    }

    public MachineRecipe getOutput() {
        this.output = this.inputSlotA.process();
        return this.output;
    }

    @Override
    public SoundEvent getSound() {
        return EnumSound.handlerho.getSoundEvent();
    }

    @Override
    public void onUpdate() {
    }

    private double getSpeed() {
        switch (this.enumTypeSlot) {
            case ADVANCED: {
                return 1.3;
            }
            case IMPROVED: {
                return 1.5;
            }
            case PERFECT: {
                return 2.0;
            }
        }
        return 1.0;
    }

    @Override
    public MachineRecipe getRecipeOutput() {
        return this.output;
    }

    @Override
    public void setRecipeOutput(MachineRecipe output) {
        this.output = output;
        if (output == null) {
            this.col = new int[0];
        } else {
            this.col = new int[output.getRecipe().output.items.size()];
            for (int i = 0; i < this.col.length; ++i) {
                this.col[i] = (int)((double)output.getRecipe().output.metadata.m_128451_("input" + i) * this.coef);
                this.col[i] = Math.min(this.col[i], 95);
            }
        }
    }
}

