/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.widget;

import com.denfop.api.widget.ScreenWidget;
import com.denfop.componets.Fluids;
import com.denfop.screen.ScreenIndustrialUpgrade;
import com.denfop.utils.Localization;
import com.denfop.utils.ModUtils;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidStack;

public class TanksWidget
extends ScreenWidget {
    public static final int v = 100;
    private final List<Fluids.InternalFluidTank> tank;

    private TanksWidget(ScreenIndustrialUpgrade<?> gui, int x, int y, int width, int height, List<Fluids.InternalFluidTank> tank) {
        super(gui, x, y, width, height);
        if (tank == null) {
            throw new NullPointerException("null tank");
        }
        this.tank = tank;
    }

    public static TanksWidget createNormal(ScreenIndustrialUpgrade<?> gui, int x, int y, List<Fluids.InternalFluidTank> tank) {
        return new TanksWidget(gui, x, y, 20, 55, tank);
    }

    @Override
    public void drawBackground(GuiGraphics poseStack, int mouseX, int mouseY) {
        TanksWidget.bindCommonTexture();
        FluidStack fs = null;
        int amount = 0;
        int capacity = 0;
        for (Fluids.InternalFluidTank tank1 : this.tank) {
            if (fs == null && !tank1.getFluid().isEmpty()) {
                fs = tank1.getFluid();
            }
            amount += tank1.getFluidAmount();
            capacity += tank1.getCapacity();
        }
        if (fs != null && !fs.isEmpty() && fs.getAmount() > 0) {
            this.gui.drawTexturedModalRect(poseStack, mouseX + this.x, mouseY + this.y, 70, 100, this.f_93618_, this.f_93619_);
            int fluidX = this.x;
            int fluidY = this.y;
            int fluidWidth = this.f_93618_;
            int fluidHeight = this.f_93619_;
            fluidX += 4;
            fluidY += 4;
            fluidWidth = 12;
            fluidHeight = 48;
            Fluid fluid = fs.getFluid();
            IClientFluidTypeExtensions extensions = IClientFluidTypeExtensions.of((Fluid)fluid);
            TextureAtlasSprite sprite = TanksWidget.getBlockTextureMap().m_118316_(extensions.getStillTexture(fs));
            int color = extensions.getTintColor();
            double renderHeight = (double)fluidHeight * ModUtils.limit((double)amount / (double)capacity, 0.0, 1.0);
            TanksWidget.bindBlockTexture();
            this.gui.drawSprite(poseStack, mouseX + fluidX, (double)mouseY + (double)(fluidY + fluidHeight) - renderHeight, fluidWidth, renderHeight, sprite, color, 1.0, false, true);
            TanksWidget.bindCommonTexture();
            int gaugeX = this.x;
            int gaugeY = this.y;
            this.gui.drawTexturedModalRect(poseStack, mouseX + gaugeX, mouseY + gaugeY, 38, 100, 20, 55);
        } else {
            this.gui.drawTexturedModalRect(poseStack, mouseX + this.x, mouseY + this.y, 70, 100, this.f_93618_, this.f_93619_);
        }
    }

    @Override
    protected List<String> getToolTip() {
        List<String> ret = super.getToolTip();
        FluidStack fs = null;
        int amount = 0;
        for (Fluids.InternalFluidTank tank1 : this.tank) {
            if (fs == null && !tank1.getFluid().isEmpty()) {
                fs = tank1.getFluid();
            }
            amount += tank1.getFluidAmount();
        }
        if (fs != null && amount > 0) {
            Fluid fluid = fs.getFluid();
            if (fluid != null) {
                ret.add(Localization.translate(fs.getFluid().getFluidType().getDescriptionId()) + ": " + amount + " " + Localization.translate("iu.generic.text.mb"));
            } else {
                ret.add("invalid fluid stack");
            }
        } else {
            ret.add(Localization.translate("iu.generic.text.empty"));
        }
        return ret;
    }
}

