/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.vein.gas;

import com.denfop.api.vein.gas.GasVein;
import com.denfop.api.vein.gas.TypeGas;
import com.denfop.network.packet.CustomPacketBuffer;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.ChunkPos;

public class GasVeinBase
implements GasVein {
    private final ChunkPos chunk;
    boolean find;
    private TypeGas type;
    private int col;
    private int maxcol;

    public GasVeinBase(TypeGas type, ChunkPos chunk) {
        this.type = type;
        this.chunk = chunk;
        this.col = 0;
        this.maxcol = 0;
    }

    public GasVeinBase(CompoundTag tagCompound) {
        this.type = TypeGas.values()[tagCompound.m_128445_("type")];
        this.chunk = new ChunkPos((int)tagCompound.m_128448_("x"), (int)tagCompound.m_128448_("z"));
        this.col = tagCompound.m_128451_("col");
        this.maxcol = tagCompound.m_128451_("maxcol");
        this.find = tagCompound.m_128471_("find");
        if (!this.find && this.col != this.maxcol) {
            this.find = true;
        }
    }

    public GasVeinBase(CustomPacketBuffer is) {
        this.find = is.readBoolean();
        this.chunk = new ChunkPos((int)is.readShort(), (int)is.readShort());
        this.type = TypeGas.values()[is.readByte()];
        this.col = is.readInt();
        this.maxcol = is.readInt();
        if (!this.find && this.col != this.maxcol) {
            this.find = true;
        }
    }

    @Override
    public CustomPacketBuffer writePacket() {
        CustomPacketBuffer customPacketBuffer = new CustomPacketBuffer(32);
        customPacketBuffer.writeBoolean(this.find);
        customPacketBuffer.writeShort(this.chunk.f_45578_);
        customPacketBuffer.writeShort(this.chunk.f_45579_);
        customPacketBuffer.writeByte(this.type.ordinal());
        customPacketBuffer.writeInt(this.col);
        customPacketBuffer.writeInt(this.maxcol);
        return customPacketBuffer;
    }

    @Override
    public TypeGas getType() {
        return this.type;
    }

    @Override
    public void setType(TypeGas type) {
        this.type = type;
    }

    @Override
    public ChunkPos getChunk() {
        return this.chunk;
    }

    @Override
    public int getCol() {
        return this.col;
    }

    @Override
    public void setCol(int col) {
        this.col = col;
    }

    @Override
    public int getMaxCol() {
        return this.maxcol;
    }

    @Override
    public void setMaxCol(int maxcol) {
        this.maxcol = maxcol;
    }

    @Override
    public void removeCol(int col) {
        assert (this.col - col >= 0);
        this.col -= col;
    }

    @Override
    public boolean isFind() {
        return this.find;
    }

    @Override
    public void setFind(boolean find) {
        this.find = find;
    }

    @Override
    public CompoundTag writeTag() {
        CompoundTag tagCompound = new CompoundTag();
        tagCompound.m_128379_("find", this.find);
        tagCompound.m_128376_("x", (short)this.chunk.f_45578_);
        tagCompound.m_128376_("z", (short)this.chunk.f_45579_);
        tagCompound.m_128344_("type", (byte)this.type.ordinal());
        tagCompound.m_128405_("col", this.col);
        tagCompound.m_128405_("maxcol", this.maxcol);
        return tagCompound;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GasVeinBase vein = (GasVeinBase)o;
        return vein.chunk.equals((Object)this.chunk);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.chunk, this.find, this.type, this.col, this.maxcol});
    }
}

