/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.vein.common;

import com.denfop.api.vein.common.Type;
import com.denfop.api.vein.common.VeinBase;
import com.denfop.api.vein.common.VeinBaseSystem;
import com.denfop.config.ModConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.Tags;

public class VeinSystem
implements VeinBaseSystem {
    public static VeinBaseSystem system;
    public static VeinBase EMPTY;
    private final Random rand;
    List<VeinBase> list;
    List<ChunkPos> chunkPos;
    Map<ChunkPos, VeinBase> chunkPosVeinMap;

    public VeinSystem() {
        system = this;
        this.list = new ArrayList<VeinBase>();
        this.chunkPos = new ArrayList<ChunkPos>();
        this.chunkPosVeinMap = new HashMap<ChunkPos, VeinBase>();
        this.rand = new Random();
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public VeinBase getEMPTY() {
        return EMPTY;
    }

    @Override
    public List<ChunkPos> getChunkPos() {
        return this.chunkPos;
    }

    @Override
    public List<VeinBase> getVeinsList() {
        return this.list;
    }

    @Override
    public void addVein(LevelChunk chunk) {
        int col;
        int chance = this.rand.nextInt(100);
        VeinBase vein = new VeinBase(Type.EMPTY, 0, chunk.m_7697_());
        Holder holder = chunk.m_62953_().m_204166_(new BlockPos(chunk.m_7697_().f_45578_ * 16, 0, chunk.m_7697_().f_45579_ * 16));
        int n = col = holder.containsTag(BiomeTags.f_207608_) ? 25 : 0;
        if (chance >= 15 + col) {
            int n2 = col = holder.containsTag(BiomeTags.f_207609_) || holder.containsTag(Tags.Biomes.IS_SNOWY) ? 15 : 0;
            if (this.rand.nextInt(100) < 85 - col) {
                this.getnumber(vein, (Holder<Biome>)holder);
            } else {
                vein.setType(Type.GAS);
                vein.setOldMineral(false);
                vein.setMeta(0);
                vein.setMaxCol(600000);
                vein.setCol(600000);
            }
        } else {
            int meta = this.rand.nextInt(30);
            vein.setType(Type.VEIN);
            vein.setOldMineral(meta <= 15);
            vein.setMeta(meta % 16);
            vein.setMaxCol((Integer)ModConfig.COMMON.maxVein.get());
            vein.setCol((Integer)ModConfig.COMMON.maxVein.get());
        }
        this.list.add(vein);
        this.chunkPos.add(vein.getChunk());
        this.chunkPosVeinMap.put(vein.getChunk(), vein);
    }

    @Override
    public void addVein(CompoundTag tag) {
        VeinBase vein = new VeinBase(tag);
        if (!this.list.contains(vein)) {
            this.list.add(vein);
            this.chunkPos.add(vein.getChunk());
            this.chunkPosVeinMap.put(vein.getChunk(), vein);
        }
    }

    @Override
    public VeinBase getVein(ChunkPos pos) {
        return this.chunkPosVeinMap.getOrDefault(pos, EMPTY);
    }

    @Override
    public void unload() {
        this.list.clear();
        this.chunkPos.clear();
        this.chunkPosVeinMap.clear();
    }

    private void applyOilVein(VeinBase vein, int chance, int min, int max, int meta) {
        int roll = this.rand.nextInt(100);
        if (roll < chance) {
            int number = this.rand.nextInt(max) + min;
            vein.setCol(number);
            vein.setMaxCol(number);
            vein.setType(Type.OIL);
            vein.setOldMineral(true);
            vein.setMeta(meta);
        } else {
            vein.setType(Type.EMPTY);
            vein.setCol(0);
            vein.setMaxCol(0);
        }
    }

    private void getnumber(VeinBase vein, Holder<Biome> biome) {
        int meta = this.rand.nextInt(6);
        if (biome.m_203656_(Tags.Biomes.IS_DESERT)) {
            this.applyOilVein(vein, (Integer)ModConfig.COMMON.desertChance.get(), (Integer)ModConfig.COMMON.desertMin.get(), (Integer)ModConfig.COMMON.desertMax.get(), meta);
        } else if (biome.m_203656_(BiomeTags.f_207603_)) {
            this.applyOilVein(vein, (Integer)ModConfig.COMMON.oceanChance.get(), (Integer)ModConfig.COMMON.oceanMin.get(), (Integer)ModConfig.COMMON.oceanMax.get(), meta);
        } else if (biome.m_203656_(BiomeTags.f_207602_)) {
            this.applyOilVein(vein, (Integer)ModConfig.COMMON.deepOceanChance.get(), (Integer)ModConfig.COMMON.deepOceanMin.get(), (Integer)ModConfig.COMMON.deepOceanMax.get(), meta);
        } else if (biome.m_203656_(BiomeTags.f_207605_)) {
            this.applyOilVein(vein, (Integer)ModConfig.COMMON.riverChance.get(), (Integer)ModConfig.COMMON.riverMin.get(), (Integer)ModConfig.COMMON.riverMax.get(), meta);
        } else if (biome.m_203656_(BiomeTags.f_215816_)) {
            this.applyOilVein(vein, (Integer)ModConfig.COMMON.savannaChance.get(), (Integer)ModConfig.COMMON.savannaMin.get(), (Integer)ModConfig.COMMON.savannaMax.get(), meta);
        } else {
            this.applyOilVein(vein, (Integer)ModConfig.COMMON.defaultChance.get(), (Integer)ModConfig.COMMON.defaultMin.get(), (Integer)ModConfig.COMMON.defaultMax.get(), meta);
        }
    }

    static {
        EMPTY = new VeinBase(Type.EMPTY, 0, new ChunkPos(999999999, 999999999));
    }
}

