/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.storage.autocrafting;

import com.denfop.api.storage.PatternItem;
import com.denfop.api.storage.autocrafting.SameStack;
import com.denfop.api.storage.autocrafting.TypeRecipe;
import com.denfop.utils.ModUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public record PatternStack(List<SameStack> inputs, SameStack output, TypeRecipe typeRecipe, ResourceLocation location) {
    public CompoundTag writeToNBT() {
        CompoundTag nbt = new CompoundTag();
        ListTag inputsList = new ListTag();
        for (SameStack s : this.inputs) {
            inputsList.add((Object)s.writeToNBT());
        }
        nbt.m_128365_("Inputs", (Tag)inputsList);
        nbt.m_128365_("Output", (Tag)this.output.writeToNBT());
        nbt.m_128359_("location", this.location.toString());
        nbt.m_128359_("TypeRecipe", this.typeRecipe.name());
        return nbt;
    }

    public boolean matches(List<SameStack> remaining) {
        if (remaining.size() != this.inputs.size()) {
            return false;
        }
        for (SameStack required : this.inputs) {
            boolean matched = false;
            for (SameStack provided : remaining) {
                if (!required.equals(provided)) continue;
                matched = true;
                remaining.remove(provided);
                break;
            }
            if (matched) continue;
            return false;
        }
        return true;
    }

    public ItemStack writePattern(ItemStack stack) {
        if (!(stack.m_41720_() instanceof PatternItem)) {
            return stack;
        }
        ModUtils.nbt(stack).m_128365_("pattern", (Tag)this.writeToNBT());
        return stack;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PatternStack that = (PatternStack)o;
        return Objects.equals(this.output, that.output) && this.typeRecipe == that.typeRecipe;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.output, this.typeRecipe});
    }

    public static PatternStack readFromNBT(CompoundTag nbt) {
        ArrayList<SameStack> inputs = new ArrayList<SameStack>();
        if (!nbt.m_128441_("Inputs")) {
            return null;
        }
        ListTag inputsList = nbt.m_128437_("Inputs", 10);
        for (int i = 0; i < inputsList.size(); ++i) {
            CompoundTag inputNBT = inputsList.m_128728_(i);
            inputs.add(SameStack.readFromNBT(inputNBT));
        }
        ResourceLocation resourceLocation = ResourceLocation.m_135820_((String)nbt.m_128461_("location"));
        SameStack output = SameStack.readFromNBT(nbt.m_128469_("Output"));
        TypeRecipe typeRecipe = TypeRecipe.valueOf(nbt.m_128461_("TypeRecipe"));
        return new PatternStack(inputs, output, typeRecipe, resourceLocation);
    }
}

