/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.storage;

import com.denfop.api.otherenergies.common.ISink;
import com.denfop.api.otherenergies.common.Path;
import com.denfop.api.storage.ElectricStorage;
import com.denfop.api.storage.EnumTypeSlots;
import com.denfop.api.storage.Export;
import com.denfop.api.storage.IMonitor;
import com.denfop.api.storage.Import;
import com.denfop.api.storage.Interface;
import com.denfop.api.storage.StorageDeviceCell;
import com.denfop.api.storage.StorageStack;
import com.denfop.api.storage.TypeStack;
import com.denfop.api.storage.autocrafting.AutoCraftOutput;
import com.denfop.api.storage.autocrafting.AutoCraftStack;
import com.denfop.api.storage.autocrafting.AutoCraftSystem;
import com.denfop.api.storage.autocrafting.AutoCraftSystemVisual;
import com.denfop.api.storage.autocrafting.PatternStack;
import com.denfop.api.storage.autocrafting.Processor;
import com.denfop.api.storage.autocrafting.SameStack;
import com.denfop.api.storage.autocrafting.TypeRecipe;
import com.denfop.api.storage.cell.ICell;
import com.denfop.componets.Energy;
import com.denfop.network.packet.PacketUpdateStorageCell;
import com.denfop.utils.ModUtils;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;

public class StorageNetwork {
    public List<StorageDeviceCell> storageDeviceCells = new LinkedList<StorageDeviceCell>();
    public Map<PatternStack, Interface> patternStackInterfaceMap = new HashMap<PatternStack, Interface>();
    List<Processor> processors = new LinkedList<Processor>();
    List<Export> exports = new LinkedList<Export>();
    List<Import> imports = new LinkedList<Import>();
    List<Interface> interfaces = new LinkedList<Interface>();
    double consumeEnergy = 0.0;
    private List<SameStack> stacks;
    private List<SameStack> fluids;
    private List<SameStack> stacksCanCreate;
    private List<SameStack> fluidsCanCreate;

    public void addElement(ElectricStorage electricStorage) {
        if (electricStorage instanceof Export) {
            Export export = (Export)electricStorage;
            this.addExport(export);
        }
        if (electricStorage instanceof Import) {
            Import imp = (Import)electricStorage;
            this.addImport(imp);
        }
        if (electricStorage instanceof Interface) {
            Interface intf = (Interface)electricStorage;
            this.addInterface(intf);
        }
        if (electricStorage instanceof Processor) {
            Processor processor = (Processor)electricStorage;
            this.addProccessor(processor);
        }
        if (electricStorage instanceof StorageDeviceCell) {
            StorageDeviceCell storageDeviceCell = (StorageDeviceCell)electricStorage;
            this.addStorageDevice(storageDeviceCell);
        }
        if (electricStorage instanceof IMonitor) {
            IMonitor monitor = (IMonitor)electricStorage;
            monitor.setStorageNetwork(this);
        }
        this.consumeEnergy += electricStorage.getRequiredPower();
    }

    public Tuple<List<SameStack>, List<SameStack>> getAllStoredItemStacks() {
        HashMap<String, Map> combined = new HashMap<String, Map>();
        for (ICell iCell : this.getAllItemCells()) {
            Map<String, List<StorageStack>> entries = iCell.getStorageStack();
            ItemStack[] stacks = iCell.getStacks();
            for (Map.Entry<String, List<StorageStack>> entry : entries.entrySet()) {
                Map map = combined.computeIfAbsent(entry.getKey(), k -> new HashMap());
                for (StorageStack storageStack : entry.getValue()) {
                    SameStack sameStack = (SameStack)map.get(storageStack);
                    if (sameStack == null) {
                        sameStack = new SameStack();
                        sameStack.setStack(stacks[storageStack.getSlot()].m_41777_());
                        map.put(storageStack, sameStack);
                        continue;
                    }
                    sameStack.getStack().m_41769_(storageStack.getCount());
                }
            }
        }
        ArrayList result = new ArrayList(combined.size() * 2);
        for (Map map : combined.values()) {
            result.addAll(map.values());
        }
        result.sort((a, b) -> Integer.compare(b.getStack().m_41613_(), a.getStack().m_41613_()));
        LinkedList<SameStack> linkedList = new LinkedList<SameStack>();
        block4: for (PatternStack patternStack : this.getAllPatterns()) {
            if (!patternStack.output().isItem()) continue;
            for (SameStack stack : result) {
                if (!stack.isCorrect(patternStack.output().getStack())) continue;
                continue block4;
            }
            linkedList.add(patternStack.output());
        }
        return new Tuple(result, linkedList);
    }

    public Tuple<List<SameStack>, List<SameStack>> getAllStoredFluidStacks() {
        HashMap<String, Map> combined = new HashMap<String, Map>();
        for (ICell iCell : this.getAllFluidCells()) {
            Map<String, List<StorageStack>> entries = iCell.getStorageStack();
            FluidStack[] stacks = iCell.getFluids();
            for (Map.Entry<String, List<StorageStack>> entry : entries.entrySet()) {
                Map map = combined.computeIfAbsent(entry.getKey(), k -> new HashMap());
                for (StorageStack storageStack : entry.getValue()) {
                    SameStack sameStack = (SameStack)map.get(storageStack);
                    if (sameStack == null) {
                        sameStack = new SameStack();
                        sameStack.setFluidStack(stacks[storageStack.getSlot()].copy());
                        map.put(storageStack, sameStack);
                        continue;
                    }
                    sameStack.getFluidStack().grow(storageStack.getCount());
                }
            }
        }
        ArrayList result = new ArrayList(combined.size() * 2);
        for (Map map : combined.values()) {
            result.addAll(map.values());
        }
        result.sort((a, b) -> Integer.compare(b.getFluidStack().getAmount(), a.getFluidStack().getAmount()));
        LinkedList<SameStack> linkedList = new LinkedList<SameStack>();
        block4: for (PatternStack patternStack : this.getAllPatterns()) {
            if (!patternStack.output().isFluid()) continue;
            for (SameStack stack : result) {
                if (!stack.isCorrect(patternStack.output().getFluidStack())) continue;
                continue block4;
            }
            linkedList.add(patternStack.output());
        }
        List list = linkedList.stream().filter(element -> !result.contains(element)).collect(Collectors.toList());
        return new Tuple(result, list);
    }

    private void addProccessor(Processor processor) {
        this.processors.add(processor);
    }

    private void addStorageDevice(StorageDeviceCell processor) {
        this.storageDeviceCells.add(processor);
    }

    private void removeStorageDevice(StorageDeviceCell processor) {
        this.storageDeviceCells.remove(processor);
    }

    public void removeElement(ElectricStorage electricStorage) {
        if (electricStorage instanceof Export) {
            Export export = (Export)electricStorage;
            this.removeExport(export);
        }
        if (electricStorage instanceof Import) {
            Import imp = (Import)electricStorage;
            this.removeImport(imp);
        }
        if (electricStorage instanceof Interface) {
            Interface intf = (Interface)electricStorage;
            this.removeInterface(intf);
        }
        if (electricStorage instanceof Processor) {
            Processor processor = (Processor)electricStorage;
            this.removeProccessor(processor);
        }
        if (electricStorage instanceof StorageDeviceCell) {
            StorageDeviceCell storageDeviceCell = (StorageDeviceCell)electricStorage;
            this.removeStorageDevice(storageDeviceCell);
        }
        this.consumeEnergy -= electricStorage.getRequiredPower();
        if (this.consumeEnergy < 0.0) {
            this.consumeEnergy = 0.0;
        }
    }

    private void removeProccessor(Processor processor) {
        this.processors.add(processor);
    }

    public void addExport(Export export) {
        this.exports.add(export);
    }

    public void addImport(Import imp) {
        this.imports.add(imp);
    }

    public void addInterface(Interface intf) {
        this.interfaces.add(intf);
        for (PatternStack patternStack : intf.getPatterns()) {
            this.patternStackInterfaceMap.put(patternStack, intf);
        }
        intf.setStorageNetwork(this);
    }

    public void removeExport(Export export) {
        this.exports.remove(export);
    }

    public void removeImport(Import imp) {
        this.imports.remove(imp);
    }

    public void removeInterface(Interface intf) {
        this.interfaces.remove(intf);
        intf.setStorageNetwork(null);
        this.patternStackInterfaceMap.entrySet().removeIf(entry -> ((Interface)entry.getValue()).equals(intf));
    }

    public boolean hasAvailableProcessors() {
        for (Processor processor : this.processors) {
            if (!processor.canAddAutoCraft()) continue;
            return true;
        }
        return false;
    }

    public void addAutoCraft(AutoCraftSystem system) {
        for (Processor processor : this.processors) {
            if (!processor.canAddAutoCraft()) continue;
            processor.addAutoCraft(system);
            break;
        }
    }

    public AutoCraftSystemVisual createAutoCraftVisual(SameStack stack) {
        AutoCraftSystemVisual autoCraftSystemVisual = new AutoCraftSystemVisual(stack);
        autoCraftSystemVisual.create(this.getAllPatterns(), this.getAllItemCells(), this.getAllFluidCells());
        return autoCraftSystemVisual;
    }

    public List<PatternStack> getAllPatterns() {
        LinkedList<PatternStack> result = new LinkedList<PatternStack>();
        for (Interface intf : this.interfaces) {
            result.addAll(intf.getPatterns());
        }
        return new ArrayList<PatternStack>(result);
    }

    public List<ICell> getAllItemCells() {
        LinkedList<ICell> result = new LinkedList<ICell>();
        for (StorageDeviceCell device : this.storageDeviceCells) {
            result.addAll(device.getItemCells());
        }
        return new ArrayList<ICell>(result);
    }

    public List<ICell> getAll() {
        LinkedList<ICell> result = new LinkedList<ICell>();
        for (StorageDeviceCell device : this.storageDeviceCells) {
            result.addAll(device.getItemCells());
            result.addAll(device.getFluidCells());
        }
        return new ArrayList<ICell>(result);
    }

    public List<ICell> getAllFluidCells() {
        ArrayList<ICell> result = new ArrayList<ICell>();
        for (StorageDeviceCell device : this.storageDeviceCells) {
            result.addAll(device.getFluidCells());
        }
        return result;
    }

    public AutoCraftSystem createAutoCraft(AutoCraftSystemVisual autoCraftSystemVisual) {
        return new AutoCraftSystem(autoCraftSystemVisual.getAutoCraftOutput(), autoCraftSystemVisual.getPatternStackList());
    }

    public PatternStack findPatternFor(ItemStack stack) {
        for (Interface intf : this.interfaces) {
            for (PatternStack ps : intf.getPatterns()) {
                if (!ps.output().isItem() || !ps.output().getStack().m_150930_(stack.m_41720_()) || !NbtUtils.m_129235_((Tag)ps.output().getStack().m_41783_(), (Tag)stack.m_41783_(), (boolean)true)) continue;
                return ps;
            }
        }
        return null;
    }

    public PatternStack findPatternFor(FluidStack stack) {
        for (Interface intf : this.interfaces) {
            for (PatternStack ps : intf.getPatterns()) {
                if (!ps.output().isFluid() || !ps.output().getFluidStack().isFluidEqual(stack)) continue;
                return ps;
            }
        }
        return null;
    }

    /*
     * Could not resolve type clashes
     */
    public void tick(Level level, Energy energy, BlockPos pos) {
        if (!energy.useEnergy(this.consumeEnergy)) {
            return;
        }
        block0: for (Iterator<Export> processor : this.processors) {
            Iterator<AutoCraftSystem> it = processor.getAutoCrafts().iterator();
            while (it.hasNext()) {
                HashMap<Object, Integer> tempStorageStackMap;
                int filledSim;
                int insertedTotal;
                int remaining;
                int maxNeeded;
                int perRecipe;
                int slot;
                int insertedTotal2;
                int remaining2;
                int maxNeeded2;
                SameStack sameStack;
                int possibleOperations;
                boolean canInsertAll;
                HashSet<Integer> usedTanks;
                HashSet<Integer> usedSlots;
                HashMap<Integer, Tuple> cachedTanks;
                HashMap<Integer, Tuple> cachedSlots;
                IFluidHandler fluid_handler;
                IItemHandler handler;
                int amount;
                AutoCraftSystem autoCraftSystem = it.next();
                Iterator<AutoCraftStack> it1 = autoCraftSystem.getPatternStacks().iterator();
                block2: while (it1.hasNext()) {
                    Interface intf;
                    AutoCraftStack autoCraftStack = it1.next();
                    PatternStack patternStack = autoCraftStack.getPatternStack();
                    HashMap<Object, Integer> tempStorageStackMap2 = new HashMap<Object, Integer>();
                    if (autoCraftStack.getPatternStack().typeRecipe() == TypeRecipe.WORKBENCH) {
                        for (Object stack : patternStack.inputs()) {
                            List<StorageStack> tuple = this.findStackForWorkBench((SameStack)stack);
                            if (tuple.isEmpty()) continue block2;
                            amount = 0;
                            for (StorageStack storageStack : tuple) {
                                if (!ModUtils.checkNbtEquality(((SameStack)stack).getStack().m_41783_(), storageStack.getTag())) continue;
                                amount += storageStack.getCount();
                            }
                            if (!((SameStack)stack).getStack().m_41619_() && ((SameStack)stack).getStack().m_41613_() > amount || !((SameStack)stack).getFluidStack().isEmpty() && ((SameStack)stack).getFluidStack().getAmount() > amount) continue block2;
                            tempStorageStackMap2.put(stack, amount);
                        }
                        if (tempStorageStackMap2.keySet().size() == patternStack.inputs().size()) {
                            int craftableByInputs;
                            Object stack;
                            int minAmount1 = Integer.MAX_VALUE;
                            stack = tempStorageStackMap2.entrySet().iterator();
                            while (stack.hasNext()) {
                                Map.Entry storageStackList = (Map.Entry)stack.next();
                                minAmount1 = Math.min(minAmount1, (Integer)storageStackList.getValue() / ((SameStack)storageStackList.getKey()).getAmount());
                            }
                            int craftableByOutput = this.getDifferenceStorage() / autoCraftStack.getPatternStack().output().getAmount();
                            craftableByOutput = Math.min(craftableByOutput, (autoCraftStack.getAll() - autoCraftStack.getCreate()) / autoCraftStack.getPatternStack().output().getAmount());
                            craftableByOutput = Math.min(autoCraftStack.getAmount(), craftableByOutput);
                            int minAmount = Math.min(craftableByOutput, craftableByInputs = minAmount1);
                            if (minAmount > 0 && minAmount1 > 0) {
                                for (Map.Entry storageStackList : tempStorageStackMap2.entrySet()) {
                                    ItemStack deleteItem = ((SameStack)storageStackList.getKey()).getStack().m_41777_();
                                    deleteItem.m_41764_(minAmount * ((SameStack)storageStackList.getKey()).getAmount());
                                    this.removeStackWithIgnoring(deleteItem);
                                }
                                ItemStack addItem = autoCraftStack.getPatternStack().output().getStack().m_41777_();
                                addItem.m_41764_(autoCraftStack.getPatternStack().output().getAmount() * minAmount);
                                this.addStack(addItem);
                                autoCraftStack.removeAmount(minAmount);
                                if (autoCraftStack.getAmount() == 0) {
                                    it1.remove();
                                }
                            }
                        }
                    }
                    if (autoCraftStack.getPatternStack().typeRecipe() != TypeRecipe.BLOCK) continue;
                    for (SameStack stack : patternStack.inputs()) {
                        List<StorageStack> tuple = this.findStack(stack);
                        if (tuple.isEmpty()) continue block2;
                        amount = 0;
                        for (StorageStack storageStack : tuple) {
                            if (stack.getStack().m_41619_()) continue;
                            if (NbtUtils.m_129235_((Tag)stack.getStack().m_41783_(), (Tag)storageStack.getTag(), (boolean)true)) {
                                amount += storageStack.getCount();
                                continue;
                            }
                            if (!NbtUtils.m_129235_((Tag)stack.getFluidStack().getTag(), (Tag)storageStack.getTag(), (boolean)true)) continue;
                            amount += storageStack.getCount();
                        }
                        if (!stack.getStack().m_41619_() && stack.getStack().m_41613_() > amount || !stack.getFluidStack().isEmpty() && stack.getFluidStack().getAmount() > amount) continue block2;
                        tempStorageStackMap2.put(stack, amount);
                    }
                    if (tempStorageStackMap2.keySet().size() != patternStack.inputs().size() || (intf = this.patternStackInterfaceMap.get(autoCraftStack.getPatternStack())) == null || intf.getBlockEntityNeighbor() == null) continue;
                    int minAmount1 = Integer.MAX_VALUE;
                    for (Map.Entry storageStackList : tempStorageStackMap2.entrySet()) {
                        minAmount1 = Math.min(minAmount1, (Integer)storageStackList.getValue() / ((SameStack)storageStackList.getKey()).getAmount());
                    }
                    int craftableByOutput = this.getDifferenceStorage() / autoCraftStack.getPatternStack().output().getAmount();
                    craftableByOutput = Math.min(craftableByOutput, (autoCraftStack.getAll() - autoCraftStack.getCreate()) / autoCraftStack.getPatternStack().output().getAmount());
                    craftableByOutput = Math.min(autoCraftStack.getAmount(), craftableByOutput);
                    int craftableByInputs = minAmount1;
                    int minAmount = Math.min(craftableByOutput, craftableByInputs);
                    handler = (IItemHandler)intf.getBlockEntityNeighbor().getCapability(ForgeCapabilities.ITEM_HANDLER, intf.getDirection()).orElse(null);
                    fluid_handler = (IFluidHandler)intf.getBlockEntityNeighbor().getCapability(ForgeCapabilities.FLUID_HANDLER, intf.getDirection()).orElse(null);
                    if (minAmount <= 0 || minAmount1 <= 0 || handler == null) continue;
                    cachedSlots = new HashMap<Integer, Tuple>();
                    cachedTanks = new HashMap<Integer, Tuple>();
                    usedSlots = new HashSet<Integer>();
                    usedTanks = new HashSet<Integer>();
                    canInsertAll = true;
                    possibleOperations = Integer.MAX_VALUE;
                    for (Map.Entry storageStackList : tempStorageStackMap2.entrySet()) {
                        sameStack = (SameStack)storageStackList.getKey();
                        if (!sameStack.getStack().m_41619_()) {
                            if (handler == null) {
                                canInsertAll = false;
                                break;
                            }
                            int perRecipe2 = sameStack.getStack().m_41613_();
                            remaining2 = maxNeeded2 = perRecipe2 * minAmount;
                            insertedTotal2 = 0;
                            for (slot = 0; slot < handler.getSlots() && remaining2 > 0; ++slot) {
                                if (usedSlots.contains(slot)) continue;
                                ItemStack tryStack = sameStack.getStack().m_41777_();
                                tryStack.m_41764_(Math.min(remaining2, tryStack.m_41741_()));
                                ItemStack leftoverSim = handler.insertItem(slot, tryStack, true);
                                int insertedSim = tryStack.m_41613_() - leftoverSim.m_41613_();
                                if (insertedSim <= 0 || insertedSim <= 0) continue;
                                remaining2 -= insertedSim;
                                insertedTotal2 += insertedSim;
                                usedSlots.add(slot);
                                cachedSlots.put(slot, new Tuple((Object)tryStack.m_41777_(), (Object)perRecipe2));
                                break;
                            }
                            if ((possibleOperations = Math.min(possibleOperations, insertedTotal2 / perRecipe2)) <= 0) {
                                canInsertAll = false;
                                break;
                            }
                            insertedTotal2 = possibleOperations * perRecipe2;
                            continue;
                        }
                        if (sameStack.getFluidStack().isEmpty()) continue;
                        if (fluid_handler == null) {
                            canInsertAll = false;
                            break;
                        }
                        FluidStack fluidStack = sameStack.getFluidStack();
                        perRecipe = fluidStack.getAmount();
                        remaining = maxNeeded = perRecipe * minAmount;
                        insertedTotal = 0;
                        boolean placed = false;
                        for (int tank = 0; tank < fluid_handler.getTanks() && remaining > 0; ++tank) {
                            if (usedTanks.contains(tank)) continue;
                            FluidStack tryFluid = fluidStack.copy();
                            tryFluid.setAmount(Math.min(remaining, tryFluid.getAmount()));
                            filledSim = fluid_handler.fill(tryFluid, IFluidHandler.FluidAction.SIMULATE);
                            if (filledSim <= 0 || filledSim <= 0) continue;
                            remaining -= filledSim;
                            insertedTotal += filledSim;
                            usedTanks.add(tank);
                            cachedTanks.put(tank, new Tuple((Object)fluidStack.copy(), (Object)possibleOperations));
                            placed = true;
                            break;
                        }
                        if ((possibleOperations = Math.min(possibleOperations, insertedTotal / perRecipe)) <= 0 || !placed) {
                            canInsertAll = false;
                            break;
                        }
                        insertedTotal = possibleOperations * perRecipe;
                    }
                    if (!canInsertAll) continue;
                    autoCraftStack.addCreate(possibleOperations * autoCraftStack.getPatternStack().output().getAmount());
                    for (Map.Entry entry : cachedSlots.entrySet()) {
                        int slot2 = (Integer)entry.getKey();
                        ItemStack cached = (ItemStack)((Tuple)entry.getValue()).m_14418_();
                        cached.m_41764_((Integer)((Tuple)entry.getValue()).m_14419_() * possibleOperations);
                        this.removeStack(cached);
                        handler.insertItem(slot2, cached, false);
                    }
                    for (Map.Entry entry : cachedTanks.entrySet()) {
                        FluidStack cached = (FluidStack)((Tuple)entry.getValue()).m_14418_();
                        cached.setAmount(((FluidStack)((Tuple)entry.getValue()).m_14418_()).getAmount() * possibleOperations);
                        this.removeFluidStack(cached);
                        fluid_handler.fill(cached, IFluidHandler.FluidAction.EXECUTE);
                    }
                }
                if (!autoCraftSystem.getPatternStacks().isEmpty()) continue;
                if (autoCraftSystem.getAutoCraftOutput().patternStack().typeRecipe() == TypeRecipe.WORKBENCH) {
                    tempStorageStackMap = new HashMap<Object, Integer>();
                    for (Object stack : autoCraftSystem.getAutoCraftOutput().patternStack().inputs()) {
                        List<StorageStack> tuple = this.findStackForWorkBench((SameStack)stack);
                        if (tuple.isEmpty()) continue block0;
                        int amount2 = 0;
                        for (StorageStack storageStack : tuple) {
                            if (!((SameStack)stack).getStack().m_41619_() && NbtUtils.m_129235_((Tag)((SameStack)stack).getStack().m_41783_(), (Tag)storageStack.getTag(), (boolean)true)) {
                                amount2 += storageStack.getCount();
                            }
                            if (((SameStack)stack).getFluidStack().isEmpty() || !NbtUtils.m_129235_((Tag)((SameStack)stack).getFluidStack().getTag(), (Tag)storageStack.getTag(), (boolean)true)) continue;
                            amount2 += storageStack.getCount();
                        }
                        if (!((SameStack)stack).getStack().m_41619_() && ((SameStack)stack).getStack().m_41613_() > amount2 || !((SameStack)stack).getFluidStack().isEmpty() && ((SameStack)stack).getFluidStack().getAmount() > amount2) continue block0;
                        tempStorageStackMap.put(stack, amount2);
                    }
                    if (tempStorageStackMap.keySet().size() == autoCraftSystem.getAutoCraftOutput().patternStack().inputs().size()) {
                        int craftableByInputs;
                        Object stack;
                        int minAmount1 = Integer.MAX_VALUE;
                        stack = tempStorageStackMap.entrySet().iterator();
                        while (stack.hasNext()) {
                            Map.Entry storageStackList = (Map.Entry)stack.next();
                            minAmount1 = Math.min(minAmount1, (Integer)storageStackList.getValue() / ((SameStack)storageStackList.getKey()).getAmount());
                        }
                        int craftableByOutput = this.getDifferenceStorage() / autoCraftSystem.getAutoCraftOutput().patternStack().output().getAmount();
                        craftableByOutput = Math.min(autoCraftSystem.getCount(), craftableByOutput);
                        int minAmount = Math.min(craftableByOutput, craftableByInputs = minAmount1);
                        if (minAmount > 0 && minAmount1 > 0) {
                            for (Map.Entry storageStackList : tempStorageStackMap.entrySet()) {
                                ItemStack deleteItem = ((SameStack)storageStackList.getKey()).getStack().m_41777_();
                                deleteItem.m_41764_(minAmount * ((SameStack)storageStackList.getKey()).getAmount());
                                this.removeStackWithIgnoring(deleteItem);
                            }
                            ItemStack addItem = autoCraftSystem.getAutoCraftOutput().patternStack().output().getStack().m_41777_();
                            addItem.m_41764_(autoCraftSystem.getAutoCraftOutput().patternStack().output().getAmount() * minAmount);
                            this.addStack(addItem);
                            autoCraftSystem.removeCountAutoCraftStack(minAmount);
                        }
                    }
                }
                if (autoCraftSystem.getAutoCraftOutput().patternStack().typeRecipe() == TypeRecipe.BLOCK) {
                    tempStorageStackMap = new HashMap();
                    PatternStack patternStack = autoCraftSystem.getAutoCraftOutput().patternStack();
                    AutoCraftOutput autoCraftStack = autoCraftSystem.getAutoCraftOutput();
                    for (SameStack stack : autoCraftSystem.getAutoCraftOutput().patternStack().inputs()) {
                        List<StorageStack> tuple = this.findStack(stack);
                        if (tuple.isEmpty()) {
                            return;
                        }
                        amount = 0;
                        for (StorageStack storageStack : tuple) {
                            if (!stack.getStack().m_41619_() && NbtUtils.m_129235_((Tag)stack.getStack().m_41783_(), (Tag)storageStack.getTag(), (boolean)true)) {
                                amount += storageStack.getCount();
                            }
                            if (stack.getFluidStack().isEmpty() || !NbtUtils.m_129235_((Tag)stack.getFluidStack().getTag(), (Tag)storageStack.getTag(), (boolean)true)) continue;
                            amount += storageStack.getCount();
                        }
                        if (!stack.getStack().m_41619_() && stack.getStack().m_41613_() > amount) {
                            return;
                        }
                        if (!stack.getFluidStack().isEmpty() && stack.getFluidStack().getAmount() > amount) {
                            return;
                        }
                        tempStorageStackMap.put(stack, amount);
                    }
                    if (tempStorageStackMap.keySet().size() == patternStack.inputs().size()) {
                        Interface intf = this.patternStackInterfaceMap.get(autoCraftStack.patternStack());
                        if (intf == null || intf.getBlockEntityNeighbor() == null) continue;
                        int minAmount1 = Integer.MAX_VALUE;
                        for (Map.Entry storageStackList : tempStorageStackMap.entrySet()) {
                            minAmount1 = Math.min(minAmount1, (Integer)storageStackList.getValue() / ((SameStack)storageStackList.getKey()).getAmount());
                        }
                        int craftableByOutput = this.getDifferenceStorage() / autoCraftStack.patternStack().output().getAmount();
                        craftableByOutput = Math.min(craftableByOutput, (autoCraftStack.getAll() - autoCraftStack.getCreate()) / autoCraftStack.patternStack().output().getAmount());
                        craftableByOutput = Math.min(autoCraftStack.getAmount(), craftableByOutput);
                        int craftableByInputs = minAmount1;
                        int minAmount = Math.min(craftableByOutput, craftableByInputs);
                        handler = (IItemHandler)intf.getBlockEntityNeighbor().getCapability(ForgeCapabilities.ITEM_HANDLER, intf.getDirection()).orElse(null);
                        fluid_handler = (IFluidHandler)intf.getBlockEntityNeighbor().getCapability(ForgeCapabilities.FLUID_HANDLER, intf.getDirection()).orElse(null);
                        if (minAmount > 0 && minAmount1 > 0 && handler != null) {
                            cachedSlots = new HashMap();
                            cachedTanks = new HashMap();
                            usedSlots = new HashSet();
                            usedTanks = new HashSet();
                            canInsertAll = true;
                            possibleOperations = Integer.MAX_VALUE;
                            for (Map.Entry storageStackList : tempStorageStackMap.entrySet()) {
                                sameStack = (SameStack)storageStackList.getKey();
                                if (!sameStack.getStack().m_41619_()) {
                                    if (handler == null) {
                                        canInsertAll = false;
                                        break;
                                    }
                                    int perRecipe3 = sameStack.getStack().m_41613_();
                                    remaining2 = maxNeeded2 = perRecipe3 * minAmount;
                                    insertedTotal2 = 0;
                                    for (slot = 0; slot < handler.getSlots() && remaining2 > 0; ++slot) {
                                        if (usedSlots.contains(slot)) continue;
                                        ItemStack tryStack = sameStack.getStack().m_41777_();
                                        tryStack.m_41764_(Math.min(remaining2, tryStack.m_41741_()));
                                        ItemStack leftoverSim = handler.insertItem(slot, tryStack, true);
                                        int insertedSim = tryStack.m_41613_() - leftoverSim.m_41613_();
                                        if (insertedSim <= 0) continue;
                                        remaining2 -= insertedSim;
                                        insertedTotal2 += insertedSim;
                                        usedSlots.add(slot);
                                        cachedSlots.put(slot, new Tuple((Object)sameStack.getStack().m_41777_(), (Object)perRecipe3));
                                        break;
                                    }
                                    if ((possibleOperations = Math.min(possibleOperations, insertedTotal2 / perRecipe3)) <= 0) {
                                        canInsertAll = false;
                                        break;
                                    }
                                    insertedTotal2 = possibleOperations * perRecipe3;
                                    continue;
                                }
                                if (sameStack.getFluidStack().isEmpty()) continue;
                                if (fluid_handler == null) {
                                    canInsertAll = false;
                                    break;
                                }
                                FluidStack fluidStack = sameStack.getFluidStack();
                                perRecipe = fluidStack.getAmount();
                                remaining = maxNeeded = perRecipe * minAmount;
                                insertedTotal = 0;
                                boolean placed = false;
                                for (int tank = 0; tank < fluid_handler.getTanks() && remaining > 0; ++tank) {
                                    if (usedTanks.contains(tank)) continue;
                                    FluidStack tryFluid = fluidStack.copy();
                                    tryFluid.setAmount(Math.min(remaining, tryFluid.getAmount()));
                                    filledSim = fluid_handler.fill(tryFluid, IFluidHandler.FluidAction.SIMULATE);
                                    if (filledSim <= 0) continue;
                                    remaining -= filledSim;
                                    insertedTotal += filledSim;
                                    usedTanks.add(tank);
                                    cachedTanks.put(tank, new Tuple((Object)fluidStack.copy(), (Object)possibleOperations));
                                    placed = true;
                                    break;
                                }
                                if ((possibleOperations = Math.min(possibleOperations, insertedTotal / perRecipe)) <= 0 || !placed) {
                                    canInsertAll = false;
                                    break;
                                }
                                insertedTotal = possibleOperations * perRecipe;
                            }
                            if (canInsertAll) {
                                autoCraftStack.addCreate(possibleOperations * autoCraftStack.patternStack().output().getAmount());
                                for (Map.Entry entry : cachedSlots.entrySet()) {
                                    int slot3 = (Integer)entry.getKey();
                                    ItemStack cached = (ItemStack)((Tuple)entry.getValue()).m_14418_();
                                    cached.m_41764_((Integer)((Tuple)entry.getValue()).m_14419_() * possibleOperations);
                                    this.removeStack(cached);
                                    handler.insertItem(slot3, cached, false);
                                }
                                for (Map.Entry entry : cachedTanks.entrySet()) {
                                    FluidStack cached = (FluidStack)((Tuple)entry.getValue()).m_14418_();
                                    cached.setAmount(((FluidStack)((Tuple)entry.getValue()).m_14418_()).getAmount() * possibleOperations);
                                    this.removeFluidStack(cached);
                                    fluid_handler.fill(cached, IFluidHandler.FluidAction.EXECUTE);
                                }
                            }
                        }
                    }
                }
                if (!autoCraftSystem.isEnd()) continue;
                it.remove();
            }
        }
        if (level.m_46467_() % 2L == 0L) {
            for (Import imp : this.imports) {
                this.workImport(imp);
            }
            for (Export exp : this.exports) {
                this.workExport(exp);
            }
        }
        if (level.m_46467_() % 4L == 0L) {
            Tuple<List<SameStack>, List<SameStack>> tupleItem = this.getAllStoredItemStacks();
            Tuple<List<SameStack>, List<SameStack>> tupleFluid = this.getAllStoredFluidStacks();
            this.stacks = (List)tupleItem.m_14418_();
            this.fluids = (List)tupleFluid.m_14418_();
            this.stacksCanCreate = (List)tupleItem.m_14419_();
            this.fluidsCanCreate = (List)tupleFluid.m_14419_();
            new PacketUpdateStorageCell(this.stacks, false, false, pos, level);
            new PacketUpdateStorageCell(this.fluids, true, false, pos, level);
            new PacketUpdateStorageCell(this.stacksCanCreate, false, true, pos, level);
            new PacketUpdateStorageCell(this.fluidsCanCreate, true, true, pos, level);
        }
    }

    public void addStack(ItemStack addItem) {
        CompoundTag tag = addItem.m_41783_();
        Item item = addItem.m_41720_();
        for (ICell cell : this.getAllItemCells()) {
            if (addItem.m_41619_()) {
                return;
            }
            if (addItem.m_41613_() <= 0) {
                return;
            }
            int amount = cell.canAdd(addItem);
            if (amount <= 0) continue;
            addItem.m_41774_(amount);
            cell.addStack(item, tag, amount);
        }
    }

    public void addStack(FluidStack addItem) {
        CompoundTag tag = addItem.getTag();
        Fluid fluid = addItem.getFluid();
        for (ICell cell : this.getAllFluidCells()) {
            if (addItem.isEmpty()) {
                return;
            }
            if (addItem.getAmount() <= 0) {
                return;
            }
            int amount = cell.canAdd(addItem);
            if (amount <= 0) continue;
            addItem.shrink(amount);
            cell.addFluid(fluid, tag, amount);
        }
    }

    public int getDifferenceStorage() {
        int sum = 0;
        for (ICell cell : this.getAllItemCells()) {
            sum += cell.getCellInfo().capacity() - cell.getStorage();
        }
        return sum;
    }

    public double getItemStorage() {
        double sum = 0.0;
        for (ICell cell : this.getAllItemCells()) {
            sum += (double)cell.getStorage();
        }
        return sum;
    }

    public double getItemMaxStorage() {
        double sum = 0.0;
        for (ICell cell : this.getAllItemCells()) {
            sum += (double)cell.getCellInfo().capacity();
        }
        return sum;
    }

    public List<StorageStack> findStackForWorkBench(SameStack stack) {
        LinkedList<StorageStack> storageStackList = new LinkedList<StorageStack>();
        for (ICell cell : this.getAllItemCells()) {
            List<StorageStack> list;
            ResourceLocation rl;
            Map<String, List<StorageStack>> map = cell.getStorageStack();
            if (!stack.getStack().m_41619_()) {
                rl = BuiltInRegistries.f_257033_.m_7981_((Object)stack.getStack().m_41720_());
                list = map.get(rl.toString());
                if (list == null) continue;
                for (StorageStack stack1 : list) {
                    if (!ModUtils.checkNbtEquality(stack1.getTag(), stack.getStack().m_41783_())) continue;
                    storageStackList.add(stack1);
                }
                continue;
            }
            if (stack.getFluidStack().isEmpty() || (list = map.get((rl = BuiltInRegistries.f_257020_.m_7981_((Object)stack.getFluidStack().getFluid())).toString())) == null) continue;
            for (StorageStack stack1 : list) {
                if (!ModUtils.checkNbtEquality(stack1.getTag(), stack.getFluidStack().getTag())) continue;
                storageStackList.add(stack1);
            }
        }
        return storageStackList;
    }

    public List<StorageStack> findStack(SameStack stack) {
        List<StorageStack> list;
        ResourceLocation rl;
        Map<String, List<StorageStack>> map;
        LinkedList<StorageStack> storageStackList = new LinkedList<StorageStack>();
        if (!stack.getStack().m_41619_()) {
            for (ICell cell : this.getAllItemCells()) {
                map = cell.getStorageStack();
                list = map.get((rl = BuiltInRegistries.f_257033_.m_7981_((Object)stack.getStack().m_41720_())).toString());
                if (list == null) continue;
                for (StorageStack stack1 : list) {
                    if (!NbtUtils.m_129235_((Tag)stack1.getTag(), (Tag)stack.getStack().m_41783_(), (boolean)true)) continue;
                    storageStackList.add(stack1);
                }
            }
        }
        if (!stack.getFluidStack().isEmpty()) {
            for (ICell cell : this.getAllFluidCells()) {
                map = cell.getStorageStack();
                list = map.get((rl = BuiltInRegistries.f_257020_.m_7981_((Object)stack.getFluidStack().getFluid())).toString());
                if (list == null) continue;
                for (StorageStack stack1 : list) {
                    if (!NbtUtils.m_129235_((Tag)stack1.getTag(), (Tag)stack.getStack().m_41783_(), (boolean)true)) continue;
                    storageStackList.add(stack1);
                }
            }
        }
        return storageStackList;
    }

    public void workImport(Import imp) {
        AutoCraftOutput autoCraftStack;
        int canRemove;
        Iterator<AutoCraftStack> it1;
        Iterator<AutoCraftSystem> it;
        AbstractList added;
        int differenceStorage;
        LazyOptional cap;
        boolean isBlackList;
        TypeStack typeStack = imp.getTypeStack();
        BlockEntity block = imp.getBlockEntityNeighbor();
        List<ItemStack> listStacks = imp.getStacks();
        List<FluidStack> listFluidStacks = imp.getFluidStacks();
        boolean bl = isBlackList = imp.getTypeSlots() == EnumTypeSlots.BLACKLIST;
        if (block == null) {
            return;
        }
        if (typeStack == TypeStack.ITEM) {
            cap = block.getCapability(ForgeCapabilities.ITEM_HANDLER, imp.getDirection());
            if (!cap.isPresent()) {
                return;
            }
            IItemHandler itemHandler = (IItemHandler)cap.orElse(null);
            differenceStorage = this.getDifferenceStorage();
            added = new LinkedList();
            if (differenceStorage > 0) {
                for (int slot = 0; slot < itemHandler.getSlots() && differenceStorage > 0; ++slot) {
                    ItemStack extracted;
                    int canAdd;
                    boolean allowed;
                    ItemStack candidate = itemHandler.extractItem(slot, differenceStorage, true);
                    if (candidate.m_41619_() || !(allowed = this.checkItemFilter(candidate, listStacks, isBlackList)) || (canAdd = this.canAdd(candidate)) <= 0 || (extracted = itemHandler.extractItem(slot, canAdd, false)).m_41619_()) continue;
                    int extractedCount = extracted.m_41613_();
                    added.add(extracted.m_41777_());
                    this.addStack(extracted);
                    differenceStorage = this.getDifferenceStorage();
                }
            }
            added = new ArrayList(added);
            for (ItemStack extracted : added) {
                block2: for (Processor processor : this.processors) {
                    it = processor.getAutoCrafts().iterator();
                    while (it.hasNext()) {
                        AutoCraftSystem autoCraftSystem = it.next();
                        if (!autoCraftSystem.getPatternStacks().isEmpty()) {
                            it1 = autoCraftSystem.getPatternStacks().iterator();
                            while (it1.hasNext()) {
                                AutoCraftStack autoCraftStack2 = it1.next();
                                if (autoCraftStack2.getPatternStack().typeRecipe() != TypeRecipe.BLOCK || !autoCraftStack2.getPatternStack().output().isItem() || !autoCraftStack2.getPatternStack().output().isCorrect(extracted)) continue;
                                canRemove = Math.min(autoCraftStack2.getCreate(), extracted.m_41613_());
                                autoCraftStack2.removeAllAmount(canRemove);
                                autoCraftStack2.removeCreate(canRemove);
                                extracted.m_41774_(canRemove);
                                if (autoCraftStack2.getAll() != 0) continue;
                                it1.remove();
                                break;
                            }
                        }
                        if (extracted.m_41619_() || (autoCraftStack = autoCraftSystem.getAutoCraftOutput()).getPatternStack().typeRecipe() != TypeRecipe.BLOCK || !autoCraftStack.getPatternStack().output().isItem() || !autoCraftStack.getPatternStack().output().isCorrect(extracted)) continue;
                        int canRemove2 = Math.min(autoCraftStack.getCreate(), extracted.m_41613_());
                        autoCraftStack.removeAllAmount(canRemove2);
                        autoCraftStack.removeCreate(canRemove2);
                        extracted.m_41774_(canRemove2);
                        if (autoCraftStack.getAll() != 0) continue;
                        it.remove();
                        continue block2;
                    }
                }
            }
        }
        if (typeStack == TypeStack.FLUID) {
            FluidStack simulate;
            cap = block.getCapability(ForgeCapabilities.FLUID_HANDLER, imp.getDirection());
            if (!cap.isPresent()) {
                return;
            }
            IFluidHandler fluidHandler = (IFluidHandler)cap.orElse(null);
            differenceStorage = this.getDifferenceStorage();
            added = new LinkedList();
            if (differenceStorage > 0 && !(simulate = fluidHandler.drain(differenceStorage, IFluidHandler.FluidAction.SIMULATE)).isEmpty()) {
                boolean allowed = this.checkFluidFilter(simulate, listFluidStacks, isBlackList);
                if (!allowed) {
                    return;
                }
                int canAdd = this.canAdd(simulate);
                if (canAdd > 0) {
                    FluidStack drained = fluidHandler.drain(new FluidStack(simulate.getFluid(), canAdd), IFluidHandler.FluidAction.EXECUTE);
                    added.add(drained.copy());
                    if (!drained.isEmpty()) {
                        this.addStack(drained);
                    }
                }
            }
            added = new ArrayList(added);
            for (FluidStack extracted : added) {
                block6: for (Processor processor : this.processors) {
                    it = processor.getAutoCrafts().iterator();
                    while (it.hasNext()) {
                        AutoCraftSystem autoCraftSystem = it.next();
                        if (!autoCraftSystem.getPatternStacks().isEmpty()) {
                            it1 = autoCraftSystem.getPatternStacks().iterator();
                            while (it1.hasNext()) {
                                AutoCraftStack autoCraftStack3 = it1.next();
                                if (autoCraftStack3.getPatternStack().typeRecipe() != TypeRecipe.BLOCK || !autoCraftStack3.getPatternStack().output().isFluid() || !autoCraftStack3.getPatternStack().output().isCorrect(extracted)) continue;
                                canRemove = Math.min(autoCraftStack3.getCreate(), extracted.getAmount());
                                autoCraftStack3.removeAllAmount(canRemove);
                                autoCraftStack3.removeCreate(canRemove);
                                extracted.shrink(canRemove);
                                if (autoCraftStack3.getAll() != 0) continue;
                                it1.remove();
                                break;
                            }
                        }
                        if (extracted.isEmpty() || (autoCraftStack = autoCraftSystem.getAutoCraftOutput()).getPatternStack().typeRecipe() != TypeRecipe.BLOCK || !autoCraftStack.getPatternStack().output().isItem() || !autoCraftStack.getPatternStack().output().isCorrect(extracted)) continue;
                        int canRemove3 = Math.min(autoCraftStack.getCreate(), extracted.getAmount());
                        autoCraftStack.removeAllAmount(canRemove3);
                        autoCraftStack.removeCreate(canRemove3);
                        extracted.shrink(canRemove3);
                        if (autoCraftStack.getAll() != 0) continue;
                        it.remove();
                        continue block6;
                    }
                }
            }
        }
    }

    public void workExport(Export exp) {
        LazyOptional cap;
        TypeStack typeStack = exp.getTypeStack();
        BlockEntity block = exp.getBlockEntityNeighbor();
        List<ItemStack> listStacks = exp.getStacks();
        List<FluidStack> listFluidStacks = exp.getFluidStacks();
        if (block == null) {
            return;
        }
        if (typeStack == TypeStack.ITEM) {
            if (listStacks == null || listStacks.isEmpty()) {
                return;
            }
            cap = block.getCapability(ForgeCapabilities.ITEM_HANDLER, exp.getDirection());
            if (!cap.isPresent()) {
                return;
            }
            IItemHandler itemHandler = (IItemHandler)cap.orElse(null);
            for (ItemStack itemStack : listStacks) {
                ItemStack extracted;
                ItemStack request;
                int available;
                if (itemStack.m_41619_() || (available = this.canRemoveExport(request = itemStack.m_41777_())) <= 0) continue;
                ItemStack toInsert = new ItemStack((ItemLike)request.m_41720_(), Math.min(available, request.m_41741_() * 4));
                toInsert.m_41751_(request.m_41783_());
                ItemStack remaining = this.insertIntoHandler(itemHandler, toInsert, true);
                int inserted = available - remaining.m_41613_();
                if (inserted <= 0 || (extracted = this.removeStackWithIgnoring(new ItemStack((ItemLike)request.m_41720_(), inserted))).m_41619_()) continue;
                this.insertIntoHandler(itemHandler, extracted, false);
            }
        }
        if (typeStack == TypeStack.FLUID) {
            if (listFluidStacks == null || listFluidStacks.isEmpty()) {
                return;
            }
            cap = block.getCapability(ForgeCapabilities.FLUID_HANDLER, exp.getDirection());
            if (!cap.isPresent()) {
                return;
            }
            IFluidHandler fluidHandler = (IFluidHandler)cap.orElse(null);
            for (FluidStack fluidStack : listFluidStacks) {
                FluidStack availableFluid;
                int canFill;
                int available;
                if (fluidStack.isEmpty() || (available = this.canRemoveExport(fluidStack)) <= 0 || (canFill = fluidHandler.fill(availableFluid = new FluidStack(fluidStack.getFluid(), available, fluidStack.getTag()), IFluidHandler.FluidAction.SIMULATE)) <= 0) continue;
                availableFluid.setAmount(canFill);
                FluidStack extracted = this.removeStack(availableFluid);
                if (extracted.isEmpty()) continue;
                fluidHandler.fill(extracted, IFluidHandler.FluidAction.EXECUTE);
            }
        }
    }

    public FluidStack removeStack(FluidStack request) {
        if (request == null || request.isEmpty()) {
            return FluidStack.EMPTY;
        }
        int remaining = request.getAmount();
        FluidStack result = FluidStack.EMPTY;
        for (ICell cell : this.getAllFluidCells()) {
            if (remaining <= 0) break;
            FluidStack extracted = cell.removeFluid(request);
            if (extracted.isEmpty()) continue;
            if (result.isEmpty()) {
                result = extracted.copy();
            } else {
                result.grow(extracted.getAmount());
            }
            remaining -= extracted.getAmount();
        }
        return result;
    }

    public ItemStack insertIntoHandler(IItemHandler handler, ItemStack stack, boolean simulate) {
        ItemStack remaining = stack.m_41777_();
        for (int slot = 0; slot < handler.getSlots() && !remaining.m_41619_(); ++slot) {
            remaining = handler.insertItem(slot, remaining, simulate);
        }
        return remaining;
    }

    public boolean checkItemFilter(ItemStack stack, List<ItemStack> filters, boolean isBlackList) {
        if (filters == null || filters.isEmpty()) {
            return isBlackList;
        }
        for (ItemStack filter : filters) {
            if (filter.m_41619_() || filter.m_41720_() != stack.m_41720_() || (filter.m_41783_() != null || stack.m_41783_() != null) && !ModUtils.checkNbtEquality(filter.m_41783_(), stack.m_41783_())) continue;
            return !isBlackList;
        }
        return isBlackList;
    }

    public boolean checkFluidFilter(FluidStack stack, List<FluidStack> filters, boolean isBlackList) {
        if (filters == null || filters.isEmpty()) {
            return !isBlackList;
        }
        for (FluidStack filter : filters) {
            if (filter.isEmpty() || filter.getFluid() != stack.getFluid() || filter.getTag() != null && !ModUtils.checkNbtEquality(filter.getTag(), stack.getTag())) continue;
            return !isBlackList;
        }
        return isBlackList;
    }

    public int canAdd(ItemStack stack) {
        if (stack == null || stack.m_41619_()) {
            return 0;
        }
        ItemStack copy = stack.m_41777_();
        int inserted = 0;
        for (ICell cell : this.getAllItemCells()) {
            if (copy.m_41619_()) break;
            int accepted = cell.canAdd(copy);
            if (accepted <= 0) continue;
            inserted += accepted;
            copy.m_41774_(accepted);
        }
        return inserted;
    }

    public int canAdd(FluidStack stack) {
        if (stack == null || stack.isEmpty()) {
            return 0;
        }
        FluidStack copy = stack.copy();
        int inserted = 0;
        for (ICell cell : this.getAllFluidCells()) {
            if (copy.isEmpty()) break;
            int accepted = cell.canAdd(copy);
            if (accepted <= 0) continue;
            inserted += accepted;
            copy.shrink(accepted);
        }
        return inserted;
    }

    public int canRemove(ItemStack stack) {
        if (stack == null || stack.m_41619_()) {
            return 0;
        }
        ItemStack copy = stack.m_41777_();
        int removable = 0;
        block0: for (ICell cell : this.getAllItemCells()) {
            if (copy.m_41619_()) break;
            List<StorageStack> availableStacks = cell.getStorageStackFromItem(copy);
            for (StorageStack s : availableStacks) {
                int take = Math.min(s.getCount(), copy.m_41613_());
                removable += take;
                copy.m_41774_(take);
                if (!copy.m_41619_()) continue;
                continue block0;
            }
        }
        return removable;
    }

    public int canRemoveExport(ItemStack stack) {
        if (stack == null || stack.m_41619_()) {
            return 0;
        }
        int removable = 0;
        for (ICell cell : this.getAllItemCells()) {
            List<StorageStack> availableStacks = cell.getStorageStackFromItem(stack);
            for (StorageStack s : availableStacks) {
                int take = s.getCount();
                removable += take;
            }
        }
        return removable;
    }

    public int canRemove(FluidStack stack) {
        if (stack == null || stack.isEmpty()) {
            return 0;
        }
        FluidStack copy = stack.copy();
        int removable = 0;
        block0: for (ICell cell : this.getAllFluidCells()) {
            if (copy.isEmpty()) break;
            List<StorageStack> availableStacks = cell.getStorageStackFromFluid(copy);
            for (StorageStack s : availableStacks) {
                int take = Math.min(s.getCount(), copy.getAmount());
                removable += take;
                copy.shrink(take);
                if (!copy.isEmpty()) continue;
                continue block0;
            }
        }
        return removable;
    }

    public int canRemoveExport(FluidStack stack) {
        if (stack == null || stack.isEmpty()) {
            return 0;
        }
        int removable = 0;
        for (ICell cell : this.getAllFluidCells()) {
            List<StorageStack> availableStacks = cell.getStorageStackFromFluid(stack);
            for (StorageStack s : availableStacks) {
                int take = s.getCount();
                removable += take;
            }
        }
        return removable;
    }

    public ItemStack removeStackWithIgnoring(ItemStack request) {
        if (request == null || request.m_41619_()) {
            return ItemStack.f_41583_;
        }
        int remaining = request.m_41613_();
        ItemStack result = ItemStack.f_41583_;
        for (ICell cell : this.getAllItemCells()) {
            if (remaining <= 0) break;
            ItemStack extracted = cell.removeStackWithIgnoring(request);
            if (extracted.m_41619_()) continue;
            if (result.m_41619_()) {
                result = extracted.m_41777_();
            } else {
                result.m_41769_(extracted.m_41613_());
            }
            remaining -= extracted.m_41613_();
        }
        return result;
    }

    public void removeStack(ItemStack request) {
        if (request == null || request.m_41619_()) {
            return;
        }
        int remaining = request.m_41613_();
        Item item = request.m_41720_();
        CompoundTag tag = request.m_41783_();
        for (ICell cell : this.getAllItemCells()) {
            if (remaining <= 0) break;
            int extracted = cell.removeStack(item, tag, remaining);
            remaining -= extracted;
        }
    }

    public void removeFluidStack(FluidStack request) {
        if (request == null || request.isEmpty()) {
            return;
        }
        int remaining = request.getAmount();
        Fluid item = request.getFluid();
        CompoundTag tag = request.getTag();
        for (ICell cell : this.getAllFluidCells()) {
            if (remaining <= 0) break;
            int extracted = cell.removeFluid(item, tag, remaining);
            remaining -= extracted;
        }
    }

    public void reBuild(List<Path> paths, Level level) {
        this.storageDeviceCells.clear();
        this.consumeEnergy = 0.0;
        this.interfaces.clear();
        this.processors.clear();
        this.imports.clear();
        this.exports.clear();
        this.patternStackInterfaceMap.clear();
        if (paths != null) {
            paths.forEach(path -> {
                ISink sink = path.getSink();
                BlockEntity blockEntity = level.m_7702_(sink.getPos());
                if (blockEntity instanceof ElectricStorage) {
                    ElectricStorage storage = (ElectricStorage)blockEntity;
                    this.addElement(storage);
                }
            });
        }
    }

    public void reBuild(Level level, List<BlockPos> paths) {
        this.storageDeviceCells.clear();
        this.consumeEnergy = 0.0;
        this.interfaces.clear();
        this.processors.clear();
        this.imports.clear();
        this.exports.clear();
        this.patternStackInterfaceMap.clear();
        paths.forEach(path -> {
            BlockEntity blockEntity = level.m_7702_(path);
            if (blockEntity instanceof ElectricStorage) {
                ElectricStorage storage = (ElectricStorage)blockEntity;
                this.addElement(storage);
            }
        });
    }

    public void onUnload() {
        this.storageDeviceCells.clear();
        this.consumeEnergy = 0.0;
        this.interfaces.forEach(interf -> interf.setStorageNetwork(null));
        this.interfaces.clear();
        this.processors.clear();
        this.imports.clear();
        this.exports.clear();
        this.patternStackInterfaceMap.clear();
    }

    public List<SameStack> getFluids() {
        return this.fluids;
    }

    public List<SameStack> getStacks() {
        return this.stacks;
    }

    public List<SameStack> getFluidsCanCreate() {
        return this.fluidsCanCreate;
    }

    public List<SameStack> getStacksCanCreate() {
        return this.stacksCanCreate;
    }

    public void setFluids(List<SameStack> stacks) {
        this.fluids = stacks;
    }

    public void setItems(List<SameStack> stacks) {
        this.stacks = stacks;
    }

    public void setFluidsCreate(List<SameStack> stacks) {
        this.fluidsCanCreate = stacks;
    }

    public void setItemsCreate(List<SameStack> stacks) {
        this.stacksCanCreate = stacks;
    }

    public void reloadInterface(Interface base) {
        this.patternStackInterfaceMap.entrySet().removeIf(entry -> entry.getValue() == base);
        for (PatternStack patternStack : base.getPatterns()) {
            this.patternStackInterfaceMap.put(patternStack, base);
        }
    }
}

