/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.solar;

import com.denfop.api.solar.EnumSolarType;
import com.denfop.api.solar.EnumTypeParts;
import com.denfop.api.solar.IBatteryItem;
import com.denfop.api.solar.IOutputItem;
import com.denfop.api.solar.ISolarItem;
import com.denfop.api.solar.ISolarTile;
import com.denfop.blockentity.panels.entity.BlockEntityMiniPanels;
import com.denfop.blocks.SubEnum;
import com.denfop.items.ItemMain;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.world.item.ItemStack;

public class SolarEnergySystem {
    public static SolarEnergySystem system;
    public static int[][] indexes;

    public void calculateCores(ISolarTile solarTile) {
        List<ItemStack> stackList = solarTile.getCoresItems();
        int level = 0;
        for (ItemStack stack : stackList) {
            if (stack.m_41619_()) continue;
            level += ((SubEnum)((ItemMain)stack.m_41720_()).getElement()).getId() + 1;
        }
        solarTile.setCoreLevel(level);
    }

    public void recalculation(ISolarTile solarTile, EnumTypeParts parts) {
        switch (parts) {
            case OUTPUT: {
                List<ItemStack> items = solarTile.getOutputItems();
                int max = 0;
                double average = 0.0;
                double output = 0.0;
                for (ItemStack item : items) {
                    if (item == null || item.m_41619_()) continue;
                    int meta = ((SubEnum)((ItemMain)item.m_41720_()).getElement()).getId();
                    if (meta + 1 > max) {
                        max = meta + 1;
                    }
                    average += (double)(meta + 1);
                    output += ((IOutputItem)item.m_41720_()).getOutput(meta);
                }
                average /= (double)items.size();
                if ((average = Math.floor(average)) == (double)max) {
                    solarTile.setBonus(EnumTypeParts.OUTPUT, 0.05 * (double)max);
                } else {
                    solarTile.setBonus(EnumTypeParts.OUTPUT, 0.0);
                }
                solarTile.setOutput(output);
                break;
            }
            case CAPACITY: {
                List<ItemStack> items = solarTile.getCapacityItems();
                int max = 0;
                double average = 0.0;
                int capacity = 0;
                for (ItemStack item : items) {
                    if (item == null || item.m_41619_()) continue;
                    int meta = ((SubEnum)((ItemMain)item.m_41720_()).getElement()).getId();
                    if (meta + 1 > max) {
                        max = meta + 1;
                    }
                    average += (double)(meta + 1);
                    capacity = (int)((double)capacity + ((IBatteryItem)item.m_41720_()).getCapacity(meta));
                }
                average /= (double)items.size();
                if ((average = Math.floor(average)) == (double)max) {
                    solarTile.setBonus(EnumTypeParts.CAPACITY, 0.1 * (double)max);
                } else {
                    solarTile.setBonus(EnumTypeParts.CAPACITY, 0.0);
                }
                solarTile.setCapacity(capacity);
                break;
            }
            case GENERATION: {
                List<ItemStack> items = solarTile.getGenerationItems();
                int max = 0;
                double average = 0.0;
                double day = 0.0;
                double night = 0.0;
                double day_night = 0.0;
                int index = 0;
                boolean canBonus = true;
                EnumSolarType solarType = null;
                for (ItemStack item : items) {
                    if (item == null || item.m_41619_()) {
                        solarTile.setStables(index, Collections.emptyList());
                        ++index;
                        continue;
                    }
                    int meta = ((SubEnum)((ItemMain)item.m_41720_()).getElement()).getId();
                    if (meta + 1 > max) {
                        max = meta + 1;
                    }
                    average += (double)(meta + 1);
                    ISolarItem solarItem = (ISolarItem)item.m_41720_();
                    if (solarType == null) {
                        solarType = solarItem.getType();
                    } else if (solarType != solarItem.getType()) {
                        canBonus = false;
                    }
                    switch (solarItem.getType()) {
                        case DAY: {
                            day += solarItem.getGenerationValue(meta);
                            break;
                        }
                        case NIGHT: {
                            night += solarItem.getGenerationValue(meta);
                            break;
                        }
                        case DAY_NIGHT: {
                            day_night += solarItem.getGenerationValue(meta);
                        }
                    }
                    int[] indexes1 = indexes[index];
                    ArrayList<BlockEntityMiniPanels.EnumState> enumStateList = new ArrayList<BlockEntityMiniPanels.EnumState>();
                    for (int i : indexes1) {
                        ItemStack stack = items.get(i);
                        if (stack == null || stack.m_41619_()) {
                            enumStateList.add(BlockEntityMiniPanels.EnumState.EMPTY);
                            continue;
                        }
                        int meta1 = ((SubEnum)((ItemMain)stack.m_41720_()).getElement()).getId();
                        int differenceMeta = Math.abs(meta - meta1);
                        if (differenceMeta == 0) {
                            enumStateList.add(BlockEntityMiniPanels.EnumState.STABLE);
                            continue;
                        }
                        if (differenceMeta == 1) {
                            enumStateList.add(BlockEntityMiniPanels.EnumState.NORMAL);
                            continue;
                        }
                        enumStateList.add(BlockEntityMiniPanels.EnumState.UNSTABLE);
                    }
                    solarTile.setStables(index, enumStateList);
                    ++index;
                }
                double load = ((double)max - (average /= (double)items.size())) * (double)max * 15.0;
                if (load >= 99.0 && max <= solarTile.getCoreLevel()) {
                    load = 99.0;
                }
                solarTile.setLoad(load);
                average = Math.floor(average);
                if (average == (double)max && canBonus) {
                    solarTile.setBonus(EnumTypeParts.GENERATION, 0.05 * (double)max);
                } else {
                    solarTile.setBonus(EnumTypeParts.GENERATION, 0.0);
                }
                solarTile.setGeneration(EnumSolarType.DAY, day);
                solarTile.setGeneration(EnumSolarType.NIGHT, night);
                solarTile.setGeneration(EnumSolarType.DAY_NIGHT, day_night);
            }
        }
    }

    static {
        indexes = new int[][]{{1, 3}, {2, 4}, {5}, {4, 6}, {5, 7}, {8}, {7}, {8}, new int[0]};
    }
}

