/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.reactors;

import com.denfop.api.reactors.EnumTypeComponent;
import com.denfop.api.reactors.IAdvReactor;
import com.denfop.api.reactors.IReactorItem;
import com.denfop.api.reactors.LogicCreativeComponent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import net.minecraft.world.item.ItemStack;

public class LogicCreativeReactor {
    public static Random rand = new Random();
    static LogicCreativeComponent NULL = new LogicCreativeComponent(new IReactorItem(){

        @Override
        public EnumTypeComponent getType() {
            return null;
        }

        @Override
        public int getLevel() {
            return 0;
        }

        @Override
        public int getAutoRepair(IAdvReactor reactor) {
            return 0;
        }

        @Override
        public int getRepairOther(IAdvReactor reactor) {
            return 0;
        }

        @Override
        public int getDamageCFromHeat(int heat, IAdvReactor reactor) {
            return 0;
        }

        @Override
        public int getHeat(IAdvReactor reactor) {
            return 0;
        }

        @Override
        public double getHeatRemovePercent(IAdvReactor reactor) {
            return 0.0;
        }

        @Override
        public void damageItem(ItemStack stack, int damage) {
        }

        @Override
        public boolean updatableItem() {
            return false;
        }

        @Override
        public boolean caneExtractHeat() {
            return false;
        }

        @Override
        public double getEnergyProduction(IAdvReactor reactor) {
            return 0.0;
        }

        @Override
        public boolean needClear(ItemStack stack) {
            return false;
        }
    }, -1, -1, ItemStack.f_41583_, null);
    protected final IAdvReactor reactor;
    protected final List<Integer> listIndexRod = new ArrayList<Integer>();
    protected final int x;
    protected final int y;
    protected List<LogicCreativeComponent> rodsList = new ArrayList<LogicCreativeComponent>();
    protected int generation;
    protected int rad_generation;
    List<ItemStack> infoStack = new LinkedList<ItemStack>();
    private List<LogicCreativeComponent> listComponent;
    private double maxHeat;

    public LogicCreativeReactor(IAdvReactor advReactor) {
        this.reactor = advReactor;
        this.x = this.reactor.getWidth();
        this.y = this.reactor.getHeight();
        this.listComponent = new ArrayList<LogicCreativeComponent>(Collections.nCopies(this.x * this.y, NULL));
        this.calculateComponent();
        for (LogicCreativeComponent component : this.listComponent) {
            ItemStack stack = component.getStack();
            boolean find = false;
            for (ItemStack stack1 : this.infoStack) {
                if (!stack1.m_150930_(stack.m_41720_())) continue;
                stack1.m_41769_(1);
                find = true;
                break;
            }
            if (find) continue;
            this.infoStack.add(stack.m_41777_());
        }
    }

    public List<ItemStack> getInfoStack() {
        return this.infoStack;
    }

    public int getGeneration() {
        return this.generation;
    }

    public void setGeneration(int generation) {
        this.generation = generation;
    }

    public int getRadGeneration() {
        return this.rad_generation;
    }

    public void setRadGeneration(int rad_generation) {
        this.rad_generation = rad_generation;
    }

    public void calculateComponent() {
        for (int j = 0; j < this.y; ++j) {
            for (int i = 0; i < this.x; ++i) {
                ItemStack stack = this.reactor.getItemAt(i, j);
                if (stack.m_41619_() || !(stack.m_41720_() instanceof IReactorItem)) continue;
                this.listComponent.set(i + this.x * j, new LogicCreativeComponent((IReactorItem)stack.m_41720_(), i, j, stack, this.reactor));
            }
        }
        this.listComponent.forEach(logicComponent -> logicComponent.updateAllInterface(this.listComponent, this.x, this.y, this.reactor));
        this.listComponent.removeIf(logicComponent -> logicComponent.getItem().getType() != EnumTypeComponent.ROD || logicComponent == NULL);
        this.rodsList = new ArrayList<LogicCreativeComponent>(this.listComponent);
        for (LogicCreativeComponent component : this.rodsList) {
            if (this.listIndexRod.contains(component.getX())) continue;
            this.listIndexRod.add(component.getX());
        }
        this.calculateFirstLogic(this.listComponent);
    }

    public List<LogicCreativeComponent> getListComponent() {
        return this.listComponent;
    }

    public List<Integer> getListIndexRod() {
        return this.listIndexRod;
    }

    private void calculateFirstLogic(List<LogicCreativeComponent> logicComponents) {
        ArrayList<LogicCreativeComponent> list = new ArrayList<LogicCreativeComponent>(logicComponents);
        ArrayList<LogicCreativeComponent> logicComponents1 = new ArrayList<LogicCreativeComponent>(logicComponents);
        ArrayList<LogicCreativeComponent> list1 = new ArrayList<LogicCreativeComponent>();
        this.maxHeat = 0.0;
        this.generation = 0;
        this.rad_generation = 0;
        while (!logicComponents1.isEmpty()) {
            ArrayList<LogicCreativeComponent> logicComponents2 = new ArrayList<LogicCreativeComponent>();
            for (LogicCreativeComponent component : logicComponents1) {
                boolean added = false;
                int col = 0;
                if (component == null || component.getItem() == null) continue;
                this.generation += (int)(component.getItem().getEnergyProduction(this.reactor) * this.reactor.getMulOutput(component.getX(), component.getY(), component.getStack()));
                this.rad_generation += (int)component.getItem().getRadiation();
                if (component.getItem().getType() == EnumTypeComponent.ENERGY_COUPLER) {
                    double temp_generation = 0.0;
                    double temp_rad_generation = 0.0;
                    int count = 0;
                    for (LogicCreativeComponent component1 : component.getLogicComponents()) {
                        if (component1.getItem().getType() != EnumTypeComponent.ROD) continue;
                        ++count;
                        temp_generation += component1.getItem().getEnergyProduction(this.reactor) * this.reactor.getMulOutput(component1.getX(), component1.getY(), component1.getStack()) * (0.45 + component.getItem().getEnergyProduction(this.reactor));
                        temp_rad_generation += component1.getItem().getRadiation() * component.getItem().getEnergyProduction(this.reactor);
                    }
                    if (count > 1) {
                        this.generation += (int)temp_generation;
                        this.rad_generation += (int)temp_rad_generation;
                    }
                }
                if (component.getItem().updatableItem() && !list1.contains(component)) {
                    list1.add(component);
                }
                for (LogicCreativeComponent lg : component.getLogicComponents()) {
                    if (list.contains(lg)) continue;
                    ++col;
                }
                if (component.getItem().getType() == EnumTypeComponent.ROD) {
                    boolean empty = true;
                    boolean coupler = false;
                    for (LogicCreativeComponent lg : component.getLogicComponents()) {
                        if (lg.getItem().getType() == EnumTypeComponent.ENERGY_COUPLER) {
                            coupler = true;
                            continue;
                        }
                        if (lg.getItem().getType() == EnumTypeComponent.ROD) continue;
                        empty = false;
                    }
                    if (empty && coupler) {
                        this.maxHeat += component.getHeat();
                    }
                }
                for (LogicCreativeComponent lg : component.getLogicComponents()) {
                    if (list.contains(lg) || lg == NULL) continue;
                    if (component.getItem().getType() == EnumTypeComponent.ROD && lg.getItem().getType() != EnumTypeComponent.ROD) {
                        ++lg.nearRod;
                    }
                    if (component.canExtractHeat()) {
                        double percent = lg.getItem().getHeatRemovePercent(this.reactor);
                        lg.heat += component.heat / (double)col * percent;
                        lg.damage = (int)(lg.heat / (double)lg.getItem().getDamageCFromHeat((int)lg.heat, this.reactor) - (double)lg.getItem().getAutoRepair(this.reactor));
                        if (lg.getItem().getType() == EnumTypeComponent.COOLANT_ROD) {
                            lg.damage *= 10;
                        }
                        if (component.getItem().getType() == EnumTypeComponent.ROD && lg.getItem().getType() == EnumTypeComponent.PLATE) {
                            lg.heat *= 1.5;
                        }
                        if (lg.getItem().getType() == EnumTypeComponent.CAPACITOR) {
                            lg.damage *= 3;
                        }
                        added = true;
                    }
                    if (logicComponents2.contains(lg)) continue;
                    logicComponents2.add(lg);
                }
                if (added) continue;
                this.maxHeat += component.getHeat();
            }
            logicComponents1.clear();
            logicComponents1.addAll(logicComponents2);
            list.addAll(logicComponents2);
        }
        this.listComponent = list1;
        this.listComponent.forEach(LogicCreativeComponent::calculateDamageOther);
    }

    public void onTick() {
        ArrayList<LogicCreativeComponent> logicComponentList = new ArrayList<LogicCreativeComponent>();
        for (LogicCreativeComponent component : this.listComponent) {
            boolean tick = component.onTick();
            if (!tick) continue;
            logicComponentList.add(component);
        }
        if (!logicComponentList.isEmpty()) {
            logicComponentList.forEach(logicComponent -> this.reactor.setItemAt(logicComponent.getX(), logicComponent.getY()));
            this.reactor.setUpdate();
        }
        if (this.getMaxHeat() > (double)this.reactor.getMaxHeat() * 1.15) {
            this.reactor.setHeat(this.reactor.getHeat() * 0.5);
        }
        if (!this.rodsList.isEmpty()) {
            this.reactor.setOutput(this.generation);
        } else {
            this.reactor.setOutput(0.0);
        }
        this.reactor.setRad(this.rad_generation);
    }

    public List<LogicCreativeComponent> getRodsList() {
        return this.rodsList;
    }

    public double getMaxHeat() {
        return this.maxHeat;
    }
}

