/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.pollution.radiation;

import com.denfop.api.item.armor.HazmatLike;
import com.denfop.api.pollution.radiation.EnumLevelRadiation;
import com.denfop.api.pollution.radiation.EventHandler;
import com.denfop.api.pollution.radiation.Radiation;
import com.denfop.api.reactors.IAdvReactor;
import com.denfop.config.ModConfig;
import com.denfop.network.packet.PacketRadiation;
import com.denfop.network.packet.PacketUpdateRadiation;
import com.denfop.potion.IUPotion;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;

public class RadiationSystem {
    public static RadiationSystem rad_system;
    public List<Radiation> radiationList = new ArrayList<Radiation>();
    Map<ChunkPos, Radiation> map = new HashMap<ChunkPos, Radiation>();
    Map<ChunkPos, List<IAdvReactor>> iAdvReactorMap = new HashMap<ChunkPos, List<IAdvReactor>>();

    public RadiationSystem() {
        rad_system = this;
        MinecraftForge.EVENT_BUS.register((Object)new EventHandler());
    }

    public Map<ChunkPos, List<IAdvReactor>> getAdvReactorMap() {
        return this.iAdvReactorMap;
    }

    public void work(Player player) {
        if (player.m_9236_().m_46472_() != Level.f_46428_ || player.m_9236_().f_46443_) {
            return;
        }
        if (player.m_9236_().m_46467_() % 200L == 0L) {
            ChunkPos pos = new ChunkPos(player.m_20183_());
            Radiation rad = this.map.get(pos);
            if (rad != null) {
                if (!HazmatLike.hasCompleteHazmat((LivingEntity)player, rad.getLevel())) {
                    rad.process(player);
                }
            } else {
                if (!((Boolean)ModConfig.COMMON.radiationDamageEnabled.get()).booleanValue()) {
                    return;
                }
                double radiation = player.getPersistentData().m_128459_("radiation");
                if (radiation >= 50.0) {
                    player.m_7292_(new MobEffectInstance((MobEffect)IUPotion.radiation, 43200, 0));
                    player.m_7292_(new MobEffectInstance(MobEffects.f_19615_, 400, 0));
                } else if (radiation >= 10.0) {
                    player.m_7292_(new MobEffectInstance((MobEffect)IUPotion.radiation, 1000, 0));
                    player.m_7292_(new MobEffectInstance(MobEffects.f_19614_, 200, 0));
                } else if (radiation >= 1.0) {
                    player.m_7292_(new MobEffectInstance((MobEffect)IUPotion.radiation, 200, 0));
                    player.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 200, 0));
                }
            }
        }
    }

    public Map<ChunkPos, Radiation> getMap() {
        return this.map;
    }

    public List<Radiation> getRadiationList() {
        return this.radiationList;
    }

    public void addRadiation(CompoundTag tagCompound) {
        Radiation rad = new Radiation(tagCompound);
        if (!this.map.containsKey(rad.getPos())) {
            this.map.put(rad.getPos(), rad);
            this.radiationList.add(rad);
        }
    }

    public void addRadiation(Radiation radiation) {
        if (!this.map.containsKey(radiation.getPos())) {
            this.map.put(radiation.getPos(), radiation);
            this.radiationList.add(radiation);
        }
    }

    public void update(Player player) {
        new PacketRadiation(this.radiationList, player);
    }

    public void addRadiationWihoutUpdate(Radiation radiation) {
        if (!this.map.containsKey(radiation.getPos())) {
            this.map.put(radiation.getPos(), radiation);
            this.radiationList.add(radiation);
        }
    }

    public void workDecay(Level world) {
        try {
            for (Radiation radiation : this.radiationList) {
                if (!((Boolean)ModConfig.COMMON.radiationChunksEnabled.get()).booleanValue()) {
                    radiation.setRadiation(0.0);
                    radiation.setLevel(EnumLevelRadiation.LOW);
                    new PacketUpdateRadiation(radiation);
                }
                if (!(radiation.getRadiation() > 0.0)) continue;
                switch (radiation.getLevel()) {
                    case LOW: {
                        if (world.m_46467_() % 36000L != 0L) break;
                        if (radiation.getRadiation() > 1.0) {
                            radiation.removeRadiation(radiation.getRadiation() / 2.0);
                        } else {
                            radiation.removeRadiation(radiation.getRadiation());
                        }
                        new PacketUpdateRadiation(radiation);
                        break;
                    }
                    case DEFAULT: {
                        if (world.m_46467_() % 18000L != 0L) break;
                        if (radiation.getRadiation() > 1.0) {
                            radiation.removeRadiation(radiation.getRadiation() / 2.0);
                        } else {
                            radiation.removeRadiation(radiation.getRadiation());
                        }
                        new PacketUpdateRadiation(radiation);
                        break;
                    }
                    case MEDIUM: {
                        if (world.m_46467_() % 12000L != 0L) break;
                        if (radiation.getRadiation() > 1.0) {
                            radiation.removeRadiation(radiation.getRadiation() / 2.0);
                        } else {
                            radiation.removeRadiation(radiation.getRadiation());
                        }
                        new PacketUpdateRadiation(radiation);
                        break;
                    }
                    case HIGH: {
                        if (world.m_46467_() % 6000L != 0L) break;
                        if (radiation.getRadiation() > 1.0) {
                            radiation.removeRadiation(radiation.getRadiation() / 2.0);
                        } else {
                            radiation.removeRadiation(radiation.getRadiation());
                        }
                        new PacketUpdateRadiation(radiation);
                        break;
                    }
                    case VERY_HIGH: {
                        if (world.m_46467_() % 2400L != 0L) break;
                        if (radiation.getRadiation() > 1.0) {
                            radiation.removeRadiation(radiation.getRadiation() / 2.0);
                        } else {
                            radiation.removeRadiation(radiation.getRadiation());
                        }
                        new PacketUpdateRadiation(radiation);
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void clear() {
        this.map.clear();
        this.radiationList.clear();
    }
}

