/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.item.upgrade;

import com.denfop.IUItem;
import com.denfop.api.Recipes;
import com.denfop.api.item.upgrade.LevelInstruments;
import com.denfop.api.item.upgrade.UpgradeBaseSystem;
import com.denfop.api.item.upgrade.UpgradeItem;
import com.denfop.api.item.upgrade.UpgradeItemInform;
import com.denfop.api.item.upgrade.UpgradeModificator;
import com.denfop.api.item.upgrade.UpgradeWithBlackList;
import com.denfop.api.item.upgrade.event.EventItemBlackListLoad;
import com.denfop.api.item.upgrade.event.EventItemLoad;
import com.denfop.api.recipe.BaseMachineRecipe;
import com.denfop.api.recipe.Input;
import com.denfop.api.recipe.RecipeOutput;
import com.denfop.items.EnumInfoUpgradeModules;
import com.denfop.items.modules.ItemUpgradeModule;
import com.denfop.recipe.IInputHandler;
import com.denfop.utils.ModUtils;
import java.lang.invoke.CallSite;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class BaseUpgradeSystem
implements UpgradeBaseSystem {
    Map<Integer, List<UpgradeItemInform>> map = new HashMap<Integer, List<UpgradeItemInform>>();
    Map<Integer, List<UpgradeModificator>> map_modification;
    Map<Integer, ItemStack> map_stack;
    Map<Integer, Integer> map_col;
    Map<Integer, List<Integer>> levelMap;
    Map<Integer, List<String>> map_blackList = new HashMap<Integer, List<String>>();
    List<UpgradeModificator> list_modificators;
    int max = 0;

    public BaseUpgradeSystem() {
        this.map_col = new HashMap<Integer, Integer>();
        this.map_stack = new HashMap<Integer, ItemStack>();
        this.levelMap = new HashMap<Integer, List<Integer>>();
        this.list_modificators = new ArrayList<UpgradeModificator>();
        this.map_modification = new HashMap<Integer, List<UpgradeModificator>>();
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public static void addupgrade(Item container, ItemStack fill) {
        CompoundTag nbt = ModUtils.nbt();
        nbt.m_128359_("mode_module", fill.m_41720_() instanceof ItemUpgradeModule ? ItemUpgradeModule.getType((int)IUItem.upgrademodule.getMeta((ItemUpgradeModule)((ItemUpgradeModule)fill.m_41720_()))).name : "blacklist");
        IInputHandler input = Recipes.inputFactory;
        Recipes.recipes.addRecipe("upgradeblock", new BaseMachineRecipe(new Input(input.getInput(new ItemStack((ItemLike)container, 1)), input.getInput(fill)), new RecipeOutput(nbt, new ItemStack((ItemLike)container, 1))));
        Recipes.recipes.addRecipe("antiupgradeblock", new BaseMachineRecipe(new Input(input.getInput(new ItemStack((ItemLike)container, 1))), new RecipeOutput(nbt, fill)));
    }

    public static void addupgrade(Item container, ItemStack fill, String type) {
        CompoundTag nbt = ModUtils.nbt();
        nbt.m_128359_("type", type);
        IInputHandler input = Recipes.inputFactory;
        Recipes.recipes.addRecipe("upgradeblock", new BaseMachineRecipe(new Input(input.getInput(new ItemStack((ItemLike)container, 1)), input.getInput(fill)), new RecipeOutput(nbt, new ItemStack((ItemLike)container, 1))));
    }

    @Override
    public void addModification() {
        if (this.list_modificators.isEmpty()) {
            this.list_modificators.add(new UpgradeModificator(IUItem.core.getRegistryObject(7), "0"));
            this.list_modificators.add(new UpgradeModificator(IUItem.neutroniumingot.getRegistryObject(), "1"));
        }
    }

    public List<Integer> getPositiveUpgradeFromLevel(ItemStack stack) {
        if (stack.m_41720_() instanceof LevelInstruments) {
            LevelInstruments levelInstruments = (LevelInstruments)stack.m_41720_();
            int level = levelInstruments.getLevel(stack);
            int speed = level / 2;
            int less_draw_energy = level / 5;
            int lucky = level / 10;
            int area = level / 15;
            int depth = level / 20;
            ArrayList<Integer> integers = new ArrayList<Integer>();
            integers.add(speed);
            integers.add(less_draw_energy);
            integers.add(lucky);
            integers.add(area);
            integers.add(depth);
            return integers;
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public void addModificate(ItemStack container, String name) {
        CompoundTag nbt = ModUtils.nbt(container);
        ListTag modificationsTagList = nbt.m_128437_("modifications", 10);
        for (int i = 0; i < this.list_modificators.size(); ++i) {
            UpgradeModificator modificator = this.list_modificators.get(i);
            if (!modificator.matches(name)) continue;
            CompoundTag tagCompound = new CompoundTag();
            tagCompound.m_128405_("index", i);
            modificationsTagList.add((Object)tagCompound);
            nbt.m_128365_("modifications", (Tag)modificationsTagList);
            break;
        }
    }

    @Override
    public boolean needModificate(ItemStack container, ItemStack fill) {
        List<UpgradeModificator> list = this.getListModifications(container);
        for (UpgradeModificator modificator : list) {
            if (!modificator.matches(fill)) continue;
            return false;
        }
        return true;
    }

    @SubscribeEvent
    public void loadItem(EventItemLoad event) {
        this.updateListFromNBT(event.item, event.stack);
    }

    @SubscribeEvent
    public void loadItem(EventItemBlackListLoad event) {
        this.updateBlackListFromNBT(event.item, event.stack, event.nbt);
    }

    @Override
    public boolean getModifications(ItemStack item) {
        return this.map_modification.containsKey(ModUtils.nbt(item).m_128451_("ID_Item"));
    }

    @Override
    public List<UpgradeModificator> getListModifications(ItemStack item) {
        int id = ModUtils.nbt(item).m_128451_("ID_Item");
        ArrayList list = this.map_modification.get(id);
        return list != null ? list : new ArrayList();
    }

    @Override
    public int getRemaining(ItemStack item) {
        CompoundTag nbt = ModUtils.nbt(item);
        int id = nbt.m_128451_("ID_Item");
        int k = this.getListModifications(item).size();
        return this.map_col.getOrDefault(id, 4 + k);
    }

    @Override
    public boolean hasBlackList(ItemStack item) {
        CompoundTag nbt = ModUtils.nbt(item);
        int id = nbt.m_128451_("ID_Item");
        return this.map_blackList.containsKey(id);
    }

    @Override
    public boolean hasInMap(ItemStack stack) {
        CompoundTag nbt = ModUtils.nbt(stack);
        int id = nbt.m_128451_("ID_Item");
        ItemStack item = this.map_stack.get(id);
        if (item == null || item.m_41619_()) {
            return false;
        }
        int id1 = ModUtils.nbt(item).m_128451_("ID_Item");
        return item.m_150930_(stack.m_41720_()) && id1 == id && item.m_41783_() != null && item.m_41783_().equals((Object)stack.m_41783_());
    }

    @Override
    public List<String> getBlackList(ItemStack item) {
        CompoundTag nbt = ModUtils.nbt(item);
        int id = nbt.m_128451_("ID_Item");
        List<String> list = this.map_blackList.get(id);
        return list != null ? list : Collections.emptyList();
    }

    @Override
    public List<UpgradeItemInform> getInformation(ItemStack item) {
        CompoundTag nbt = ModUtils.nbt(item);
        int id = nbt.m_128451_("ID_Item");
        List<UpgradeItemInform> list = this.map.get(id);
        return list != null ? list : Collections.emptyList();
    }

    @Override
    public List<String> getAvailableUpgrade(UpgradeItem upgradeItem, ItemStack item) {
        CompoundTag nbt = ModUtils.nbt(item);
        int id = nbt.m_128451_("ID_Item");
        List<UpgradeItemInform> list = this.map.get(id);
        List<EnumInfoUpgradeModules> list1 = upgradeItem.getUpgradeModules();
        LinkedList<CallSite> stringList = new LinkedList<CallSite>();
        block0: for (EnumInfoUpgradeModules enumInfoUpgradeModules : list1) {
            for (UpgradeItemInform upgradeItemInform : list) {
                if (!upgradeItemInform.upgrade.equals((Object)enumInfoUpgradeModules)) continue;
                if (upgradeItemInform.number >= upgradeItemInform.upgrade.max) continue block0;
                stringList.add((CallSite)((Object)(ChatFormatting.GREEN + (upgradeItemInform.upgrade.max - upgradeItemInform.number) + "x " + new ItemStack((ItemLike)IUItem.upgrademodule.getItemFromMeta(enumInfoUpgradeModules.ordinal()), 1).m_41611_().getString())));
                continue block0;
            }
            stringList.add((CallSite)((Object)(ChatFormatting.GREEN + enumInfoUpgradeModules.max + "x " + new ItemStack((ItemLike)IUItem.upgrademodule.getItemFromMeta(enumInfoUpgradeModules.ordinal()), 1).m_41611_().getString())));
        }
        return list != null ? stringList : Collections.emptyList();
    }

    @Override
    public UpgradeItemInform getModules(EnumInfoUpgradeModules module, ItemStack item) {
        List<UpgradeItemInform> list = this.getInformation(item);
        for (UpgradeItemInform upgrade : list) {
            if (!upgrade.matched(module)) continue;
            return upgrade;
        }
        return null;
    }

    @Override
    public UpgradeItemInform getModules(EnumInfoUpgradeModules module, ItemStack item, List<UpgradeItemInform> list) {
        for (UpgradeItemInform upgrade : list) {
            if (!upgrade.matched(module)) continue;
            return upgrade;
        }
        return null;
    }

    @Override
    public boolean hasModules(EnumInfoUpgradeModules module, ItemStack item) {
        if (!(item.m_41720_() instanceof UpgradeItem)) {
            return false;
        }
        List<UpgradeItemInform> list = this.getInformation(item);
        for (UpgradeItemInform upgrade : list) {
            if (!upgrade.matched(module)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasModules(EnumInfoUpgradeModules module, ItemStack item, List<UpgradeItemInform> list) {
        if (!(item.m_41720_() instanceof UpgradeItem)) {
            return false;
        }
        for (UpgradeItemInform upgrade : list) {
            if (!upgrade.matched(module)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void updateListFromNBT(UpgradeItem item, ItemStack stack) {
        CompoundTag nbt = ModUtils.nbt(stack);
        boolean hasID = nbt.m_128471_("hasID");
        int id = nbt.m_128451_("ID_Item");
        if (!hasID) {
            id = this.max++;
            nbt.m_128405_("ID_Item", id);
            nbt.m_128379_("hasID", true);
        }
        ListTag modificationsTagList = nbt.m_128437_("modifications", 10);
        ArrayList<UpgradeModificator> list = new ArrayList<UpgradeModificator>();
        this.addModification();
        for (int i = 0; i < modificationsTagList.size(); ++i) {
            CompoundTag modificationTag = modificationsTagList.m_128728_(i);
            int index = modificationTag.m_128451_("index");
            if (this.getModification(index) == null) continue;
            list.add(this.getModification(index));
        }
        List<UpgradeModificator> list1 = this.map_modification.get(id);
        if (list1 != null) {
            list1.clear();
            list1.addAll(list);
        } else {
            this.map_modification.put(id, list);
        }
        ListTag modesTagList = nbt.m_128437_("modes", 10);
        ArrayList<EnumInfoUpgradeModules> lst = new ArrayList<EnumInfoUpgradeModules>();
        for (int i = 0; i < modesTagList.size(); ++i) {
            CompoundTag modeTag = modesTagList.m_128728_(i);
            int index = modeTag.m_128451_("index");
            lst.add(EnumInfoUpgradeModules.getFromID(index));
        }
        int ost = modificationsTagList.size() + 4 - modesTagList.size();
        nbt.m_128379_("canupgrade", ost > 0);
        if (this.map_col.containsKey(id)) {
            this.map_col.replace(id, ost);
        } else {
            this.map_col.put(id, ost);
        }
        if (this.levelMap.containsKey(id)) {
            this.levelMap.replace(id, this.getPositiveUpgradeFromLevel(stack));
        } else {
            this.levelMap.put(id, this.getPositiveUpgradeFromLevel(stack));
        }
        this.setInformation(item, lst, stack);
    }

    public List<Integer> getLevel(ItemStack stack) {
        List<Integer> level;
        CompoundTag nbt = ModUtils.nbt(stack);
        int id = nbt.m_128451_("ID_Item");
        if (this.levelMap.containsKey(id)) {
            level = this.getPositiveUpgradeFromLevel(stack);
            this.levelMap.replace(id, level);
        } else {
            level = this.getPositiveUpgradeFromLevel(stack);
            this.levelMap.put(id, level);
        }
        return level;
    }

    @Override
    public List<Integer> getUpgradeFromList(ItemStack stack) {
        CompoundTag nbt = ModUtils.nbt(stack);
        int id = nbt.m_128451_("ID_Item");
        return this.levelMap.getOrDefault(id, this.getLevel(stack));
    }

    private UpgradeModificator getModification(int i) {
        if (i == 0) {
            return this.list_modificators.get(0);
        }
        if (i == 1) {
            return this.list_modificators.get(1);
        }
        return null;
    }

    @Override
    public void setInformation(UpgradeItem item, List<EnumInfoUpgradeModules> lst, ItemStack stack) {
        this.write(item, lst, stack);
    }

    @SubscribeEvent
    public void onWorldUnload(LevelEvent.Unload event) {
        if (event.getLevel().m_5776_()) {
            return;
        }
        this.map.clear();
        this.map_blackList.clear();
        this.max = 0;
        this.map_col.clear();
        this.map_stack.clear();
        this.list_modificators.clear();
        this.map_modification.clear();
        this.levelMap.clear();
    }

    @Override
    public void write(UpgradeItem item, List<EnumInfoUpgradeModules> lst, ItemStack stack) {
        CompoundTag nbt = ModUtils.nbt(stack);
        int id = nbt.m_128451_("ID_Item");
        Map<EnumInfoUpgradeModules, Integer> moduleCounts = lst.stream().collect(Collectors.toMap(module -> module, module -> 1, Integer::sum));
        List upgrades = moduleCounts.entrySet().stream().map(entry -> new UpgradeItemInform((EnumInfoUpgradeModules)((Object)((Object)entry.getKey())), (Integer)entry.getValue())).collect(Collectors.toList());
        this.map.put(id, upgrades);
        this.map_stack.put(id, stack);
        Map enchantmentMap = EnchantmentHelper.m_44831_((ItemStack)stack);
        this.updateEnchantment(enchantmentMap, Enchantments.f_44985_, EnumInfoUpgradeModules.SILK_TOUCH, 1, stack);
        this.updateEnchantment(enchantmentMap, Enchantments.f_44987_, EnumInfoUpgradeModules.LUCKY, this.getModulesValue(EnumInfoUpgradeModules.LUCKY, stack), stack);
        this.updateEnchantment(enchantmentMap, Enchantments.f_44984_, EnumInfoUpgradeModules.EFFICIENT, this.calculateEfficiencyLevel(stack), stack);
        this.updateEnchantment(enchantmentMap, Enchantments.f_44981_, EnumInfoUpgradeModules.FIRE, this.getModulesValue(EnumInfoUpgradeModules.FIRE, stack), stack);
        this.updateEnchantment(enchantmentMap, Enchantments.f_44982_, EnumInfoUpgradeModules.LOOT, this.getModulesValue(EnumInfoUpgradeModules.LOOT, stack), stack);
        this.updateEnchantment(enchantmentMap, Enchantments.f_44969_, EnumInfoUpgradeModules.PROTECTION_ARROW, this.calculateProjectileProtectionLevel(stack), stack);
        EnchantmentHelper.m_44865_((Map)enchantmentMap, (ItemStack)stack);
    }

    private void updateEnchantment(Map<Enchantment, Integer> enchantmentMap, Enchantment enchantment, EnumInfoUpgradeModules module, int level, ItemStack stack) {
        if (this.hasModules(module, stack)) {
            enchantmentMap.put(enchantment, level);
        } else {
            enchantmentMap.remove(enchantment);
        }
    }

    private int getModulesValue(EnumInfoUpgradeModules module, ItemStack stack) {
        UpgradeItemInform modules = this.getModules(module, stack);
        if (modules == null) {
            return 0;
        }
        return modules.number;
    }

    private int calculateEfficiencyLevel(ItemStack stack) {
        int baseLevel = 1;
        int moduleLevel = this.getModulesValue(EnumInfoUpgradeModules.EFFICIENT, stack);
        if (moduleLevel == 0) {
            return 0;
        }
        return baseLevel + (moduleLevel - 1) * 2;
    }

    private int calculateProjectileProtectionLevel(ItemStack stack) {
        int baseLevel = 1;
        int moduleLevel = this.getModulesValue(EnumInfoUpgradeModules.PROTECTION_ARROW, stack);
        if (moduleLevel == 0) {
            return 0;
        }
        return baseLevel + (moduleLevel - 1) * 2;
    }

    @Override
    public void updateBlackListFromNBT(UpgradeWithBlackList item, ItemStack stack, CompoundTag nbt) {
        this.updateListFromNBT(item, stack);
        int id = nbt.m_128451_("ID_Item");
        ListTag tagList = nbt.m_128437_("blacklist", 8);
        AbstractList blacklist = new LinkedList<String>();
        for (int i = 0; i < tagList.size(); ++i) {
            blacklist.add(tagList.m_128778_(i));
        }
        blacklist = new ArrayList(blacklist);
        nbt.m_128379_("accept_blacklist", true);
        if (this.map_blackList.containsKey(id)) {
            this.map_blackList.replace(id, blacklist);
        } else {
            this.map_blackList.put(id, blacklist);
        }
    }

    @Override
    public void updateLevel(ItemStack stack) {
        CompoundTag nbt = ModUtils.nbt(stack);
        int id = nbt.m_128451_("ID_Item");
        if (this.levelMap.containsKey(id)) {
            this.levelMap.replace(id, this.getPositiveUpgradeFromLevel(stack));
        } else {
            this.levelMap.put(id, this.getPositiveUpgradeFromLevel(stack));
        }
    }

    @Override
    public void updateBlackListFromStack(ItemStack stack) {
        AbstractList lst = new LinkedList<String>();
        CompoundTag nbt = ModUtils.nbt(stack);
        ListTag tagList = nbt.m_128437_("blacklist", 8);
        for (int i = 0; i < tagList.size(); ++i) {
            lst.add(tagList.m_128778_(i));
        }
        lst = new ArrayList(lst);
        int id = nbt.m_128451_("ID_Item");
        nbt.m_128379_("accept_blacklist", true);
        this.map_blackList.put(id, lst);
    }

    @Override
    public void removeUpdate(ItemStack stack, Level world, int index) {
        CompoundTag nbt = ModUtils.nbt(stack);
        ListTag modesTagList = nbt.m_128437_("modes", 10);
        int i = 0;
        for (int ii = 0; ii < modesTagList.size(); ++ii) {
            CompoundTag tagCompound = modesTagList.m_128728_(ii);
            if (tagCompound.m_128451_("index") != index) continue;
            i = ii;
            break;
        }
        modesTagList.remove(i);
        MinecraftForge.EVENT_BUS.post((Event)new EventItemLoad(world, (UpgradeItem)stack.m_41720_(), stack));
    }

    @Override
    public List<ItemStack> getListStack(ItemStack stack) {
        LinkedList<ItemStack> list = new LinkedList<ItemStack>();
        CompoundTag nbt = ModUtils.nbt(stack);
        ListTag modesTagList = nbt.m_128437_("modes", 10);
        for (int ii = 0; ii < modesTagList.size(); ++ii) {
            CompoundTag tagCompound = modesTagList.m_128728_(ii);
            list.add(new ItemStack((ItemLike)IUItem.upgrademodule.getItemFromMeta(tagCompound.m_128451_("index")), 1));
        }
        return list;
    }

    @Override
    public void addRecipe(Item stack, List<EnumInfoUpgradeModules> lst) {
        for (EnumInfoUpgradeModules upgrades : lst) {
            BaseUpgradeSystem.addupgrade(stack, new ItemStack((ItemLike)IUItem.upgrademodule.getStack(upgrades.ordinal()), 1));
        }
        if (lst.contains((Object)EnumInfoUpgradeModules.DIG_DEPTH)) {
            BaseUpgradeSystem.addupgrade(stack, new ItemStack((ItemLike)IUItem.module9.getStack(12), 1));
        }
        for (UpgradeModificator modificator : this.list_modificators) {
            BaseUpgradeSystem.addupgrade(stack, new ItemStack((ItemLike)modificator.itemstack.get()), modificator.type);
        }
    }

    @Override
    public boolean shouldUpdate(EnumInfoUpgradeModules type, ItemStack stack1) {
        List<UpgradeItemInform> list = this.getInformation(stack1);
        for (UpgradeItemInform inform : list) {
            if (inform.upgrade != type || inform.number < type.max) continue;
            return false;
        }
        return true;
    }
}

