/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.energy.networking;

import com.denfop.api.energy.interfaces.EnergySink;
import com.denfop.api.energy.networking.ConductorInfo;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.Direction;

public class Path {
    public final EnergySink target;
    public final Direction targetDirection;
    public Direction sourceDirection;
    double min = Double.MAX_VALUE;
    double loss = 0.0;
    boolean hasController = false;
    boolean isLimit = false;
    double limit_amount = Double.MAX_VALUE;
    double adding = 0.0;
    List<ConductorInfo> conductorList = new LinkedList<ConductorInfo>();

    Path(EnergySink sink, Direction facing) {
        this.target = sink;
        this.targetDirection = facing;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass() && !(o instanceof EnergySink)) {
            return false;
        }
        if (o instanceof EnergySink) {
            EnergySink energySink = (EnergySink)o;
            return energySink == this.target;
        }
        Path path = (Path)o;
        return this.target == path.target;
    }

    public int hashCode() {
        return Objects.hash(this.target);
    }

    public void setHasController(boolean hasController) {
        this.hasController = hasController;
    }

    public double getMin() {
        return this.min;
    }

    public void setMin(double min) {
        this.min = min;
    }

    public void tick(int tick, double adding) {
        if (this.target.isSink()) {
            if (this.target.getTick() != (double)tick) {
                this.target.addTick(tick);
                this.target.setPastEnergy(this.target.getPerEnergy());
            }
            this.target.addPerEnergy(adding);
        }
    }

    public List<ConductorInfo> getConductorList() {
        return this.conductorList;
    }
}

