/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.energy.forgeenergy;

import com.denfop.api.energy.forgeenergy.EnergyForge;
import com.denfop.api.energy.interfaces.EnergyAcceptor;
import com.denfop.api.energy.interfaces.EnergySource;
import com.denfop.api.energy.networking.EnergyNetGlobal;
import java.util.Map;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.energy.IEnergyStorage;

public class EnergyForgeSource
extends EnergyForge
implements EnergySource {
    private double perenergy;
    private double pastEnergy;
    private double tick;

    public EnergyForgeSource(BlockEntity blockEntity) {
        super(blockEntity);
    }

    @Override
    public double getPerEnergy() {
        return this.perenergy;
    }

    @Override
    public double getPastEnergy() {
        return this.pastEnergy;
    }

    @Override
    public void setPastEnergy(double pastEnergy) {
        this.pastEnergy = pastEnergy;
    }

    @Override
    public void addPerEnergy(double setEnergy) {
        this.perenergy += setEnergy;
    }

    @Override
    public boolean isSource() {
        return true;
    }

    @Override
    public double canExtractEnergy(Direction direction) {
        IEnergyStorage energy = (IEnergyStorage)this.storages.get(direction);
        if (energy == null) {
            return 0.0;
        }
        return (double)((IEnergyStorage)this.storages.get(direction)).extractEnergy(Integer.MAX_VALUE, true) / 4.0;
    }

    @Override
    public double canExtractEnergy() {
        int amount = 0;
        for (Map.Entry storage : this.storages.entrySet()) {
            if (storage.getValue() == null || !((IEnergyStorage)storage.getValue()).canExtract()) continue;
            amount += ((IEnergyStorage)storage.getValue()).extractEnergy(Integer.MAX_VALUE, true) / 4;
        }
        return amount;
    }

    @Override
    public int getSourceTier(Direction direction) {
        IEnergyStorage energyStorage = (IEnergyStorage)this.storages.get(direction);
        return EnergyNetGlobal.instance.getTierFromPower((double)energyStorage.extractEnergy(Integer.MAX_VALUE, true) / 4.0);
    }

    @Override
    public void extractEnergy(Direction direction, double var1) {
        ((IEnergyStorage)this.storages.get(direction)).extractEnergy((int)(var1 * 4.0), false);
    }

    @Override
    public void extractEnergy(double var1) {
    }

    @Override
    public int getSourceTier() {
        return 1;
    }

    @Override
    public boolean emitsEnergyTo(EnergyAcceptor var1, Direction var2) {
        IEnergyStorage energyStorage = (IEnergyStorage)this.storages.get(var2);
        return energyStorage != null && energyStorage.canExtract();
    }
}

