/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.crafting;

import com.denfop.api.Recipes;
import com.denfop.items.ItemToolCrafting;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.recipe.IInputItemStack;
import com.denfop.recipe.IngredientInput;
import com.denfop.recipe.InputItemStack;
import com.denfop.recipe.InputOreDict;
import com.denfop.register.Register;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.Level;

public class BaseShapelessRecipe
extends ShapelessRecipe {
    final NonNullList<Ingredient> listIngridient;
    private final ItemStack output;
    private final List<IInputItemStack> recipeInputList;
    private final String id;
    private ResourceLocation name;

    public BaseShapelessRecipe(ResourceLocation id, String group, CraftingBookCategory category, ItemStack output, List<IInputItemStack> recipeInputList) {
        super(id, group, category, output, NonNullList.m_122779_());
        this.id = "";
        this.output = output;
        this.recipeInputList = recipeInputList;
        this.listIngridient = NonNullList.m_122779_();
        for (IInputItemStack input : this.recipeInputList) {
            this.listIngridient.add((Object)new IngredientInput(input).getInput());
        }
    }

    public BaseShapelessRecipe(ItemStack output, List<IInputItemStack> recipeInputList) {
        super(ResourceLocation.m_135820_((String)"minecraft:minecraft"), "", CraftingBookCategory.MISC, output, NonNullList.m_122779_());
        this.output = output;
        this.recipeInputList = recipeInputList;
        this.listIngridient = NonNullList.m_122779_();
        for (IInputItemStack input : this.recipeInputList) {
            this.listIngridient.add((Object)new IngredientInput(input).getInput());
        }
        this.id = Recipes.registerRecipe((Recipe)this);
    }

    public static BaseShapelessRecipe create(ResourceLocation id, CustomPacketBuffer customPacketBuffer) {
        try {
            String group = (String)DecoderHandler.decode(customPacketBuffer);
            int category = (Integer)DecoderHandler.decode(customPacketBuffer);
            ItemStack output = (ItemStack)DecoderHandler.decode(customPacketBuffer);
            ArrayList<IInputItemStack> recipeInputList = new ArrayList<IInputItemStack>();
            int size = customPacketBuffer.readInt();
            for (int i = 0; i < size; ++i) {
                recipeInputList.add(InputItemStack.create((CompoundTag)DecoderHandler.decode(customPacketBuffer)));
            }
            return new BaseShapelessRecipe(id, group, CraftingBookCategory.values()[category], output, recipeInputList);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public List<IInputItemStack> getRecipeInputList() {
        return this.recipeInputList;
    }

    public ItemStack getOutput() {
        return this.output;
    }

    public ItemStack matches(CraftingContainer inv) {
        for (int i = 0; i < this.recipeInputList.size(); ++i) {
            IInputItemStack input = this.recipeInputList.get(i);
            if (!(input instanceof InputOreDict) || !input.hasTag() || !input.getInputs().isEmpty()) continue;
            this.recipeInputList.set(i, new InputOreDict(input.getTag(), input.getAmount()));
        }
        ArrayList<IInputItemStack> recipeInputList1 = new ArrayList<IInputItemStack>(this.recipeInputList);
        block1: for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            Iterator iter = recipeInputList1.iterator();
            while (iter.hasNext()) {
                IInputItemStack recipeInput = (IInputItemStack)iter.next();
                if (!recipeInput.matches(stack)) continue;
                iter.remove();
                continue block1;
            }
        }
        if (!recipeInputList1.isEmpty()) {
            return ItemStack.f_41583_;
        }
        int col = 0;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_41619_()) continue;
            ++col;
        }
        if (col == this.recipeInputList.size()) {
            return this.output.m_41777_();
        }
        return ItemStack.f_41583_;
    }

    public boolean m_5818_(CraftingContainer p_44002_, Level p_44003_) {
        return this.matches(p_44002_) != ItemStack.f_41583_;
    }

    public ItemStack m_5874_(CraftingContainer craftingContainer, RegistryAccess registryAccess) {
        return this.output.m_41777_();
    }

    public boolean m_8004_(int x, int y) {
        return x * y >= this.recipeInputList.size();
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return this.output.m_41777_();
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer p_44004_) {
        NonNullList list = NonNullList.m_122780_((int)p_44004_.m_6643_(), (Object)ItemStack.f_41583_);
        for (int i = 0; i < p_44004_.m_6643_(); ++i) {
            ItemStack stack = p_44004_.m_8020_(i);
            if (!(stack.m_41720_() instanceof ItemToolCrafting)) continue;
            stack = stack.m_41720_().getCraftingRemainingItem(stack);
            list.set(i, (Object)stack);
        }
        return list;
    }

    public NonNullList<Ingredient> m_7527_() {
        NonNullList ingredients = NonNullList.m_122779_();
        for (IInputItemStack input : this.recipeInputList) {
            ingredients.add((Object)(input.hasTag() ? Ingredient.m_204132_(input.getTag()) : Ingredient.m_43927_((ItemStack[])new ItemStack[]{input.getInputs().get(0)})));
        }
        return ingredients;
    }

    public RecipeType<?> m_6671_() {
        return RecipeType.f_44107_;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)Register.RECIPE_SERIALIZER_SHAPELESS_RECIPE.get();
    }

    public void toNetwork(FriendlyByteBuf buf) {
        CustomPacketBuffer packetBuffer = new CustomPacketBuffer((ByteBuf)buf);
        try {
            EncoderHandler.encode(packetBuffer, this.m_6076_());
            EncoderHandler.encode(packetBuffer, this.m_245232_().ordinal());
            EncoderHandler.encode(packetBuffer, this.output);
            packetBuffer.writeInt(this.recipeInputList.size());
            for (IInputItemStack part : this.recipeInputList) {
                EncoderHandler.encode(packetBuffer, part.writeNBT());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

